/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal;

import org.apache.pekko.actor.Dropped$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.BehaviorInterceptor;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.SupervisorStrategy;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.internal.UnstashException$;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$TypedActorRefOps$;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$TypedActorSystemOps$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.Logging$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

@InternalApi
public abstract class AbstractSupervisor<I, Thr extends Throwable>
extends BehaviorInterceptor<Object, I> {
    private final SupervisorStrategy strategy;
    private final Class throwableClass;

    public AbstractSupervisor(SupervisorStrategy strategy, ClassTag<Thr> ev) {
        this.strategy = strategy;
        super(ClassTag$.MODULE$.Any());
        this.throwableClass = Predef$.MODULE$.implicitly(ev).runtimeClass();
    }

    private Class<?> throwableClass() {
        return this.throwableClass;
    }

    public boolean isInstanceOfTheThrowableClass(Throwable t) {
        return this.throwableClass().isAssignableFrom(UnstashException$.MODULE$.unwrap(t).getClass());
    }

    @Override
    public boolean isSame(BehaviorInterceptor<Object, Object> other) {
        BehaviorInterceptor<Object, Object> behaviorInterceptor = other;
        if (behaviorInterceptor instanceof AbstractSupervisor) {
            AbstractSupervisor as = (AbstractSupervisor)behaviorInterceptor;
            Class<?> clazz = this.throwableClass();
            Class<?> clazz2 = as.throwableClass();
            if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Behavior<I> aroundStart(TypedActorContext<Object> ctx, BehaviorInterceptor.PreStartTarget<I> target) {
        Behavior behavior;
        try {
            behavior = target.start(ctx);
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, Behavior<I>> $1$ = this.handleExceptionOnStart(ctx, target);
            if ($1$.isDefinedAt(ex$)) {
                behavior = (Behavior)$1$.apply(ex$);
            }
            throw ex$;
        }
        return behavior;
    }

    @Override
    public Behavior<I> aroundSignal(TypedActorContext<Object> ctx, Signal signal, BehaviorInterceptor.SignalTarget<I> target) {
        Behavior behavior;
        try {
            behavior = target.apply(ctx, signal);
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, Behavior<I>> $2$ = this.handleSignalException(ctx, target);
            if ($2$.isDefinedAt(ex$)) {
                behavior = (Behavior)$2$.apply(ex$);
            }
            throw ex$;
        }
        return behavior;
    }

    public void log(TypedActorContext<?> ctx, Throwable t) {
        this.log(ctx, t, -1);
    }

    public void log(TypedActorContext<?> ctx, Throwable t, int errorCount) {
        if (this.strategy.loggingEnabled()) {
            SupervisorStrategy.Backoff b;
            Level logLevel;
            Throwable unwrapped = UnstashException$.MODULE$.unwrap(t);
            String errorCountStr = errorCount >= 0 ? new StringBuilder(3).append(" [").append(errorCount).append("]").toString() : "";
            String logMessage = new StringBuilder(25).append("Supervisor ").append(this).append(" saw failure").append(errorCountStr).append(": ").append(unwrapped.getMessage()).toString();
            Logger logger = ctx.asScala().log();
            SupervisorStrategy supervisorStrategy = this.strategy;
            Level level = logLevel = supervisorStrategy instanceof SupervisorStrategy.Backoff ? (errorCount > (b = (SupervisorStrategy.Backoff)supervisorStrategy).criticalLogLevelAfter() ? b.criticalLogLevel() : this.strategy.logLevel()) : this.strategy.logLevel();
            Level level2 = Level.ERROR;
            Level level3 = level;
            if (!(level2 != null ? !((Object)((Object)level2)).equals((Object)level3) : level3 != null)) {
                logger.error(logMessage, unwrapped);
                return;
            }
            Level level4 = Level.WARN;
            Level level5 = level;
            if (!(level4 != null ? !((Object)((Object)level4)).equals((Object)level5) : level5 != null)) {
                logger.warn(logMessage, unwrapped);
                return;
            }
            Level level6 = Level.INFO;
            Level level7 = level;
            if (!(level6 != null ? !((Object)((Object)level6)).equals((Object)level7) : level7 != null)) {
                logger.info(logMessage, unwrapped);
                return;
            }
            Level level8 = Level.DEBUG;
            Level level9 = level;
            if (!(level8 != null ? !((Object)((Object)level8)).equals((Object)level9) : level9 != null)) {
                logger.debug(logMessage, unwrapped);
                return;
            }
            Level level10 = Level.TRACE;
            Level level11 = level;
            if (!(level10 != null ? !((Object)((Object)level10)).equals((Object)level11) : level11 != null)) {
                logger.trace(logMessage, unwrapped);
                return;
            }
            throw new MatchError((Object)level);
        }
    }

    public void dropped(TypedActorContext<?> ctx, Object signalOrMessage) {
        package$TypedActorSystemOps$.MODULE$.toClassic$extension(package$.MODULE$.TypedActorSystemOps(ctx.asScala().system())).eventStream().publish(Dropped$.MODULE$.apply(signalOrMessage, new StringBuilder(19).append("Stash is full in [").append(this.getClass().getSimpleName()).append("]").toString(), package$TypedActorRefOps$.MODULE$.toClassic$extension(package$.MODULE$.TypedActorRefOps(ctx.asScala().self()))));
    }

    public abstract PartialFunction<Throwable, Behavior<I>> handleExceptionOnStart(TypedActorContext<Object> var1, BehaviorInterceptor.PreStartTarget<I> var2);

    public abstract PartialFunction<Throwable, Behavior<I>> handleSignalException(TypedActorContext<Object> var1, BehaviorInterceptor.SignalTarget<I> var2);

    public abstract PartialFunction<Throwable, Behavior<I>> handleReceiveException(TypedActorContext<Object> var1, BehaviorInterceptor.ReceiveTarget<I> var2);

    public String toString() {
        return Logging$.MODULE$.simpleName(this.getClass());
    }
}

