/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.eventstream;

import java.io.Serializable;
import org.apache.pekko.actor.InvalidMessageException$;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.eventstream.EventStream$Publish$;
import org.apache.pekko.actor.typed.eventstream.EventStream$Subscribe$;
import org.apache.pekko.actor.typed.eventstream.EventStream$Unsubscribe$;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.annotation.InternalApi;
import scala.Product;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class EventStream {

    @DoNotInherit
    public static interface Command {
    }

    public static final class Publish<E>
    implements Command,
    Product,
    Serializable {
        private final Object event;

        public static <E> Publish<E> apply(E e) {
            return EventStream$Publish$.MODULE$.apply(e);
        }

        public static Publish<?> fromProduct(Product product) {
            return EventStream$Publish$.MODULE$.fromProduct(product);
        }

        public static <E> Publish<E> unapply(Publish<E> publish) {
            return EventStream$Publish$.MODULE$.unapply(publish);
        }

        public Publish(E event) {
            this.event = event;
            if (event == null) {
                throw InvalidMessageException$.MODULE$.apply("[null] is not an allowed event");
            }
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Publish)) return false;
            Publish publish = (Publish)object;
            if (!BoxesRunTime.equals(this.event(), publish.event())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Publish;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Publish";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "event";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public E event() {
            return (E)this.event;
        }

        public <E> Publish<E> copy(E event) {
            return new Publish<E>(event);
        }

        public <E> E copy$default$1() {
            return this.event();
        }

        public E _1() {
            return this.event();
        }
    }

    public static final class Subscribe<E>
    implements Command,
    Product,
    Serializable {
        private final ActorRef subscriber;
        private final ClassTag<E> classTag;

        public static <E> Subscribe<E> apply(ActorRef<E> actorRef, ClassTag<E> classTag) {
            return EventStream$Subscribe$.MODULE$.apply(actorRef, classTag);
        }

        public static <E> Subscribe<E> unapply(Subscribe<E> subscribe) {
            return EventStream$Subscribe$.MODULE$.unapply(subscribe);
        }

        public Subscribe(ActorRef<E> subscriber, ClassTag<E> classTag) {
            this.subscriber = subscriber;
            this.classTag = classTag;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Subscribe)) return false;
            Subscribe subscribe = (Subscribe)object;
            ActorRef<E> actorRef = this.subscriber();
            ActorRef<E> actorRef2 = subscribe.subscriber();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Subscribe;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Subscribe";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "subscriber";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<E> subscriber() {
            return this.subscriber;
        }

        public Subscribe(Class<E> clazz, ActorRef<E> subscriber) {
            this(subscriber, ClassTag$.MODULE$.apply(clazz));
        }

        @InternalApi
        public Class<?> topic() {
            return this.classTag.runtimeClass();
        }

        public <E> Subscribe<E> copy(ActorRef<E> subscriber, ClassTag<E> classTag) {
            return new Subscribe<E>(subscriber, classTag);
        }

        public <E> ActorRef<E> copy$default$1() {
            return this.subscriber();
        }

        public ActorRef<E> _1() {
            return this.subscriber();
        }
    }

    public static final class Unsubscribe<E>
    implements Command,
    Product,
    Serializable {
        private final ActorRef subscriber;

        public static <E> Unsubscribe<E> apply(ActorRef<E> actorRef) {
            return EventStream$Unsubscribe$.MODULE$.apply(actorRef);
        }

        public static Unsubscribe<?> fromProduct(Product product) {
            return EventStream$Unsubscribe$.MODULE$.fromProduct(product);
        }

        public static <E> Unsubscribe<E> unapply(Unsubscribe<E> unsubscribe) {
            return EventStream$Unsubscribe$.MODULE$.unapply(unsubscribe);
        }

        public Unsubscribe(ActorRef<E> subscriber) {
            this.subscriber = subscriber;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Unsubscribe)) return false;
            Unsubscribe unsubscribe = (Unsubscribe)object;
            ActorRef<E> actorRef = this.subscriber();
            ActorRef<E> actorRef2 = unsubscribe.subscriber();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Unsubscribe;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Unsubscribe";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "subscriber";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<E> subscriber() {
            return this.subscriber;
        }

        public <E> Unsubscribe<E> copy(ActorRef<E> subscriber) {
            return new Unsubscribe<E>(subscriber);
        }

        public <E> ActorRef<E> copy$default$1() {
            return this.subscriber();
        }

        public ActorRef<E> _1() {
            return this.subscriber();
        }
    }
}

