/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.delivery.internal;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.ActorRef$ActorRefOps$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.DispatcherSelector$;
import org.apache.pekko.actor.typed.RecipientRef;
import org.apache.pekko.actor.typed.delivery.ConsumerController;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue$MessageSent$;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue$StoreMessageConfirmed$;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue$StoreMessageSent$;
import org.apache.pekko.actor.typed.delivery.ProducerController;
import org.apache.pekko.actor.typed.delivery.ProducerController$;
import org.apache.pekko.actor.typed.delivery.ProducerController$MessageWithConfirmation$;
import org.apache.pekko.actor.typed.delivery.ProducerController$RegisterConsumer$;
import org.apache.pekko.actor.typed.delivery.ProducerController$Start$;
import org.apache.pekko.actor.typed.delivery.WorkPullingProducerController;
import org.apache.pekko.actor.typed.delivery.WorkPullingProducerController$GetWorkerStats$;
import org.apache.pekko.actor.typed.delivery.WorkPullingProducerController$MessageWithConfirmation$;
import org.apache.pekko.actor.typed.delivery.WorkPullingProducerController$WorkerStats$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$Ack$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$AskTimeout$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$CurrentWorkers$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$DurableQueueTerminated$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$HandOver$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$LoadStateFailed$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$LoadStateReply$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$Msg$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$OutState$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$PreselectedWorker$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$RegisterConsumerDone$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$ResendDurableMsg$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$State$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$StoreMessageSentCompleted$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$StoreMessageSentFailed$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$StoreMessageSentReply$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$Unconfirmed$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl$WorkerRequestNext$;
import org.apache.pekko.actor.typed.receptionist.ServiceKey;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.actor.typed.scaladsl.StashBuffer;
import org.apache.pekko.actor.typed.scaladsl.package$LoggerOps$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple5;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

public class WorkPullingProducerControllerImpl<A> {
    private final ActorContext<InternalCommand> context;
    private final StashBuffer<InternalCommand> stashBuffer;
    private final String producerId;
    private final WorkPullingProducerController.RequestNext<A> requestNext;
    private final Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue;
    private final ClassTag<A> evidence$1;
    private final ProducerController.Settings producerControllerSettings;
    private final boolean traceEnabled;
    private final Timeout durableQueueAskTimeout;
    private final Timeout workerAskTimeout;
    private final ActorRef<ProducerController.RequestNext<A>> workerRequestNextAdapter;

    public static <A> Behavior<WorkPullingProducerController.Command<A>> apply(String string2, ServiceKey<ConsumerController.Command<A>> serviceKey, Option<Behavior<DurableProducerQueue.Command<A>>> option, WorkPullingProducerController.Settings settings, ClassTag<A> classTag) {
        return WorkPullingProducerControllerImpl$.MODULE$.apply(string2, serviceKey, option, settings, classTag);
    }

    public WorkPullingProducerControllerImpl(ActorContext<InternalCommand> context, StashBuffer<InternalCommand> stashBuffer, String producerId, WorkPullingProducerController.RequestNext<A> requestNext, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, WorkPullingProducerController.Settings settings, ClassTag<A> evidence$1) {
        this.context = context;
        this.stashBuffer = stashBuffer;
        this.producerId = producerId;
        this.requestNext = requestNext;
        this.durableQueue = durableQueue;
        this.evidence$1 = evidence$1;
        this.producerControllerSettings = settings.producerControllerSettings();
        this.traceEnabled = context.log().isTraceEnabled();
        this.durableQueueAskTimeout = Timeout$.MODULE$.durationToTimeout(this.producerControllerSettings.durableQueueRequestTimeout());
        this.workerAskTimeout = Timeout$.MODULE$.durationToTimeout(settings.internalAskTimeout());
        this.workerRequestNextAdapter = context.messageAdapter((Function1<ProducerController.RequestNext, InternalCommand> & Serializable)next -> WorkPullingProducerControllerImpl$WorkerRequestNext$.MODULE$.apply(next), ClassTag$.MODULE$.apply(ProducerController.RequestNext.class));
    }

    public Behavior<InternalCommand> org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(State<A> s2) {
        return (Behavior)((Object)Behaviors$.MODULE$.receiveMessage((Function1<InternalCommand, Behavior> & Serializable)x$1 -> {
            Option<Tuple5<Object, Object, Object, String, Object>> option;
            StoreMessageSentCompleted storeMessageSentCompleted;
            DurableProducerQueue.MessageSent messageSent;
            InternalCommand internalCommand = x$1;
            if (internalCommand instanceof Msg) {
                Option<A> option2;
                Msg msg = WorkPullingProducerControllerImpl$Msg$.MODULE$.unapply((Msg)internalCommand);
                Object a = msg._1();
                boolean bl = msg._2();
                Option<ActorRef<Done>> option3 = msg._3();
                if (a != null && !(option2 = this.evidence$1.unapply(a)).isEmpty()) {
                    A a2;
                    A msg2 = a2 = option2.get();
                    boolean wasStashed = bl;
                    Option<ActorRef<Done>> replyTo = option3;
                    if (this.durableQueue.isEmpty() || wasStashed) {
                        return this.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(this.onMessage$1(s2, msg2, wasStashed, replyTo, s2.currentSeqNr()));
                    }
                    return this.onMessageBeforeDurableQueue$1(s2, msg2, replyTo);
                }
            }
            if (internalCommand instanceof WorkPullingProducerController.MessageWithConfirmation) {
                Option<A> option4;
                WorkPullingProducerController.MessageWithConfirmation messageWithConfirmation = WorkPullingProducerController$MessageWithConfirmation$.MODULE$.unapply((WorkPullingProducerController.MessageWithConfirmation)internalCommand);
                Object a = messageWithConfirmation._1();
                ActorRef<Done> actorRef = messageWithConfirmation._2();
                if (a != null && !(option4 = this.evidence$1.unapply(a)).isEmpty()) {
                    A a3;
                    A msg = a3 = option4.get();
                    ActorRef<Done> replyTo = actorRef;
                    if (this.durableQueue.isEmpty()) {
                        return this.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(this.onMessage$1(s2, msg, false, Some$.MODULE$.apply(replyTo), s2.currentSeqNr()));
                    }
                    return this.onMessageBeforeDurableQueue$1(s2, msg, Some$.MODULE$.apply(replyTo));
                }
            }
            if (internalCommand instanceof ResendDurableMsg) {
                ResendDurableMsg m = (ResendDurableMsg)internalCommand;
                return this.onResendDurableMsg$1(s2, m);
            }
            if (internalCommand instanceof StoreMessageSentCompleted && (messageSent = (storeMessageSentCompleted = WorkPullingProducerControllerImpl$StoreMessageSentCompleted$.MODULE$.unapply((StoreMessageSentCompleted)internalCommand))._1()) != null && !(option = DurableProducerQueue$MessageSent$.MODULE$.unapply(messageSent)).isEmpty()) {
                Option<A> option5;
                Tuple5<Object, Object, Object, String, Object> tuple5 = option.get();
                Object object = tuple5._2();
                long seqNr = BoxesRunTime.unboxToLong(tuple5._1());
                if (object != null && !(option5 = this.evidence$1.unapply(object)).isEmpty()) {
                    A a;
                    A m = a = option5.get();
                    return this.receiveStoreMessageSentCompleted$1(s2, seqNr, m);
                }
            }
            if (internalCommand instanceof StoreMessageSentFailed) {
                StoreMessageSentFailed f = (StoreMessageSentFailed)internalCommand;
                return this.receiveStoreMessageSentFailed(f);
            }
            if (internalCommand instanceof Ack) {
                Ack ack = (Ack)internalCommand;
                return this.receiveAck$1(s2, ack);
            }
            if (internalCommand instanceof WorkerRequestNext) {
                WorkerRequestNext w = (WorkerRequestNext)internalCommand;
                return this.receiveWorkerRequestNext$1(s2, w);
            }
            if (internalCommand instanceof CurrentWorkers) {
                CurrentWorkers curr = (CurrentWorkers)internalCommand;
                return this.receiveCurrentWorkers$1(s2, curr);
            }
            if (internalCommand instanceof WorkPullingProducerController.GetWorkerStats) {
                ActorRef<WorkPullingProducerController.WorkerStats> actorRef;
                WorkPullingProducerController.GetWorkerStats getWorkerStats = WorkPullingProducerController$GetWorkerStats$.MODULE$.unapply((WorkPullingProducerController.GetWorkerStats)internalCommand);
                ActorRef<WorkPullingProducerController.WorkerStats> replyTo = actorRef = getWorkerStats._1();
                ActorRef actorRef2 = ActorRef$.MODULE$.ActorRefOps(replyTo);
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef2, WorkPullingProducerController$WorkerStats$.MODULE$.apply(s2.workers().size()));
                return Behaviors$.MODULE$.same();
            }
            if (WorkPullingProducerControllerImpl$RegisterConsumerDone$.MODULE$.equals(internalCommand)) {
                return Behaviors$.MODULE$.same();
            }
            if (internalCommand instanceof WorkPullingProducerController.Start) {
                WorkPullingProducerController.Start start = (WorkPullingProducerController.Start)internalCommand;
                return this.receiveStart$1(s2, start);
            }
            if (internalCommand instanceof AskTimeout) {
                AskTimeout askTimeout = WorkPullingProducerControllerImpl$AskTimeout$.MODULE$.unapply((AskTimeout)internalCommand);
                String string2 = askTimeout._1();
                long l = askTimeout._2();
                String outKey = string2;
                long outSeqNr = l;
                this.context.log().debug("Message seqNr [{}] sent to worker [{}] timed out. It will be be redelivered.", (Object)BoxesRunTime.boxToLong(outSeqNr), (Object)outKey);
                return Behaviors$.MODULE$.same();
            }
            if (WorkPullingProducerControllerImpl$DurableQueueTerminated$.MODULE$.equals(internalCommand)) {
                throw new IllegalStateException("DurableQueue was unexpectedly terminated.");
            }
            InternalCommand unexpected = internalCommand;
            throw new RuntimeException(new StringBuilder(20).append("Unexpected message: ").append(unexpected).toString());
        }));
    }

    private Behavior<InternalCommand> receiveStoreMessageSentFailed(StoreMessageSentFailed<A> f) {
        if (f.attempt() >= this.producerControllerSettings.durableQueueRetryAttempts()) {
            String errorMessage = new StringBuilder(68).append("StoreMessageSentFailed seqNr [").append(f.messageSent().seqNr()).append("] failed after [").append(f.attempt()).append("] attempts, giving up.").toString();
            this.context.log().error(errorMessage);
            throw new TimeoutException(errorMessage);
        }
        this.context.log().warn("StoreMessageSent seqNr [{}] failed, attempt [{}], retrying.", (Object)BoxesRunTime.boxToLong(f.messageSent().seqNr()), (Object)BoxesRunTime.boxToInteger(f.attempt()));
        this.storeMessageSent(f.messageSent(), f.attempt() + 1);
        return Behaviors$.MODULE$.same();
    }

    private void storeMessageSent(DurableProducerQueue.MessageSent<A> messageSent, int attempt) {
        Timeout askTimout = this.durableQueueAskTimeout;
        this.context.ask((RecipientRef)this.durableQueue.get(), (Function1<ActorRef, DurableProducerQueue.StoreMessageSent> & Serializable)askReplyTo -> DurableProducerQueue$StoreMessageSent$.MODULE$.apply(messageSent, (ActorRef<DurableProducerQueue.StoreMessageSentAck>)askReplyTo), (Function1<Try, InternalCommand> & Serializable)x$1 -> {
            Product product;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                product = WorkPullingProducerControllerImpl$StoreMessageSentCompleted$.MODULE$.apply(messageSent);
            } else if (try_ instanceof Failure) {
                product = WorkPullingProducerControllerImpl$StoreMessageSentFailed$.MODULE$.apply(messageSent, attempt);
            } else {
                throw new MatchError(try_);
            }
            return product;
        }, askTimout, ClassTag$.MODULE$.apply(DurableProducerQueue.StoreMessageSentAck.class));
    }

    private final void tellRequestNext$1(long totalSeqNr$1, State s$2) {
        if (this.traceEnabled) {
            this.context.log().trace("Sending RequestNext to producer, seqNr [{}].", (Object)BoxesRunTime.boxToLong(totalSeqNr$1));
        }
        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(s$2.producer());
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, this.requestNext);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final State onMessage$1(State s$1, Object msg, boolean wasStashed, Option replyTo, long totalSeqNr) {
        Tuple2 tuple2;
        Right selectedWorker;
        Either either;
        Vector consumersWithDemand;
        block23: {
            block24: {
                PreselectedWorker preselectedWorker;
                consumersWithDemand = s$1.out().iterator().filter((Function1<Tuple2, boolean> & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        OutState out = (OutState)tuple2._2();
                        return out.askNextTo().isDefined();
                    }
                    throw new MatchError(tuple2);
                }).toVector();
                if (this.traceEnabled) {
                    package$LoggerOps$.MODULE$.traceN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Received message seqNr [{}], wasStashed [{}], consumersWithDemand [{}], hasRequested [{}].", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(totalSeqNr), BoxesRunTime.boxToBoolean(wasStashed), ((IterableOnceOps)consumersWithDemand.map((Function1<Tuple2, String> & Serializable)_$1 -> (String)_$1._1())).mkString(", "), BoxesRunTime.boxToBoolean(s$1.requested())}));
                }
                if (!s$1.requested() && !wasStashed && this.durableQueue.isEmpty()) {
                    throw new IllegalStateException(new StringBuilder(54).append("Unexpected message [").append(msg).append("], wasn't requested nor unstashed.").toString());
                }
                if (!this.durableQueue.isDefined()) break block24;
                Option option = s$1.preselectedWorkers().get(BoxesRunTime.boxToLong(totalSeqNr));
                if (option instanceof Some && (preselectedWorker = (PreselectedWorker)((Some)option).value()) != null) {
                    PreselectedWorker preselectedWorker2 = WorkPullingProducerControllerImpl$PreselectedWorker$.MODULE$.unapply(preselectedWorker);
                    String string2 = preselectedWorker2._1();
                    String string3 = preselectedWorker2._2();
                    String outKey = string2;
                    String confirmationQualifier = string3;
                    Option option2 = s$1.out().get(outKey);
                    if (option2 instanceof Some) {
                        OutState out = (OutState)((Some)option2).value();
                        String string4 = Predef$.MODULE$.ArrowAssoc(outKey);
                        either = package$.MODULE$.Right().apply(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string4, out));
                        break block23;
                    } else {
                        if (!None$.MODULE$.equals(option2)) {
                            throw new MatchError(option2);
                        }
                        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.context.self());
                        ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, WorkPullingProducerControllerImpl$ResendDurableMsg$.MODULE$.apply(msg, confirmationQualifier, totalSeqNr));
                        either = package$.MODULE$.Left().apply(s$1);
                    }
                    break block23;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                    throw new IllegalStateException(new StringBuilder(41).append("Expected preselected worker for seqNr [").append(totalSeqNr).append("].").toString());
                }
            }
            Option option = WorkPullingProducerControllerImpl.selectWorker$1(s$1);
            if (option instanceof Some) {
                Tuple2 w = (Tuple2)((Some)option).value();
                either = package$.MODULE$.Right().apply(w);
            } else {
                if (!None$.MODULE$.equals(option)) {
                    throw new MatchError(option);
                }
                WorkPullingProducerControllerImpl$.MODULE$.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$$checkStashFull(this.stashBuffer);
                this.context.log().debug("Stashing message, seqNr [{}]", (Object)BoxesRunTime.boxToLong(totalSeqNr));
                this.stashBuffer.stash(WorkPullingProducerControllerImpl$Msg$.MODULE$.apply(msg, true, replyTo));
                boolean newRequested = wasStashed ? s$1.requested() : false;
                either = package$.MODULE$.Left().apply(s$1.copy(s$1.copy$default$1(), s$1.copy$default$2(), s$1.copy$default$3(), s$1.copy$default$4(), s$1.copy$default$5(), s$1.copy$default$6(), s$1.copy$default$7(), newRequested));
            }
        }
        Right right = selectedWorker = either;
        if (right instanceof Right && (tuple2 = right.value()) != null) {
            boolean bl;
            boolean hasMoreDemand;
            String outKey = (String)tuple2._1();
            OutState out = (OutState)tuple2._2();
            Vector newUnconfirmed = (Vector)out.unconfirmed().$colon$plus(WorkPullingProducerControllerImpl$Unconfirmed$.MODULE$.apply(totalSeqNr, out.seqNr(), msg, replyTo));
            None$ none$ = None$.MODULE$;
            ActorRef actorRef = out.copy$default$1();
            ActorRef actorRef2 = out.copy$default$2();
            long l = out.copy$default$3();
            Map newOut = (Map)s$1.out().updated(outKey, out.copy(actorRef, actorRef2, l, newUnconfirmed, none$));
            Timeout askTimeout = this.workerAskTimeout;
            this.context.ask(out.askNextTo().get(), (Function1<ActorRef, ProducerController.MessageWithConfirmation> & Serializable)_$2 -> ProducerController$MessageWithConfirmation$.MODULE$.apply(msg, (ActorRef<Object>)_$2), (Function1<Try, InternalCommand> & Serializable)x$1 -> {
                Product product;
                Try try_ = x$1;
                if (try_ instanceof Success) {
                    long seqNr = BoxesRunTime.unboxToLong(((Success)try_).value());
                    product = WorkPullingProducerControllerImpl$Ack$.MODULE$.apply(outKey, seqNr);
                } else if (try_ instanceof Failure) {
                    product = WorkPullingProducerControllerImpl$AskTimeout$.MODULE$.apply(outKey, out.seqNr());
                } else {
                    throw new MatchError(try_);
                }
                return product;
            }, askTimeout, ClassTag$.MODULE$.apply(Long.TYPE));
            boolean bl2 = hasMoreDemand = consumersWithDemand.size() >= 2;
            if (s$1.requested() && !wasStashed && hasMoreDemand) {
                this.tellRequestNext$1(totalSeqNr, s$1);
                bl = true;
            } else if (s$1.requested() && !wasStashed && !hasMoreDemand) {
                bl = false;
            } else if (!s$1.requested() && wasStashed && hasMoreDemand && this.stashBuffer.isEmpty()) {
                this.tellRequestNext$1(totalSeqNr, s$1);
                bl = true;
            } else if (!s$1.requested() && wasStashed && hasMoreDemand && this.stashBuffer.nonEmpty()) {
                bl = false;
            } else if (!s$1.requested() && wasStashed && !hasMoreDemand) {
                bl = false;
            } else if (s$1.requested() && wasStashed) {
                bl = true;
            } else {
                if (!this.durableQueue.isDefined()) throw new IllegalStateException(new StringBuilder(40).append("Invalid combination of hasRequested [").append(s$1.requested()).append("], ").append(new StringBuilder(55).append("wasStashed [").append(wasStashed).append("], hasMoreDemand [").append(hasMoreDemand).append("], stashBuffer.isEmpty [").append(this.stashBuffer.isEmpty()).append("]").toString()).toString());
                if (s$1.requested()) throw new IllegalStateException(new StringBuilder(40).append("Invalid combination of hasRequested [").append(s$1.requested()).append("], ").append(new StringBuilder(55).append("wasStashed [").append(wasStashed).append("], hasMoreDemand [").append(hasMoreDemand).append("], stashBuffer.isEmpty [").append(this.stashBuffer.isEmpty()).append("]").toString()).toString());
                if (wasStashed) throw new IllegalStateException(new StringBuilder(40).append("Invalid combination of hasRequested [").append(s$1.requested()).append("], ").append(new StringBuilder(55).append("wasStashed [").append(wasStashed).append("], hasMoreDemand [").append(hasMoreDemand).append("], stashBuffer.isEmpty [").append(this.stashBuffer.isEmpty()).append("]").toString()).toString());
                bl = false;
            }
            boolean newRequested = bl;
            Map map = (Map)s$1.preselectedWorkers().$minus(BoxesRunTime.boxToLong(totalSeqNr));
            long l2 = s$1.copy$default$1();
            Set set = s$1.copy$default$2();
            Map<Object, ActorRef<Done>> map2 = s$1.copy$default$5();
            Map<Object, HandOver> map3 = s$1.copy$default$6();
            ActorRef actorRef3 = s$1.copy$default$7();
            return s$1.copy(l2, set, newOut, map, map2, map3, actorRef3, newRequested);
        }
        if (!(right instanceof Left)) throw new MatchError(right);
        return (State)((Left)((Object)right)).value();
    }

    private static final Vector workersWithDemand$1(State s$3) {
        return s$3.out().iterator().filter((Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                OutState out = (OutState)tuple2._2();
                return out.askNextTo().isDefined();
            }
            throw new MatchError(tuple2);
        }).toVector();
    }

    private static final Option selectWorker$1(State s$4) {
        Set preselected = s$4.preselectedWorkers().valuesIterator().map((Function1<PreselectedWorker, String> & Serializable)_$3 -> _$3.outKey()).toSet();
        Vector workers = (Vector)WorkPullingProducerControllerImpl.workersWithDemand$1(s$4).filterNot((Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String outKey = (String)tuple2._1();
                return preselected.apply(outKey);
            }
            throw new MatchError(tuple2);
        });
        if (workers.isEmpty()) {
            return None$.MODULE$;
        }
        int i = ThreadLocalRandom.current().nextInt(workers.size());
        return Some$.MODULE$.apply(workers.apply(i));
    }

    private final Behavior onMessageBeforeDurableQueue$1(State s$5, Object msg, Option replyTo) {
        Tuple2 tuple2;
        Option option = WorkPullingProducerControllerImpl.selectWorker$1(s$5);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            Map map;
            String outKey = (String)tuple2._1();
            OutState out = (OutState)tuple2._2();
            this.storeMessageSent(DurableProducerQueue$MessageSent$.MODULE$.apply(s$5.currentSeqNr(), msg, replyTo.isDefined(), out.confirmationQualifier(), System.currentTimeMillis()), 1);
            Option option2 = replyTo;
            if (None$.MODULE$.equals(option2)) {
                map = s$5.replyAfterStore();
            } else if (option2 instanceof Some) {
                ActorRef r = (ActorRef)((Some)option2).value();
                map = (Map)s$5.replyAfterStore().updated(BoxesRunTime.boxToLong(s$5.currentSeqNr()), r);
            } else {
                throw new MatchError(option2);
            }
            Map newReplyAfterStore = map;
            long l = s$5.currentSeqNr() + 1L;
            Map map2 = (Map)s$5.preselectedWorkers().updated(BoxesRunTime.boxToLong(s$5.currentSeqNr()), WorkPullingProducerControllerImpl$PreselectedWorker$.MODULE$.apply(outKey, out.confirmationQualifier()));
            Set set = s$5.copy$default$2();
            Map map3 = s$5.copy$default$3();
            Map<Object, HandOver> map4 = s$5.copy$default$6();
            ActorRef actorRef = s$5.copy$default$7();
            boolean bl = s$5.copy$default$8();
            return this.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(s$5.copy(l, set, map3, map2, newReplyAfterStore, map4, actorRef, bl));
        }
        if (None$.MODULE$.equals(option)) {
            WorkPullingProducerControllerImpl$.MODULE$.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$$checkStashFull(this.stashBuffer);
            this.context.log().debug("Stash before storage, seqNr [{}]", (Object)BoxesRunTime.boxToLong(s$5.currentSeqNr()));
            this.stashBuffer.stash(WorkPullingProducerControllerImpl$Msg$.MODULE$.apply(msg, false, replyTo));
            return this.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(s$5);
        }
        throw new MatchError(option);
    }

    private static final Object onResendDurableMsg$1$$anonfun$1() {
        return "Unexpected ResendDurableMsg when DurableQueue not defined.";
    }

    private final Behavior onResendDurableMsg$1(State s$6, ResendDurableMsg resend) {
        Tuple2 tuple2;
        Predef$.MODULE$.require(this.durableQueue.isDefined(), WorkPullingProducerControllerImpl::onResendDurableMsg$1$$anonfun$1);
        Option option = WorkPullingProducerControllerImpl.selectWorker$1(s$6);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            String outKey = (String)tuple2._1();
            OutState out = (OutState)tuple2._2();
            this.storeMessageSent(DurableProducerQueue$MessageSent$.MODULE$.apply(s$6.currentSeqNr(), resend.msg(), false, out.confirmationQualifier(), System.currentTimeMillis()), 1);
            long l = s$6.currentSeqNr() + 1L;
            Map map = (Map)s$6.preselectedWorkers().updated(BoxesRunTime.boxToLong(s$6.currentSeqNr()), WorkPullingProducerControllerImpl$PreselectedWorker$.MODULE$.apply(outKey, out.confirmationQualifier()));
            Map map2 = (Map)s$6.handOver().updated(BoxesRunTime.boxToLong(s$6.currentSeqNr()), WorkPullingProducerControllerImpl$HandOver$.MODULE$.apply(resend.oldConfirmationQualifier(), resend.oldSeqNr()));
            Set set = s$6.copy$default$2();
            Map map3 = s$6.copy$default$3();
            Map<Object, ActorRef<Done>> map4 = s$6.copy$default$5();
            ActorRef actorRef = s$6.copy$default$7();
            boolean bl = s$6.copy$default$8();
            return this.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(s$6.copy(l, set, map3, map, map4, map2, actorRef, bl));
        }
        if (None$.MODULE$.equals(option)) {
            WorkPullingProducerControllerImpl$.MODULE$.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$$checkStashFull(this.stashBuffer);
            this.context.log().debug("Stash before storage of resent durable message, seqNr [{}].", (Object)BoxesRunTime.boxToLong(s$6.currentSeqNr()));
            this.stashBuffer.stash(resend);
            return this.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(s$6);
        }
        throw new MatchError(option);
    }

    private final Behavior receiveStoreMessageSentCompleted$1(State s$7, long seqNr, Object m) {
        boolean bl;
        HandOver handOver;
        s$7.replyAfterStore().get(BoxesRunTime.boxToLong(seqNr)).foreach(replyTo -> {
            if (this.traceEnabled) {
                this.context.log().trace("Sending reply for seqNr [{}] after storage.", (Object)BoxesRunTime.boxToLong(seqNr));
            }
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(replyTo);
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, Done$.MODULE$);
        });
        Option option = s$7.handOver().get(BoxesRunTime.boxToLong(seqNr));
        if (option instanceof Some && (handOver = (HandOver)((Some)option).value()) != null) {
            HandOver handOver2 = WorkPullingProducerControllerImpl$HandOver$.MODULE$.unapply(handOver);
            String string2 = handOver2._1();
            long l = handOver2._2();
            String oldConfirmationQualifier = string2;
            long oldSeqNr = l;
            this.durableQueue.foreach(d -> {
                ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(d);
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, DurableProducerQueue$StoreMessageConfirmed$.MODULE$.apply(oldSeqNr, oldConfirmationQualifier, System.currentTimeMillis()));
            });
            bl = true;
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError(option);
        }
        boolean wasHandOver = bl;
        State newState = this.onMessage$1(s$7, m, wasHandOver, None$.MODULE$, seqNr);
        Map map = (Map)newState.replyAfterStore().$minus(BoxesRunTime.boxToLong(seqNr));
        Map map2 = (Map)newState.handOver().$minus(BoxesRunTime.boxToLong(seqNr));
        long l = newState.copy$default$1();
        Set set = newState.copy$default$2();
        Map map3 = newState.copy$default$3();
        Map<Object, PreselectedWorker> map4 = newState.copy$default$4();
        ActorRef actorRef = newState.copy$default$7();
        boolean bl2 = newState.copy$default$8();
        return this.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(newState.copy(l, set, map3, map4, map, map2, actorRef, bl2));
    }

    private final Behavior receiveAck$1(State s$8, Ack ack) {
        Option option = s$8.out().get(ack.outKey());
        if (option instanceof Some) {
            OutState outState = (OutState)((Some)option).value();
            Vector newUnconfirmed = this.onAck$1(outState, ack.confirmedSeqNr());
            Map map = (Map)s$8.out().updated(ack.outKey(), outState.copy(outState.copy$default$1(), outState.copy$default$2(), outState.copy$default$3(), newUnconfirmed, outState.copy$default$5()));
            long l = s$8.copy$default$1();
            Set set = s$8.copy$default$2();
            Map<Object, PreselectedWorker> map2 = s$8.copy$default$4();
            Map<Object, ActorRef<Done>> map3 = s$8.copy$default$5();
            Map<Object, HandOver> map4 = s$8.copy$default$6();
            ActorRef actorRef = s$8.copy$default$7();
            boolean bl = s$8.copy$default$8();
            return this.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(s$8.copy(l, set, map, map2, map3, map4, actorRef, bl));
        }
        if (None$.MODULE$.equals(option)) {
            return Behaviors$.MODULE$.unhandled();
        }
        throw new MatchError(option);
    }

    private final Vector onAck$1(OutState outState, long confirmedSeqNr) {
        Tuple2 tuple2 = outState.unconfirmed().partition((Function1<Unconfirmed, boolean> & Serializable)x$1 -> {
            Unconfirmed unconfirmed = x$1;
            if (unconfirmed != null) {
                Unconfirmed unconfirmed2 = WorkPullingProducerControllerImpl$Unconfirmed$.MODULE$.unapply(unconfirmed);
                long l = unconfirmed2._1();
                long l2 = unconfirmed2._2();
                Object a = unconfirmed2._3();
                Option<ActorRef<Done>> option = unconfirmed2._4();
                long seqNr = l2;
                return seqNr <= confirmedSeqNr;
            }
            throw new MatchError(unconfirmed);
        });
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Vector confirmed = tuple2._1();
        Vector newUnconfirmed = tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply(confirmed, newUnconfirmed);
        Vector confirmed2 = tuple22._1();
        Vector newUnconfirmed2 = tuple22._2();
        if (confirmed2.nonEmpty()) {
            if (this.traceEnabled) {
                this.context.log().trace("Received Ack seqNr [{}] from worker [{}].", (Object)BoxesRunTime.boxToLong(confirmedSeqNr), (Object)outState.confirmationQualifier());
            }
            confirmed2.foreach(x$1 -> {
                Unconfirmed unconfirmed = x$1;
                if (unconfirmed != null) {
                    Unconfirmed unconfirmed2 = WorkPullingProducerControllerImpl$Unconfirmed$.MODULE$.unapply(unconfirmed);
                    long l = unconfirmed2._1();
                    long l2 = unconfirmed2._2();
                    Object a = unconfirmed2._3();
                    Option<ActorRef<Done>> option = unconfirmed2._4();
                    if (None$.MODULE$.equals(option)) {
                        return;
                    }
                    if (option instanceof Some) {
                        ActorRef replyTo = (ActorRef)((Some)option).value();
                        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(replyTo);
                        ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, Done$.MODULE$);
                        return;
                    }
                }
                throw new MatchError(unconfirmed);
            });
            this.durableQueue.foreach(d -> {
                ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(d);
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, DurableProducerQueue$StoreMessageConfirmed$.MODULE$.apply(((Unconfirmed)confirmed2.last()).totalSeqNr(), outState.confirmationQualifier(), System.currentTimeMillis()));
            });
        }
        return newUnconfirmed2;
    }

    private final Behavior receiveWorkerRequestNext$1(State s$9, WorkerRequestNext w) {
        ProducerController.RequestNext next = w.next();
        String outKey = next.producerId();
        Option option = s$9.out().get(outKey);
        if (option instanceof Some) {
            OutState outState = (OutState)((Some)option).value();
            long confirmedSeqNr = w.next().confirmedSeqNr();
            if (this.traceEnabled) {
                package$LoggerOps$.MODULE$.trace2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Received RequestNext from worker [{}], confirmedSeqNr [{}].", w.next().producerId(), BoxesRunTime.boxToLong(confirmedSeqNr));
            }
            Vector newUnconfirmed = this.onAck$1(outState, confirmedSeqNr);
            Some some = Some$.MODULE$.apply(next.askNextTo());
            ActorRef actorRef = outState.copy$default$1();
            ActorRef actorRef2 = outState.copy$default$2();
            Map newOut = (Map)s$9.out().updated(outKey, outState.copy(actorRef, actorRef2, w.next().currentSeqNr(), newUnconfirmed, some));
            if (this.stashBuffer.nonEmpty()) {
                package$LoggerOps$.MODULE$.debug2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Unstash [{}] after RequestNext from worker [{}]", BoxesRunTime.boxToInteger(this.stashBuffer.size()), w.next().producerId());
                return this.stashBuffer.unstashAll(this.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(s$9.copy(s$9.copy$default$1(), s$9.copy$default$2(), newOut, s$9.copy$default$4(), s$9.copy$default$5(), s$9.copy$default$6(), s$9.copy$default$7(), s$9.copy$default$8())));
            }
            if (s$9.requested()) {
                return this.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(s$9.copy(s$9.copy$default$1(), s$9.copy$default$2(), newOut, s$9.copy$default$4(), s$9.copy$default$5(), s$9.copy$default$6(), s$9.copy$default$7(), s$9.copy$default$8()));
            }
            if (this.traceEnabled) {
                this.context.log().trace("Sending RequestNext to producer after RequestNext from worker [{}].", (Object)w.next().producerId());
            }
            ActorRef actorRef3 = ActorRef$.MODULE$.ActorRefOps(s$9.producer());
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef3, this.requestNext);
            return this.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(s$9.copy(s$9.copy$default$1(), s$9.copy$default$2(), newOut, s$9.copy$default$4(), s$9.copy$default$5(), s$9.copy$default$6(), s$9.copy$default$7(), true));
        }
        if (None$.MODULE$.equals(option)) {
            return Behaviors$.MODULE$.unhandled();
        }
        throw new MatchError(option);
    }

    private final Behavior receiveCurrentWorkers$1(State s$10, CurrentWorkers curr) {
        Set addedWorkers = (Set)curr.workers().diff(s$10.workers());
        Set removedWorkers = (Set)s$10.workers().diff(curr.workers());
        State newState = addedWorkers.foldLeft(s$10, (Function2<State, ActorRef, State> & Serializable)(acc, c) -> {
            String uuid = UUID.randomUUID().toString();
            String outKey = new StringBuilder(1).append(this.producerId).append("-").append(uuid).toString();
            package$LoggerOps$.MODULE$.debug2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Registered worker [{}], with producerId [{}].", c, outKey);
            ActorRef<ProducerController.Command<A>> p = this.context.spawn(ProducerController$.MODULE$.apply(outKey, None$.MODULE$, this.producerControllerSettings, this.evidence$1), uuid, DispatcherSelector$.MODULE$.sameAsParent());
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(p);
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerController$Start$.MODULE$.apply(this.workerRequestNextAdapter));
            ActorRef actorRef2 = ActorRef$.MODULE$.ActorRefOps(p);
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef2, ProducerController$RegisterConsumer$.MODULE$.apply(c));
            Map map = (Map)acc.out().updated(outKey, WorkPullingProducerControllerImpl$OutState$.MODULE$.apply(p, c, 0L, package$.MODULE$.Vector().empty(), None$.MODULE$));
            long l = acc.copy$default$1();
            Set set = acc.copy$default$2();
            Map<Object, PreselectedWorker> map2 = acc.copy$default$4();
            Map<Object, ActorRef<Done>> map3 = acc.copy$default$5();
            Map<Object, HandOver> map4 = acc.copy$default$6();
            ActorRef actorRef3 = acc.copy$default$7();
            boolean bl = acc.copy$default$8();
            return acc.copy(l, set, map, map2, map3, map4, actorRef3, bl);
        });
        State newState2 = removedWorkers.foldLeft(newState, (Function2<State, ActorRef, State> & Serializable)(acc, c) -> {
            Tuple2 tuple2;
            Option option = acc.out().find((Function1<Tuple2, boolean> & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    OutState outState = (OutState)tuple2._2();
                    ActorRef actorRef = outState.consumerController();
                    ActorRef actorRef2 = c;
                    return !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null);
                }
                throw new MatchError(tuple2);
            });
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                String key2 = (String)tuple2._1();
                OutState outState = (OutState)tuple2._2();
                package$LoggerOps$.MODULE$.debug2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Deregistered worker [{}], with producerId [{}].", c, key2);
                this.context.stop(outState.producerController());
                if (outState.unconfirmed().nonEmpty()) {
                    package$LoggerOps$.MODULE$.debugN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Resending unconfirmed from deregistered worker with producerId [{}], from seqNr [{}] to [{}].", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{key2, BoxesRunTime.boxToLong(outState.unconfirmed().head().outSeqNr()), BoxesRunTime.boxToLong(outState.unconfirmed().last().outSeqNr())}));
                }
                outState.unconfirmed().foreach(x$1 -> {
                    Unconfirmed unconfirmed = x$1;
                    if (unconfirmed != null) {
                        Unconfirmed unconfirmed2 = WorkPullingProducerControllerImpl$Unconfirmed$.MODULE$.unapply(unconfirmed);
                        long l = unconfirmed2._1();
                        long l2 = unconfirmed2._2();
                        Object a = unconfirmed2._3();
                        Option<ActorRef<Done>> option = unconfirmed2._4();
                        long totalSeqNr = l;
                        Object msg = a;
                        Option<ActorRef<Done>> replyTo = option;
                        if (this.durableQueue.isEmpty()) {
                            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.context.self());
                            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, WorkPullingProducerControllerImpl$Msg$.MODULE$.apply(msg, true, replyTo));
                            return;
                        }
                        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.context.self());
                        ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, WorkPullingProducerControllerImpl$ResendDurableMsg$.MODULE$.apply(msg, outState.confirmationQualifier(), totalSeqNr));
                        return;
                    }
                    throw new MatchError(unconfirmed);
                });
                Map map = (Map)acc.out().$minus(key2);
                long l = acc.copy$default$1();
                Set set = acc.copy$default$2();
                Map<Object, PreselectedWorker> map2 = acc.copy$default$4();
                Map<Object, ActorRef<Done>> map3 = acc.copy$default$5();
                Map<Object, HandOver> map4 = acc.copy$default$6();
                ActorRef actorRef = acc.copy$default$7();
                boolean bl = acc.copy$default$8();
                return acc.copy(l, set, map, map2, map3, map4, actorRef, bl);
            }
            if (None$.MODULE$.equals(option)) {
                this.context.log().debug("Deregistered non-existing worker [{}]", c);
                return acc;
            }
            throw new MatchError(option);
        });
        return this.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(newState2.copy(newState2.copy$default$1(), curr.workers(), newState2.copy$default$3(), newState2.copy$default$4(), newState2.copy$default$5(), newState2.copy$default$6(), newState2.copy$default$7(), newState2.copy$default$8()));
    }

    private final Behavior receiveStart$1(State s$11, WorkPullingProducerController.Start start) {
        ProducerControllerImpl$.MODULE$.enforceLocalProducer(start.producer());
        this.context.log().debug("Register new Producer [{}], currentSeqNr [{}].", (Object)start.producer(), (Object)BoxesRunTime.boxToLong(s$11.currentSeqNr()));
        if (s$11.requested()) {
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(start.producer());
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, this.requestNext);
        }
        return this.org$apache$pekko$actor$typed$delivery$internal$WorkPullingProducerControllerImpl$$active(s$11.copy(s$11.copy$default$1(), s$11.copy$default$2(), s$11.copy$default$3(), s$11.copy$default$4(), s$11.copy$default$5(), s$11.copy$default$6(), start.producer(), s$11.copy$default$8()));
    }

    public static final class Ack
    implements InternalCommand,
    Product,
    Serializable {
        private final String outKey;
        private final long confirmedSeqNr;

        public static Ack apply(String string2, long l) {
            return WorkPullingProducerControllerImpl$Ack$.MODULE$.apply(string2, l);
        }

        public static Ack fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$Ack$.MODULE$.fromProduct(product);
        }

        public static Ack unapply(Ack ack) {
            return WorkPullingProducerControllerImpl$Ack$.MODULE$.unapply(ack);
        }

        public Ack(String outKey, long confirmedSeqNr) {
            this.outKey = outKey;
            this.confirmedSeqNr = confirmedSeqNr;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.outKey()));
            n = Statics.mix(n, Statics.longHash(this.confirmedSeqNr()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Ack)) return false;
            Ack ack = (Ack)object;
            String string2 = this.outKey();
            String string3 = ack.outKey();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (this.confirmedSeqNr() != ack.confirmedSeqNr()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Ack;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Ack";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong(this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "outKey";
            }
            if (1 == n2) {
                return "confirmedSeqNr";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String outKey() {
            return this.outKey;
        }

        public long confirmedSeqNr() {
            return this.confirmedSeqNr;
        }

        public Ack copy(String outKey, long confirmedSeqNr) {
            return new Ack(outKey, confirmedSeqNr);
        }

        public String copy$default$1() {
            return this.outKey();
        }

        public long copy$default$2() {
            return this.confirmedSeqNr();
        }

        public String _1() {
            return this.outKey();
        }

        public long _2() {
            return this.confirmedSeqNr();
        }
    }

    public static final class AskTimeout
    implements InternalCommand,
    Product,
    Serializable {
        private final String outKey;
        private final long outSeqNr;

        public static AskTimeout apply(String string2, long l) {
            return WorkPullingProducerControllerImpl$AskTimeout$.MODULE$.apply(string2, l);
        }

        public static AskTimeout fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$AskTimeout$.MODULE$.fromProduct(product);
        }

        public static AskTimeout unapply(AskTimeout askTimeout) {
            return WorkPullingProducerControllerImpl$AskTimeout$.MODULE$.unapply(askTimeout);
        }

        public AskTimeout(String outKey, long outSeqNr) {
            this.outKey = outKey;
            this.outSeqNr = outSeqNr;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.outKey()));
            n = Statics.mix(n, Statics.longHash(this.outSeqNr()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AskTimeout)) return false;
            AskTimeout askTimeout = (AskTimeout)object;
            String string2 = this.outKey();
            String string3 = askTimeout.outKey();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (this.outSeqNr() != askTimeout.outSeqNr()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof AskTimeout;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "AskTimeout";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong(this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "outKey";
            }
            if (1 == n2) {
                return "outSeqNr";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String outKey() {
            return this.outKey;
        }

        public long outSeqNr() {
            return this.outSeqNr;
        }

        public AskTimeout copy(String outKey, long outSeqNr) {
            return new AskTimeout(outKey, outSeqNr);
        }

        public String copy$default$1() {
            return this.outKey();
        }

        public long copy$default$2() {
            return this.outSeqNr();
        }

        public String _1() {
            return this.outKey();
        }

        public long _2() {
            return this.outSeqNr();
        }
    }

    public static final class CurrentWorkers<A>
    implements InternalCommand,
    Product,
    Serializable {
        private final Set workers;

        public static <A> CurrentWorkers<A> apply(Set<ActorRef<ConsumerController.Command<A>>> set) {
            return WorkPullingProducerControllerImpl$CurrentWorkers$.MODULE$.apply(set);
        }

        public static CurrentWorkers<?> fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$CurrentWorkers$.MODULE$.fromProduct(product);
        }

        public static <A> CurrentWorkers<A> unapply(CurrentWorkers<A> currentWorkers) {
            return WorkPullingProducerControllerImpl$CurrentWorkers$.MODULE$.unapply(currentWorkers);
        }

        public CurrentWorkers(Set<ActorRef<ConsumerController.Command<A>>> workers) {
            this.workers = workers;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CurrentWorkers)) return false;
            CurrentWorkers currentWorkers = (CurrentWorkers)object;
            Set<ActorRef<ConsumerController.Command<A>>> set = this.workers();
            Set<ActorRef<ConsumerController.Command<A>>> set2 = currentWorkers.workers();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof CurrentWorkers;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "CurrentWorkers";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "workers";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Set<ActorRef<ConsumerController.Command<A>>> workers() {
            return this.workers;
        }

        public <A> CurrentWorkers<A> copy(Set<ActorRef<ConsumerController.Command<A>>> workers) {
            return new CurrentWorkers<A>(workers);
        }

        public <A> Set<ActorRef<ConsumerController.Command<A>>> copy$default$1() {
            return this.workers();
        }

        public Set<ActorRef<ConsumerController.Command<A>>> _1() {
            return this.workers();
        }
    }

    public static class HandOver
    implements Product,
    Serializable {
        private final String oldConfirmationQualifier;
        private final long oldSeqNr;

        public static HandOver apply(String string2, long l) {
            return WorkPullingProducerControllerImpl$HandOver$.MODULE$.apply(string2, l);
        }

        public static HandOver fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$HandOver$.MODULE$.fromProduct(product);
        }

        public static HandOver unapply(HandOver handOver) {
            return WorkPullingProducerControllerImpl$HandOver$.MODULE$.unapply(handOver);
        }

        public HandOver(String oldConfirmationQualifier, long oldSeqNr) {
            this.oldConfirmationQualifier = oldConfirmationQualifier;
            this.oldSeqNr = oldSeqNr;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.oldConfirmationQualifier()));
            n = Statics.mix(n, Statics.longHash(this.oldSeqNr()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HandOver)) return false;
            HandOver handOver = (HandOver)object;
            String string2 = this.oldConfirmationQualifier();
            String string3 = handOver.oldConfirmationQualifier();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (this.oldSeqNr() != handOver.oldSeqNr()) return false;
            if (!handOver.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof HandOver;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "HandOver";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong(this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "oldConfirmationQualifier";
            }
            if (1 == n2) {
                return "oldSeqNr";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String oldConfirmationQualifier() {
            return this.oldConfirmationQualifier;
        }

        public long oldSeqNr() {
            return this.oldSeqNr;
        }

        public HandOver copy(String oldConfirmationQualifier, long oldSeqNr) {
            return new HandOver(oldConfirmationQualifier, oldSeqNr);
        }

        public String copy$default$1() {
            return this.oldConfirmationQualifier();
        }

        public long copy$default$2() {
            return this.oldSeqNr();
        }

        public String _1() {
            return this.oldConfirmationQualifier();
        }

        public long _2() {
            return this.oldSeqNr();
        }
    }

    public static interface InternalCommand {
    }

    public static class LoadStateFailed
    implements InternalCommand,
    Product,
    Serializable {
        private final int attempt;

        public static LoadStateFailed apply(int n) {
            return WorkPullingProducerControllerImpl$LoadStateFailed$.MODULE$.apply(n);
        }

        public static LoadStateFailed fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$LoadStateFailed$.MODULE$.fromProduct(product);
        }

        public static LoadStateFailed unapply(LoadStateFailed loadStateFailed) {
            return WorkPullingProducerControllerImpl$LoadStateFailed$.MODULE$.unapply(loadStateFailed);
        }

        public LoadStateFailed(int attempt) {
            this.attempt = attempt;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.attempt());
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LoadStateFailed)) return false;
            LoadStateFailed loadStateFailed = (LoadStateFailed)object;
            if (this.attempt() != loadStateFailed.attempt()) return false;
            if (!loadStateFailed.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof LoadStateFailed;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "LoadStateFailed";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToInteger(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "attempt";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public int attempt() {
            return this.attempt;
        }

        public LoadStateFailed copy(int attempt) {
            return new LoadStateFailed(attempt);
        }

        public int copy$default$1() {
            return this.attempt();
        }

        public int _1() {
            return this.attempt();
        }
    }

    public static class LoadStateReply<A>
    implements InternalCommand,
    Product,
    Serializable {
        private final DurableProducerQueue.State state;

        public static <A> LoadStateReply<A> apply(DurableProducerQueue.State<A> state) {
            return WorkPullingProducerControllerImpl$LoadStateReply$.MODULE$.apply(state);
        }

        public static LoadStateReply<?> fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$LoadStateReply$.MODULE$.fromProduct(product);
        }

        public static <A> LoadStateReply<A> unapply(LoadStateReply<A> loadStateReply) {
            return WorkPullingProducerControllerImpl$LoadStateReply$.MODULE$.unapply(loadStateReply);
        }

        public LoadStateReply(DurableProducerQueue.State<A> state) {
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LoadStateReply)) return false;
            LoadStateReply loadStateReply = (LoadStateReply)object;
            DurableProducerQueue.State<A> state = this.state();
            DurableProducerQueue.State<A> state2 = loadStateReply.state();
            if (state == null) {
                if (state2 != null) {
                    return false;
                }
            } else if (!((Object)state).equals(state2)) return false;
            if (!loadStateReply.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof LoadStateReply;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "LoadStateReply";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public DurableProducerQueue.State<A> state() {
            return this.state;
        }

        public <A> LoadStateReply<A> copy(DurableProducerQueue.State<A> state) {
            return new LoadStateReply<A>(state);
        }

        public <A> DurableProducerQueue.State<A> copy$default$1() {
            return this.state();
        }

        public DurableProducerQueue.State<A> _1() {
            return this.state();
        }
    }

    public static final class Msg<A>
    implements InternalCommand,
    Product,
    Serializable {
        private final Object msg;
        private final boolean wasStashed;
        private final Option replyTo;

        public static <A> Msg<A> apply(A a, boolean bl, Option<ActorRef<Done>> option) {
            return WorkPullingProducerControllerImpl$Msg$.MODULE$.apply(a, bl, option);
        }

        public static Msg<?> fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$Msg$.MODULE$.fromProduct(product);
        }

        public static <A> Msg<A> unapply(Msg<A> msg) {
            return WorkPullingProducerControllerImpl$Msg$.MODULE$.unapply(msg);
        }

        public Msg(A msg, boolean wasStashed, Option<ActorRef<Done>> replyTo) {
            this.msg = msg;
            this.wasStashed = wasStashed;
            this.replyTo = replyTo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.msg()));
            n = Statics.mix(n, this.wasStashed() ? 1231 : 1237);
            n = Statics.mix(n, Statics.anyHash(this.replyTo()));
            return Statics.finalizeHash(n, 3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Msg)) return false;
            Msg msg = (Msg)object;
            if (this.wasStashed() != msg.wasStashed()) return false;
            if (!BoxesRunTime.equals(this.msg(), msg.msg())) return false;
            Option<ActorRef<Done>> option = this.replyTo();
            Option<ActorRef<Done>> option2 = msg.replyTo();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Msg;
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "Msg";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToBoolean(this._2());
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "msg";
                }
                case 1: {
                    return "wasStashed";
                }
                case 2: {
                    return "replyTo";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public A msg() {
            return (A)this.msg;
        }

        public boolean wasStashed() {
            return this.wasStashed;
        }

        public Option<ActorRef<Done>> replyTo() {
            return this.replyTo;
        }

        public <A> Msg<A> copy(A msg, boolean wasStashed, Option<ActorRef<Done>> replyTo) {
            return new Msg<A>(msg, wasStashed, replyTo);
        }

        public <A> A copy$default$1() {
            return this.msg();
        }

        public boolean copy$default$2() {
            return this.wasStashed();
        }

        public <A> Option<ActorRef<Done>> copy$default$3() {
            return this.replyTo();
        }

        public A _1() {
            return this.msg();
        }

        public boolean _2() {
            return this.wasStashed();
        }

        public Option<ActorRef<Done>> _3() {
            return this.replyTo();
        }
    }

    public static final class OutState<A>
    implements Product,
    Serializable {
        private final ActorRef producerController;
        private final ActorRef consumerController;
        private final long seqNr;
        private final Vector unconfirmed;
        private final Option askNextTo;

        public static <A> OutState<A> apply(ActorRef<ProducerController.Command<A>> actorRef, ActorRef<ConsumerController.Command<A>> actorRef2, long l, Vector<Unconfirmed<A>> vector, Option<ActorRef<ProducerController.MessageWithConfirmation<A>>> option) {
            return WorkPullingProducerControllerImpl$OutState$.MODULE$.apply(actorRef, actorRef2, l, vector, option);
        }

        public static OutState<?> fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$OutState$.MODULE$.fromProduct(product);
        }

        public static <A> OutState<A> unapply(OutState<A> outState) {
            return WorkPullingProducerControllerImpl$OutState$.MODULE$.unapply(outState);
        }

        public OutState(ActorRef<ProducerController.Command<A>> producerController, ActorRef<ConsumerController.Command<A>> consumerController, long seqNr, Vector<Unconfirmed<A>> unconfirmed, Option<ActorRef<ProducerController.MessageWithConfirmation<A>>> askNextTo) {
            this.producerController = producerController;
            this.consumerController = consumerController;
            this.seqNr = seqNr;
            this.unconfirmed = unconfirmed;
            this.askNextTo = askNextTo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.producerController()));
            n = Statics.mix(n, Statics.anyHash(this.consumerController()));
            n = Statics.mix(n, Statics.longHash(this.seqNr()));
            n = Statics.mix(n, Statics.anyHash(this.unconfirmed()));
            n = Statics.mix(n, Statics.anyHash(this.askNextTo()));
            return Statics.finalizeHash(n, 5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OutState)) return false;
            OutState outState = (OutState)object;
            ActorRef<ProducerController.Command<A>> actorRef = this.producerController();
            ActorRef<ProducerController.Command<A>> actorRef2 = outState.producerController();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            ActorRef<ConsumerController.Command<A>> actorRef3 = this.consumerController();
            ActorRef<ConsumerController.Command<A>> actorRef4 = outState.consumerController();
            if (actorRef3 == null) {
                if (actorRef4 != null) {
                    return false;
                }
            } else if (!actorRef3.equals(actorRef4)) return false;
            if (this.seqNr() != outState.seqNr()) return false;
            Vector<Unconfirmed<A>> vector = this.unconfirmed();
            Vector<Unconfirmed<A>> vector2 = outState.unconfirmed();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!((Object)vector).equals(vector2)) return false;
            Option<ActorRef<ProducerController.MessageWithConfirmation<A>>> option = this.askNextTo();
            Option<ActorRef<ProducerController.MessageWithConfirmation<A>>> option2 = outState.askNextTo();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof OutState;
        }

        @Override
        public int productArity() {
            return 5;
        }

        @Override
        public String productPrefix() {
            return "OutState";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToLong(this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "producerController";
                }
                case 1: {
                    return "consumerController";
                }
                case 2: {
                    return "seqNr";
                }
                case 3: {
                    return "unconfirmed";
                }
                case 4: {
                    return "askNextTo";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<ProducerController.Command<A>> producerController() {
            return this.producerController;
        }

        public ActorRef<ConsumerController.Command<A>> consumerController() {
            return this.consumerController;
        }

        public long seqNr() {
            return this.seqNr;
        }

        public Vector<Unconfirmed<A>> unconfirmed() {
            return this.unconfirmed;
        }

        public Option<ActorRef<ProducerController.MessageWithConfirmation<A>>> askNextTo() {
            return this.askNextTo;
        }

        public String confirmationQualifier() {
            return this.producerController().path().name();
        }

        public <A> OutState<A> copy(ActorRef<ProducerController.Command<A>> producerController, ActorRef<ConsumerController.Command<A>> consumerController, long seqNr, Vector<Unconfirmed<A>> unconfirmed, Option<ActorRef<ProducerController.MessageWithConfirmation<A>>> askNextTo) {
            return new OutState<A>(producerController, consumerController, seqNr, unconfirmed, askNextTo);
        }

        public <A> ActorRef<ProducerController.Command<A>> copy$default$1() {
            return this.producerController();
        }

        public <A> ActorRef<ConsumerController.Command<A>> copy$default$2() {
            return this.consumerController();
        }

        public long copy$default$3() {
            return this.seqNr();
        }

        public <A> Vector<Unconfirmed<A>> copy$default$4() {
            return this.unconfirmed();
        }

        public <A> Option<ActorRef<ProducerController.MessageWithConfirmation<A>>> copy$default$5() {
            return this.askNextTo();
        }

        public ActorRef<ProducerController.Command<A>> _1() {
            return this.producerController();
        }

        public ActorRef<ConsumerController.Command<A>> _2() {
            return this.consumerController();
        }

        public long _3() {
            return this.seqNr();
        }

        public Vector<Unconfirmed<A>> _4() {
            return this.unconfirmed();
        }

        public Option<ActorRef<ProducerController.MessageWithConfirmation<A>>> _5() {
            return this.askNextTo();
        }
    }

    public static class PreselectedWorker
    implements Product,
    Serializable {
        private final String outKey;
        private final String confirmationQualifier;

        public static PreselectedWorker apply(String string2, String string3) {
            return WorkPullingProducerControllerImpl$PreselectedWorker$.MODULE$.apply(string2, string3);
        }

        public static PreselectedWorker fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$PreselectedWorker$.MODULE$.fromProduct(product);
        }

        public static PreselectedWorker unapply(PreselectedWorker preselectedWorker) {
            return WorkPullingProducerControllerImpl$PreselectedWorker$.MODULE$.unapply(preselectedWorker);
        }

        public PreselectedWorker(String outKey, String confirmationQualifier) {
            this.outKey = outKey;
            this.confirmationQualifier = confirmationQualifier;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PreselectedWorker)) return false;
            PreselectedWorker preselectedWorker = (PreselectedWorker)object;
            String string2 = this.outKey();
            String string3 = preselectedWorker.outKey();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            String string4 = this.confirmationQualifier();
            String string5 = preselectedWorker.confirmationQualifier();
            if (string4 == null) {
                if (string5 != null) {
                    return false;
                }
            } else if (!string4.equals(string5)) return false;
            if (!preselectedWorker.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof PreselectedWorker;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "PreselectedWorker";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "outKey";
            }
            if (1 == n2) {
                return "confirmationQualifier";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String outKey() {
            return this.outKey;
        }

        public String confirmationQualifier() {
            return this.confirmationQualifier;
        }

        public PreselectedWorker copy(String outKey, String confirmationQualifier) {
            return new PreselectedWorker(outKey, confirmationQualifier);
        }

        public String copy$default$1() {
            return this.outKey();
        }

        public String copy$default$2() {
            return this.confirmationQualifier();
        }

        public String _1() {
            return this.outKey();
        }

        public String _2() {
            return this.confirmationQualifier();
        }
    }

    public static final class ResendDurableMsg<A>
    implements InternalCommand,
    Product,
    Serializable {
        private final Object msg;
        private final String oldConfirmationQualifier;
        private final long oldSeqNr;

        public static <A> ResendDurableMsg<A> apply(A a, String string2, long l) {
            return WorkPullingProducerControllerImpl$ResendDurableMsg$.MODULE$.apply(a, string2, l);
        }

        public static ResendDurableMsg<?> fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$ResendDurableMsg$.MODULE$.fromProduct(product);
        }

        public static <A> ResendDurableMsg<A> unapply(ResendDurableMsg<A> resendDurableMsg) {
            return WorkPullingProducerControllerImpl$ResendDurableMsg$.MODULE$.unapply(resendDurableMsg);
        }

        public ResendDurableMsg(A msg, String oldConfirmationQualifier, long oldSeqNr) {
            this.msg = msg;
            this.oldConfirmationQualifier = oldConfirmationQualifier;
            this.oldSeqNr = oldSeqNr;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.msg()));
            n = Statics.mix(n, Statics.anyHash(this.oldConfirmationQualifier()));
            n = Statics.mix(n, Statics.longHash(this.oldSeqNr()));
            return Statics.finalizeHash(n, 3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ResendDurableMsg)) return false;
            ResendDurableMsg resendDurableMsg = (ResendDurableMsg)object;
            if (!BoxesRunTime.equals(this.msg(), resendDurableMsg.msg())) return false;
            String string2 = this.oldConfirmationQualifier();
            String string3 = resendDurableMsg.oldConfirmationQualifier();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (this.oldSeqNr() != resendDurableMsg.oldSeqNr()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof ResendDurableMsg;
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "ResendDurableMsg";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToLong(this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "msg";
                }
                case 1: {
                    return "oldConfirmationQualifier";
                }
                case 2: {
                    return "oldSeqNr";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public A msg() {
            return (A)this.msg;
        }

        public String oldConfirmationQualifier() {
            return this.oldConfirmationQualifier;
        }

        public long oldSeqNr() {
            return this.oldSeqNr;
        }

        public <A> ResendDurableMsg<A> copy(A msg, String oldConfirmationQualifier, long oldSeqNr) {
            return new ResendDurableMsg<A>(msg, oldConfirmationQualifier, oldSeqNr);
        }

        public <A> A copy$default$1() {
            return this.msg();
        }

        public <A> String copy$default$2() {
            return this.oldConfirmationQualifier();
        }

        public long copy$default$3() {
            return this.oldSeqNr();
        }

        public A _1() {
            return this.msg();
        }

        public String _2() {
            return this.oldConfirmationQualifier();
        }

        public long _3() {
            return this.oldSeqNr();
        }
    }

    public static final class State<A>
    implements Product,
    Serializable {
        private final long currentSeqNr;
        private final Set workers;
        private final Map out;
        private final Map preselectedWorkers;
        private final Map replyAfterStore;
        private final Map handOver;
        private final ActorRef producer;
        private final boolean requested;

        public static <A> State<A> apply(long l, Set<ActorRef<ConsumerController.Command<A>>> set, Map<String, OutState<A>> map, Map<Object, PreselectedWorker> map2, Map<Object, ActorRef<Done>> map3, Map<Object, HandOver> map4, ActorRef<WorkPullingProducerController.RequestNext<A>> actorRef, boolean bl) {
            return WorkPullingProducerControllerImpl$State$.MODULE$.apply(l, set, map, map2, map3, map4, actorRef, bl);
        }

        public static State<?> fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$State$.MODULE$.fromProduct(product);
        }

        public static <A> State<A> unapply(State<A> state) {
            return WorkPullingProducerControllerImpl$State$.MODULE$.unapply(state);
        }

        public State(long currentSeqNr, Set<ActorRef<ConsumerController.Command<A>>> workers, Map<String, OutState<A>> out, Map<Object, PreselectedWorker> preselectedWorkers, Map<Object, ActorRef<Done>> replyAfterStore, Map<Object, HandOver> handOver, ActorRef<WorkPullingProducerController.RequestNext<A>> producer, boolean requested) {
            this.currentSeqNr = currentSeqNr;
            this.workers = workers;
            this.out = out;
            this.preselectedWorkers = preselectedWorkers;
            this.replyAfterStore = replyAfterStore;
            this.handOver = handOver;
            this.producer = producer;
            this.requested = requested;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.longHash(this.currentSeqNr()));
            n = Statics.mix(n, Statics.anyHash(this.workers()));
            n = Statics.mix(n, Statics.anyHash(this.out()));
            n = Statics.mix(n, Statics.anyHash(this.preselectedWorkers()));
            n = Statics.mix(n, Statics.anyHash(this.replyAfterStore()));
            n = Statics.mix(n, Statics.anyHash(this.handOver()));
            n = Statics.mix(n, Statics.anyHash(this.producer()));
            n = Statics.mix(n, this.requested() ? 1231 : 1237);
            return Statics.finalizeHash(n, 8);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.requested() != state.requested()) return false;
            if (this.currentSeqNr() != state.currentSeqNr()) return false;
            Set<ActorRef<ConsumerController.Command<A>>> set = this.workers();
            Set<ActorRef<ConsumerController.Command<A>>> set2 = state.workers();
            if (set == null) {
                if (set2 != null) {
                    return false;
                }
            } else if (!set.equals(set2)) return false;
            Map<String, OutState<A>> map = this.out();
            Map<String, OutState<A>> map2 = state.out();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Map<Object, PreselectedWorker> map3 = this.preselectedWorkers();
            Map<Object, PreselectedWorker> map4 = state.preselectedWorkers();
            if (map3 == null) {
                if (map4 != null) {
                    return false;
                }
            } else if (!map3.equals(map4)) return false;
            Map<Object, ActorRef<Done>> map5 = this.replyAfterStore();
            Map<Object, ActorRef<Done>> map6 = state.replyAfterStore();
            if (map5 == null) {
                if (map6 != null) {
                    return false;
                }
            } else if (!map5.equals(map6)) return false;
            Map<Object, HandOver> map7 = this.handOver();
            Map<Object, HandOver> map8 = state.handOver();
            if (map7 == null) {
                if (map8 != null) {
                    return false;
                }
            } else if (!map7.equals(map8)) return false;
            ActorRef<WorkPullingProducerController.RequestNext<A>> actorRef = this.producer();
            ActorRef<WorkPullingProducerController.RequestNext<A>> actorRef2 = state.producer();
            if (actorRef == null) {
                if (actorRef2 == null) return true;
                return false;
            } else {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        @Override
        public int productArity() {
            return 8;
        }

        @Override
        public String productPrefix() {
            return "State";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong(this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return BoxesRunTime.boxToBoolean(this._8());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "currentSeqNr";
                }
                case 1: {
                    return "workers";
                }
                case 2: {
                    return "out";
                }
                case 3: {
                    return "preselectedWorkers";
                }
                case 4: {
                    return "replyAfterStore";
                }
                case 5: {
                    return "handOver";
                }
                case 6: {
                    return "producer";
                }
                case 7: {
                    return "requested";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public long currentSeqNr() {
            return this.currentSeqNr;
        }

        public Set<ActorRef<ConsumerController.Command<A>>> workers() {
            return this.workers;
        }

        public Map<String, OutState<A>> out() {
            return this.out;
        }

        public Map<Object, PreselectedWorker> preselectedWorkers() {
            return this.preselectedWorkers;
        }

        public Map<Object, ActorRef<Done>> replyAfterStore() {
            return this.replyAfterStore;
        }

        public Map<Object, HandOver> handOver() {
            return this.handOver;
        }

        public ActorRef<WorkPullingProducerController.RequestNext<A>> producer() {
            return this.producer;
        }

        public boolean requested() {
            return this.requested;
        }

        public <A> State<A> copy(long currentSeqNr, Set<ActorRef<ConsumerController.Command<A>>> workers, Map<String, OutState<A>> out, Map<Object, PreselectedWorker> preselectedWorkers, Map<Object, ActorRef<Done>> replyAfterStore, Map<Object, HandOver> handOver, ActorRef<WorkPullingProducerController.RequestNext<A>> producer, boolean requested) {
            return new State<A>(currentSeqNr, workers, out, preselectedWorkers, replyAfterStore, handOver, producer, requested);
        }

        public long copy$default$1() {
            return this.currentSeqNr();
        }

        public <A> Set<ActorRef<ConsumerController.Command<A>>> copy$default$2() {
            return this.workers();
        }

        public <A> Map<String, OutState<A>> copy$default$3() {
            return this.out();
        }

        public <A> Map<Object, PreselectedWorker> copy$default$4() {
            return this.preselectedWorkers();
        }

        public <A> Map<Object, ActorRef<Done>> copy$default$5() {
            return this.replyAfterStore();
        }

        public <A> Map<Object, HandOver> copy$default$6() {
            return this.handOver();
        }

        public <A> ActorRef<WorkPullingProducerController.RequestNext<A>> copy$default$7() {
            return this.producer();
        }

        public boolean copy$default$8() {
            return this.requested();
        }

        public long _1() {
            return this.currentSeqNr();
        }

        public Set<ActorRef<ConsumerController.Command<A>>> _2() {
            return this.workers();
        }

        public Map<String, OutState<A>> _3() {
            return this.out();
        }

        public Map<Object, PreselectedWorker> _4() {
            return this.preselectedWorkers();
        }

        public Map<Object, ActorRef<Done>> _5() {
            return this.replyAfterStore();
        }

        public Map<Object, HandOver> _6() {
            return this.handOver();
        }

        public ActorRef<WorkPullingProducerController.RequestNext<A>> _7() {
            return this.producer();
        }

        public boolean _8() {
            return this.requested();
        }
    }

    public static class StoreMessageSentCompleted<A>
    implements InternalCommand,
    Product,
    Serializable {
        private final DurableProducerQueue.MessageSent messageSent;

        public static <A> StoreMessageSentCompleted<A> apply(DurableProducerQueue.MessageSent<A> messageSent) {
            return WorkPullingProducerControllerImpl$StoreMessageSentCompleted$.MODULE$.apply(messageSent);
        }

        public static StoreMessageSentCompleted<?> fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$StoreMessageSentCompleted$.MODULE$.fromProduct(product);
        }

        public static <A> StoreMessageSentCompleted<A> unapply(StoreMessageSentCompleted<A> storeMessageSentCompleted) {
            return WorkPullingProducerControllerImpl$StoreMessageSentCompleted$.MODULE$.unapply(storeMessageSentCompleted);
        }

        public StoreMessageSentCompleted(DurableProducerQueue.MessageSent<A> messageSent) {
            this.messageSent = messageSent;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoreMessageSentCompleted)) return false;
            StoreMessageSentCompleted storeMessageSentCompleted = (StoreMessageSentCompleted)object;
            DurableProducerQueue.MessageSent<A> messageSent = this.messageSent();
            DurableProducerQueue.MessageSent<A> messageSent2 = storeMessageSentCompleted.messageSent();
            if (messageSent == null) {
                if (messageSent2 != null) {
                    return false;
                }
            } else if (!((Object)messageSent).equals(messageSent2)) return false;
            if (!storeMessageSentCompleted.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof StoreMessageSentCompleted;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "StoreMessageSentCompleted";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "messageSent";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public DurableProducerQueue.MessageSent<A> messageSent() {
            return this.messageSent;
        }

        public <A> StoreMessageSentCompleted<A> copy(DurableProducerQueue.MessageSent<A> messageSent) {
            return new StoreMessageSentCompleted<A>(messageSent);
        }

        public <A> DurableProducerQueue.MessageSent<A> copy$default$1() {
            return this.messageSent();
        }

        public DurableProducerQueue.MessageSent<A> _1() {
            return this.messageSent();
        }
    }

    public static class StoreMessageSentFailed<A>
    implements InternalCommand,
    Product,
    Serializable {
        private final DurableProducerQueue.MessageSent messageSent;
        private final int attempt;

        public static <A> StoreMessageSentFailed<A> apply(DurableProducerQueue.MessageSent<A> messageSent, int n) {
            return WorkPullingProducerControllerImpl$StoreMessageSentFailed$.MODULE$.apply(messageSent, n);
        }

        public static StoreMessageSentFailed<?> fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$StoreMessageSentFailed$.MODULE$.fromProduct(product);
        }

        public static <A> StoreMessageSentFailed<A> unapply(StoreMessageSentFailed<A> storeMessageSentFailed) {
            return WorkPullingProducerControllerImpl$StoreMessageSentFailed$.MODULE$.unapply(storeMessageSentFailed);
        }

        public StoreMessageSentFailed(DurableProducerQueue.MessageSent<A> messageSent, int attempt) {
            this.messageSent = messageSent;
            this.attempt = attempt;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.messageSent()));
            n = Statics.mix(n, this.attempt());
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoreMessageSentFailed)) return false;
            StoreMessageSentFailed storeMessageSentFailed = (StoreMessageSentFailed)object;
            if (this.attempt() != storeMessageSentFailed.attempt()) return false;
            DurableProducerQueue.MessageSent<A> messageSent = this.messageSent();
            DurableProducerQueue.MessageSent<A> messageSent2 = storeMessageSentFailed.messageSent();
            if (messageSent == null) {
                if (messageSent2 != null) {
                    return false;
                }
            } else if (!((Object)messageSent).equals(messageSent2)) return false;
            if (!storeMessageSentFailed.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof StoreMessageSentFailed;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "StoreMessageSentFailed";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger(this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "messageSent";
            }
            if (1 == n2) {
                return "attempt";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public DurableProducerQueue.MessageSent<A> messageSent() {
            return this.messageSent;
        }

        public int attempt() {
            return this.attempt;
        }

        public <A> StoreMessageSentFailed<A> copy(DurableProducerQueue.MessageSent<A> messageSent, int attempt) {
            return new StoreMessageSentFailed<A>(messageSent, attempt);
        }

        public <A> DurableProducerQueue.MessageSent<A> copy$default$1() {
            return this.messageSent();
        }

        public int copy$default$2() {
            return this.attempt();
        }

        public DurableProducerQueue.MessageSent<A> _1() {
            return this.messageSent();
        }

        public int _2() {
            return this.attempt();
        }
    }

    public static class StoreMessageSentReply
    implements Product,
    Serializable {
        private final DurableProducerQueue.StoreMessageSentAck ack;

        public static StoreMessageSentReply apply(DurableProducerQueue.StoreMessageSentAck storeMessageSentAck) {
            return WorkPullingProducerControllerImpl$StoreMessageSentReply$.MODULE$.apply(storeMessageSentAck);
        }

        public static StoreMessageSentReply fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$StoreMessageSentReply$.MODULE$.fromProduct(product);
        }

        public static StoreMessageSentReply unapply(StoreMessageSentReply storeMessageSentReply) {
            return WorkPullingProducerControllerImpl$StoreMessageSentReply$.MODULE$.unapply(storeMessageSentReply);
        }

        public StoreMessageSentReply(DurableProducerQueue.StoreMessageSentAck ack) {
            this.ack = ack;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoreMessageSentReply)) return false;
            StoreMessageSentReply storeMessageSentReply = (StoreMessageSentReply)object;
            DurableProducerQueue.StoreMessageSentAck storeMessageSentAck = this.ack();
            DurableProducerQueue.StoreMessageSentAck storeMessageSentAck2 = storeMessageSentReply.ack();
            if (storeMessageSentAck == null) {
                if (storeMessageSentAck2 != null) {
                    return false;
                }
            } else if (!((Object)storeMessageSentAck).equals(storeMessageSentAck2)) return false;
            if (!storeMessageSentReply.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof StoreMessageSentReply;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "StoreMessageSentReply";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ack";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public DurableProducerQueue.StoreMessageSentAck ack() {
            return this.ack;
        }

        public StoreMessageSentReply copy(DurableProducerQueue.StoreMessageSentAck ack) {
            return new StoreMessageSentReply(ack);
        }

        public DurableProducerQueue.StoreMessageSentAck copy$default$1() {
            return this.ack();
        }

        public DurableProducerQueue.StoreMessageSentAck _1() {
            return this.ack();
        }
    }

    public static final class Unconfirmed<A>
    implements Product,
    Serializable {
        private final long totalSeqNr;
        private final long outSeqNr;
        private final Object msg;
        private final Option replyTo;

        public static <A> Unconfirmed<A> apply(long l, long l2, A a, Option<ActorRef<Done>> option) {
            return WorkPullingProducerControllerImpl$Unconfirmed$.MODULE$.apply(l, l2, a, option);
        }

        public static Unconfirmed<?> fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$Unconfirmed$.MODULE$.fromProduct(product);
        }

        public static <A> Unconfirmed<A> unapply(Unconfirmed<A> unconfirmed) {
            return WorkPullingProducerControllerImpl$Unconfirmed$.MODULE$.unapply(unconfirmed);
        }

        public Unconfirmed(long totalSeqNr, long outSeqNr, A msg, Option<ActorRef<Done>> replyTo) {
            this.totalSeqNr = totalSeqNr;
            this.outSeqNr = outSeqNr;
            this.msg = msg;
            this.replyTo = replyTo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.longHash(this.totalSeqNr()));
            n = Statics.mix(n, Statics.longHash(this.outSeqNr()));
            n = Statics.mix(n, Statics.anyHash(this.msg()));
            n = Statics.mix(n, Statics.anyHash(this.replyTo()));
            return Statics.finalizeHash(n, 4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Unconfirmed)) return false;
            Unconfirmed unconfirmed = (Unconfirmed)object;
            if (this.totalSeqNr() != unconfirmed.totalSeqNr()) return false;
            if (this.outSeqNr() != unconfirmed.outSeqNr()) return false;
            if (!BoxesRunTime.equals(this.msg(), unconfirmed.msg())) return false;
            Option<ActorRef<Done>> option = this.replyTo();
            Option<ActorRef<Done>> option2 = unconfirmed.replyTo();
            if (option != null) {
                if (!option.equals(option2)) return false;
                return true;
            }
            if (option2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Unconfirmed;
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public String productPrefix() {
            return "Unconfirmed";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong(this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToLong(this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "totalSeqNr";
                }
                case 1: {
                    return "outSeqNr";
                }
                case 2: {
                    return "msg";
                }
                case 3: {
                    return "replyTo";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public long totalSeqNr() {
            return this.totalSeqNr;
        }

        public long outSeqNr() {
            return this.outSeqNr;
        }

        public A msg() {
            return (A)this.msg;
        }

        public Option<ActorRef<Done>> replyTo() {
            return this.replyTo;
        }

        public <A> Unconfirmed<A> copy(long totalSeqNr, long outSeqNr, A msg, Option<ActorRef<Done>> replyTo) {
            return new Unconfirmed<A>(totalSeqNr, outSeqNr, msg, replyTo);
        }

        public long copy$default$1() {
            return this.totalSeqNr();
        }

        public long copy$default$2() {
            return this.outSeqNr();
        }

        public <A> A copy$default$3() {
            return this.msg();
        }

        public <A> Option<ActorRef<Done>> copy$default$4() {
            return this.replyTo();
        }

        public long _1() {
            return this.totalSeqNr();
        }

        public long _2() {
            return this.outSeqNr();
        }

        public A _3() {
            return this.msg();
        }

        public Option<ActorRef<Done>> _4() {
            return this.replyTo();
        }
    }

    public static interface UnsealedInternalCommand
    extends InternalCommand {
    }

    public static final class WorkerRequestNext<A>
    implements InternalCommand,
    Product,
    Serializable {
        private final ProducerController.RequestNext next;

        public static <A> WorkerRequestNext<A> apply(ProducerController.RequestNext<A> requestNext) {
            return WorkPullingProducerControllerImpl$WorkerRequestNext$.MODULE$.apply(requestNext);
        }

        public static WorkerRequestNext<?> fromProduct(Product product) {
            return WorkPullingProducerControllerImpl$WorkerRequestNext$.MODULE$.fromProduct(product);
        }

        public static <A> WorkerRequestNext<A> unapply(WorkerRequestNext<A> workerRequestNext) {
            return WorkPullingProducerControllerImpl$WorkerRequestNext$.MODULE$.unapply(workerRequestNext);
        }

        public WorkerRequestNext(ProducerController.RequestNext<A> next) {
            this.next = next;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WorkerRequestNext)) return false;
            WorkerRequestNext workerRequestNext = (WorkerRequestNext)object;
            ProducerController.RequestNext<A> requestNext = this.next();
            ProducerController.RequestNext<A> requestNext2 = workerRequestNext.next();
            if (requestNext != null) {
                if (!((Object)requestNext).equals(requestNext2)) return false;
                return true;
            }
            if (requestNext2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof WorkerRequestNext;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "WorkerRequestNext";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "next";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ProducerController.RequestNext<A> next() {
            return this.next;
        }

        public <A> WorkerRequestNext<A> copy(ProducerController.RequestNext<A> next) {
            return new WorkerRequestNext<A>(next);
        }

        public <A> ProducerController.RequestNext<A> copy$default$1() {
            return this.next();
        }

        public ProducerController.RequestNext<A> _1() {
            return this.next();
        }
    }
}

