/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.delivery.internal;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.ActorRef$ActorRefOps$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.RecipientRef;
import org.apache.pekko.actor.typed.delivery.ConsumerController;
import org.apache.pekko.actor.typed.delivery.ConsumerController$SequencedMessage$;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue$;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue$MessageSent$;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue$StoreMessageConfirmed$;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue$StoreMessageSent$;
import org.apache.pekko.actor.typed.delivery.ProducerController;
import org.apache.pekko.actor.typed.delivery.ProducerController$MessageWithConfirmation$;
import org.apache.pekko.actor.typed.delivery.ProducerController$RegisterConsumer$;
import org.apache.pekko.actor.typed.delivery.ProducerController$RequestNext$;
import org.apache.pekko.actor.typed.delivery.internal.ChunkedMessage;
import org.apache.pekko.actor.typed.delivery.internal.DeliverySerializable;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$Ack$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$DurableQueueTerminated$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$LoadStateFailed$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$LoadStateReply$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$Msg$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$Request$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$Resend$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$ResendFirst$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$ResendFirstUnconfirmed$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$SendChunk$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$State$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$StoreMessageSentCompleted$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$StoreMessageSentFailed$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$StoreMessageSentReply$;
import org.apache.pekko.actor.typed.internal.ActorFlightRecorder;
import org.apache.pekko.actor.typed.internal.ActorFlightRecorder$;
import org.apache.pekko.actor.typed.internal.DeliveryFlightRecorder;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.actor.typed.scaladsl.TimerScheduler;
import org.apache.pekko.actor.typed.scaladsl.package$LoggerOps$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractSeq;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class ProducerControllerImpl<A> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ProducerControllerImpl.class.getDeclaredField("serialization$lzy1"));
    private final ActorContext<InternalCommand> context;
    private final String producerId;
    private final Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue;
    private final ProducerController.Settings settings;
    private final ActorRef<A> msgAdapter;
    private final TimerScheduler<InternalCommand> timers;
    private final ClassTag<A> evidence$1;
    private final DeliveryFlightRecorder flightRecorder;
    private final boolean traceEnabled;
    private final Timeout askTimeout;
    private volatile Object serialization$lzy1;

    public static <A> Behavior<ProducerController.Command<A>> apply(String string2, Option<Behavior<DurableProducerQueue.Command<A>>> option, ProducerController.Settings settings, ClassTag<A> classTag) {
        return ProducerControllerImpl$.MODULE$.apply(string2, option, settings, classTag);
    }

    public static <A> Behavior<ProducerController.Command<A>> apply(String string2, Option<Behavior<DurableProducerQueue.Command<A>>> option, ProducerController.Settings settings, Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> function1, ClassTag<A> classTag) {
        return ProducerControllerImpl$.MODULE$.apply(string2, option, settings, function1, classTag);
    }

    public static <A> Seq<ChunkedMessage> createChunks(A a, int n, Serialization serialization) {
        return ProducerControllerImpl$.MODULE$.createChunks(a, n, serialization);
    }

    public static void enforceLocalProducer(ActorRef<?> actorRef) {
        ProducerControllerImpl$.MODULE$.enforceLocalProducer(actorRef);
    }

    public ProducerControllerImpl(ActorContext<InternalCommand> context, String producerId, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, ProducerController.Settings settings, ActorRef<A> msgAdapter, TimerScheduler<InternalCommand> timers, ClassTag<A> evidence$1) {
        this.context = context;
        this.producerId = producerId;
        this.durableQueue = durableQueue;
        this.settings = settings;
        this.msgAdapter = msgAdapter;
        this.timers = timers;
        this.evidence$1 = evidence$1;
        this.flightRecorder = ((ActorFlightRecorder)ActorFlightRecorder$.MODULE$.apply(context.system())).delivery();
        this.traceEnabled = context.log().isTraceEnabled();
        this.askTimeout = Timeout$.MODULE$.durationToTimeout(settings.durableQueueRequestTimeout());
    }

    private Serialization serialization() {
        Object object = this.serialization$lzy1;
        if (object instanceof Serialization) {
            return (Serialization)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Serialization)this.serialization$lzyINIT1();
    }

    private Object serialization$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.serialization$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Serialization serialization = null;
                    try {
                        serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.context.system());
                        object2 = serialization == null ? LazyVals$NullValue$.MODULE$ : serialization;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.serialization$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serialization;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Behavior<InternalCommand> org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$active(State<A> s2) {
        return (Behavior)((Object)Behaviors$.MODULE$.receiveMessage((Function1<InternalCommand, Behavior> & Serializable)x$1 -> {
            ProducerController.RegisterConsumer registerConsumer;
            ActorRef actorRef;
            StoreMessageSentCompleted storeMessageSentCompleted;
            DurableProducerQueue.MessageSent messageSent;
            Option<A> option;
            Msg msg;
            Object a;
            InternalCommand internalCommand = x$1;
            if (internalCommand instanceof ProducerController.MessageWithConfirmation) {
                Option<A> option2;
                ProducerController.MessageWithConfirmation messageWithConfirmation = ProducerController$MessageWithConfirmation$.MODULE$.unapply((ProducerController.MessageWithConfirmation)internalCommand);
                Object a2 = messageWithConfirmation._1();
                ActorRef<Object> actorRef2 = messageWithConfirmation._2();
                if (a2 != null && !(option2 = this.evidence$1.unapply(a2)).isEmpty()) {
                    A a3;
                    A m = a3 = option2.get();
                    ActorRef<Object> replyTo = actorRef2;
                    ProducerControllerImpl.checkReceiveMessageRemainingChunksState$1(s2);
                    this.flightRecorder.producerReceived(this.producerId, s2.currentSeqNr());
                    Seq chunks = this.chunk$1(s2, m, true);
                    Map newReplyAfterStore = (Map)s2.replyAfterStore().updated(BoxesRunTime.boxToLong(((ConsumerController.SequencedMessage)chunks.last()).seqNr()), replyTo);
                    if (this.durableQueue.isEmpty()) {
                        return this.onMsg$1(s2, (ConsumerController.SequencedMessage)chunks.head(), newReplyAfterStore, (Seq)chunks.tail());
                    }
                    ConsumerController.SequencedMessage seqMsg = (ConsumerController.SequencedMessage)chunks.head();
                    this.storeMessageSent(DurableProducerQueue$MessageSent$.MODULE$.fromMessageOrChunked(seqMsg.seqNr(), seqMsg.message(), seqMsg.ack(), DurableProducerQueue$.MODULE$.NoQualifier(), System.currentTimeMillis()), 1);
                    return this.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$active(s2.copy(s2.copy$default$1(), s2.copy$default$2(), s2.copy$default$3(), s2.copy$default$4(), newReplyAfterStore, s2.copy$default$6(), s2.copy$default$7(), chunks, seqMsg.seqNr(), s2.copy$default$10(), s2.copy$default$11(), s2.copy$default$12()));
                }
            }
            if (internalCommand instanceof Msg && (a = (msg = ProducerControllerImpl$Msg$.MODULE$.unapply((Msg)internalCommand))._1()) != null && !(option = this.evidence$1.unapply(a)).isEmpty()) {
                A a4;
                A m = a4 = option.get();
                ProducerControllerImpl.checkReceiveMessageRemainingChunksState$1(s2);
                this.flightRecorder.producerReceived(this.producerId, s2.currentSeqNr());
                Seq chunks = this.chunk$1(s2, m, false);
                if (this.durableQueue.isEmpty()) {
                    return this.onMsg$1(s2, (ConsumerController.SequencedMessage)chunks.head(), s2.replyAfterStore(), (Seq)chunks.tail());
                }
                ConsumerController.SequencedMessage seqMsg = (ConsumerController.SequencedMessage)chunks.head();
                this.storeMessageSent(DurableProducerQueue$MessageSent$.MODULE$.fromMessageOrChunked(seqMsg.seqNr(), seqMsg.message(), seqMsg.ack(), DurableProducerQueue$.MODULE$.NoQualifier(), System.currentTimeMillis()), 1);
                return this.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$active(s2.copy(s2.copy$default$1(), s2.copy$default$2(), s2.copy$default$3(), s2.copy$default$4(), s2.copy$default$5(), s2.copy$default$6(), s2.copy$default$7(), chunks, seqMsg.seqNr(), s2.copy$default$10(), s2.copy$default$11(), s2.copy$default$12()));
            }
            if (internalCommand instanceof StoreMessageSentCompleted && (messageSent = (storeMessageSentCompleted = ProducerControllerImpl$StoreMessageSentCompleted$.MODULE$.unapply((StoreMessageSentCompleted)internalCommand))._1()) instanceof DurableProducerQueue.MessageSent) {
                DurableProducerQueue.MessageSent sent = messageSent;
                return this.receiveStoreMessageSentCompleted$1(s2, sent.seqNr());
            }
            if (internalCommand instanceof StoreMessageSentFailed) {
                StoreMessageSentFailed f = (StoreMessageSentFailed)internalCommand;
                return this.receiveStoreMessageSentFailed$1(s2, f);
            }
            if (internalCommand instanceof Request) {
                Request request = ProducerControllerImpl$Request$.MODULE$.unapply((Request)internalCommand);
                long l = request._1();
                long l2 = request._2();
                boolean bl = request._3();
                boolean bl2 = request._4();
                long newConfirmedSeqNr = l;
                long newRequestedSeqNr = l2;
                boolean supportResend = bl;
                boolean viaTimeout = bl2;
                return this.receiveRequest$1(s2, newConfirmedSeqNr, newRequestedSeqNr, supportResend, viaTimeout);
            }
            if (internalCommand instanceof Ack) {
                long l;
                Ack ack = ProducerControllerImpl$Ack$.MODULE$.unapply((Ack)internalCommand);
                long newConfirmedSeqNr = l = ack._1();
                return this.receiveAck$1(s2, newConfirmedSeqNr);
            }
            if (ProducerControllerImpl$SendChunk$.MODULE$.equals(internalCommand)) {
                return this.receiveSendChunk$1(s2);
            }
            if (internalCommand instanceof Resend) {
                long l;
                Resend resend = ProducerControllerImpl$Resend$.MODULE$.unapply((Resend)internalCommand);
                long fromSeqNr = l = resend._1();
                return this.receiveResend$1(s2, fromSeqNr);
            }
            if (ProducerControllerImpl$ResendFirst$.MODULE$.equals(internalCommand)) {
                return this.receiveResendFirst$1(s2);
            }
            if (ProducerControllerImpl$ResendFirstUnconfirmed$.MODULE$.equals(internalCommand)) {
                return this.receiveResendFirstUnconfirmed$1(s2);
            }
            if (internalCommand instanceof ProducerController.Start) {
                ProducerController.Start start = (ProducerController.Start)internalCommand;
                return this.receiveStart$1(s2, start);
            }
            if (internalCommand instanceof ProducerController.RegisterConsumer && (actorRef = (registerConsumer = ProducerController$RegisterConsumer$.MODULE$.unapply((ProducerController.RegisterConsumer)internalCommand))._1()) instanceof ActorRef) {
                ActorRef consumerController = actorRef;
                return this.receiveRegisterConsumer$1(s2, consumerController);
            }
            if (ProducerControllerImpl$DurableQueueTerminated$.MODULE$.equals(internalCommand)) {
                throw new IllegalStateException("DurableQueue was unexpectedly terminated.");
            }
            InternalCommand unexpected = internalCommand;
            throw new RuntimeException(new StringBuilder(20).append("Unexpected message: ").append(unexpected).toString());
        }));
    }

    private void storeMessageSent(DurableProducerQueue.MessageSent<A> messageSent, int attempt) {
        this.context.ask((RecipientRef)this.durableQueue.get(), (Function1<ActorRef, DurableProducerQueue.StoreMessageSent> & Serializable)askReplyTo -> DurableProducerQueue$StoreMessageSent$.MODULE$.apply(messageSent, (ActorRef<DurableProducerQueue.StoreMessageSentAck>)askReplyTo), (Function1<Try, InternalCommand> & Serializable)x$1 -> {
            InternalCommand internalCommand;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                internalCommand = ProducerControllerImpl$StoreMessageSentCompleted$.MODULE$.apply(messageSent);
            } else if (try_ instanceof Failure) {
                internalCommand = ProducerControllerImpl$StoreMessageSentFailed$.MODULE$.apply(messageSent, attempt);
            } else {
                throw new MatchError(try_);
            }
            return internalCommand;
        }, this.askTimeout, ClassTag$.MODULE$.apply(DurableProducerQueue.StoreMessageSentAck.class));
    }

    private final Behavior onMsg$1(State s$1, ConsumerController.SequencedMessage seqMsg, Map newReplyAfterStore, Seq newRemainingChunks) {
        boolean bl;
        Object newUnconfirmed;
        ProducerControllerImpl.checkOnMsgRequestedState$1(s$1);
        if (seqMsg.isLastChunk() != newRemainingChunks.isEmpty()) {
            throw new IllegalStateException(new StringBuilder(48).append("seqMsg [").append(seqMsg.seqNr()).append("] was lastChunk but remaining [").append(newRemainingChunks.size()).append("] chunks.").toString());
        }
        if (this.traceEnabled) {
            this.context.log().trace("Sending [{}] with seqNr [{}].", (Object)seqMsg.message().getClass().getName(), (Object)BoxesRunTime.boxToLong(s$1.currentSeqNr()));
        }
        Object object = newUnconfirmed = s$1.supportResend() ? (Vector)s$1.unconfirmed().$colon$plus(seqMsg) : scala.package$.MODULE$.Vector().empty();
        if (s$1.currentSeqNr() == s$1.firstSeqNr()) {
            this.timers.startTimerWithFixedDelay(ProducerControllerImpl$ResendFirst$.MODULE$, this.settings.durableQueueResendFirstInterval());
        }
        this.flightRecorder.producerSent(this.producerId, seqMsg.seqNr());
        s$1.send().apply(seqMsg);
        if (s$1.currentSeqNr() == s$1.requestedSeqNr()) {
            this.flightRecorder.producerWaitingForRequest(this.producerId, s$1.currentSeqNr());
            bl = newRemainingChunks.nonEmpty();
        } else if (seqMsg.isLastChunk()) {
            this.flightRecorder.producerRequestNext(this.producerId, s$1.currentSeqNr() + 1L, s$1.confirmedSeqNr());
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(s$1.producer());
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerController$RequestNext$.MODULE$.apply(this.producerId, s$1.currentSeqNr() + 1L, s$1.confirmedSeqNr(), this.msgAdapter, this.context.self()));
            bl = true;
        } else {
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.context.self());
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerControllerImpl$SendChunk$.MODULE$);
            bl = true;
        }
        boolean newRequested = bl;
        long l = s$1.currentSeqNr() + 1L;
        long l2 = s$1.copy$default$3();
        long l3 = s$1.copy$default$4();
        boolean bl2 = s$1.copy$default$6();
        long l4 = s$1.copy$default$10();
        ActorRef actorRef = s$1.copy$default$11();
        Function1 function1 = s$1.copy$default$12();
        return this.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$active(s$1.copy(newRequested, l, l2, l3, newReplyAfterStore, bl2, newUnconfirmed, newRemainingChunks, 0L, l4, actorRef, function1));
    }

    private static final void checkOnMsgRequestedState$1(State s$2) {
        if (!s$2.requested() || s$2.currentSeqNr() > s$2.requestedSeqNr()) {
            throw new IllegalStateException(new StringBuilder(43).append("Unexpected Msg when no demand, requested ").append(s$2.requested()).append(", ").append(new StringBuilder(30).append("requestedSeqNr ").append(s$2.requestedSeqNr()).append(", currentSeqNr ").append(s$2.currentSeqNr()).toString()).toString());
        }
    }

    private static final void checkReceiveMessageRemainingChunksState$1(State s$3) {
        if (s$3.remainingChunks().nonEmpty()) {
            throw new IllegalStateException(new StringBuilder(63).append("Received unexpected message before sending remaining [").append(s$3.remainingChunks().size()).append("] chunks.").toString());
        }
    }

    private final Behavior receiveRequest$1(State s$4, long newConfirmedSeqNr, long newRequestedSeqNr, boolean supportResend, boolean viaTimeout) {
        long newRequestedSeqNr2;
        Object newUnconfirmed;
        this.flightRecorder.producerReceivedRequest(this.producerId, newRequestedSeqNr, newConfirmedSeqNr);
        package$LoggerOps$.MODULE$.debugN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Received Request, confirmed [{}], requested [{}], current [{}]", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(newConfirmedSeqNr), BoxesRunTime.boxToLong(newRequestedSeqNr), BoxesRunTime.boxToLong(s$4.currentSeqNr())}));
        State stateAfterAck = this.onAck$1(s$4, newConfirmedSeqNr);
        Object object = newUnconfirmed = supportResend ? stateAfterAck.unconfirmed() : scala.package$.MODULE$.Vector().empty();
        if ((viaTimeout || newConfirmedSeqNr == s$4.firstSeqNr()) && supportResend) {
            this.resendUnconfirmed$1(s$4, (Vector)newUnconfirmed);
        }
        long l = newRequestedSeqNr2 = !supportResend && newRequestedSeqNr <= stateAfterAck.currentSeqNr() ? stateAfterAck.currentSeqNr() + (newRequestedSeqNr - newConfirmedSeqNr) : newRequestedSeqNr;
        if (newRequestedSeqNr2 != newRequestedSeqNr) {
            package$LoggerOps$.MODULE$.debugN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Expanded requestedSeqNr from [{}] to [{}], because current [{}] and all were probably lost", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(newRequestedSeqNr), BoxesRunTime.boxToLong(newRequestedSeqNr2), BoxesRunTime.boxToLong(stateAfterAck.currentSeqNr())}));
        }
        if (newRequestedSeqNr2 > s$4.requestedSeqNr()) {
            boolean bl;
            if (s$4.storeMessageSentInProgress() != 0L) {
                bl = s$4.requested();
            } else if (s$4.remainingChunks().nonEmpty()) {
                ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.context.self());
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerControllerImpl$SendChunk$.MODULE$);
                bl = s$4.requested();
            } else if (!s$4.requested() && newRequestedSeqNr2 - s$4.currentSeqNr() > 0L) {
                this.flightRecorder.producerRequestNext(this.producerId, s$4.currentSeqNr(), newConfirmedSeqNr);
                ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(s$4.producer());
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerController$RequestNext$.MODULE$.apply(this.producerId, s$4.currentSeqNr(), newConfirmedSeqNr, this.msgAdapter, this.context.self()));
                bl = true;
            } else {
                bl = s$4.requested();
            }
            boolean newRequested = bl;
            return this.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$active(stateAfterAck.copy(newRequested, stateAfterAck.copy$default$2(), stateAfterAck.copy$default$3(), newRequestedSeqNr2, stateAfterAck.copy$default$5(), supportResend, newUnconfirmed, stateAfterAck.copy$default$8(), stateAfterAck.copy$default$9(), stateAfterAck.copy$default$10(), stateAfterAck.copy$default$11(), stateAfterAck.copy$default$12()));
        }
        return this.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$active(stateAfterAck.copy(stateAfterAck.copy$default$1(), stateAfterAck.copy$default$2(), stateAfterAck.copy$default$3(), stateAfterAck.copy$default$4(), stateAfterAck.copy$default$5(), supportResend, newUnconfirmed, stateAfterAck.copy$default$8(), stateAfterAck.copy$default$9(), stateAfterAck.copy$default$10(), stateAfterAck.copy$default$11(), stateAfterAck.copy$default$12()));
    }

    private final Behavior receiveAck$1(State s$5, long newConfirmedSeqNr) {
        if (this.traceEnabled) {
            package$LoggerOps$.MODULE$.trace2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Received Ack, confirmed [{}], current [{}].", BoxesRunTime.boxToLong(newConfirmedSeqNr), BoxesRunTime.boxToLong(s$5.currentSeqNr()));
        }
        State stateAfterAck = this.onAck$1(s$5, newConfirmedSeqNr);
        if (newConfirmedSeqNr == s$5.firstSeqNr() && stateAfterAck.unconfirmed().nonEmpty()) {
            this.resendUnconfirmed$1(s$5, stateAfterAck.unconfirmed());
        }
        return this.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$active(stateAfterAck);
    }

    private final State onAck$1(State s$6, long newConfirmedSeqNr) {
        Object newUnconfirmed;
        Tuple2 tuple2 = s$6.replyAfterStore().partition((Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long seqNr = BoxesRunTime.unboxToLong(tuple2._1());
                return seqNr <= newConfirmedSeqNr;
            }
            throw new MatchError(tuple2);
        });
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Map replies = (Map)tuple2._1();
        Map newReplyAfterStore = (Map)tuple2._2();
        Tuple2<Map, Map> tuple22 = Tuple2$.MODULE$.apply(replies, newReplyAfterStore);
        Map replies2 = tuple22._1();
        Map newReplyAfterStore2 = tuple22._2();
        if (replies2.nonEmpty() && this.traceEnabled) {
            this.context.log().trace("Sending confirmation replies from [{}] to [{}].", ((Tuple2)replies2.head())._1(), ((Tuple2)replies2.last())._1());
        }
        replies2.foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                long seqNr = BoxesRunTime.unboxToLong(tuple2._1());
                ActorRef replyTo = (ActorRef)tuple2._2();
                ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(replyTo);
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, BoxesRunTime.boxToLong(seqNr));
                return;
            }
            throw new MatchError(tuple2);
        });
        Object object = newUnconfirmed = s$6.supportResend() ? (Vector)s$6.unconfirmed().dropWhile((Function1<ConsumerController.SequencedMessage, boolean> & Serializable)_$3 -> _$3.seqNr() <= newConfirmedSeqNr) : scala.package$.MODULE$.Vector().empty();
        if (newConfirmedSeqNr == s$6.firstSeqNr()) {
            this.timers.cancel(ProducerControllerImpl$ResendFirst$.MODULE$);
        }
        long newMaxConfirmedSeqNr = package$.MODULE$.max(s$6.confirmedSeqNr(), newConfirmedSeqNr);
        this.durableQueue.foreach(d -> {
            if (newMaxConfirmedSeqNr != s$6.confirmedSeqNr()) {
                ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(d);
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, DurableProducerQueue$StoreMessageConfirmed$.MODULE$.apply(newMaxConfirmedSeqNr, DurableProducerQueue$.MODULE$.NoQualifier(), System.currentTimeMillis()));
                return;
            }
        });
        return s$6.copy(s$6.copy$default$1(), s$6.copy$default$2(), newMaxConfirmedSeqNr, s$6.copy$default$4(), newReplyAfterStore2, s$6.copy$default$6(), newUnconfirmed, s$6.copy$default$8(), s$6.copy$default$9(), s$6.copy$default$10(), s$6.copy$default$11(), s$6.copy$default$12());
    }

    private final Behavior receiveStoreMessageSentCompleted$1(State s$8, long seqNr) {
        if (seqNr == s$8.storeMessageSentInProgress()) {
            if (seqNr != s$8.currentSeqNr()) {
                throw new IllegalStateException(new StringBuilder(44).append("currentSeqNr [").append(s$8.currentSeqNr()).append("] not matching stored seqNr [").append(seqNr).append("]").toString());
            }
            ConsumerController.SequencedMessage seqMsg = (ConsumerController.SequencedMessage)s$8.remainingChunks().head();
            if (seqNr != seqMsg.seqNr()) {
                throw new IllegalStateException(new StringBuilder(37).append("seqNr [").append(seqMsg.seqNr()).append("] not matching stored seqNr [").append(seqNr).append("]").toString());
            }
            s$8.replyAfterStore().get(BoxesRunTime.boxToLong(seqNr)).foreach(replyTo -> {
                if (this.traceEnabled) {
                    this.context.log().trace("Sending confirmation reply to [{}] after storage.", (Object)BoxesRunTime.boxToLong(seqNr));
                }
                ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(replyTo);
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, BoxesRunTime.boxToLong(seqNr));
            });
            Map newReplyAfterStore = (Map)s$8.replyAfterStore().$minus(BoxesRunTime.boxToLong(seqNr));
            return this.onMsg$1(s$8, seqMsg, newReplyAfterStore, (Seq)s$8.remainingChunks().tail());
        }
        this.context.log().debug("Received StoreMessageSentCompleted for seqNr [{}] but waiting for [{}]. Probably due to retry.", (Object)BoxesRunTime.boxToLong(seqNr), (Object)BoxesRunTime.boxToLong(s$8.storeMessageSentInProgress()));
        return Behaviors$.MODULE$.same();
    }

    private final Behavior receiveStoreMessageSentFailed$1(State s$9, StoreMessageSentFailed f) {
        if (f.messageSent().seqNr() == s$9.storeMessageSentInProgress()) {
            if (f.attempt() >= this.settings.durableQueueRetryAttempts()) {
                String errorMessage = new StringBuilder(68).append("StoreMessageSentFailed seqNr [").append(f.messageSent().seqNr()).append("] failed after [").append(f.attempt()).append("] attempts, giving up.").toString();
                this.context.log().error(errorMessage);
                throw new TimeoutException(errorMessage);
            }
            package$LoggerOps$.MODULE$.warnN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "StoreMessageSent seqNr [{}] failed, attempt [{}] of [{}], retrying.", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(f.messageSent().seqNr()), BoxesRunTime.boxToInteger(f.attempt()), BoxesRunTime.boxToInteger(this.settings.durableQueueRetryAttempts())}));
            if (f.messageSent().isFirstChunk()) {
                this.storeMessageSent(f.messageSent(), f.attempt() + 1);
                return Behaviors$.MODULE$.same();
            }
            Vector unconfirmedReverse = (Vector)s$9.unconfirmed().reverse();
            Vector xs = (Vector)unconfirmedReverse.takeWhile((Function1<ConsumerController.SequencedMessage, boolean> & Serializable)_$4 -> !_$4.isFirstChunk());
            if (unconfirmedReverse.size() == xs.size()) {
                throw new IllegalStateException(new StringBuilder(38).append("First chunk not found in unconfirmed: ").append(s$9.unconfirmed()).toString());
            }
            ConsumerController.SequencedMessage firstChunk = (ConsumerController.SequencedMessage)((Vector)unconfirmedReverse.drop(xs.size())).head();
            Vector newRemainingChunks = (Vector)((IterableOps)((SeqOps)xs.reverse()).$plus$colon(firstChunk)).$plus$plus(s$9.remainingChunks());
            Object newUnconfirmed = s$9.unconfirmed().dropRight(xs.size() + 1);
            this.context.log().debug("Store all [{}] chunks again, starting at seqNr [{}].", (Object)BoxesRunTime.boxToInteger(newRemainingChunks.size()), (Object)BoxesRunTime.boxToLong(firstChunk.seqNr()));
            if (!((ConsumerController.SequencedMessage)newRemainingChunks.head()).isFirstChunk() || !((ConsumerController.SequencedMessage)newRemainingChunks.last()).isLastChunk()) {
                throw new IllegalStateException(new StringBuilder(23).append("Wrong remainingChunks: ").append(newRemainingChunks).toString());
            }
            this.storeMessageSent(DurableProducerQueue$MessageSent$.MODULE$.fromMessageOrChunked(firstChunk.seqNr(), firstChunk.message(), firstChunk.ack(), DurableProducerQueue$.MODULE$.NoQualifier(), System.currentTimeMillis()), f.attempt() + 1);
            return this.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$active(s$9.copy(s$9.copy$default$1(), firstChunk.seqNr(), s$9.copy$default$3(), s$9.copy$default$4(), s$9.copy$default$5(), s$9.copy$default$6(), newUnconfirmed, newRemainingChunks, firstChunk.seqNr(), s$9.copy$default$10(), s$9.copy$default$11(), s$9.copy$default$12()));
        }
        return Behaviors$.MODULE$.same();
    }

    private final Behavior receiveResend$1(State s$10, long fromSeqNr) {
        this.flightRecorder.producerReceivedResend(this.producerId, fromSeqNr);
        this.resendUnconfirmed$1(s$10, (Vector)s$10.unconfirmed().dropWhile((Function1<ConsumerController.SequencedMessage, boolean> & Serializable)_$5 -> _$5.seqNr() < fromSeqNr));
        if (fromSeqNr == 0L && s$10.unconfirmed().nonEmpty()) {
            ConsumerController.SequencedMessage sequencedMessage = s$10.unconfirmed().head().asFirst();
            Vector newUnconfirmed = (Vector)((AbstractSeq)s$10.unconfirmed().tail()).$plus$colon(sequencedMessage);
            return this.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$active(s$10.copy(s$10.copy$default$1(), s$10.copy$default$2(), s$10.copy$default$3(), s$10.copy$default$4(), s$10.copy$default$5(), s$10.copy$default$6(), newUnconfirmed, s$10.copy$default$8(), s$10.copy$default$9(), s$10.copy$default$10(), s$10.copy$default$11(), s$10.copy$default$12()));
        }
        return Behaviors$.MODULE$.same();
    }

    private final void resendUnconfirmed$1(State s$11, Vector newUnconfirmed) {
        if (newUnconfirmed.nonEmpty()) {
            long fromSeqNr = ((ConsumerController.SequencedMessage)newUnconfirmed.head()).seqNr();
            long toSeqNr = ((ConsumerController.SequencedMessage)newUnconfirmed.last()).seqNr();
            this.flightRecorder.producerResentUnconfirmed(this.producerId, fromSeqNr, toSeqNr);
            this.context.log().debug("Resending [{} - {}].", (Object)BoxesRunTime.boxToLong(fromSeqNr), (Object)BoxesRunTime.boxToLong(toSeqNr));
            newUnconfirmed.foreach(s$11.send());
            return;
        }
    }

    private final Behavior receiveResendFirstUnconfirmed$1(State s$12) {
        if (s$12.unconfirmed().nonEmpty()) {
            this.flightRecorder.producerResentFirstUnconfirmed(this.producerId, s$12.unconfirmed().head().seqNr());
            this.context.log().debug("Resending first unconfirmed [{}].", (Object)BoxesRunTime.boxToLong(s$12.unconfirmed().head().seqNr()));
            s$12.send().apply(s$12.unconfirmed().head());
        }
        return Behaviors$.MODULE$.same();
    }

    private final Behavior receiveResendFirst$1(State s$13) {
        if (s$13.unconfirmed().nonEmpty() && s$13.unconfirmed().head().seqNr() == s$13.firstSeqNr()) {
            this.flightRecorder.producerResentFirst(this.producerId, s$13.firstSeqNr());
            this.context.log().debug("Resending first, [{}].", (Object)BoxesRunTime.boxToLong(s$13.firstSeqNr()));
            s$13.send().apply(s$13.unconfirmed().head().asFirst());
        } else if (s$13.currentSeqNr() > s$13.firstSeqNr()) {
            this.timers.cancel(ProducerControllerImpl$ResendFirst$.MODULE$);
        }
        return Behaviors$.MODULE$.same();
    }

    private final Behavior receiveStart$1(State s$14, ProducerController.Start start) {
        ProducerControllerImpl$.MODULE$.enforceLocalProducer(start.producer());
        this.context.log().debug("Register new Producer [{}], currentSeqNr [{}].", (Object)start.producer(), (Object)BoxesRunTime.boxToLong(s$14.currentSeqNr()));
        if (s$14.requested() && s$14.remainingChunks().isEmpty()) {
            this.flightRecorder.producerRequestNext(this.producerId, s$14.currentSeqNr(), s$14.confirmedSeqNr());
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(start.producer());
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerController$RequestNext$.MODULE$.apply(this.producerId, s$14.currentSeqNr(), s$14.confirmedSeqNr(), this.msgAdapter, this.context.self()));
        }
        return this.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$active(s$14.copy(s$14.copy$default$1(), s$14.copy$default$2(), s$14.copy$default$3(), s$14.copy$default$4(), s$14.copy$default$5(), s$14.copy$default$6(), s$14.copy$default$7(), s$14.copy$default$8(), s$14.copy$default$9(), s$14.copy$default$10(), start.producer(), s$14.copy$default$12()));
    }

    private final Behavior receiveRegisterConsumer$1(State s$15, ActorRef consumerController) {
        long newFirstSeqNr = s$15.unconfirmed().isEmpty() ? s$15.currentSeqNr() : s$15.unconfirmed().head().seqNr();
        this.context.log().debug("Register new ConsumerController [{}], starting with seqNr [{}].", (Object)consumerController, (Object)BoxesRunTime.boxToLong(newFirstSeqNr));
        if (s$15.unconfirmed().nonEmpty()) {
            this.timers.startTimerWithFixedDelay(ProducerControllerImpl$ResendFirst$.MODULE$, this.settings.durableQueueResendFirstInterval());
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(this.context.self());
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerControllerImpl$ResendFirst$.MODULE$);
        }
        JProcedure1<ConsumerController.Command> newSend = _$6 -> consumerController.tell(_$6);
        return this.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$active(s$15.copy(s$15.copy$default$1(), s$15.copy$default$2(), s$15.copy$default$3(), s$15.copy$default$4(), s$15.copy$default$5(), s$15.copy$default$6(), s$15.copy$default$7(), s$15.copy$default$8(), s$15.copy$default$9(), newFirstSeqNr, s$15.copy$default$11(), newSend));
    }

    private final Behavior receiveSendChunk$1(State s$16) {
        if (s$16.remainingChunks().nonEmpty() && ((ConsumerController.SequencedMessage)s$16.remainingChunks().head()).seqNr() <= s$16.requestedSeqNr() && s$16.storeMessageSentInProgress() == 0L) {
            if (this.traceEnabled) {
                this.context.log().trace("Send next chunk seqNr [{}].", (Object)BoxesRunTime.boxToLong(((ConsumerController.SequencedMessage)s$16.remainingChunks().head()).seqNr()));
            }
            if (this.durableQueue.isEmpty()) {
                return this.onMsg$1(s$16, (ConsumerController.SequencedMessage)s$16.remainingChunks().head(), s$16.replyAfterStore(), (Seq)s$16.remainingChunks().tail());
            }
            ConsumerController.SequencedMessage seqMsg = (ConsumerController.SequencedMessage)s$16.remainingChunks().head();
            this.storeMessageSent(DurableProducerQueue$MessageSent$.MODULE$.fromMessageOrChunked(seqMsg.seqNr(), seqMsg.message(), seqMsg.ack(), DurableProducerQueue$.MODULE$.NoQualifier(), System.currentTimeMillis()), 1);
            return this.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$active(s$16.copy(s$16.copy$default$1(), s$16.copy$default$2(), s$16.copy$default$3(), s$16.copy$default$4(), s$16.copy$default$5(), s$16.copy$default$6(), s$16.copy$default$7(), s$16.copy$default$8(), seqMsg.seqNr(), s$16.copy$default$10(), s$16.copy$default$11(), s$16.copy$default$12()));
        }
        return Behaviors$.MODULE$.same();
    }

    private final Seq chunk$1(State s$17, Object m, boolean ack) {
        int chunkSize = this.settings.chunkLargeMessagesBytes();
        if (chunkSize > 0) {
            Seq<ChunkedMessage> chunkedMessages = ProducerControllerImpl$.MODULE$.createChunks(m, chunkSize, this.serialization());
            if (this.traceEnabled) {
                if (chunkedMessages.size() == 1) {
                    this.context.log().trace("No chunking of seqNr [{}], size [{} bytes].", (Object)BoxesRunTime.boxToLong(s$17.currentSeqNr()), (Object)BoxesRunTime.boxToInteger(((ChunkedMessage)chunkedMessages.head()).serialized().size()));
                } else {
                    package$LoggerOps$.MODULE$.traceN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Chunked seqNr [{}] into [{}] pieces, total size [{} bytes].", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(s$17.currentSeqNr()), BoxesRunTime.boxToInteger(chunkedMessages.size()), ((IterableOnceOps)chunkedMessages.map((Function1<ChunkedMessage, int> & Serializable)_$7 -> _$7.serialized().size())).sum(Numeric$IntIsIntegral$.MODULE$)}));
                }
            }
            IntRef i = IntRef.create(0);
            return (Seq)chunkedMessages.map((Function1<ChunkedMessage, ConsumerController.SequencedMessage> & Serializable)chunkedMessage -> {
                long seqNr = s$17.currentSeqNr() + (long)i$1.elem;
                ++i$1.elem;
                return ConsumerController$SequencedMessage$.MODULE$.fromChunked(this.producerId, seqNr, (ChunkedMessage)chunkedMessage, seqNr == s$17.firstSeqNr(), ack && chunkedMessage.lastChunk(), this.context.self());
            });
        }
        ConsumerController.SequencedMessage seqMsg = ConsumerController$SequencedMessage$.MODULE$.apply(this.producerId, s$17.currentSeqNr(), m, s$17.currentSeqNr() == s$17.firstSeqNr(), ack, this.context.self());
        return scala.package$.MODULE$.Nil().$colon$colon(seqMsg);
    }

    public static final class Ack
    implements InternalCommand,
    DeliverySerializable,
    DeadLetterSuppression,
    Product,
    Serializable {
        private final long confirmedSeqNr;

        public static Ack apply(long l) {
            return ProducerControllerImpl$Ack$.MODULE$.apply(l);
        }

        public static Ack fromProduct(Product product) {
            return ProducerControllerImpl$Ack$.MODULE$.fromProduct(product);
        }

        public static Ack unapply(Ack ack) {
            return ProducerControllerImpl$Ack$.MODULE$.unapply(ack);
        }

        public Ack(long confirmedSeqNr) {
            this.confirmedSeqNr = confirmedSeqNr;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.longHash(this.confirmedSeqNr()));
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Ack)) return false;
            Ack ack = (Ack)object;
            if (this.confirmedSeqNr() != ack.confirmedSeqNr()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Ack;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Ack";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToLong(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "confirmedSeqNr";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public long confirmedSeqNr() {
            return this.confirmedSeqNr;
        }

        public Ack copy(long confirmedSeqNr) {
            return new Ack(confirmedSeqNr);
        }

        public long copy$default$1() {
            return this.confirmedSeqNr();
        }

        public long _1() {
            return this.confirmedSeqNr();
        }
    }

    public static interface InternalCommand {
    }

    public static class LoadStateFailed
    implements InternalCommand,
    Product,
    Serializable {
        private final int attempt;

        public static LoadStateFailed apply(int n) {
            return ProducerControllerImpl$LoadStateFailed$.MODULE$.apply(n);
        }

        public static LoadStateFailed fromProduct(Product product) {
            return ProducerControllerImpl$LoadStateFailed$.MODULE$.fromProduct(product);
        }

        public static LoadStateFailed unapply(LoadStateFailed loadStateFailed) {
            return ProducerControllerImpl$LoadStateFailed$.MODULE$.unapply(loadStateFailed);
        }

        public LoadStateFailed(int attempt) {
            this.attempt = attempt;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.attempt());
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LoadStateFailed)) return false;
            LoadStateFailed loadStateFailed = (LoadStateFailed)object;
            if (this.attempt() != loadStateFailed.attempt()) return false;
            if (!loadStateFailed.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof LoadStateFailed;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "LoadStateFailed";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToInteger(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "attempt";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public int attempt() {
            return this.attempt;
        }

        public LoadStateFailed copy(int attempt) {
            return new LoadStateFailed(attempt);
        }

        public int copy$default$1() {
            return this.attempt();
        }

        public int _1() {
            return this.attempt();
        }
    }

    public static class LoadStateReply<A>
    implements InternalCommand,
    Product,
    Serializable {
        private final DurableProducerQueue.State state;

        public static <A> LoadStateReply<A> apply(DurableProducerQueue.State<A> state) {
            return ProducerControllerImpl$LoadStateReply$.MODULE$.apply(state);
        }

        public static LoadStateReply<?> fromProduct(Product product) {
            return ProducerControllerImpl$LoadStateReply$.MODULE$.fromProduct(product);
        }

        public static <A> LoadStateReply<A> unapply(LoadStateReply<A> loadStateReply) {
            return ProducerControllerImpl$LoadStateReply$.MODULE$.unapply(loadStateReply);
        }

        public LoadStateReply(DurableProducerQueue.State<A> state) {
            this.state = state;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LoadStateReply)) return false;
            LoadStateReply loadStateReply = (LoadStateReply)object;
            DurableProducerQueue.State<A> state = this.state();
            DurableProducerQueue.State<A> state2 = loadStateReply.state();
            if (state == null) {
                if (state2 != null) {
                    return false;
                }
            } else if (!((Object)state).equals(state2)) return false;
            if (!loadStateReply.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof LoadStateReply;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "LoadStateReply";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "state";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public DurableProducerQueue.State<A> state() {
            return this.state;
        }

        public <A> LoadStateReply<A> copy(DurableProducerQueue.State<A> state) {
            return new LoadStateReply<A>(state);
        }

        public <A> DurableProducerQueue.State<A> copy$default$1() {
            return this.state();
        }

        public DurableProducerQueue.State<A> _1() {
            return this.state();
        }
    }

    public static class Msg<A>
    implements InternalCommand,
    Product,
    Serializable {
        private final Object msg;

        public static <A> Msg<A> apply(A a) {
            return ProducerControllerImpl$Msg$.MODULE$.apply(a);
        }

        public static Msg<?> fromProduct(Product product) {
            return ProducerControllerImpl$Msg$.MODULE$.fromProduct(product);
        }

        public static <A> Msg<A> unapply(Msg<A> msg) {
            return ProducerControllerImpl$Msg$.MODULE$.unapply(msg);
        }

        public Msg(A msg) {
            this.msg = msg;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Msg)) return false;
            Msg msg = (Msg)object;
            if (!BoxesRunTime.equals(this.msg(), msg.msg())) return false;
            if (!msg.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Msg;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Msg";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "msg";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public A msg() {
            return (A)this.msg;
        }

        public <A> Msg<A> copy(A msg) {
            return new Msg<A>(msg);
        }

        public <A> A copy$default$1() {
            return this.msg();
        }

        public A _1() {
            return this.msg();
        }
    }

    public static final class Request
    implements InternalCommand,
    DeliverySerializable,
    DeadLetterSuppression,
    Product,
    Serializable {
        private final long confirmedSeqNr;
        private final long requestUpToSeqNr;
        private final boolean supportResend;
        private final boolean viaTimeout;

        public static Request apply(long l, long l2, boolean bl, boolean bl2) {
            return ProducerControllerImpl$Request$.MODULE$.apply(l, l2, bl, bl2);
        }

        public static Request fromProduct(Product product) {
            return ProducerControllerImpl$Request$.MODULE$.fromProduct(product);
        }

        public static Request unapply(Request request) {
            return ProducerControllerImpl$Request$.MODULE$.unapply(request);
        }

        public Request(long confirmedSeqNr, long requestUpToSeqNr, boolean supportResend, boolean viaTimeout) {
            this.confirmedSeqNr = confirmedSeqNr;
            this.requestUpToSeqNr = requestUpToSeqNr;
            this.supportResend = supportResend;
            this.viaTimeout = viaTimeout;
            Predef$.MODULE$.require(confirmedSeqNr <= requestUpToSeqNr, () -> this.$init$$$anonfun$1(confirmedSeqNr, requestUpToSeqNr));
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.longHash(this.confirmedSeqNr()));
            n = Statics.mix(n, Statics.longHash(this.requestUpToSeqNr()));
            n = Statics.mix(n, this.supportResend() ? 1231 : 1237);
            n = Statics.mix(n, this.viaTimeout() ? 1231 : 1237);
            return Statics.finalizeHash(n, 4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Request)) return false;
            Request request = (Request)object;
            if (this.supportResend() != request.supportResend()) return false;
            if (this.viaTimeout() != request.viaTimeout()) return false;
            if (this.confirmedSeqNr() != request.confirmedSeqNr()) return false;
            if (this.requestUpToSeqNr() != request.requestUpToSeqNr()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Request;
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public String productPrefix() {
            return "Request";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToLong(this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToLong(this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean(this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean(this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "confirmedSeqNr";
                }
                case 1: {
                    return "requestUpToSeqNr";
                }
                case 2: {
                    return "supportResend";
                }
                case 3: {
                    return "viaTimeout";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public long confirmedSeqNr() {
            return this.confirmedSeqNr;
        }

        public long requestUpToSeqNr() {
            return this.requestUpToSeqNr;
        }

        public boolean supportResend() {
            return this.supportResend;
        }

        public boolean viaTimeout() {
            return this.viaTimeout;
        }

        public Request copy(long confirmedSeqNr, long requestUpToSeqNr, boolean supportResend, boolean viaTimeout) {
            return new Request(confirmedSeqNr, requestUpToSeqNr, supportResend, viaTimeout);
        }

        public long copy$default$1() {
            return this.confirmedSeqNr();
        }

        public long copy$default$2() {
            return this.requestUpToSeqNr();
        }

        public boolean copy$default$3() {
            return this.supportResend();
        }

        public boolean copy$default$4() {
            return this.viaTimeout();
        }

        public long _1() {
            return this.confirmedSeqNr();
        }

        public long _2() {
            return this.requestUpToSeqNr();
        }

        public boolean _3() {
            return this.supportResend();
        }

        public boolean _4() {
            return this.viaTimeout();
        }

        private final Object $init$$$anonfun$1(long confirmedSeqNr$2, long requestUpToSeqNr$1) {
            return new StringBuilder(50).append("confirmedSeqNr [").append(confirmedSeqNr$2).append("] should be <= requestUpToSeqNr [").append(requestUpToSeqNr$1).append("]").toString();
        }
    }

    public static final class Resend
    implements InternalCommand,
    DeliverySerializable,
    DeadLetterSuppression,
    Product,
    Serializable {
        private final long fromSeqNr;

        public static Resend apply(long l) {
            return ProducerControllerImpl$Resend$.MODULE$.apply(l);
        }

        public static Resend fromProduct(Product product) {
            return ProducerControllerImpl$Resend$.MODULE$.fromProduct(product);
        }

        public static Resend unapply(Resend resend) {
            return ProducerControllerImpl$Resend$.MODULE$.unapply(resend);
        }

        public Resend(long fromSeqNr) {
            this.fromSeqNr = fromSeqNr;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.longHash(this.fromSeqNr()));
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Resend)) return false;
            Resend resend = (Resend)object;
            if (this.fromSeqNr() != resend.fromSeqNr()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Resend;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Resend";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToLong(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "fromSeqNr";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public long fromSeqNr() {
            return this.fromSeqNr;
        }

        public Resend copy(long fromSeqNr) {
            return new Resend(fromSeqNr);
        }

        public long copy$default$1() {
            return this.fromSeqNr();
        }

        public long _1() {
            return this.fromSeqNr();
        }
    }

    public static final class State<A>
    implements Product,
    Serializable {
        private final boolean requested;
        private final long currentSeqNr;
        private final long confirmedSeqNr;
        private final long requestedSeqNr;
        private final Map replyAfterStore;
        private final boolean supportResend;
        private final Vector unconfirmed;
        private final Seq remainingChunks;
        private final long storeMessageSentInProgress;
        private final long firstSeqNr;
        private final ActorRef producer;
        private final Function1 send;

        public static <A> State<A> apply(boolean bl, long l, long l2, long l3, Map<Object, ActorRef<Object>> map, boolean bl2, Vector<ConsumerController.SequencedMessage<A>> vector, Seq<ConsumerController.SequencedMessage<A>> seq, long l4, long l5, ActorRef<ProducerController.RequestNext<A>> actorRef, Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> function1) {
            return ProducerControllerImpl$State$.MODULE$.apply(bl, l, l2, l3, map, bl2, vector, seq, l4, l5, actorRef, function1);
        }

        public static State<?> fromProduct(Product product) {
            return ProducerControllerImpl$State$.MODULE$.fromProduct(product);
        }

        public static <A> State<A> unapply(State<A> state) {
            return ProducerControllerImpl$State$.MODULE$.unapply(state);
        }

        public State(boolean requested, long currentSeqNr, long confirmedSeqNr, long requestedSeqNr, Map<Object, ActorRef<Object>> replyAfterStore, boolean supportResend, Vector<ConsumerController.SequencedMessage<A>> unconfirmed, Seq<ConsumerController.SequencedMessage<A>> remainingChunks, long storeMessageSentInProgress, long firstSeqNr, ActorRef<ProducerController.RequestNext<A>> producer, Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> send) {
            this.requested = requested;
            this.currentSeqNr = currentSeqNr;
            this.confirmedSeqNr = confirmedSeqNr;
            this.requestedSeqNr = requestedSeqNr;
            this.replyAfterStore = replyAfterStore;
            this.supportResend = supportResend;
            this.unconfirmed = unconfirmed;
            this.remainingChunks = remainingChunks;
            this.storeMessageSentInProgress = storeMessageSentInProgress;
            this.firstSeqNr = firstSeqNr;
            this.producer = producer;
            this.send = send;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.requested() ? 1231 : 1237);
            n = Statics.mix(n, Statics.longHash(this.currentSeqNr()));
            n = Statics.mix(n, Statics.longHash(this.confirmedSeqNr()));
            n = Statics.mix(n, Statics.longHash(this.requestedSeqNr()));
            n = Statics.mix(n, Statics.anyHash(this.replyAfterStore()));
            n = Statics.mix(n, this.supportResend() ? 1231 : 1237);
            n = Statics.mix(n, Statics.anyHash(this.unconfirmed()));
            n = Statics.mix(n, Statics.anyHash(this.remainingChunks()));
            n = Statics.mix(n, Statics.longHash(this.storeMessageSentInProgress()));
            n = Statics.mix(n, Statics.longHash(this.firstSeqNr()));
            n = Statics.mix(n, Statics.anyHash(this.producer()));
            n = Statics.mix(n, Statics.anyHash(this.send()));
            return Statics.finalizeHash(n, 12);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.requested() != state.requested()) return false;
            if (this.supportResend() != state.supportResend()) return false;
            if (this.currentSeqNr() != state.currentSeqNr()) return false;
            if (this.confirmedSeqNr() != state.confirmedSeqNr()) return false;
            if (this.requestedSeqNr() != state.requestedSeqNr()) return false;
            Map<Object, ActorRef<Object>> map = this.replyAfterStore();
            Map<Object, ActorRef<Object>> map2 = state.replyAfterStore();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Vector<ConsumerController.SequencedMessage<A>> vector = this.unconfirmed();
            Vector<ConsumerController.SequencedMessage<A>> vector2 = state.unconfirmed();
            if (vector == null) {
                if (vector2 != null) {
                    return false;
                }
            } else if (!((Object)vector).equals(vector2)) return false;
            Seq<ConsumerController.SequencedMessage<A>> seq = this.remainingChunks();
            Seq<ConsumerController.SequencedMessage<A>> seq2 = state.remainingChunks();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (this.storeMessageSentInProgress() != state.storeMessageSentInProgress()) return false;
            if (this.firstSeqNr() != state.firstSeqNr()) return false;
            ActorRef<ProducerController.RequestNext<A>> actorRef = this.producer();
            ActorRef<ProducerController.RequestNext<A>> actorRef2 = state.producer();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> function1 = this.send();
            Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> function12 = state.send();
            if (function1 == null) {
                if (function12 == null) return true;
                return false;
            } else {
                if (!function1.equals(function12)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        @Override
        public int productArity() {
            return 12;
        }

        @Override
        public String productPrefix() {
            return "State";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean(this._1());
                }
                case 1: {
                    return BoxesRunTime.boxToLong(this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToLong(this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToLong(this._4());
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return BoxesRunTime.boxToBoolean(this._6());
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return BoxesRunTime.boxToLong(this._9());
                }
                case 9: {
                    return BoxesRunTime.boxToLong(this._10());
                }
                case 10: {
                    return this._11();
                }
                case 11: {
                    return this._12();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "requested";
                }
                case 1: {
                    return "currentSeqNr";
                }
                case 2: {
                    return "confirmedSeqNr";
                }
                case 3: {
                    return "requestedSeqNr";
                }
                case 4: {
                    return "replyAfterStore";
                }
                case 5: {
                    return "supportResend";
                }
                case 6: {
                    return "unconfirmed";
                }
                case 7: {
                    return "remainingChunks";
                }
                case 8: {
                    return "storeMessageSentInProgress";
                }
                case 9: {
                    return "firstSeqNr";
                }
                case 10: {
                    return "producer";
                }
                case 11: {
                    return "send";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public boolean requested() {
            return this.requested;
        }

        public long currentSeqNr() {
            return this.currentSeqNr;
        }

        public long confirmedSeqNr() {
            return this.confirmedSeqNr;
        }

        public long requestedSeqNr() {
            return this.requestedSeqNr;
        }

        public Map<Object, ActorRef<Object>> replyAfterStore() {
            return this.replyAfterStore;
        }

        public boolean supportResend() {
            return this.supportResend;
        }

        public Vector<ConsumerController.SequencedMessage<A>> unconfirmed() {
            return this.unconfirmed;
        }

        public Seq<ConsumerController.SequencedMessage<A>> remainingChunks() {
            return this.remainingChunks;
        }

        public long storeMessageSentInProgress() {
            return this.storeMessageSentInProgress;
        }

        public long firstSeqNr() {
            return this.firstSeqNr;
        }

        public ActorRef<ProducerController.RequestNext<A>> producer() {
            return this.producer;
        }

        public Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> send() {
            return this.send;
        }

        public <A> State<A> copy(boolean requested, long currentSeqNr, long confirmedSeqNr, long requestedSeqNr, Map<Object, ActorRef<Object>> replyAfterStore, boolean supportResend, Vector<ConsumerController.SequencedMessage<A>> unconfirmed, Seq<ConsumerController.SequencedMessage<A>> remainingChunks, long storeMessageSentInProgress, long firstSeqNr, ActorRef<ProducerController.RequestNext<A>> producer, Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> send) {
            return new State<A>(requested, currentSeqNr, confirmedSeqNr, requestedSeqNr, replyAfterStore, supportResend, unconfirmed, remainingChunks, storeMessageSentInProgress, firstSeqNr, producer, send);
        }

        public boolean copy$default$1() {
            return this.requested();
        }

        public long copy$default$2() {
            return this.currentSeqNr();
        }

        public long copy$default$3() {
            return this.confirmedSeqNr();
        }

        public long copy$default$4() {
            return this.requestedSeqNr();
        }

        public <A> Map<Object, ActorRef<Object>> copy$default$5() {
            return this.replyAfterStore();
        }

        public boolean copy$default$6() {
            return this.supportResend();
        }

        public <A> Vector<ConsumerController.SequencedMessage<A>> copy$default$7() {
            return this.unconfirmed();
        }

        public <A> Seq<ConsumerController.SequencedMessage<A>> copy$default$8() {
            return this.remainingChunks();
        }

        public long copy$default$9() {
            return this.storeMessageSentInProgress();
        }

        public long copy$default$10() {
            return this.firstSeqNr();
        }

        public <A> ActorRef<ProducerController.RequestNext<A>> copy$default$11() {
            return this.producer();
        }

        public <A> Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> copy$default$12() {
            return this.send();
        }

        public boolean _1() {
            return this.requested();
        }

        public long _2() {
            return this.currentSeqNr();
        }

        public long _3() {
            return this.confirmedSeqNr();
        }

        public long _4() {
            return this.requestedSeqNr();
        }

        public Map<Object, ActorRef<Object>> _5() {
            return this.replyAfterStore();
        }

        public boolean _6() {
            return this.supportResend();
        }

        public Vector<ConsumerController.SequencedMessage<A>> _7() {
            return this.unconfirmed();
        }

        public Seq<ConsumerController.SequencedMessage<A>> _8() {
            return this.remainingChunks();
        }

        public long _9() {
            return this.storeMessageSentInProgress();
        }

        public long _10() {
            return this.firstSeqNr();
        }

        public ActorRef<ProducerController.RequestNext<A>> _11() {
            return this.producer();
        }

        public Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> _12() {
            return this.send();
        }
    }

    public static class StoreMessageSentCompleted<A>
    implements InternalCommand,
    Product,
    Serializable {
        private final DurableProducerQueue.MessageSent messageSent;

        public static <A> StoreMessageSentCompleted<A> apply(DurableProducerQueue.MessageSent<A> messageSent) {
            return ProducerControllerImpl$StoreMessageSentCompleted$.MODULE$.apply(messageSent);
        }

        public static StoreMessageSentCompleted<?> fromProduct(Product product) {
            return ProducerControllerImpl$StoreMessageSentCompleted$.MODULE$.fromProduct(product);
        }

        public static <A> StoreMessageSentCompleted<A> unapply(StoreMessageSentCompleted<A> storeMessageSentCompleted) {
            return ProducerControllerImpl$StoreMessageSentCompleted$.MODULE$.unapply(storeMessageSentCompleted);
        }

        public StoreMessageSentCompleted(DurableProducerQueue.MessageSent<A> messageSent) {
            this.messageSent = messageSent;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoreMessageSentCompleted)) return false;
            StoreMessageSentCompleted storeMessageSentCompleted = (StoreMessageSentCompleted)object;
            DurableProducerQueue.MessageSent<A> messageSent = this.messageSent();
            DurableProducerQueue.MessageSent<A> messageSent2 = storeMessageSentCompleted.messageSent();
            if (messageSent == null) {
                if (messageSent2 != null) {
                    return false;
                }
            } else if (!((Object)messageSent).equals(messageSent2)) return false;
            if (!storeMessageSentCompleted.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof StoreMessageSentCompleted;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "StoreMessageSentCompleted";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "messageSent";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public DurableProducerQueue.MessageSent<A> messageSent() {
            return this.messageSent;
        }

        public <A> StoreMessageSentCompleted<A> copy(DurableProducerQueue.MessageSent<A> messageSent) {
            return new StoreMessageSentCompleted<A>(messageSent);
        }

        public <A> DurableProducerQueue.MessageSent<A> copy$default$1() {
            return this.messageSent();
        }

        public DurableProducerQueue.MessageSent<A> _1() {
            return this.messageSent();
        }
    }

    public static class StoreMessageSentFailed<A>
    implements InternalCommand,
    Product,
    Serializable {
        private final DurableProducerQueue.MessageSent messageSent;
        private final int attempt;

        public static <A> StoreMessageSentFailed<A> apply(DurableProducerQueue.MessageSent<A> messageSent, int n) {
            return ProducerControllerImpl$StoreMessageSentFailed$.MODULE$.apply(messageSent, n);
        }

        public static StoreMessageSentFailed<?> fromProduct(Product product) {
            return ProducerControllerImpl$StoreMessageSentFailed$.MODULE$.fromProduct(product);
        }

        public static <A> StoreMessageSentFailed<A> unapply(StoreMessageSentFailed<A> storeMessageSentFailed) {
            return ProducerControllerImpl$StoreMessageSentFailed$.MODULE$.unapply(storeMessageSentFailed);
        }

        public StoreMessageSentFailed(DurableProducerQueue.MessageSent<A> messageSent, int attempt) {
            this.messageSent = messageSent;
            this.attempt = attempt;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.messageSent()));
            n = Statics.mix(n, this.attempt());
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoreMessageSentFailed)) return false;
            StoreMessageSentFailed storeMessageSentFailed = (StoreMessageSentFailed)object;
            if (this.attempt() != storeMessageSentFailed.attempt()) return false;
            DurableProducerQueue.MessageSent<A> messageSent = this.messageSent();
            DurableProducerQueue.MessageSent<A> messageSent2 = storeMessageSentFailed.messageSent();
            if (messageSent == null) {
                if (messageSent2 != null) {
                    return false;
                }
            } else if (!((Object)messageSent).equals(messageSent2)) return false;
            if (!storeMessageSentFailed.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof StoreMessageSentFailed;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "StoreMessageSentFailed";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToInteger(this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "messageSent";
            }
            if (1 == n2) {
                return "attempt";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public DurableProducerQueue.MessageSent<A> messageSent() {
            return this.messageSent;
        }

        public int attempt() {
            return this.attempt;
        }

        public <A> StoreMessageSentFailed<A> copy(DurableProducerQueue.MessageSent<A> messageSent, int attempt) {
            return new StoreMessageSentFailed<A>(messageSent, attempt);
        }

        public <A> DurableProducerQueue.MessageSent<A> copy$default$1() {
            return this.messageSent();
        }

        public int copy$default$2() {
            return this.attempt();
        }

        public DurableProducerQueue.MessageSent<A> _1() {
            return this.messageSent();
        }

        public int _2() {
            return this.attempt();
        }
    }

    public static class StoreMessageSentReply
    implements Product,
    Serializable {
        private final DurableProducerQueue.StoreMessageSentAck ack;

        public static StoreMessageSentReply apply(DurableProducerQueue.StoreMessageSentAck storeMessageSentAck) {
            return ProducerControllerImpl$StoreMessageSentReply$.MODULE$.apply(storeMessageSentAck);
        }

        public static StoreMessageSentReply fromProduct(Product product) {
            return ProducerControllerImpl$StoreMessageSentReply$.MODULE$.fromProduct(product);
        }

        public static StoreMessageSentReply unapply(StoreMessageSentReply storeMessageSentReply) {
            return ProducerControllerImpl$StoreMessageSentReply$.MODULE$.unapply(storeMessageSentReply);
        }

        public StoreMessageSentReply(DurableProducerQueue.StoreMessageSentAck ack) {
            this.ack = ack;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoreMessageSentReply)) return false;
            StoreMessageSentReply storeMessageSentReply = (StoreMessageSentReply)object;
            DurableProducerQueue.StoreMessageSentAck storeMessageSentAck = this.ack();
            DurableProducerQueue.StoreMessageSentAck storeMessageSentAck2 = storeMessageSentReply.ack();
            if (storeMessageSentAck == null) {
                if (storeMessageSentAck2 != null) {
                    return false;
                }
            } else if (!((Object)storeMessageSentAck).equals(storeMessageSentAck2)) return false;
            if (!storeMessageSentReply.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof StoreMessageSentReply;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "StoreMessageSentReply";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ack";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public DurableProducerQueue.StoreMessageSentAck ack() {
            return this.ack;
        }

        public StoreMessageSentReply copy(DurableProducerQueue.StoreMessageSentAck ack) {
            return new StoreMessageSentReply(ack);
        }

        public DurableProducerQueue.StoreMessageSentAck copy$default$1() {
            return this.ack();
        }

        public DurableProducerQueue.StoreMessageSentAck _1() {
            return this.ack();
        }
    }

    public static interface UnsealedInternalCommand
    extends InternalCommand {
    }
}

