/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.delivery.internal;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.ActorRef$ActorRefOps$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.DispatcherSelector$;
import org.apache.pekko.actor.typed.delivery.ConsumerController;
import org.apache.pekko.actor.typed.delivery.ConsumerController$SequencedMessage$;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue$LoadState$;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue$State$;
import org.apache.pekko.actor.typed.delivery.ProducerController;
import org.apache.pekko.actor.typed.delivery.ProducerController$RegisterConsumer$;
import org.apache.pekko.actor.typed.delivery.ProducerController$RequestNext$;
import org.apache.pekko.actor.typed.delivery.internal.ChunkedMessage;
import org.apache.pekko.actor.typed.delivery.internal.ChunkedMessage$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$Ack$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$DurableQueueTerminated$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$LoadStateFailed$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$LoadStateReply$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$Msg$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$Request$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$Resend$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$ResendFirst$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$ResendFirstUnconfirmed$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$SendChunk$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$State$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$StoreMessageSentCompleted$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$StoreMessageSentFailed$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$StoreMessageSentReply$;
import org.apache.pekko.actor.typed.internal.ActorFlightRecorder;
import org.apache.pekko.actor.typed.internal.ActorFlightRecorder$;
import org.apache.pekko.actor.typed.internal.DeliveryFlightRecorder;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.actor.typed.scaladsl.TimerScheduler;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ProducerControllerImpl$
implements Serializable {
    public static final ProducerControllerImpl$Request$ Request;
    public static final ProducerControllerImpl$Resend$ Resend;
    public static final ProducerControllerImpl$Ack$ Ack;
    public static final ProducerControllerImpl$Msg$ org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$Msg;
    public static final ProducerControllerImpl$ResendFirst$ org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$ResendFirst;
    public static final ProducerControllerImpl$ResendFirstUnconfirmed$ ResendFirstUnconfirmed;
    public static final ProducerControllerImpl$SendChunk$ org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$SendChunk;
    private static final ProducerControllerImpl$LoadStateReply$ LoadStateReply;
    public static final ProducerControllerImpl$LoadStateFailed$ org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$LoadStateFailed;
    private static final ProducerControllerImpl$StoreMessageSentReply$ StoreMessageSentReply;
    public static final ProducerControllerImpl$StoreMessageSentFailed$ org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$StoreMessageSentFailed;
    public static final ProducerControllerImpl$StoreMessageSentCompleted$ org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$StoreMessageSentCompleted;
    public static final ProducerControllerImpl$DurableQueueTerminated$ org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$DurableQueueTerminated;
    private static final ProducerControllerImpl$State$ State;
    public static final ProducerControllerImpl$ MODULE$;

    private ProducerControllerImpl$() {
    }

    static {
        MODULE$ = new ProducerControllerImpl$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ProducerControllerImpl$.class);
    }

    public <A> Behavior<ProducerController.Command<A>> apply(String producerId, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, ProducerController.Settings settings, ClassTag<A> evidence$1) {
        return Behaviors$.MODULE$.setup((Function1<ActorContext, Behavior> & Serializable)context -> {
            ((ActorFlightRecorder)ActorFlightRecorder$.MODULE$.apply(context.system())).delivery().producerCreated(producerId, context.self().path());
            Tuple2[] tuple2Array = new Tuple2[1];
            String string2 = Predef$.MODULE$.ArrowAssoc("producerId");
            tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, producerId);
            Map map = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
            context.setLoggerName("org.apache.pekko.actor.typed.delivery.ProducerController");
            Option durableQueue = MODULE$.askLoadState((ActorContext<ProducerControllerImpl.InternalCommand>)context, durableQueueBehavior, settings);
            return Behaviors$.MODULE$.withMdc(map, MODULE$.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$waitingForInitialization((ActorContext<ProducerControllerImpl.InternalCommand>)context, None$.MODULE$, None$.MODULE$, durableQueue, settings, MODULE$.createInitialState(durableQueue.nonEmpty()), (Function3<ActorRef, ActorRef, DurableProducerQueue.State, Behavior> & Serializable)(producer, consumerController, loadedState) -> {
                JProcedure1 send = _$1 -> {
                    ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(consumerController);
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, _$1);
                };
                return MODULE$.becomeActive(producerId, durableQueue, settings, MODULE$.createState(context.self(), producerId, send, (ActorRef)producer, (DurableProducerQueue.State)loadedState), evidence$1);
            }, evidence$1), ClassTag$.MODULE$.apply(ProducerControllerImpl.InternalCommand.class));
        }).narrow();
    }

    public <A> Behavior<ProducerController.Command<A>> apply(String producerId, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, ProducerController.Settings settings, Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> send, ClassTag<A> evidence$1) {
        return Behaviors$.MODULE$.setup((Function1<ActorContext, Behavior> & Serializable)context -> {
            ((ActorFlightRecorder)ActorFlightRecorder$.MODULE$.apply(context.system())).delivery().producerCreated(producerId, context.self().path());
            Tuple2[] tuple2Array = new Tuple2[1];
            String string2 = Predef$.MODULE$.ArrowAssoc("producerId");
            tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, producerId);
            Map map = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
            context.setLoggerName("org.apache.pekko.actor.typed.delivery.ProducerController");
            Option durableQueue = MODULE$.askLoadState((ActorContext<ProducerControllerImpl.InternalCommand>)context, durableQueueBehavior, settings);
            return Behaviors$.MODULE$.withMdc(map, MODULE$.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$waitingForInitialization((ActorContext<ProducerControllerImpl.InternalCommand>)context, None$.MODULE$, Some$.MODULE$.apply(context.system().deadLetters()), durableQueue, settings, MODULE$.createInitialState(durableQueue.nonEmpty()), (Function3<ActorRef, ActorRef, DurableProducerQueue.State, Behavior> & Serializable)(producer, _$2, loadedState) -> MODULE$.becomeActive(producerId, durableQueue, settings, MODULE$.createState(context.self(), producerId, send, (ActorRef)producer, (DurableProducerQueue.State)loadedState), evidence$1), evidence$1), ClassTag$.MODULE$.apply(ProducerControllerImpl.InternalCommand.class));
        }).narrow();
    }

    private <A> Option<ActorRef<DurableProducerQueue.Command<A>>> askLoadState(ActorContext<ProducerControllerImpl.InternalCommand> context, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, ProducerController.Settings settings) {
        return durableQueueBehavior.map((Function1<Behavior, ActorRef> & Serializable)b -> {
            ActorRef ref = context.spawn(b, "durable", DispatcherSelector$.MODULE$.sameAsParent());
            context.watchWith(ref, ProducerControllerImpl$DurableQueueTerminated$.MODULE$);
            MODULE$.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$askLoadState(context, Some$.MODULE$.apply(ref), settings, 1);
            return ref;
        });
    }

    public <A> void org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$askLoadState(ActorContext<ProducerControllerImpl.InternalCommand> context, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, ProducerController.Settings settings, int attempt) {
        Timeout loadTimeout = Timeout$.MODULE$.durationToTimeout(settings.durableQueueRequestTimeout());
        durableQueue.foreach(ref -> context.ask(ref, (Function1<ActorRef, DurableProducerQueue.LoadState> & Serializable)askReplyTo -> DurableProducerQueue$LoadState$.MODULE$.apply(askReplyTo), (Function1<Try, ProducerControllerImpl.InternalCommand> & Serializable)x$1 -> {
            ProducerControllerImpl.InternalCommand internalCommand;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                DurableProducerQueue.State s2 = (DurableProducerQueue.State)((Success)try_).value();
                internalCommand = ProducerControllerImpl$LoadStateReply$.MODULE$.apply(s2);
            } else if (try_ instanceof Failure) {
                internalCommand = ProducerControllerImpl$LoadStateFailed$.MODULE$.apply(attempt);
            } else {
                throw new MatchError(try_);
            }
            return internalCommand;
        }, loadTimeout, ClassTag$.MODULE$.apply(DurableProducerQueue.State.class)));
    }

    private <A> Option<DurableProducerQueue.State<A>> createInitialState(boolean hasDurableQueue) {
        if (hasDurableQueue) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(DurableProducerQueue$State$.MODULE$.empty());
    }

    private <A> ProducerControllerImpl.State<A> createState(ActorRef<ProducerControllerImpl.InternalCommand> self, String producerId, Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> send, ActorRef<ProducerController.RequestNext<A>> producer, DurableProducerQueue.State<A> loadedState) {
        Vector unconfirmed = (Vector)((StrictOptimizedIterableOps)loadedState.unconfirmed().toVector().zipWithIndex()).map((Function1<Tuple2, ConsumerController.SequencedMessage> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                DurableProducerQueue.MessageSent u = (DurableProducerQueue.MessageSent)tuple2._1();
                int i = BoxesRunTime.unboxToInt(tuple2._2());
                return ConsumerController$SequencedMessage$.MODULE$.apply(producerId, u.seqNr(), u.message(), i == 0, u.ack(), self);
            }
            throw new MatchError(tuple2);
        });
        return ProducerControllerImpl$State$.MODULE$.apply(false, loadedState.currentSeqNr(), loadedState.highestConfirmedSeqNr(), 1L, (Map<Object, ActorRef<Object>>)Predef$.MODULE$.Map().empty(), true, unconfirmed, package$.MODULE$.Nil(), 0L, loadedState.highestConfirmedSeqNr() + 1L, producer, send);
    }

    public <A> Behavior<ProducerControllerImpl.InternalCommand> org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$waitingForInitialization(ActorContext<ProducerControllerImpl.InternalCommand> context, Option<ActorRef<ProducerController.RequestNext<A>>> producer, Option<ActorRef<ConsumerController.Command<A>>> consumerController, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, ProducerController.Settings settings, Option<DurableProducerQueue.State<A>> initialState, Function3<ActorRef<ProducerController.RequestNext<A>>, ActorRef<ConsumerController.Command<A>>, DurableProducerQueue.State<A>, Behavior<ProducerControllerImpl.InternalCommand>> thenBecomeActive, ClassTag<A> evidence$1) {
        return (Behavior)((Object)Behaviors$.MODULE$.receiveMessagePartial(new Serializable(producer, initialState, thenBecomeActive, context, durableQueue, settings, evidence$1, consumerController){
            private final Option producer$2;
            private final Option initialState$1;
            private final Function3 thenBecomeActive$1;
            private final ActorContext context$5;
            private final Option durableQueue$3;
            private final ProducerController.Settings settings$6;
            private final ClassTag evidence$1$5;
            private final Option consumerController$3;
            {
                this.producer$2 = producer$3;
                this.initialState$1 = initialState$2;
                this.thenBecomeActive$1 = thenBecomeActive$2;
                this.context$5 = context$7;
                this.durableQueue$3 = durableQueue$6;
                this.settings$6 = settings$9;
                this.evidence$1$5 = evidence$1$8;
                this.consumerController$3 = consumerController$4;
            }

            public final boolean isDefinedAt(ProducerControllerImpl.InternalCommand x) {
                ProducerController.RegisterConsumer<A> registerConsumer;
                ActorRef<ConsumerController.Command<A>> actorRef;
                ProducerControllerImpl.InternalCommand internalCommand = x;
                if (internalCommand instanceof ProducerController.RegisterConsumer && (actorRef = (registerConsumer = ProducerController$RegisterConsumer$.MODULE$.unapply((ProducerController.RegisterConsumer)internalCommand))._1()) instanceof ActorRef) {
                    ActorRef<ConsumerController.Command<A>> c = actorRef;
                    return true;
                }
                if (internalCommand instanceof ProducerController.Start) {
                    ProducerController.Start start = (ProducerController.Start)internalCommand;
                    return true;
                }
                if (internalCommand instanceof ProducerControllerImpl.LoadStateReply) {
                    ProducerControllerImpl.LoadStateReply load = (ProducerControllerImpl.LoadStateReply)internalCommand;
                    return true;
                }
                if (internalCommand instanceof ProducerControllerImpl.LoadStateFailed) {
                    int n;
                    ProducerControllerImpl.LoadStateFailed loadStateFailed = ProducerControllerImpl$LoadStateFailed$.MODULE$.unapply((ProducerControllerImpl.LoadStateFailed)internalCommand);
                    int attempt = n = loadStateFailed._1();
                    return true;
                }
                return ProducerControllerImpl$DurableQueueTerminated$.MODULE$.equals(internalCommand);
            }

            public final Object applyOrElse(ProducerControllerImpl.InternalCommand x, Function1 function1) {
                ProducerController.RegisterConsumer<A> registerConsumer;
                ActorRef<ConsumerController.Command<A>> actorRef;
                ProducerControllerImpl.InternalCommand internalCommand = x;
                if (internalCommand instanceof ProducerController.RegisterConsumer && (actorRef = (registerConsumer = ProducerController$RegisterConsumer$.MODULE$.unapply((ProducerController.RegisterConsumer)internalCommand))._1()) instanceof ActorRef) {
                    ActorRef<ConsumerController.Command<A>> c = actorRef;
                    Tuple2<Option, Option> tuple2 = Tuple2$.MODULE$.apply(this.producer$2, this.initialState$1);
                    if (tuple2 != null) {
                        Option option = tuple2._1();
                        Option option2 = tuple2._2();
                        if (option instanceof Some) {
                            ActorRef p = (ActorRef)((Some)option).value();
                            if (option2 instanceof Some) {
                                DurableProducerQueue.State s2 = (DurableProducerQueue.State)((Some)option2).value();
                                return (Behavior)this.thenBecomeActive$1.apply(p, c, s2);
                            }
                        }
                        return ProducerControllerImpl$.MODULE$.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$waitingForInitialization(this.context$5, this.producer$2, Some$.MODULE$.apply(c), this.durableQueue$3, this.settings$6, this.initialState$1, this.thenBecomeActive$1, this.evidence$1$5);
                    }
                    throw new MatchError(tuple2);
                }
                if (internalCommand instanceof ProducerController.Start) {
                    ProducerController.Start start = (ProducerController.Start)internalCommand;
                    Tuple2<Option, Option> tuple2 = Tuple2$.MODULE$.apply(this.consumerController$3, this.initialState$1);
                    if (tuple2 != null) {
                        Option option = tuple2._1();
                        Option option3 = tuple2._2();
                        if (option instanceof Some) {
                            ActorRef c = (ActorRef)((Some)option).value();
                            if (option3 instanceof Some) {
                                DurableProducerQueue.State s3 = (DurableProducerQueue.State)((Some)option3).value();
                                return (Behavior)this.thenBecomeActive$1.apply(start.producer(), c, s3);
                            }
                        }
                        return ProducerControllerImpl$.MODULE$.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$waitingForInitialization(this.context$5, Some$.MODULE$.apply(start.producer()), this.consumerController$3, this.durableQueue$3, this.settings$6, this.initialState$1, this.thenBecomeActive$1, this.evidence$1$5);
                    }
                    throw new MatchError(tuple2);
                }
                if (internalCommand instanceof ProducerControllerImpl.LoadStateReply) {
                    ProducerControllerImpl.LoadStateReply load = (ProducerControllerImpl.LoadStateReply)internalCommand;
                    Tuple2<Option, Option> tuple2 = Tuple2$.MODULE$.apply(this.producer$2, this.consumerController$3);
                    if (tuple2 != null) {
                        Option option = tuple2._1();
                        Option option4 = tuple2._2();
                        if (option instanceof Some) {
                            ActorRef p = (ActorRef)((Some)option).value();
                            if (option4 instanceof Some) {
                                ActorRef c = (ActorRef)((Some)option4).value();
                                return (Behavior)this.thenBecomeActive$1.apply(p, c, load.state());
                            }
                        }
                        return ProducerControllerImpl$.MODULE$.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$waitingForInitialization(this.context$5, this.producer$2, this.consumerController$3, this.durableQueue$3, this.settings$6, Some$.MODULE$.apply(load.state()), this.thenBecomeActive$1, this.evidence$1$5);
                    }
                    throw new MatchError(tuple2);
                }
                if (internalCommand instanceof ProducerControllerImpl.LoadStateFailed) {
                    ProducerControllerImpl.LoadStateFailed loadStateFailed = ProducerControllerImpl$LoadStateFailed$.MODULE$.unapply((ProducerControllerImpl.LoadStateFailed)internalCommand);
                    int n = loadStateFailed._1();
                    int attempt = n;
                    if (attempt >= this.settings$6.durableQueueRetryAttempts()) {
                        String errorMessage = new StringBuilder(46).append("LoadState failed after [").append(attempt).append("] attempts, giving up.").toString();
                        this.context$5.log().error(errorMessage);
                        throw new TimeoutException(errorMessage);
                    }
                    this.context$5.log().warn("LoadState failed, attempt [{}] of [{}], retrying.", (Object)BoxesRunTime.boxToInteger(attempt), (Object)BoxesRunTime.boxToInteger(this.settings$6.durableQueueRetryAttempts()));
                    ProducerControllerImpl$.MODULE$.org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$$askLoadState(this.context$5, this.durableQueue$3, this.settings$6, attempt + 1);
                    return Behaviors$.MODULE$.same();
                }
                if (ProducerControllerImpl$DurableQueueTerminated$.MODULE$.equals(internalCommand)) {
                    throw new IllegalStateException("DurableQueue was unexpectedly terminated.");
                }
                return function1.apply(x);
            }
        }));
    }

    private <A> Behavior<ProducerControllerImpl.InternalCommand> becomeActive(String producerId, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, ProducerController.Settings settings, ProducerControllerImpl.State<A> state, ClassTag<A> evidence$1) {
        return Behaviors$.MODULE$.setup((Function1<ActorContext, Behavior> & Serializable)context -> {
            DeliveryFlightRecorder flightRecorder = ((ActorFlightRecorder)ActorFlightRecorder$.MODULE$.apply(context.system())).delivery();
            flightRecorder.producerStarted(producerId, context.self().path());
            return Behaviors$.MODULE$.withTimers((Function1<TimerScheduler, Behavior> & Serializable)timers -> {
                boolean bl;
                ActorRef msgAdapter = context.messageAdapter((Function1<Object, ProducerControllerImpl.InternalCommand> & Serializable)msg -> ProducerControllerImpl$Msg$.MODULE$.apply(msg), evidence$1);
                if (state.unconfirmed().isEmpty()) {
                    flightRecorder.producerRequestNext(producerId, 1L, 0L);
                    ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(state.producer());
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerController$RequestNext$.MODULE$.apply(producerId, 1L, 0L, msgAdapter, context.self()));
                    bl = true;
                } else {
                    context.log().debug("Starting with [{}] unconfirmed.", (Object)BoxesRunTime.boxToInteger(state.unconfirmed().size()));
                    ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(context.self());
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerControllerImpl$ResendFirst$.MODULE$);
                    bl = false;
                }
                boolean requested = bl;
                return new ProducerControllerImpl((ActorContext<ProducerControllerImpl.InternalCommand>)context, producerId, durableQueue, settings, msgAdapter, (TimerScheduler<ProducerControllerImpl.InternalCommand>)timers, evidence$1).org$apache$pekko$actor$typed$delivery$internal$ProducerControllerImpl$$active(state.copy(requested, state.copy$default$2(), state.copy$default$3(), state.copy$default$4(), state.copy$default$5(), state.copy$default$6(), state.copy$default$7(), state.copy$default$8(), state.copy$default$9(), state.copy$default$10(), state.copy$default$11(), state.copy$default$12()));
            });
        });
    }

    public void enforceLocalProducer(ActorRef<?> ref) {
        if (ref.path().address().hasGlobalScope()) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Consumer [").append(ref).append("] should be local.").toString());
        }
    }

    public <A> Seq<ChunkedMessage> createChunks(A m, int chunkSize, Serialization serialization) {
        A mAnyRef = m;
        byte[] bytes = serialization.serialize(mAnyRef).get();
        Serializer ser = serialization.findSerializerFor(mAnyRef);
        String manifest = Serializers$.MODULE$.manifestFor(ser, mAnyRef);
        int serializerId = ser.identifier();
        if (bytes.length <= chunkSize) {
            ChunkedMessage chunkedMessage = ChunkedMessage$.MODULE$.apply(ByteString$.MODULE$.fromArrayUnsafe(bytes), true, true, serializerId, manifest);
            return package$.MODULE$.Nil().$colon$colon(chunkedMessage);
        }
        Builder builder = package$.MODULE$.Vector().newBuilder();
        Iterator<ByteString> chunksIter = ByteString$.MODULE$.fromArrayUnsafe(bytes).grouped(chunkSize);
        boolean first = true;
        while (chunksIter.hasNext()) {
            ByteString chunk = chunksIter.next();
            boolean firstChunk = first;
            first = false;
            boolean lastChunk = !chunksIter.hasNext();
            builder.$plus$eq(ChunkedMessage$.MODULE$.apply(chunk, firstChunk, lastChunk, serializerId, manifest));
        }
        return (Seq)builder.result();
    }
}

