/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.delivery.internal;

import java.io.Serializable;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorRef$;
import org.apache.pekko.actor.typed.ActorRef$ActorRefOps$;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.PostStop$;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.delivery.ConsumerController;
import org.apache.pekko.actor.typed.delivery.ConsumerController$Confirmed$;
import org.apache.pekko.actor.typed.delivery.ConsumerController$Delivery$;
import org.apache.pekko.actor.typed.delivery.ConsumerController$SequencedMessage$;
import org.apache.pekko.actor.typed.delivery.ProducerController;
import org.apache.pekko.actor.typed.delivery.ProducerController$RegisterConsumer$;
import org.apache.pekko.actor.typed.delivery.internal.ChunkedMessage;
import org.apache.pekko.actor.typed.delivery.internal.ConsumerControllerImpl$;
import org.apache.pekko.actor.typed.delivery.internal.ConsumerControllerImpl$ConsumerTerminated$;
import org.apache.pekko.actor.typed.delivery.internal.ConsumerControllerImpl$Retry$;
import org.apache.pekko.actor.typed.delivery.internal.ConsumerControllerImpl$State$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$Ack$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$Request$;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl$Resend$;
import org.apache.pekko.actor.typed.internal.ActorFlightRecorder;
import org.apache.pekko.actor.typed.internal.ActorFlightRecorder$;
import org.apache.pekko.actor.typed.internal.DeliveryFlightRecorder;
import org.apache.pekko.actor.typed.receptionist.ServiceKey;
import org.apache.pekko.actor.typed.scaladsl.ActorContext;
import org.apache.pekko.actor.typed.scaladsl.Behaviors$;
import org.apache.pekko.actor.typed.scaladsl.StashBuffer;
import org.apache.pekko.actor.typed.scaladsl.TimerScheduler;
import org.apache.pekko.actor.typed.scaladsl.package$LoggerOps$;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteStringBuilder;
import org.apache.pekko.util.ConstantFun$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class ConsumerControllerImpl<A> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ConsumerControllerImpl.class.getDeclaredField("serialization$lzy1"));
    private final ActorContext<InternalCommand> context;
    private final RetryTimer retryTimer;
    private final StashBuffer<InternalCommand> stashBuffer;
    private final ConsumerController.Settings settings;
    private final DeliveryFlightRecorder flightRecorder;
    private final boolean traceEnabled;
    private volatile Object serialization$lzy1;

    public static <A> Behavior<ConsumerController.Command<A>> apply(Option<ServiceKey<ConsumerController.Command<A>>> option, ConsumerController.Settings settings) {
        return ConsumerControllerImpl$.MODULE$.apply(option, settings);
    }

    public static void enforceLocalConsumer(ActorRef<?> actorRef) {
        ConsumerControllerImpl$.MODULE$.enforceLocalConsumer(actorRef);
    }

    public ConsumerControllerImpl(ActorContext<InternalCommand> context, RetryTimer retryTimer, StashBuffer<InternalCommand> stashBuffer, ConsumerController.Settings settings) {
        this.context = context;
        this.retryTimer = retryTimer;
        this.stashBuffer = stashBuffer;
        this.settings = settings;
        this.flightRecorder = ((ActorFlightRecorder)ActorFlightRecorder$.MODULE$.apply(context.system())).delivery();
        this.traceEnabled = context.log().isTraceEnabled();
        retryTimer.start();
    }

    private Serialization serialization() {
        Object object = this.serialization$lzy1;
        if (object instanceof Serialization) {
            return (Serialization)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Serialization)this.serialization$lzyINIT1();
    }

    private Object serialization$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.serialization$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Serialization serialization = null;
                    try {
                        serialization = (Serialization)SerializationExtension$.MODULE$.apply(this.context.system());
                        object2 = serialization == null ? LazyVals$NullValue$.MODULE$ : serialization;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.serialization$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return serialization;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private boolean resendLost() {
        return !this.settings.onlyFlowControl();
    }

    public Behavior<InternalCommand> org$apache$pekko$actor$typed$delivery$internal$ConsumerControllerImpl$$active(State<A> s2) {
        return Behaviors$.MODULE$.receiveMessage((Function1<InternalCommand, Behavior> & Serializable)x$1 -> {
            InternalCommand internalCommand = x$1;
            if (internalCommand instanceof ConsumerController.SequencedMessage) {
                ConsumerController.SequencedMessage seqMsg = (ConsumerController.SequencedMessage)internalCommand;
                String pid = seqMsg.producerId();
                long seqNr = seqMsg.seqNr();
                long expectedSeqNr = s2.receivedSeqNr() + 1L;
                this.flightRecorder.consumerReceived(pid, seqNr);
                this.retryTimer.reset();
                if (s2.isProducerChanged(seqMsg)) {
                    if (seqMsg.first() && this.traceEnabled) {
                        this.context.log().trace("Received first SequencedMessage seqNr [{}], delivering to consumer.", (Object)BoxesRunTime.boxToLong(seqNr));
                    }
                    return this.receiveChangedProducer(s2, seqMsg);
                }
                if (s2.registering().isDefined()) {
                    this.context.log().debug("Received SequencedMessage seqNr [{}], discarding message because registering to new ProducerController.", (Object)BoxesRunTime.boxToLong(seqNr));
                    return this.stashBuffer.unstash(Behaviors$.MODULE$.same(), 1, ConstantFun$.MODULE$.scalaIdentityFunction());
                }
                if (s2.isNextExpected(seqMsg)) {
                    if (this.traceEnabled) {
                        this.context.log().trace("Received SequencedMessage seqNr [{}], delivering to consumer.", (Object)BoxesRunTime.boxToLong(seqNr));
                    }
                    return this.deliver(s2.copy(s2.copy$default$1(), s2.copy$default$2(), s2.copy$default$3(), seqNr, s2.copy$default$5(), s2.copy$default$6(), s2.copy$default$7(), s2.copy$default$8(), s2.copy$default$9()), seqMsg);
                }
                if (seqNr > expectedSeqNr) {
                    this.flightRecorder.consumerMissing(pid, expectedSeqNr, seqNr);
                    package$LoggerOps$.MODULE$.debugN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Received SequencedMessage seqNr [{}], but expected [{}], {}.", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(seqNr), BoxesRunTime.boxToLong(expectedSeqNr), this.resendLost() ? "requesting resend from expected seqNr" : "delivering to consumer anyway"}));
                    if (this.resendLost()) {
                        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(seqMsg.producerController());
                        ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerControllerImpl$Resend$.MODULE$.apply(expectedSeqNr));
                        this.stashBuffer.clear();
                        this.retryTimer.start();
                        return this.resending(s2);
                    }
                    return this.deliver(s2.copy(s2.copy$default$1(), s2.copy$default$2(), s2.copy$default$3(), seqNr, s2.copy$default$5(), s2.copy$default$6(), s2.copy$default$7(), s2.copy$default$8(), s2.copy$default$9()), seqMsg);
                }
                this.flightRecorder.consumerDuplicate(pid, expectedSeqNr, seqNr);
                package$LoggerOps$.MODULE$.debug2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Received duplicate SequencedMessage seqNr [{}], expected [{}].", BoxesRunTime.boxToLong(seqNr), BoxesRunTime.boxToLong(expectedSeqNr));
                if (seqMsg.first()) {
                    return this.stashBuffer.unstash(this.org$apache$pekko$actor$typed$delivery$internal$ConsumerControllerImpl$$active(this.retryRequest(s2)), 1, ConstantFun$.MODULE$.scalaIdentityFunction());
                }
                return this.stashBuffer.unstash(Behaviors$.MODULE$.same(), 1, ConstantFun$.MODULE$.scalaIdentityFunction());
            }
            if (ConsumerControllerImpl$Retry$.MODULE$.equals(internalCommand)) {
                return this.receiveRetry(s2, (Function0<Behavior<InternalCommand>>)(Function0<Behavior> & Serializable)() -> this.org$apache$pekko$actor$typed$delivery$internal$ConsumerControllerImpl$$active(this.retryRequest(s2)));
            }
            if (ConsumerController$Confirmed$.MODULE$.equals(internalCommand)) {
                return this.receiveUnexpectedConfirmed();
            }
            if (internalCommand instanceof ConsumerController.Start) {
                ConsumerController.Start start = (ConsumerController.Start)internalCommand;
                return this.receiveStart(s2, start, (Function1<State, Behavior> & Serializable)newState -> this.org$apache$pekko$actor$typed$delivery$internal$ConsumerControllerImpl$$active((State<A>)newState));
            }
            if (internalCommand instanceof ConsumerTerminated) {
                ActorRef<?> actorRef;
                ConsumerTerminated consumerTerminated = ConsumerControllerImpl$ConsumerTerminated$.MODULE$.unapply((ConsumerTerminated)internalCommand);
                ActorRef<?> c = actorRef = consumerTerminated._1();
                return this.receiveConsumerTerminated(c);
            }
            if (internalCommand instanceof ConsumerController.RegisterToProducerController) {
                ConsumerController.RegisterToProducerController reg = (ConsumerController.RegisterToProducerController)internalCommand;
                return this.receiveRegisterToProducerController(s2, reg, (Function1<State, Behavior> & Serializable)newState -> this.org$apache$pekko$actor$typed$delivery$internal$ConsumerControllerImpl$$active((State<A>)newState));
            }
            if (internalCommand instanceof ConsumerController.DeliverThenStop) {
                return this.receiveDeliverThenStop(s2, (Function1<State, Behavior> & Serializable)newState -> this.org$apache$pekko$actor$typed$delivery$internal$ConsumerControllerImpl$$active((State<A>)newState));
            }
            if (internalCommand instanceof UnsealedInternalCommand) {
                return Behaviors$.MODULE$.unhandled();
            }
            throw new MatchError(internalCommand);
        }).receiveSignal((PartialFunction<Tuple2<ActorContext<InternalCommand>, Signal>, Behavior<InternalCommand>>)((Object)new Serializable(s2, this){
            private final State s$3;
            private final /* synthetic */ ConsumerControllerImpl $outer;
            {
                this.s$3 = s$11;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                return tuple2 != null && PostStop$.MODULE$.equals(tuple2._2());
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null && PostStop$.MODULE$.equals(tuple2._2())) {
                    return this.$outer.org$apache$pekko$actor$typed$delivery$internal$ConsumerControllerImpl$$postStop(this.s$3);
                }
                return function1.apply(x);
            }
        }));
    }

    private Behavior<InternalCommand> receiveChangedProducer(State<A> s2, ConsumerController.SequencedMessage<A> seqMsg) {
        long seqNr = seqMsg.seqNr();
        if (seqMsg.first() || !this.resendLost()) {
            this.logChangedProducer(s2, seqMsg);
            long newRequestedSeqNr = seqMsg.seqNr() - 1L + (long)this.settings.flowControlWindow();
            this.context.log().debug("Sending Request with requestUpToSeqNr [{}] after first SequencedMessage.", (Object)BoxesRunTime.boxToLong(newRequestedSeqNr));
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(seqMsg.producerController());
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerControllerImpl$Request$.MODULE$.apply(0L, newRequestedSeqNr, this.resendLost(), false));
            Option<ActorRef<ProducerController.Command<A>>> option = s2.updatedRegistering(seqMsg);
            ActorRef<ConsumerController.Delivery<A>> actorRef2 = s2.copy$default$3();
            List<ConsumerController.SequencedMessage<A>> list = s2.copy$default$7();
            boolean bl = s2.copy$default$9();
            return this.deliver(s2.copy(seqMsg.producerController(), seqMsg.producerId(), actorRef2, seqNr, 0L, newRequestedSeqNr, list, option, bl), seqMsg);
        }
        if (s2.receivedSeqNr() == 0L) {
            this.context.log().debug("Received SequencedMessage seqNr [{}], from new producer producer [{}] but it wasn't first. Resending.", (Object)BoxesRunTime.boxToLong(seqNr), (Object)seqMsg.producerController());
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(seqMsg.producerController());
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerControllerImpl$Resend$.MODULE$.apply(0L));
            this.stashBuffer.clear();
            this.retryTimer.start();
            return this.resending(s2);
        }
        package$LoggerOps$.MODULE$.warnN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Received SequencedMessage seqNr [{}], discarding message because it was from unexpected producer [{}] when expecting [{}].", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(seqNr), seqMsg.producerController(), s2.producerController()}));
        return this.stashBuffer.unstash(Behaviors$.MODULE$.same(), 1, ConstantFun$.MODULE$.scalaIdentityFunction());
    }

    private void logChangedProducer(State<A> s2, ConsumerController.SequencedMessage<A> seqMsg) {
        ActorRef<ProducerControllerImpl.InternalCommand> actorRef = s2.producerController();
        ActorRef actorRef2 = this.context.system().deadLetters();
        if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
            package$LoggerOps$.MODULE$.debugN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Associated with new ProducerController [{}], seqNr [{}].", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{seqMsg.producerController(), BoxesRunTime.boxToLong(seqMsg.seqNr())}));
            return;
        }
        this.flightRecorder.consumerChangedProducer(seqMsg.producerId());
        package$LoggerOps$.MODULE$.debugN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Changing ProducerController from [{}] to [{}], seqNr [{}].", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{s2.producerController(), seqMsg.producerController(), BoxesRunTime.boxToLong(seqMsg.seqNr())}));
    }

    private Behavior<InternalCommand> resending(State<A> s2) {
        if (this.stashBuffer.nonEmpty()) {
            throw new IllegalStateException("StashBuffer should be cleared before resending.");
        }
        return Behaviors$.MODULE$.receiveMessage((Function1<InternalCommand, Behavior> & Serializable)x$1 -> {
            InternalCommand internalCommand = x$1;
            if (internalCommand instanceof ConsumerController.SequencedMessage) {
                ConsumerController.SequencedMessage seqMsg = (ConsumerController.SequencedMessage)internalCommand;
                long seqNr = seqMsg.seqNr();
                if (s2.isProducerChanged(seqMsg)) {
                    if (seqMsg.first() && this.traceEnabled) {
                        this.context.log().trace("Received first SequencedMessage seqNr [{}], delivering to consumer.", (Object)BoxesRunTime.boxToLong(seqNr));
                    }
                    return this.receiveChangedProducer(s2, seqMsg);
                }
                if (s2.registering().isDefined()) {
                    this.context.log().debug("Received SequencedMessage seqNr [{}], discarding message because registering to new ProducerController.", (Object)BoxesRunTime.boxToLong(seqNr));
                    return Behaviors$.MODULE$.same();
                }
                if (s2.isNextExpected(seqMsg)) {
                    this.flightRecorder.consumerReceivedResend(seqNr);
                    this.context.log().debug("Received missing SequencedMessage seqNr [{}].", (Object)BoxesRunTime.boxToLong(seqNr));
                    return this.deliver(s2.copy(s2.copy$default$1(), s2.copy$default$2(), s2.copy$default$3(), seqNr, s2.copy$default$5(), s2.copy$default$6(), s2.copy$default$7(), s2.copy$default$8(), s2.copy$default$9()), seqMsg);
                }
                package$LoggerOps$.MODULE$.debug2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Received SequencedMessage seqNr [{}], discarding message because waiting for [{}].", BoxesRunTime.boxToLong(seqNr), BoxesRunTime.boxToLong(s2.receivedSeqNr() + 1L));
                if (seqMsg.first()) {
                    this.retryRequest(s2);
                }
                return Behaviors$.MODULE$.same();
            }
            if (ConsumerControllerImpl$Retry$.MODULE$.equals(internalCommand)) {
                return this.receiveRetry(s2, (Function0<Behavior<InternalCommand>>)(Function0<Behavior> & Serializable)() -> {
                    this.context.log().debug("Retry sending Resend [{}].", (Object)BoxesRunTime.boxToLong(s2.receivedSeqNr() + 1L));
                    ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(s2.producerController());
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerControllerImpl$Resend$.MODULE$.apply(s2.receivedSeqNr() + 1L));
                    return Behaviors$.MODULE$.same();
                });
            }
            if (ConsumerController$Confirmed$.MODULE$.equals(internalCommand)) {
                return this.receiveUnexpectedConfirmed();
            }
            if (internalCommand instanceof ConsumerController.Start) {
                ConsumerController.Start start = (ConsumerController.Start)internalCommand;
                return this.receiveStart(s2, start, (Function1<State, Behavior> & Serializable)newState -> this.resending((State<A>)newState));
            }
            if (internalCommand instanceof ConsumerTerminated) {
                ActorRef<?> actorRef;
                ConsumerTerminated consumerTerminated = ConsumerControllerImpl$ConsumerTerminated$.MODULE$.unapply((ConsumerTerminated)internalCommand);
                ActorRef<?> c = actorRef = consumerTerminated._1();
                return this.receiveConsumerTerminated(c);
            }
            if (internalCommand instanceof ConsumerController.RegisterToProducerController) {
                ConsumerController.RegisterToProducerController reg = (ConsumerController.RegisterToProducerController)internalCommand;
                return this.receiveRegisterToProducerController(s2, reg, (Function1<State, Behavior> & Serializable)newState -> this.org$apache$pekko$actor$typed$delivery$internal$ConsumerControllerImpl$$active((State<A>)newState));
            }
            if (internalCommand instanceof ConsumerController.DeliverThenStop) {
                return this.receiveDeliverThenStop(s2, (Function1<State, Behavior> & Serializable)newState -> this.resending((State<A>)newState));
            }
            if (internalCommand instanceof UnsealedInternalCommand) {
                return Behaviors$.MODULE$.unhandled();
            }
            throw new MatchError(internalCommand);
        }).receiveSignal((PartialFunction<Tuple2<ActorContext<InternalCommand>, Signal>, Behavior<InternalCommand>>)((Object)new Serializable(s2, this){
            private final State s$6;
            private final /* synthetic */ ConsumerControllerImpl $outer;
            {
                this.s$6 = s$12;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                return tuple2 != null && PostStop$.MODULE$.equals(tuple2._2());
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null && PostStop$.MODULE$.equals(tuple2._2())) {
                    return this.$outer.org$apache$pekko$actor$typed$delivery$internal$ConsumerControllerImpl$$postStop(this.s$6);
                }
                return function1.apply(x);
            }
        }));
    }

    private Behavior<InternalCommand> deliver(State<A> s2, ConsumerController.SequencedMessage<A> seqMsg) {
        long l;
        if (seqMsg.isLastChunk()) {
            ConsumerController.SequencedMessage<A> assembledSeqMsg = seqMsg.message() instanceof ChunkedMessage ? this.assembleChunks(ConsumerControllerImpl.previouslyCollectedChunks$1(seqMsg, s2).$colon$colon(seqMsg)) : seqMsg;
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(s2.consumer());
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ConsumerController$Delivery$.MODULE$.apply(assembledSeqMsg.message(), this.context.self(), seqMsg.producerId(), seqMsg.seqNr()));
            return this.waitingForConfirmation(s2.clearCollectedChunks(), assembledSeqMsg);
        }
        if (s2.requestedSeqNr() - seqMsg.seqNr() == (long)(this.settings.flowControlWindow() / 2)) {
            long newRequestedSeqNr = s2.requestedSeqNr() + (long)(this.settings.flowControlWindow() / 2);
            this.flightRecorder.consumerSentRequest(seqMsg.producerId(), newRequestedSeqNr);
            package$LoggerOps$.MODULE$.debugN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Sending Request when collecting chunks seqNr [{}], confirmedSeqNr [{}], requestUpToSeqNr [{}].", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(seqMsg.seqNr()), BoxesRunTime.boxToLong(s2.confirmedSeqNr()), BoxesRunTime.boxToLong(newRequestedSeqNr)}));
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(s2.producerController());
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerControllerImpl$Request$.MODULE$.apply(s2.confirmedSeqNr(), newRequestedSeqNr, this.resendLost(), false));
            this.retryTimer.start();
            l = newRequestedSeqNr;
        } else {
            l = s2.requestedSeqNr();
        }
        long newRequestedSeqNr = l;
        List<ConsumerController.SequencedMessage<A>> list = ConsumerControllerImpl.previouslyCollectedChunks$1(seqMsg, s2).$colon$colon(seqMsg);
        ActorRef<ProducerControllerImpl.InternalCommand> actorRef = s2.copy$default$1();
        String string2 = s2.copy$default$2();
        ActorRef<ConsumerController.Delivery<A>> actorRef2 = s2.copy$default$3();
        long l2 = s2.copy$default$4();
        long l3 = s2.copy$default$5();
        Option<ActorRef<ProducerController.Command<A>>> option = s2.copy$default$8();
        boolean bl = s2.copy$default$9();
        return this.stashBuffer.unstash(this.org$apache$pekko$actor$typed$delivery$internal$ConsumerControllerImpl$$active(s2.copy(actorRef, string2, actorRef2, l2, l3, newRequestedSeqNr, list, option, bl)), 1, ConstantFun$.MODULE$.scalaIdentityFunction());
    }

    private ConsumerController.SequencedMessage<A> assembleChunks(List<ConsumerController.SequencedMessage<A>> collectedChunks) {
        Object reverseCollectedChunks = collectedChunks.reverse();
        ByteStringBuilder builder = ByteString$.MODULE$.createBuilder();
        ((List)reverseCollectedChunks).foreach((Function1<ConsumerController.SequencedMessage, ByteStringBuilder> & Serializable)seqMsg -> builder.$plus$plus$eq(((ChunkedMessage)seqMsg.message()).serialized()));
        byte[] bytes = builder.result().toArrayUnsafe();
        ConsumerController.SequencedMessage head = (ConsumerController.SequencedMessage)collectedChunks.head();
        ChunkedMessage headMessage = (ChunkedMessage)head.message();
        Object message = this.serialization().deserialize(bytes, headMessage.serializerId(), headMessage.manifest()).get();
        return ConsumerController$SequencedMessage$.MODULE$.apply(head.producerId(), head.seqNr(), message, ((ConsumerController.SequencedMessage)((AbstractIterable)reverseCollectedChunks).head()).first(), head.ack(), head.producerController());
    }

    private Behavior<InternalCommand> waitingForConfirmation(State<A> s2, ConsumerController.SequencedMessage<A> seqMsg) {
        return Behaviors$.MODULE$.receiveMessage((Function1<InternalCommand, Behavior> & Serializable)x$1 -> {
            InternalCommand internalCommand = x$1;
            if (ConsumerController$Confirmed$.MODULE$.equals(internalCommand)) {
                long l;
                long seqNr = seqMsg.seqNr();
                if (this.traceEnabled) {
                    this.context.log().trace("Received Confirmed seqNr [{}] from consumer, stashed size [{}].", (Object)BoxesRunTime.boxToLong(seqNr), (Object)BoxesRunTime.boxToInteger(this.stashBuffer.size()));
                }
                if (seqMsg.first()) {
                    long newRequestedSeqNr = seqNr - 1L + (long)this.settings.flowControlWindow();
                    this.flightRecorder.consumerSentRequest(seqMsg.producerId(), newRequestedSeqNr);
                    this.context.log().debug("Sending Request after first with confirmedSeqNr [{}], requestUpToSeqNr [{}].", (Object)BoxesRunTime.boxToLong(seqNr), (Object)BoxesRunTime.boxToLong(newRequestedSeqNr));
                    ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(s2.producerController());
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerControllerImpl$Request$.MODULE$.apply(seqNr, newRequestedSeqNr, this.resendLost(), false));
                    l = newRequestedSeqNr;
                } else if (s2.requestedSeqNr() - seqNr == (long)(this.settings.flowControlWindow() / 2)) {
                    long newRequestedSeqNr = s2.requestedSeqNr() + (long)(this.settings.flowControlWindow() / 2);
                    this.flightRecorder.consumerSentRequest(seqMsg.producerId(), newRequestedSeqNr);
                    this.context.log().debug("Sending Request with confirmedSeqNr [{}], requestUpToSeqNr [{}].", (Object)BoxesRunTime.boxToLong(seqNr), (Object)BoxesRunTime.boxToLong(newRequestedSeqNr));
                    ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(s2.producerController());
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerControllerImpl$Request$.MODULE$.apply(seqNr, newRequestedSeqNr, this.resendLost(), false));
                    this.retryTimer.start();
                    l = newRequestedSeqNr;
                } else {
                    if (seqMsg.ack()) {
                        if (this.traceEnabled) {
                            this.context.log().trace("Sending Ack seqNr [{}].", (Object)BoxesRunTime.boxToLong(seqNr));
                        }
                        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(s2.producerController());
                        ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerControllerImpl$Ack$.MODULE$.apply(seqNr));
                    }
                    l = s2.requestedSeqNr();
                }
                long newRequestedSeqNr = l;
                if (!s2.stopping()) return this.stashBuffer.unstash(this.org$apache$pekko$actor$typed$delivery$internal$ConsumerControllerImpl$$active(s2.copy(s2.copy$default$1(), s2.copy$default$2(), s2.copy$default$3(), s2.copy$default$4(), seqNr, newRequestedSeqNr, s2.copy$default$7(), s2.copy$default$8(), s2.copy$default$9())), 1, ConstantFun$.MODULE$.scalaIdentityFunction());
                if (!this.stashBuffer.isEmpty()) return this.stashBuffer.unstash(this.org$apache$pekko$actor$typed$delivery$internal$ConsumerControllerImpl$$active(s2.copy(s2.copy$default$1(), s2.copy$default$2(), s2.copy$default$3(), s2.copy$default$4(), seqNr, newRequestedSeqNr, s2.copy$default$7(), s2.copy$default$8(), s2.copy$default$9())), 1, ConstantFun$.MODULE$.scalaIdentityFunction());
                this.context.log().debug("Stopped at seqNr [{}], after delivery of buffered messages.", (Object)BoxesRunTime.boxToLong(seqNr));
                return Behaviors$.MODULE$.stopped(() -> {
                    ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(s2.producerController());
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerControllerImpl$Ack$.MODULE$.apply(seqNr));
                });
            }
            if (internalCommand instanceof ConsumerController.SequencedMessage) {
                Object object;
                ConsumerController.SequencedMessage msg = (ConsumerController.SequencedMessage)internalCommand;
                this.flightRecorder.consumerReceivedPreviousInProgress(msg.producerId(), msg.seqNr(), this.stashBuffer.size() + 1);
                long expectedSeqNr = seqMsg.seqNr() + (long)this.stashBuffer.size() + 1L;
                if (msg.seqNr() < expectedSeqNr) {
                    ActorRef<ProducerControllerImpl.InternalCommand> actorRef = msg.producerController();
                    ActorRef<ProducerControllerImpl.InternalCommand> actorRef2 = seqMsg.producerController();
                    if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
                        this.flightRecorder.consumerDuplicate(msg.producerId(), expectedSeqNr, msg.seqNr());
                        this.context.log().debug("Received duplicate SequencedMessage seqNr [{}].", (Object)BoxesRunTime.boxToLong(msg.seqNr()));
                        object = BoxedUnit.UNIT;
                        return Behaviors$.MODULE$.same();
                    }
                }
                if (this.stashBuffer.isFull()) {
                    this.flightRecorder.consumerStashFull(msg.producerId(), msg.seqNr());
                    this.context.log().debug("Received SequencedMessage seqNr [{}], discarding message because stash is full.", (Object)BoxesRunTime.boxToLong(msg.seqNr()));
                    object = BoxedUnit.UNIT;
                    return Behaviors$.MODULE$.same();
                }
                if (this.traceEnabled) {
                    package$LoggerOps$.MODULE$.traceN$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Received SequencedMessage seqNr [{}], stashing while waiting for consumer to confirm [{}], stashed size [{}].", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(msg.seqNr()), BoxesRunTime.boxToLong(seqMsg.seqNr()), BoxesRunTime.boxToInteger(this.stashBuffer.size() + 1)}));
                }
                object = this.stashBuffer.stash(msg);
                return Behaviors$.MODULE$.same();
            }
            if (ConsumerControllerImpl$Retry$.MODULE$.equals(internalCommand)) {
                return Behaviors$.MODULE$.same();
            }
            if (internalCommand instanceof ConsumerController.Start) {
                ConsumerController.Start start = (ConsumerController.Start)internalCommand;
                ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(start.deliverTo());
                ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ConsumerController$Delivery$.MODULE$.apply(seqMsg.message(), this.context.self(), seqMsg.producerId(), seqMsg.seqNr()));
                return this.receiveStart(s2, start, (Function1<State, Behavior> & Serializable)newState -> this.waitingForConfirmation((State<A>)newState, seqMsg));
            }
            if (internalCommand instanceof ConsumerTerminated) {
                ActorRef<?> actorRef;
                ConsumerTerminated consumerTerminated = ConsumerControllerImpl$ConsumerTerminated$.MODULE$.unapply((ConsumerTerminated)internalCommand);
                ActorRef<?> c = actorRef = consumerTerminated._1();
                return this.receiveConsumerTerminated(c);
            }
            if (internalCommand instanceof ConsumerController.RegisterToProducerController) {
                ConsumerController.RegisterToProducerController reg = (ConsumerController.RegisterToProducerController)internalCommand;
                return this.receiveRegisterToProducerController(s2, reg, (Function1<State, Behavior> & Serializable)newState -> this.waitingForConfirmation((State<A>)newState, seqMsg));
            }
            if (internalCommand instanceof ConsumerController.DeliverThenStop) {
                return this.receiveDeliverThenStop(s2, (Function1<State, Behavior> & Serializable)newState -> this.waitingForConfirmation((State<A>)newState, seqMsg));
            }
            if (!(internalCommand instanceof UnsealedInternalCommand)) throw new MatchError(internalCommand);
            return Behaviors$.MODULE$.unhandled();
        }).receiveSignal((PartialFunction<Tuple2<ActorContext<InternalCommand>, Signal>, Behavior<InternalCommand>>)((Object)new Serializable(s2, this){
            private final State s$10;
            private final /* synthetic */ ConsumerControllerImpl $outer;
            {
                this.s$10 = s$13;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                return tuple2 != null && PostStop$.MODULE$.equals(tuple2._2());
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null && PostStop$.MODULE$.equals(tuple2._2())) {
                    return this.$outer.org$apache$pekko$actor$typed$delivery$internal$ConsumerControllerImpl$$postStop(this.s$10);
                }
                return function1.apply(x);
            }
        }));
    }

    private Behavior<InternalCommand> receiveRetry(State<A> s2, Function0<Behavior<InternalCommand>> nextBehavior) {
        Option<ActorRef<ProducerController.Command<A>>> option;
        this.retryTimer.scheduleNext();
        FiniteDuration finiteDuration = this.retryTimer.interval();
        FiniteDuration finiteDuration2 = this.retryTimer.minBackoff();
        if (finiteDuration == null ? finiteDuration2 != null : !((Object)finiteDuration).equals(finiteDuration2)) {
            this.context.log().debug("Schedule next retry in [{} ms]", (Object)BoxesRunTime.boxToLong(this.retryTimer.interval().toMillis()));
        }
        if (None$.MODULE$.equals(option = s2.registering())) {
            return nextBehavior.apply();
        }
        if (option instanceof Some) {
            ActorRef reg = (ActorRef)((Some)option).value();
            ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(reg);
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerController$RegisterConsumer$.MODULE$.apply(this.context.self()));
            return Behaviors$.MODULE$.same();
        }
        throw new MatchError(option);
    }

    private Behavior<InternalCommand> receiveStart(State<A> s2, ConsumerController.Start<A> start, Function1<State<A>, Behavior<InternalCommand>> nextBehavior) {
        ConsumerControllerImpl$.MODULE$.enforceLocalConsumer(start.deliverTo());
        ActorRef<ConsumerController.Delivery<A>> actorRef = start.deliverTo();
        ActorRef<ConsumerController.Delivery<A>> actorRef2 = s2.consumer();
        if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
            return nextBehavior.apply(s2);
        }
        this.context.unwatch(s2.consumer());
        this.context.watchWith(start.deliverTo(), ConsumerControllerImpl$ConsumerTerminated$.MODULE$.apply(start.deliverTo()));
        return nextBehavior.apply(s2.copy(s2.copy$default$1(), s2.copy$default$2(), start.deliverTo(), s2.copy$default$4(), s2.copy$default$5(), s2.copy$default$6(), s2.copy$default$7(), s2.copy$default$8(), s2.copy$default$9()));
    }

    private Behavior<InternalCommand> receiveRegisterToProducerController(State<A> s2, ConsumerController.RegisterToProducerController<A> reg, Function1<State<A>, Behavior<InternalCommand>> nextBehavior) {
        ActorRef<ProducerController.Command<A>> actorRef = reg.producerController();
        ActorRef<ProducerControllerImpl.InternalCommand> actorRef2 = s2.producerController();
        if (actorRef == null ? actorRef2 != null : !actorRef.equals(actorRef2)) {
            package$LoggerOps$.MODULE$.debug2$extension(org.apache.pekko.actor.typed.scaladsl.package$.MODULE$.LoggerOps(this.context.log()), "Register to new ProducerController [{}], previous was [{}].", reg.producerController(), s2.producerController());
            this.retryTimer.start();
            ActorRef actorRef3 = ActorRef$.MODULE$.ActorRefOps(reg.producerController());
            ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef3, ProducerController$RegisterConsumer$.MODULE$.apply(this.context.self()));
            Some<ActorRef<ProducerController.Command<A>>> some = Some$.MODULE$.apply(reg.producerController());
            ActorRef<ProducerControllerImpl.InternalCommand> actorRef4 = s2.copy$default$1();
            String string2 = s2.copy$default$2();
            ActorRef<ConsumerController.Delivery<A>> actorRef5 = s2.copy$default$3();
            long l = s2.copy$default$4();
            long l2 = s2.copy$default$5();
            long l3 = s2.copy$default$6();
            List<ConsumerController.SequencedMessage<A>> list = s2.copy$default$7();
            boolean bl = s2.copy$default$9();
            return nextBehavior.apply(s2.copy(actorRef4, string2, actorRef5, l, l2, l3, list, some, bl));
        }
        return Behaviors$.MODULE$.same();
    }

    private Behavior<InternalCommand> receiveDeliverThenStop(State<A> s2, Function1<State<A>, Behavior<InternalCommand>> nextBehavior) {
        if (this.stashBuffer.isEmpty() && s2.receivedSeqNr() == s2.confirmedSeqNr()) {
            this.context.log().debug("Stopped at seqNr [{}], no buffered messages.", (Object)BoxesRunTime.boxToLong(s2.confirmedSeqNr()));
            return Behaviors$.MODULE$.stopped();
        }
        return nextBehavior.apply(s2.copy(s2.copy$default$1(), s2.copy$default$2(), s2.copy$default$3(), s2.copy$default$4(), s2.copy$default$5(), s2.copy$default$6(), s2.copy$default$7(), s2.copy$default$8(), true));
    }

    private Behavior<InternalCommand> receiveConsumerTerminated(ActorRef<?> c) {
        this.context.log().debug("Consumer [{}] terminated.", (Object)c);
        return Behaviors$.MODULE$.stopped();
    }

    private Behavior<InternalCommand> receiveUnexpectedConfirmed() {
        this.context.log().warn("Received unexpected Confirmed from consumer.");
        return Behaviors$.MODULE$.unhandled();
    }

    private State<A> retryRequest(State<A> s2) {
        ActorRef<ProducerControllerImpl.InternalCommand> actorRef = s2.producerController();
        ActorRef actorRef2 = this.context.system().deadLetters();
        if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
            return s2;
        }
        long newRequestedSeqNr = this.resendLost() ? s2.requestedSeqNr() : s2.receivedSeqNr() + (long)(this.settings.flowControlWindow() / 2);
        this.flightRecorder.consumerSentRequest(s2.producerId(), newRequestedSeqNr);
        this.context.log().debug("Retry sending Request with confirmedSeqNr [{}], requestUpToSeqNr [{}].", (Object)BoxesRunTime.boxToLong(s2.confirmedSeqNr()), (Object)BoxesRunTime.boxToLong(newRequestedSeqNr));
        ActorRef actorRef3 = ActorRef$.MODULE$.ActorRefOps(s2.producerController());
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef3, ProducerControllerImpl$Request$.MODULE$.apply(s2.confirmedSeqNr(), newRequestedSeqNr, this.resendLost(), true));
        return s2.copy(s2.copy$default$1(), s2.copy$default$2(), s2.copy$default$3(), s2.copy$default$4(), s2.copy$default$5(), newRequestedSeqNr, s2.copy$default$7(), s2.copy$default$8(), s2.copy$default$9());
    }

    public Behavior<InternalCommand> org$apache$pekko$actor$typed$delivery$internal$ConsumerControllerImpl$$postStop(State<A> s2) {
        ActorRef actorRef = ActorRef$.MODULE$.ActorRefOps(s2.producerController());
        ActorRef$ActorRefOps$.MODULE$.$bang$extension(actorRef, ProducerControllerImpl$Ack$.MODULE$.apply(s2.confirmedSeqNr()));
        return Behaviors$.MODULE$.same();
    }

    private static final List previouslyCollectedChunks$1(ConsumerController.SequencedMessage seqMsg$1, State s$7) {
        if (seqMsg$1.isFirstChunk()) {
            return package$.MODULE$.Nil();
        }
        return s$7.collectedChunks();
    }

    public static final class ConsumerTerminated
    implements InternalCommand,
    Product,
    Serializable {
        private final ActorRef consumer;

        public static ConsumerTerminated apply(ActorRef<?> actorRef) {
            return ConsumerControllerImpl$ConsumerTerminated$.MODULE$.apply(actorRef);
        }

        public static ConsumerTerminated fromProduct(Product product) {
            return ConsumerControllerImpl$ConsumerTerminated$.MODULE$.fromProduct(product);
        }

        public static ConsumerTerminated unapply(ConsumerTerminated consumerTerminated) {
            return ConsumerControllerImpl$ConsumerTerminated$.MODULE$.unapply(consumerTerminated);
        }

        public ConsumerTerminated(ActorRef<?> consumer) {
            this.consumer = consumer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ConsumerTerminated)) return false;
            ConsumerTerminated consumerTerminated = (ConsumerTerminated)object;
            ActorRef<?> actorRef = this.consumer();
            ActorRef<?> actorRef2 = consumerTerminated.consumer();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof ConsumerTerminated;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "ConsumerTerminated";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "consumer";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<?> consumer() {
            return this.consumer;
        }

        public ConsumerTerminated copy(ActorRef<?> consumer) {
            return new ConsumerTerminated(consumer);
        }

        public ActorRef<?> copy$default$1() {
            return this.consumer();
        }

        public ActorRef<?> _1() {
            return this.consumer();
        }
    }

    public static interface InternalCommand {
    }

    public static class RetryTimer {
        private final TimerScheduler<InternalCommand> timers;
        private final FiniteDuration minBackoff;
        private final FiniteDuration maxBackoff;
        private FiniteDuration _interval;

        public RetryTimer(TimerScheduler<InternalCommand> timers, FiniteDuration minBackoff, FiniteDuration maxBackoff) {
            this.timers = timers;
            this.minBackoff = minBackoff;
            this.maxBackoff = maxBackoff;
            this._interval = minBackoff;
        }

        public FiniteDuration minBackoff() {
            return this.minBackoff;
        }

        public FiniteDuration interval() {
            return this._interval;
        }

        public void start() {
            this._interval = this.minBackoff();
            this.timers.startTimerWithFixedDelay(ConsumerControllerImpl$Retry$.MODULE$, this._interval);
        }

        public void scheduleNext() {
            FiniteDuration f;
            Duration duration;
            FiniteDuration newInterval;
            FiniteDuration finiteDuration = newInterval = this._interval == this.maxBackoff ? this.maxBackoff : ((duration = this.maxBackoff.min(this._interval.$times(1.5))) instanceof FiniteDuration ? (f = (FiniteDuration)duration) : this.maxBackoff);
            FiniteDuration finiteDuration2 = this._interval;
            if (finiteDuration == null ? finiteDuration2 != null : !((Object)finiteDuration).equals(finiteDuration2)) {
                this._interval = newInterval;
                this.timers.startTimerWithFixedDelay(ConsumerControllerImpl$Retry$.MODULE$, this._interval);
                return;
            }
        }

        public void reset() {
            if (this._interval != this.minBackoff()) {
                this.start();
                return;
            }
        }
    }

    public static final class State<A>
    implements Product,
    Serializable {
        private final ActorRef producerController;
        private final String producerId;
        private final ActorRef consumer;
        private final long receivedSeqNr;
        private final long confirmedSeqNr;
        private final long requestedSeqNr;
        private final List collectedChunks;
        private final Option registering;
        private final boolean stopping;

        public static <A> State<A> apply(ActorRef<ProducerControllerImpl.InternalCommand> actorRef, String string2, ActorRef<ConsumerController.Delivery<A>> actorRef2, long l, long l2, long l3, List<ConsumerController.SequencedMessage<A>> list, Option<ActorRef<ProducerController.Command<A>>> option, boolean bl) {
            return ConsumerControllerImpl$State$.MODULE$.apply(actorRef, string2, actorRef2, l, l2, l3, list, option, bl);
        }

        public static State<?> fromProduct(Product product) {
            return ConsumerControllerImpl$State$.MODULE$.fromProduct(product);
        }

        public static <A> State<A> unapply(State<A> state) {
            return ConsumerControllerImpl$State$.MODULE$.unapply(state);
        }

        public State(ActorRef<ProducerControllerImpl.InternalCommand> producerController, String producerId, ActorRef<ConsumerController.Delivery<A>> consumer, long receivedSeqNr, long confirmedSeqNr, long requestedSeqNr, List<ConsumerController.SequencedMessage<A>> collectedChunks, Option<ActorRef<ProducerController.Command<A>>> registering, boolean stopping) {
            this.producerController = producerController;
            this.producerId = producerId;
            this.consumer = consumer;
            this.receivedSeqNr = receivedSeqNr;
            this.confirmedSeqNr = confirmedSeqNr;
            this.requestedSeqNr = requestedSeqNr;
            this.collectedChunks = collectedChunks;
            this.registering = registering;
            this.stopping = stopping;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.producerController()));
            n = Statics.mix(n, Statics.anyHash(this.producerId()));
            n = Statics.mix(n, Statics.anyHash(this.consumer()));
            n = Statics.mix(n, Statics.longHash(this.receivedSeqNr()));
            n = Statics.mix(n, Statics.longHash(this.confirmedSeqNr()));
            n = Statics.mix(n, Statics.longHash(this.requestedSeqNr()));
            n = Statics.mix(n, Statics.anyHash(this.collectedChunks()));
            n = Statics.mix(n, Statics.anyHash(this.registering()));
            n = Statics.mix(n, this.stopping() ? 1231 : 1237);
            return Statics.finalizeHash(n, 9);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.stopping() != state.stopping()) return false;
            ActorRef<ProducerControllerImpl.InternalCommand> actorRef = this.producerController();
            ActorRef<ProducerControllerImpl.InternalCommand> actorRef2 = state.producerController();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            String string2 = this.producerId();
            String string3 = state.producerId();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            ActorRef<ConsumerController.Delivery<A>> actorRef3 = this.consumer();
            ActorRef<ConsumerController.Delivery<A>> actorRef4 = state.consumer();
            if (actorRef3 == null) {
                if (actorRef4 != null) {
                    return false;
                }
            } else if (!actorRef3.equals(actorRef4)) return false;
            if (this.receivedSeqNr() != state.receivedSeqNr()) return false;
            if (this.confirmedSeqNr() != state.confirmedSeqNr()) return false;
            if (this.requestedSeqNr() != state.requestedSeqNr()) return false;
            List<ConsumerController.SequencedMessage<A>> list = this.collectedChunks();
            List<ConsumerController.SequencedMessage<A>> list2 = state.collectedChunks();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!((Object)list).equals(list2)) return false;
            Option<ActorRef<ProducerController.Command<A>>> option = this.registering();
            Option<ActorRef<ProducerController.Command<A>>> option2 = state.registering();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        @Override
        public int productArity() {
            return 9;
        }

        @Override
        public String productPrefix() {
            return "State";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToLong(this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToLong(this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToLong(this._6());
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return this._8();
                }
                case 8: {
                    return BoxesRunTime.boxToBoolean(this._9());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "producerController";
                }
                case 1: {
                    return "producerId";
                }
                case 2: {
                    return "consumer";
                }
                case 3: {
                    return "receivedSeqNr";
                }
                case 4: {
                    return "confirmedSeqNr";
                }
                case 5: {
                    return "requestedSeqNr";
                }
                case 6: {
                    return "collectedChunks";
                }
                case 7: {
                    return "registering";
                }
                case 8: {
                    return "stopping";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<ProducerControllerImpl.InternalCommand> producerController() {
            return this.producerController;
        }

        public String producerId() {
            return this.producerId;
        }

        public ActorRef<ConsumerController.Delivery<A>> consumer() {
            return this.consumer;
        }

        public long receivedSeqNr() {
            return this.receivedSeqNr;
        }

        public long confirmedSeqNr() {
            return this.confirmedSeqNr;
        }

        public long requestedSeqNr() {
            return this.requestedSeqNr;
        }

        public List<ConsumerController.SequencedMessage<A>> collectedChunks() {
            return this.collectedChunks;
        }

        public Option<ActorRef<ProducerController.Command<A>>> registering() {
            return this.registering;
        }

        public boolean stopping() {
            return this.stopping;
        }

        public boolean isNextExpected(ConsumerController.SequencedMessage<A> seqMsg) {
            return seqMsg.seqNr() == this.receivedSeqNr() + 1L;
        }

        public boolean isProducerChanged(ConsumerController.SequencedMessage<A> seqMsg) {
            ActorRef<ProducerControllerImpl.InternalCommand> actorRef = seqMsg.producerController();
            ActorRef<ProducerControllerImpl.InternalCommand> actorRef2 = this.producerController();
            return (actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null) || this.receivedSeqNr() == 0L;
        }

        public Option<ActorRef<ProducerController.Command<A>>> updatedRegistering(ConsumerController.SequencedMessage<A> seqMsg) {
            Option<ActorRef<ProducerController.Command<A>>> option = this.registering();
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            if (option instanceof Some) {
                Some some = (Some)option;
                ActorRef reg = (ActorRef)some.value();
                Some s2 = some;
                ActorRef<ProducerControllerImpl.InternalCommand> actorRef = seqMsg.producerController();
                ActorRef actorRef2 = reg;
                if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
                    return None$.MODULE$;
                }
                return s2;
            }
            throw new MatchError(option);
        }

        public State<A> clearCollectedChunks() {
            List<ConsumerController.SequencedMessage<A>> list = this.collectedChunks();
            Nil$ nil$ = package$.MODULE$.Nil();
            if (!(list != null ? !((Object)list).equals(nil$) : nil$ != null)) {
                return this;
            }
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), package$.MODULE$.Nil(), this.copy$default$8(), this.copy$default$9());
        }

        public <A> State<A> copy(ActorRef<ProducerControllerImpl.InternalCommand> producerController, String producerId, ActorRef<ConsumerController.Delivery<A>> consumer, long receivedSeqNr, long confirmedSeqNr, long requestedSeqNr, List<ConsumerController.SequencedMessage<A>> collectedChunks, Option<ActorRef<ProducerController.Command<A>>> registering, boolean stopping) {
            return new State<A>(producerController, producerId, consumer, receivedSeqNr, confirmedSeqNr, requestedSeqNr, collectedChunks, registering, stopping);
        }

        public <A> ActorRef<ProducerControllerImpl.InternalCommand> copy$default$1() {
            return this.producerController();
        }

        public <A> String copy$default$2() {
            return this.producerId();
        }

        public <A> ActorRef<ConsumerController.Delivery<A>> copy$default$3() {
            return this.consumer();
        }

        public long copy$default$4() {
            return this.receivedSeqNr();
        }

        public long copy$default$5() {
            return this.confirmedSeqNr();
        }

        public long copy$default$6() {
            return this.requestedSeqNr();
        }

        public <A> List<ConsumerController.SequencedMessage<A>> copy$default$7() {
            return this.collectedChunks();
        }

        public <A> Option<ActorRef<ProducerController.Command<A>>> copy$default$8() {
            return this.registering();
        }

        public boolean copy$default$9() {
            return this.stopping();
        }

        public ActorRef<ProducerControllerImpl.InternalCommand> _1() {
            return this.producerController();
        }

        public String _2() {
            return this.producerId();
        }

        public ActorRef<ConsumerController.Delivery<A>> _3() {
            return this.consumer();
        }

        public long _4() {
            return this.receivedSeqNr();
        }

        public long _5() {
            return this.confirmedSeqNr();
        }

        public long _6() {
            return this.requestedSeqNr();
        }

        public List<ConsumerController.SequencedMessage<A>> _7() {
            return this.collectedChunks();
        }

        public Option<ActorRef<ProducerController.Command<A>>> _8() {
            return this.registering();
        }

        public boolean _9() {
            return this.stopping();
        }
    }

    public static interface UnsealedInternalCommand
    extends InternalCommand {
    }
}

