/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.delivery;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.util.Optional;
import org.apache.pekko.Done;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.delivery.ConsumerController;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue;
import org.apache.pekko.actor.typed.delivery.ProducerController;
import org.apache.pekko.actor.typed.delivery.WorkPullingProducerController$;
import org.apache.pekko.actor.typed.delivery.WorkPullingProducerController$GetWorkerStats$;
import org.apache.pekko.actor.typed.delivery.WorkPullingProducerController$MessageWithConfirmation$;
import org.apache.pekko.actor.typed.delivery.WorkPullingProducerController$RequestNext$;
import org.apache.pekko.actor.typed.delivery.WorkPullingProducerController$Settings$;
import org.apache.pekko.actor.typed.delivery.WorkPullingProducerController$Start$;
import org.apache.pekko.actor.typed.delivery.WorkPullingProducerController$WorkerStats$;
import org.apache.pekko.actor.typed.delivery.internal.WorkPullingProducerControllerImpl;
import org.apache.pekko.actor.typed.receptionist.ServiceKey;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import scala.Option;
import scala.Product;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ApiMayChange
public final class WorkPullingProducerController {
    public static <A> Behavior<Command<A>> apply(Class<A> clazz, String string2, ServiceKey<ConsumerController.Command<A>> serviceKey, Optional<Behavior<DurableProducerQueue.Command<A>>> optional, Settings settings) {
        return WorkPullingProducerController$.MODULE$.apply(clazz, string2, serviceKey, optional, settings);
    }

    public static <A> Behavior<Command<A>> apply(String string2, ServiceKey<ConsumerController.Command<A>> serviceKey, Option<Behavior<DurableProducerQueue.Command<A>>> option, ClassTag<A> classTag) {
        return WorkPullingProducerController$.MODULE$.apply(string2, serviceKey, option, classTag);
    }

    public static <A> Behavior<Command<A>> apply(String string2, ServiceKey<ConsumerController.Command<A>> serviceKey, Option<Behavior<DurableProducerQueue.Command<A>>> option, Settings settings, ClassTag<A> classTag) {
        return WorkPullingProducerController$.MODULE$.apply(string2, serviceKey, option, settings, classTag);
    }

    public static <A> Behavior<Command<A>> create(Class<A> clazz, String string2, ServiceKey<ConsumerController.Command<A>> serviceKey, Optional<Behavior<DurableProducerQueue.Command<A>>> optional) {
        return WorkPullingProducerController$.MODULE$.create(clazz, string2, serviceKey, optional);
    }

    public static <A> Class<RequestNext<A>> requestNextClass() {
        return WorkPullingProducerController$.MODULE$.requestNextClass();
    }

    public static interface Command<A>
    extends WorkPullingProducerControllerImpl.UnsealedInternalCommand {
    }

    public static final class GetWorkerStats<A>
    implements Command<A>,
    Product,
    Serializable {
        private final ActorRef replyTo;

        public static <A> GetWorkerStats<A> apply(ActorRef<WorkerStats> actorRef) {
            return WorkPullingProducerController$GetWorkerStats$.MODULE$.apply(actorRef);
        }

        public static GetWorkerStats<?> fromProduct(Product product) {
            return WorkPullingProducerController$GetWorkerStats$.MODULE$.fromProduct(product);
        }

        public static <A> GetWorkerStats<A> unapply(GetWorkerStats<A> getWorkerStats) {
            return WorkPullingProducerController$GetWorkerStats$.MODULE$.unapply(getWorkerStats);
        }

        public GetWorkerStats(ActorRef<WorkerStats> replyTo) {
            this.replyTo = replyTo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof GetWorkerStats)) return false;
            GetWorkerStats getWorkerStats = (GetWorkerStats)object;
            ActorRef<WorkerStats> actorRef = this.replyTo();
            ActorRef<WorkerStats> actorRef2 = getWorkerStats.replyTo();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof GetWorkerStats;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "GetWorkerStats";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "replyTo";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<WorkerStats> replyTo() {
            return this.replyTo;
        }

        public <A> GetWorkerStats<A> copy(ActorRef<WorkerStats> replyTo) {
            return new GetWorkerStats<A>(replyTo);
        }

        public <A> ActorRef<WorkerStats> copy$default$1() {
            return this.replyTo();
        }

        public ActorRef<WorkerStats> _1() {
            return this.replyTo();
        }
    }

    public static final class MessageWithConfirmation<A>
    implements WorkPullingProducerControllerImpl.UnsealedInternalCommand,
    Product,
    Serializable {
        private final Object message;
        private final ActorRef replyTo;

        public static <A> MessageWithConfirmation<A> apply(A a, ActorRef<Done> actorRef) {
            return WorkPullingProducerController$MessageWithConfirmation$.MODULE$.apply(a, actorRef);
        }

        public static MessageWithConfirmation<?> fromProduct(Product product) {
            return WorkPullingProducerController$MessageWithConfirmation$.MODULE$.fromProduct(product);
        }

        public static <A> MessageWithConfirmation<A> unapply(MessageWithConfirmation<A> messageWithConfirmation) {
            return WorkPullingProducerController$MessageWithConfirmation$.MODULE$.unapply(messageWithConfirmation);
        }

        public MessageWithConfirmation(A message, ActorRef<Done> replyTo) {
            this.message = message;
            this.replyTo = replyTo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MessageWithConfirmation)) return false;
            MessageWithConfirmation messageWithConfirmation = (MessageWithConfirmation)object;
            if (!BoxesRunTime.equals(this.message(), messageWithConfirmation.message())) return false;
            ActorRef<Done> actorRef = this.replyTo();
            ActorRef<Done> actorRef2 = messageWithConfirmation.replyTo();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof MessageWithConfirmation;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "MessageWithConfirmation";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "message";
            }
            if (1 == n2) {
                return "replyTo";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public A message() {
            return (A)this.message;
        }

        public ActorRef<Done> replyTo() {
            return this.replyTo;
        }

        public <A> MessageWithConfirmation<A> copy(A message, ActorRef<Done> replyTo) {
            return new MessageWithConfirmation<A>(message, replyTo);
        }

        public <A> A copy$default$1() {
            return this.message();
        }

        public <A> ActorRef<Done> copy$default$2() {
            return this.replyTo();
        }

        public A _1() {
            return this.message();
        }

        public ActorRef<Done> _2() {
            return this.replyTo();
        }
    }

    public static final class RequestNext<A>
    implements Product,
    Serializable {
        private final ActorRef sendNextTo;
        private final ActorRef askNextTo;

        public static <A> RequestNext<A> apply(ActorRef<A> actorRef, ActorRef<MessageWithConfirmation<A>> actorRef2) {
            return WorkPullingProducerController$RequestNext$.MODULE$.apply(actorRef, actorRef2);
        }

        public static RequestNext<?> fromProduct(Product product) {
            return WorkPullingProducerController$RequestNext$.MODULE$.fromProduct(product);
        }

        public static <A> RequestNext<A> unapply(RequestNext<A> requestNext) {
            return WorkPullingProducerController$RequestNext$.MODULE$.unapply(requestNext);
        }

        public RequestNext(ActorRef<A> sendNextTo, ActorRef<MessageWithConfirmation<A>> askNextTo) {
            this.sendNextTo = sendNextTo;
            this.askNextTo = askNextTo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RequestNext)) return false;
            RequestNext requestNext = (RequestNext)object;
            ActorRef<A> actorRef = this.sendNextTo();
            ActorRef<A> actorRef2 = requestNext.sendNextTo();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            ActorRef<MessageWithConfirmation<A>> actorRef3 = this.askNextTo();
            ActorRef<MessageWithConfirmation<A>> actorRef4 = requestNext.askNextTo();
            if (actorRef3 == null) {
                if (actorRef4 == null) return true;
                return false;
            } else {
                if (!actorRef3.equals(actorRef4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof RequestNext;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "RequestNext";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "sendNextTo";
            }
            if (1 == n2) {
                return "askNextTo";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<A> sendNextTo() {
            return this.sendNextTo;
        }

        public ActorRef<MessageWithConfirmation<A>> askNextTo() {
            return this.askNextTo;
        }

        public <A> RequestNext<A> copy(ActorRef<A> sendNextTo, ActorRef<MessageWithConfirmation<A>> askNextTo) {
            return new RequestNext<A>(sendNextTo, askNextTo);
        }

        public <A> ActorRef<A> copy$default$1() {
            return this.sendNextTo();
        }

        public <A> ActorRef<MessageWithConfirmation<A>> copy$default$2() {
            return this.askNextTo();
        }

        public ActorRef<A> _1() {
            return this.sendNextTo();
        }

        public ActorRef<MessageWithConfirmation<A>> _2() {
            return this.askNextTo();
        }
    }

    public static final class Settings {
        private final int bufferSize;
        private final FiniteDuration internalAskTimeout;
        private final ProducerController.Settings producerControllerSettings;

        public static Settings apply(ActorSystem<?> actorSystem) {
            return WorkPullingProducerController$Settings$.MODULE$.apply(actorSystem);
        }

        public static Settings apply(Config config) {
            return WorkPullingProducerController$Settings$.MODULE$.apply(config);
        }

        public static Settings create(ActorSystem<?> actorSystem) {
            return WorkPullingProducerController$Settings$.MODULE$.create(actorSystem);
        }

        public static Settings create(Config config) {
            return WorkPullingProducerController$Settings$.MODULE$.create(config);
        }

        public Settings(int bufferSize, FiniteDuration internalAskTimeout, ProducerController.Settings producerControllerSettings) {
            this.bufferSize = bufferSize;
            this.internalAskTimeout = internalAskTimeout;
            this.producerControllerSettings = producerControllerSettings;
            if (producerControllerSettings.chunkLargeMessagesBytes() > 0) {
                throw new IllegalArgumentException("Chunked messages not implemented for work-pulling yet.");
            }
        }

        public int bufferSize() {
            return this.bufferSize;
        }

        public FiniteDuration internalAskTimeout() {
            return this.internalAskTimeout;
        }

        public ProducerController.Settings producerControllerSettings() {
            return this.producerControllerSettings;
        }

        public Settings withBufferSize(int newBufferSize) {
            return this.copy(newBufferSize, this.copy$default$2(), this.copy$default$3());
        }

        public Settings withInternalAskTimeout(FiniteDuration newInternalAskTimeout) {
            return this.copy(this.copy$default$1(), newInternalAskTimeout, this.copy$default$3());
        }

        public Settings withInternalAskTimeout(Duration newInternalAskTimeout) {
            FiniteDuration finiteDuration = JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(newInternalAskTimeout));
            int n = this.copy$default$1();
            ProducerController.Settings settings = this.copy$default$3();
            return this.copy(n, finiteDuration, settings);
        }

        public Settings withProducerControllerSettings(ProducerController.Settings newProducerControllerSettings) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), newProducerControllerSettings);
        }

        private Settings copy(int bufferSize, FiniteDuration internalAskTimeout, ProducerController.Settings producerControllerSettings) {
            return new Settings(bufferSize, internalAskTimeout, producerControllerSettings);
        }

        private int copy$default$1() {
            return this.bufferSize();
        }

        private FiniteDuration copy$default$2() {
            return this.internalAskTimeout();
        }

        private ProducerController.Settings copy$default$3() {
            return this.producerControllerSettings();
        }

        public String toString() {
            return new StringBuilder(12).append("Settings(").append(this.bufferSize()).append(",").append(this.internalAskTimeout()).append(",").append(this.producerControllerSettings()).append(")").toString();
        }
    }

    public static final class Start<A>
    implements Command<A>,
    Product,
    Serializable {
        private final ActorRef producer;

        public static <A> Start<A> apply(ActorRef<RequestNext<A>> actorRef) {
            return WorkPullingProducerController$Start$.MODULE$.apply(actorRef);
        }

        public static Start<?> fromProduct(Product product) {
            return WorkPullingProducerController$Start$.MODULE$.fromProduct(product);
        }

        public static <A> Start<A> unapply(Start<A> start) {
            return WorkPullingProducerController$Start$.MODULE$.unapply(start);
        }

        public Start(ActorRef<RequestNext<A>> producer) {
            this.producer = producer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Start)) return false;
            Start start = (Start)object;
            ActorRef<RequestNext<A>> actorRef = this.producer();
            ActorRef<RequestNext<A>> actorRef2 = start.producer();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Start;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Start";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "producer";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<RequestNext<A>> producer() {
            return this.producer;
        }

        public <A> Start<A> copy(ActorRef<RequestNext<A>> producer) {
            return new Start<A>(producer);
        }

        public <A> ActorRef<RequestNext<A>> copy$default$1() {
            return this.producer();
        }

        public ActorRef<RequestNext<A>> _1() {
            return this.producer();
        }
    }

    public static final class WorkerStats
    implements Product,
    Serializable {
        private final int numberOfWorkers;

        public static WorkerStats apply(int n) {
            return WorkPullingProducerController$WorkerStats$.MODULE$.apply(n);
        }

        public static WorkerStats fromProduct(Product product) {
            return WorkPullingProducerController$WorkerStats$.MODULE$.fromProduct(product);
        }

        public static WorkerStats unapply(WorkerStats workerStats) {
            return WorkPullingProducerController$WorkerStats$.MODULE$.unapply(workerStats);
        }

        public WorkerStats(int numberOfWorkers) {
            this.numberOfWorkers = numberOfWorkers;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.numberOfWorkers());
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof WorkerStats)) return false;
            WorkerStats workerStats = (WorkerStats)object;
            if (this.numberOfWorkers() != workerStats.numberOfWorkers()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof WorkerStats;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "WorkerStats";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToInteger(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "numberOfWorkers";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public int numberOfWorkers() {
            return this.numberOfWorkers;
        }

        public WorkerStats copy(int numberOfWorkers) {
            return new WorkerStats(numberOfWorkers);
        }

        public int copy$default$1() {
            return this.numberOfWorkers();
        }

        public int _1() {
            return this.numberOfWorkers();
        }
    }
}

