/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.delivery;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import java.util.Optional;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.delivery.ConsumerController;
import org.apache.pekko.actor.typed.delivery.DurableProducerQueue;
import org.apache.pekko.actor.typed.delivery.ProducerController$;
import org.apache.pekko.actor.typed.delivery.ProducerController$MessageWithConfirmation$;
import org.apache.pekko.actor.typed.delivery.ProducerController$RegisterConsumer$;
import org.apache.pekko.actor.typed.delivery.ProducerController$RequestNext$;
import org.apache.pekko.actor.typed.delivery.ProducerController$Settings$;
import org.apache.pekko.actor.typed.delivery.ProducerController$Start$;
import org.apache.pekko.actor.typed.delivery.internal.DeliverySerializable;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import org.apache.pekko.util.JavaDurationConverters$ScalaDurationOps$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ApiMayChange
public final class ProducerController {
    public static <A> Behavior<Command<A>> apply(String string2, Option<Behavior<DurableProducerQueue.Command<A>>> option, ClassTag<A> classTag) {
        return ProducerController$.MODULE$.apply(string2, option, classTag);
    }

    public static <A> Behavior<Command<A>> apply(String string2, Option<Behavior<DurableProducerQueue.Command<A>>> option, Settings settings, ClassTag<A> classTag) {
        return ProducerController$.MODULE$.apply(string2, option, settings, classTag);
    }

    @InternalApi
    public static <A> Behavior<Command<A>> apply(String string2, Option<Behavior<DurableProducerQueue.Command<A>>> option, Settings settings, Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> function1, ClassTag<A> classTag) {
        return ProducerController$.MODULE$.apply(string2, option, settings, function1, classTag);
    }

    public static <A> Behavior<Command<A>> create(Class<A> clazz, String string2, Optional<Behavior<DurableProducerQueue.Command<A>>> optional) {
        return ProducerController$.MODULE$.create(clazz, string2, optional);
    }

    public static <A> Behavior<Command<A>> create(Class<A> clazz, String string2, Optional<Behavior<DurableProducerQueue.Command<A>>> optional, Settings settings) {
        return ProducerController$.MODULE$.create(clazz, string2, optional, settings);
    }

    public static <A> Class<RequestNext<A>> requestNextClass() {
        return ProducerController$.MODULE$.requestNextClass();
    }

    public static interface Command<A>
    extends ProducerControllerImpl.UnsealedInternalCommand {
    }

    public static final class MessageWithConfirmation<A>
    implements ProducerControllerImpl.UnsealedInternalCommand,
    Product,
    Serializable {
        private final Object message;
        private final ActorRef replyTo;

        public static <A> MessageWithConfirmation<A> apply(A a, ActorRef<Object> actorRef) {
            return ProducerController$MessageWithConfirmation$.MODULE$.apply(a, actorRef);
        }

        public static MessageWithConfirmation<?> fromProduct(Product product) {
            return ProducerController$MessageWithConfirmation$.MODULE$.fromProduct(product);
        }

        public static <A> MessageWithConfirmation<A> unapply(MessageWithConfirmation<A> messageWithConfirmation) {
            return ProducerController$MessageWithConfirmation$.MODULE$.unapply(messageWithConfirmation);
        }

        public MessageWithConfirmation(A message, ActorRef<Object> replyTo) {
            this.message = message;
            this.replyTo = replyTo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MessageWithConfirmation)) return false;
            MessageWithConfirmation messageWithConfirmation = (MessageWithConfirmation)object;
            if (!BoxesRunTime.equals(this.message(), messageWithConfirmation.message())) return false;
            ActorRef<Object> actorRef = this.replyTo();
            ActorRef<Object> actorRef2 = messageWithConfirmation.replyTo();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof MessageWithConfirmation;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "MessageWithConfirmation";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "message";
            }
            if (1 == n2) {
                return "replyTo";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public A message() {
            return (A)this.message;
        }

        public ActorRef<Object> replyTo() {
            return this.replyTo;
        }

        public <A> MessageWithConfirmation<A> copy(A message, ActorRef<Object> replyTo) {
            return new MessageWithConfirmation<A>(message, replyTo);
        }

        public <A> A copy$default$1() {
            return this.message();
        }

        public <A> ActorRef<Object> copy$default$2() {
            return this.replyTo();
        }

        public A _1() {
            return this.message();
        }

        public ActorRef<Object> _2() {
            return this.replyTo();
        }
    }

    public static final class RegisterConsumer<A>
    implements Command<A>,
    DeliverySerializable,
    Product,
    Serializable {
        private final ActorRef consumerController;

        public static <A> RegisterConsumer<A> apply(ActorRef<ConsumerController.Command<A>> actorRef) {
            return ProducerController$RegisterConsumer$.MODULE$.apply(actorRef);
        }

        public static RegisterConsumer<?> fromProduct(Product product) {
            return ProducerController$RegisterConsumer$.MODULE$.fromProduct(product);
        }

        public static <A> RegisterConsumer<A> unapply(RegisterConsumer<A> registerConsumer) {
            return ProducerController$RegisterConsumer$.MODULE$.unapply(registerConsumer);
        }

        public RegisterConsumer(ActorRef<ConsumerController.Command<A>> consumerController) {
            this.consumerController = consumerController;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RegisterConsumer)) return false;
            RegisterConsumer registerConsumer = (RegisterConsumer)object;
            ActorRef<ConsumerController.Command<A>> actorRef = this.consumerController();
            ActorRef<ConsumerController.Command<A>> actorRef2 = registerConsumer.consumerController();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof RegisterConsumer;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "RegisterConsumer";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "consumerController";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<ConsumerController.Command<A>> consumerController() {
            return this.consumerController;
        }

        public <A> RegisterConsumer<A> copy(ActorRef<ConsumerController.Command<A>> consumerController) {
            return new RegisterConsumer<A>(consumerController);
        }

        public <A> ActorRef<ConsumerController.Command<A>> copy$default$1() {
            return this.consumerController();
        }

        public ActorRef<ConsumerController.Command<A>> _1() {
            return this.consumerController();
        }
    }

    public static final class RequestNext<A>
    implements Product,
    Serializable {
        private final String producerId;
        private final long currentSeqNr;
        private final long confirmedSeqNr;
        private final ActorRef sendNextTo;
        private final ActorRef askNextTo;

        public static <A> RequestNext<A> apply(String string2, long l, long l2, ActorRef<A> actorRef, ActorRef<MessageWithConfirmation<A>> actorRef2) {
            return ProducerController$RequestNext$.MODULE$.apply(string2, l, l2, actorRef, actorRef2);
        }

        public static RequestNext<?> fromProduct(Product product) {
            return ProducerController$RequestNext$.MODULE$.fromProduct(product);
        }

        public static <A> RequestNext<A> unapply(RequestNext<A> requestNext) {
            return ProducerController$RequestNext$.MODULE$.unapply(requestNext);
        }

        public RequestNext(String producerId, long currentSeqNr, long confirmedSeqNr, ActorRef<A> sendNextTo, ActorRef<MessageWithConfirmation<A>> askNextTo) {
            this.producerId = producerId;
            this.currentSeqNr = currentSeqNr;
            this.confirmedSeqNr = confirmedSeqNr;
            this.sendNextTo = sendNextTo;
            this.askNextTo = askNextTo;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.producerId()));
            n = Statics.mix(n, Statics.longHash(this.currentSeqNr()));
            n = Statics.mix(n, Statics.longHash(this.confirmedSeqNr()));
            n = Statics.mix(n, Statics.anyHash(this.sendNextTo()));
            n = Statics.mix(n, Statics.anyHash(this.askNextTo()));
            return Statics.finalizeHash(n, 5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RequestNext)) return false;
            RequestNext requestNext = (RequestNext)object;
            String string2 = this.producerId();
            String string3 = requestNext.producerId();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (this.currentSeqNr() != requestNext.currentSeqNr()) return false;
            if (this.confirmedSeqNr() != requestNext.confirmedSeqNr()) return false;
            ActorRef<A> actorRef = this.sendNextTo();
            ActorRef<A> actorRef2 = requestNext.sendNextTo();
            if (actorRef == null) {
                if (actorRef2 != null) {
                    return false;
                }
            } else if (!actorRef.equals(actorRef2)) return false;
            ActorRef<MessageWithConfirmation<A>> actorRef3 = this.askNextTo();
            ActorRef<MessageWithConfirmation<A>> actorRef4 = requestNext.askNextTo();
            if (actorRef3 == null) {
                if (actorRef4 == null) return true;
                return false;
            } else {
                if (!actorRef3.equals(actorRef4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof RequestNext;
        }

        @Override
        public int productArity() {
            return 5;
        }

        @Override
        public String productPrefix() {
            return "RequestNext";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong(this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToLong(this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "producerId";
                }
                case 1: {
                    return "currentSeqNr";
                }
                case 2: {
                    return "confirmedSeqNr";
                }
                case 3: {
                    return "sendNextTo";
                }
                case 4: {
                    return "askNextTo";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String producerId() {
            return this.producerId;
        }

        public long currentSeqNr() {
            return this.currentSeqNr;
        }

        public long confirmedSeqNr() {
            return this.confirmedSeqNr;
        }

        public ActorRef<A> sendNextTo() {
            return this.sendNextTo;
        }

        public ActorRef<MessageWithConfirmation<A>> askNextTo() {
            return this.askNextTo;
        }

        public <A> RequestNext<A> copy(String producerId, long currentSeqNr, long confirmedSeqNr, ActorRef<A> sendNextTo, ActorRef<MessageWithConfirmation<A>> askNextTo) {
            return new RequestNext<A>(producerId, currentSeqNr, confirmedSeqNr, sendNextTo, askNextTo);
        }

        public <A> String copy$default$1() {
            return this.producerId();
        }

        public long copy$default$2() {
            return this.currentSeqNr();
        }

        public long copy$default$3() {
            return this.confirmedSeqNr();
        }

        public <A> ActorRef<A> copy$default$4() {
            return this.sendNextTo();
        }

        public <A> ActorRef<MessageWithConfirmation<A>> copy$default$5() {
            return this.askNextTo();
        }

        public String _1() {
            return this.producerId();
        }

        public long _2() {
            return this.currentSeqNr();
        }

        public long _3() {
            return this.confirmedSeqNr();
        }

        public ActorRef<A> _4() {
            return this.sendNextTo();
        }

        public ActorRef<MessageWithConfirmation<A>> _5() {
            return this.askNextTo();
        }
    }

    public static final class Settings {
        private final FiniteDuration durableQueueRequestTimeout;
        private final int durableQueueRetryAttempts;
        private final FiniteDuration durableQueueResendFirstInterval;
        private final int chunkLargeMessagesBytes;

        public static Settings apply(ActorSystem<?> actorSystem) {
            return ProducerController$Settings$.MODULE$.apply(actorSystem);
        }

        public static Settings apply(Config config) {
            return ProducerController$Settings$.MODULE$.apply(config);
        }

        public static Settings create(ActorSystem<?> actorSystem) {
            return ProducerController$Settings$.MODULE$.create(actorSystem);
        }

        public static Settings create(Config config) {
            return ProducerController$Settings$.MODULE$.create(config);
        }

        public Settings(FiniteDuration durableQueueRequestTimeout, int durableQueueRetryAttempts, FiniteDuration durableQueueResendFirstInterval, int chunkLargeMessagesBytes) {
            this.durableQueueRequestTimeout = durableQueueRequestTimeout;
            this.durableQueueRetryAttempts = durableQueueRetryAttempts;
            this.durableQueueResendFirstInterval = durableQueueResendFirstInterval;
            this.chunkLargeMessagesBytes = chunkLargeMessagesBytes;
        }

        public FiniteDuration durableQueueRequestTimeout() {
            return this.durableQueueRequestTimeout;
        }

        public int durableQueueRetryAttempts() {
            return this.durableQueueRetryAttempts;
        }

        public FiniteDuration durableQueueResendFirstInterval() {
            return this.durableQueueResendFirstInterval;
        }

        public int chunkLargeMessagesBytes() {
            return this.chunkLargeMessagesBytes;
        }

        public Settings withDurableQueueRetryAttempts(int newDurableQueueRetryAttempts) {
            return this.copy(this.copy$default$1(), newDurableQueueRetryAttempts, this.copy$default$3(), this.copy$default$4());
        }

        public Settings withDurableQueueRequestTimeout(FiniteDuration newDurableQueueRequestTimeout) {
            return this.copy(newDurableQueueRequestTimeout, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
        }

        public Settings withDurableQueueResendFirstInterval(FiniteDuration newDurableQueueResendFirstInterval) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), newDurableQueueResendFirstInterval, this.copy$default$4());
        }

        public Settings withDurableQueueRequestTimeout(Duration newDurableQueueRequestTimeout) {
            return this.copy(JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(newDurableQueueRequestTimeout)), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
        }

        public Settings withDurableQueueResendFirstInterval(Duration newDurableQueueResendFirstInterval) {
            FiniteDuration finiteDuration = JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(newDurableQueueResendFirstInterval));
            FiniteDuration finiteDuration2 = this.copy$default$1();
            int n = this.copy$default$2();
            int n2 = this.copy$default$4();
            return this.copy(finiteDuration2, n, finiteDuration, n2);
        }

        public Duration getDurableQueueRequestTimeout() {
            return JavaDurationConverters$ScalaDurationOps$.MODULE$.asJava$extension(JavaDurationConverters$.MODULE$.ScalaDurationOps(this.durableQueueRequestTimeout()));
        }

        public Settings withChunkLargeMessagesBytes(int newChunkLargeMessagesBytes) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), newChunkLargeMessagesBytes);
        }

        private Settings copy(FiniteDuration durableQueueRequestTimeout, int durableQueueRetryAttempts, FiniteDuration durableQueueResendFirstInterval, int chunkLargeMessagesBytes) {
            return new Settings(durableQueueRequestTimeout, durableQueueRetryAttempts, durableQueueResendFirstInterval, chunkLargeMessagesBytes);
        }

        private FiniteDuration copy$default$1() {
            return this.durableQueueRequestTimeout();
        }

        private int copy$default$2() {
            return this.durableQueueRetryAttempts();
        }

        private FiniteDuration copy$default$3() {
            return this.durableQueueResendFirstInterval();
        }

        private int copy$default$4() {
            return this.chunkLargeMessagesBytes();
        }

        public String toString() {
            return new StringBuilder(16).append("Settings(").append(this.durableQueueRequestTimeout()).append(", ").append(this.durableQueueRetryAttempts()).append(", ").append(this.durableQueueResendFirstInterval()).append(", ").append(this.chunkLargeMessagesBytes()).append(")").toString();
        }
    }

    public static final class Start<A>
    implements Command<A>,
    Product,
    Serializable {
        private final ActorRef producer;

        public static <A> Start<A> apply(ActorRef<RequestNext<A>> actorRef) {
            return ProducerController$Start$.MODULE$.apply(actorRef);
        }

        public static Start<?> fromProduct(Product product) {
            return ProducerController$Start$.MODULE$.fromProduct(product);
        }

        public static <A> Start<A> unapply(Start<A> start) {
            return ProducerController$Start$.MODULE$.unapply(start);
        }

        public Start(ActorRef<RequestNext<A>> producer) {
            this.producer = producer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Start)) return false;
            Start start = (Start)object;
            ActorRef<RequestNext<A>> actorRef = this.producer();
            ActorRef<RequestNext<A>> actorRef2 = start.producer();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Start;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Start";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "producer";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<RequestNext<A>> producer() {
            return this.producer;
        }

        public <A> Start<A> copy(ActorRef<RequestNext<A>> producer) {
            return new Start<A>(producer);
        }

        public <A> ActorRef<RequestNext<A>> copy$default$1() {
            return this.producer();
        }

        public ActorRef<RequestNext<A>> _1() {
            return this.producer();
        }
    }
}

