/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.delivery;

import com.typesafe.config.Config;
import java.io.Serializable;
import java.time.Duration;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.typed.ActorRef;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.delivery.ConsumerController$;
import org.apache.pekko.actor.typed.delivery.ConsumerController$Confirmed$;
import org.apache.pekko.actor.typed.delivery.ConsumerController$DeliverThenStop$;
import org.apache.pekko.actor.typed.delivery.ConsumerController$Delivery$;
import org.apache.pekko.actor.typed.delivery.ConsumerController$RegisterToProducerController$;
import org.apache.pekko.actor.typed.delivery.ConsumerController$SequencedMessage$;
import org.apache.pekko.actor.typed.delivery.ConsumerController$Settings$;
import org.apache.pekko.actor.typed.delivery.ConsumerController$Start$;
import org.apache.pekko.actor.typed.delivery.ProducerController;
import org.apache.pekko.actor.typed.delivery.internal.ChunkedMessage;
import org.apache.pekko.actor.typed.delivery.internal.ConsumerControllerImpl;
import org.apache.pekko.actor.typed.delivery.internal.DeliverySerializable;
import org.apache.pekko.actor.typed.delivery.internal.ProducerControllerImpl;
import org.apache.pekko.actor.typed.receptionist.ServiceKey;
import org.apache.pekko.annotation.ApiMayChange;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import org.apache.pekko.util.JavaDurationConverters$ScalaDurationOps$;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.concurrent.duration.FiniteDuration;
import scala.deriving.Mirror;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ApiMayChange
public final class ConsumerController {
    public static <A> Behavior<Command<A>> apply() {
        return ConsumerController$.MODULE$.apply();
    }

    @InternalApi
    public static <A> Behavior<Command<A>> apply(Option<ServiceKey<Command<A>>> option, Settings settings) {
        return ConsumerController$.MODULE$.apply(option, settings);
    }

    public static <A> Behavior<Command<A>> apply(ServiceKey<Command<A>> serviceKey) {
        return ConsumerController$.MODULE$.apply(serviceKey);
    }

    public static <A> Behavior<Command<A>> apply(ServiceKey<Command<A>> serviceKey, Settings settings) {
        return ConsumerController$.MODULE$.apply(serviceKey, settings);
    }

    public static <A> Behavior<Command<A>> apply(Settings settings) {
        return ConsumerController$.MODULE$.apply(settings);
    }

    public static Confirmed confirmed() {
        return ConsumerController$.MODULE$.confirmed();
    }

    public static <A> Behavior<Command<A>> create() {
        return ConsumerController$.MODULE$.create();
    }

    public static <A> Behavior<Command<A>> create(ServiceKey<Command<A>> serviceKey) {
        return ConsumerController$.MODULE$.create(serviceKey);
    }

    public static <A> Behavior<Command<A>> create(ServiceKey<Command<A>> serviceKey, Settings settings) {
        return ConsumerController$.MODULE$.create(serviceKey, settings);
    }

    public static <A> Behavior<Command<A>> create(Settings settings) {
        return ConsumerController$.MODULE$.create(settings);
    }

    public static <A> Class<Delivery<A>> deliveryClass() {
        return ConsumerController$.MODULE$.deliveryClass();
    }

    public static <A> Class<Command<A>> serviceKeyClass() {
        return ConsumerController$.MODULE$.serviceKeyClass();
    }

    public static interface Command<A>
    extends ConsumerControllerImpl.UnsealedInternalCommand {
    }

    @DoNotInherit
    public static interface Confirmed
    extends ConsumerControllerImpl.UnsealedInternalCommand {
        public static boolean canEqual(Object object) {
            return ConsumerController$Confirmed$.MODULE$.canEqual(object);
        }

        public static Mirror.Singleton fromProduct(Product product) {
            return ConsumerController$Confirmed$.MODULE$.fromProduct(product);
        }

        public static int productArity() {
            return ConsumerController$Confirmed$.MODULE$.productArity();
        }

        public static Object productElement(int n) {
            return ConsumerController$Confirmed$.MODULE$.productElement(n);
        }

        public static String productElementName(int n) {
            return ConsumerController$Confirmed$.MODULE$.productElementName(n);
        }

        public static Iterator<String> productElementNames() {
            return ConsumerController$Confirmed$.MODULE$.productElementNames();
        }

        public static Iterator<Object> productIterator() {
            return ConsumerController$Confirmed$.MODULE$.productIterator();
        }

        public static String productPrefix() {
            return ConsumerController$Confirmed$.MODULE$.productPrefix();
        }
    }

    public static final class DeliverThenStop<A>
    implements Command<A>,
    Product,
    Serializable {
        public static <A> DeliverThenStop<A> apply() {
            return ConsumerController$DeliverThenStop$.MODULE$.apply();
        }

        public static DeliverThenStop<?> fromProduct(Product product) {
            return ConsumerController$DeliverThenStop$.MODULE$.fromProduct(product);
        }

        public static <A> boolean unapply(DeliverThenStop<A> deliverThenStop) {
            return ConsumerController$DeliverThenStop$.MODULE$.unapply(deliverThenStop);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DeliverThenStop)) return false;
            DeliverThenStop deliverThenStop = (DeliverThenStop)object;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof DeliverThenStop;
        }

        @Override
        public int productArity() {
            return 0;
        }

        @Override
        public String productPrefix() {
            return "DeliverThenStop";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public <A> DeliverThenStop<A> copy() {
            return new DeliverThenStop<A>();
        }
    }

    public static final class Delivery<A> {
        private final Object message;
        private final ActorRef confirmTo;
        private final String producerId;
        private final long seqNr;

        public static <A> Delivery<A> apply(A a, ActorRef<Confirmed> actorRef, String string2, long l) {
            return ConsumerController$Delivery$.MODULE$.apply(a, actorRef, string2, l);
        }

        public static <A> Option<Tuple2<A, ActorRef<Confirmed>>> unapply(Delivery<A> delivery) {
            return ConsumerController$Delivery$.MODULE$.unapply(delivery);
        }

        public Delivery(A message, ActorRef<Confirmed> confirmTo, String producerId, long seqNr) {
            this.message = message;
            this.confirmTo = confirmTo;
            this.producerId = producerId;
            this.seqNr = seqNr;
        }

        public A message() {
            return (A)this.message;
        }

        public ActorRef<Confirmed> confirmTo() {
            return this.confirmTo;
        }

        public String producerId() {
            return this.producerId;
        }

        public long seqNr() {
            return this.seqNr;
        }

        public String toString() {
            return new StringBuilder(13).append("Delivery(").append(this.message()).append(",").append(this.confirmTo()).append(",").append(this.producerId()).append(",").append(this.seqNr()).append(")").toString();
        }
    }

    public static final class RegisterToProducerController<A>
    implements Command<A>,
    Product,
    Serializable {
        private final ActorRef producerController;

        public static <A> RegisterToProducerController<A> apply(ActorRef<ProducerController.Command<A>> actorRef) {
            return ConsumerController$RegisterToProducerController$.MODULE$.apply(actorRef);
        }

        public static RegisterToProducerController<?> fromProduct(Product product) {
            return ConsumerController$RegisterToProducerController$.MODULE$.fromProduct(product);
        }

        public static <A> RegisterToProducerController<A> unapply(RegisterToProducerController<A> registerToProducerController) {
            return ConsumerController$RegisterToProducerController$.MODULE$.unapply(registerToProducerController);
        }

        public RegisterToProducerController(ActorRef<ProducerController.Command<A>> producerController) {
            this.producerController = producerController;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RegisterToProducerController)) return false;
            RegisterToProducerController registerToProducerController = (RegisterToProducerController)object;
            ActorRef<ProducerController.Command<A>> actorRef = this.producerController();
            ActorRef<ProducerController.Command<A>> actorRef2 = registerToProducerController.producerController();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof RegisterToProducerController;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "RegisterToProducerController";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "producerController";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<ProducerController.Command<A>> producerController() {
            return this.producerController;
        }

        public <A> RegisterToProducerController<A> copy(ActorRef<ProducerController.Command<A>> producerController) {
            return new RegisterToProducerController<A>(producerController);
        }

        public <A> ActorRef<ProducerController.Command<A>> copy$default$1() {
            return this.producerController();
        }

        public ActorRef<ProducerController.Command<A>> _1() {
            return this.producerController();
        }
    }

    public static final class SequencedMessage<A>
    implements Command<A>,
    DeliverySerializable,
    DeadLetterSuppression,
    Product,
    Serializable {
        private final String producerId;
        private final long seqNr;
        private final Object message;
        private final boolean first;
        private final boolean ack;
        private final ActorRef producerController;

        public static <A> SequencedMessage<A> apply(String string2, long l, Object object, boolean bl, boolean bl2, ActorRef<ProducerControllerImpl.InternalCommand> actorRef) {
            return ConsumerController$SequencedMessage$.MODULE$.apply(string2, l, object, bl, bl2, actorRef);
        }

        @InternalApi
        public static <A> SequencedMessage<A> fromChunked(String string2, long l, ChunkedMessage chunkedMessage, boolean bl, boolean bl2, ActorRef<ProducerControllerImpl.InternalCommand> actorRef) {
            return ConsumerController$SequencedMessage$.MODULE$.fromChunked(string2, l, chunkedMessage, bl, bl2, actorRef);
        }

        public static <A> SequencedMessage<A> unapply(SequencedMessage<A> sequencedMessage) {
            return ConsumerController$SequencedMessage$.MODULE$.unapply(sequencedMessage);
        }

        public SequencedMessage(String producerId, long seqNr, Object message, boolean first, boolean ack, @InternalApi ActorRef<ProducerControllerImpl.InternalCommand> producerController) {
            this.producerId = producerId;
            this.seqNr = seqNr;
            this.message = message;
            this.first = first;
            this.ack = ack;
            this.producerController = producerController;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.producerId()));
            n = Statics.mix(n, Statics.longHash(this.seqNr()));
            n = Statics.mix(n, Statics.anyHash(this.message()));
            n = Statics.mix(n, this.first() ? 1231 : 1237);
            n = Statics.mix(n, this.ack() ? 1231 : 1237);
            return Statics.finalizeHash(n, 5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SequencedMessage)) return false;
            SequencedMessage sequencedMessage = (SequencedMessage)object;
            if (this.first() != sequencedMessage.first()) return false;
            if (this.ack() != sequencedMessage.ack()) return false;
            String string2 = this.producerId();
            String string3 = sequencedMessage.producerId();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (this.seqNr() != sequencedMessage.seqNr()) return false;
            if (!BoxesRunTime.equals(this.message(), sequencedMessage.message())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof SequencedMessage;
        }

        @Override
        public int productArity() {
            return 5;
        }

        @Override
        public String productPrefix() {
            return "SequencedMessage";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToLong(this._2());
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean(this._4());
                }
                case 4: {
                    return BoxesRunTime.boxToBoolean(this._5());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "producerId";
                }
                case 1: {
                    return "seqNr";
                }
                case 2: {
                    return "message";
                }
                case 3: {
                    return "first";
                }
                case 4: {
                    return "ack";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String producerId() {
            return this.producerId;
        }

        public long seqNr() {
            return this.seqNr;
        }

        public Object message() {
            return this.message;
        }

        public boolean first() {
            return this.first;
        }

        public boolean ack() {
            return this.ack;
        }

        public ActorRef<ProducerControllerImpl.InternalCommand> producerController() {
            return this.producerController;
        }

        @InternalApi
        public SequencedMessage<A> asFirst() {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), true, this.copy$default$5(), this.producerController());
        }

        @InternalApi
        public boolean isFirstChunk() {
            Object object = this.message();
            if (object instanceof ChunkedMessage) {
                ChunkedMessage c = (ChunkedMessage)object;
                return c.firstChunk();
            }
            return true;
        }

        @InternalApi
        public boolean isLastChunk() {
            Object object = this.message();
            if (object instanceof ChunkedMessage) {
                ChunkedMessage c = (ChunkedMessage)object;
                return c.lastChunk();
            }
            return true;
        }

        public <A> SequencedMessage<A> copy(String producerId, long seqNr, Object message, boolean first, boolean ack, ActorRef<ProducerControllerImpl.InternalCommand> producerController) {
            return new SequencedMessage<A>(producerId, seqNr, message, first, ack, producerController);
        }

        public <A> String copy$default$1() {
            return this.producerId();
        }

        public long copy$default$2() {
            return this.seqNr();
        }

        public <A> Object copy$default$3() {
            return this.message();
        }

        public boolean copy$default$4() {
            return this.first();
        }

        public boolean copy$default$5() {
            return this.ack();
        }

        public String _1() {
            return this.producerId();
        }

        public long _2() {
            return this.seqNr();
        }

        public Object _3() {
            return this.message();
        }

        public boolean _4() {
            return this.first();
        }

        public boolean _5() {
            return this.ack();
        }
    }

    public static final class Settings {
        private final int flowControlWindow;
        private final FiniteDuration resendIntervalMin;
        private final FiniteDuration resendIntervalMax;
        private final boolean onlyFlowControl;

        public static Settings apply(ActorSystem<?> actorSystem) {
            return ConsumerController$Settings$.MODULE$.apply(actorSystem);
        }

        public static Settings apply(Config config) {
            return ConsumerController$Settings$.MODULE$.apply(config);
        }

        public static Settings create(ActorSystem<?> actorSystem) {
            return ConsumerController$Settings$.MODULE$.create(actorSystem);
        }

        public static Settings create(Config config) {
            return ConsumerController$Settings$.MODULE$.create(config);
        }

        public Settings(int flowControlWindow, FiniteDuration resendIntervalMin, FiniteDuration resendIntervalMax, boolean onlyFlowControl) {
            this.flowControlWindow = flowControlWindow;
            this.resendIntervalMin = resendIntervalMin;
            this.resendIntervalMax = resendIntervalMax;
            this.onlyFlowControl = onlyFlowControl;
        }

        public int flowControlWindow() {
            return this.flowControlWindow;
        }

        public FiniteDuration resendIntervalMin() {
            return this.resendIntervalMin;
        }

        public FiniteDuration resendIntervalMax() {
            return this.resendIntervalMax;
        }

        public boolean onlyFlowControl() {
            return this.onlyFlowControl;
        }

        public Settings withFlowControlWindow(int newFlowControlWindow) {
            return this.copy(newFlowControlWindow, this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
        }

        public Settings withResendIntervalMin(FiniteDuration newResendIntervalMin) {
            return this.copy(this.copy$default$1(), newResendIntervalMin, this.copy$default$3(), this.copy$default$4());
        }

        public Settings withResendIntervalMax(FiniteDuration newResendIntervalMax) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), newResendIntervalMax, this.copy$default$4());
        }

        public Settings withResendIntervalMin(Duration newResendIntervalMin) {
            FiniteDuration finiteDuration = JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(newResendIntervalMin));
            int n = this.copy$default$1();
            FiniteDuration finiteDuration2 = this.copy$default$3();
            boolean bl = this.copy$default$4();
            return this.copy(n, finiteDuration, finiteDuration2, bl);
        }

        public Settings withResendIntervalMax(Duration newResendIntervalMax) {
            FiniteDuration finiteDuration = JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(newResendIntervalMax));
            int n = this.copy$default$1();
            FiniteDuration finiteDuration2 = this.copy$default$2();
            boolean bl = this.copy$default$4();
            return this.copy(n, finiteDuration2, finiteDuration, bl);
        }

        public Duration getResendIntervalMax() {
            return JavaDurationConverters$ScalaDurationOps$.MODULE$.asJava$extension(JavaDurationConverters$.MODULE$.ScalaDurationOps(this.resendIntervalMax()));
        }

        public Settings withOnlyFlowControl(boolean newOnlyFlowControl) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), newOnlyFlowControl);
        }

        private Settings copy(int flowControlWindow, FiniteDuration resendIntervalMin, FiniteDuration resendIntervalMax, boolean onlyFlowControl) {
            return new Settings(flowControlWindow, resendIntervalMin, resendIntervalMax, onlyFlowControl);
        }

        private int copy$default$1() {
            return this.flowControlWindow();
        }

        private FiniteDuration copy$default$2() {
            return this.resendIntervalMin();
        }

        private FiniteDuration copy$default$3() {
            return this.resendIntervalMax();
        }

        private boolean copy$default$4() {
            return this.onlyFlowControl();
        }

        public String toString() {
            return new StringBuilder(14).append("Settings(").append(this.flowControlWindow()).append(", ").append(this.resendIntervalMin()).append(", ").append(this.onlyFlowControl()).append(")").toString();
        }
    }

    public static final class Start<A>
    implements Command<A>,
    Product,
    Serializable {
        private final ActorRef deliverTo;

        public static <A> Start<A> apply(ActorRef<Delivery<A>> actorRef) {
            return ConsumerController$Start$.MODULE$.apply(actorRef);
        }

        public static Start<?> fromProduct(Product product) {
            return ConsumerController$Start$.MODULE$.fromProduct(product);
        }

        public static <A> Start<A> unapply(Start<A> start) {
            return ConsumerController$Start$.MODULE$.unapply(start);
        }

        public Start(ActorRef<Delivery<A>> deliverTo) {
            this.deliverTo = deliverTo;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Start)) return false;
            Start start = (Start)object;
            ActorRef<Delivery<A>> actorRef = this.deliverTo();
            ActorRef<Delivery<A>> actorRef2 = start.deliverTo();
            if (actorRef != null) {
                if (!actorRef.equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Start;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Start";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "deliverTo";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef<Delivery<A>> deliverTo() {
            return this.deliverTo;
        }

        public <A> Start<A> copy(ActorRef<Delivery<A>> deliverTo) {
            return new Start<A>(deliverTo);
        }

        public <A> ActorRef<Delivery<A>> copy$default$1() {
            return this.deliverTo();
        }

        public ActorRef<Delivery<A>> _1() {
            return this.deliverTo();
        }
    }
}

