/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed;

import java.io.Serializable;
import java.time.Duration;
import org.apache.pekko.actor.typed.BackoffSupervisorStrategy;
import org.apache.pekko.actor.typed.RestartSupervisorStrategy;
import org.apache.pekko.actor.typed.SupervisorStrategy$;
import org.apache.pekko.actor.typed.SupervisorStrategy$Backoff$;
import org.apache.pekko.actor.typed.SupervisorStrategy$Restart$;
import org.apache.pekko.actor.typed.SupervisorStrategy$Resume$;
import org.apache.pekko.actor.typed.SupervisorStrategy$Stop$;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import org.apache.pekko.util.JavaDurationConverters$ScalaDurationOps$;
import org.slf4j.event.Level;
import scala.Product;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@DoNotInherit
public abstract class SupervisorStrategy {
    public static int ordinal(SupervisorStrategy supervisorStrategy) {
        return SupervisorStrategy$.MODULE$.ordinal(supervisorStrategy);
    }

    public static RestartSupervisorStrategy restart() {
        return SupervisorStrategy$.MODULE$.restart();
    }

    public static BackoffSupervisorStrategy restartWithBackoff(Duration duration, Duration duration2, double d) {
        return SupervisorStrategy$.MODULE$.restartWithBackoff(duration, duration2, d);
    }

    public static BackoffSupervisorStrategy restartWithBackoff(FiniteDuration finiteDuration, FiniteDuration finiteDuration2, double d) {
        return SupervisorStrategy$.MODULE$.restartWithBackoff(finiteDuration, finiteDuration2, d);
    }

    public static SupervisorStrategy resume() {
        return SupervisorStrategy$.MODULE$.resume();
    }

    public static SupervisorStrategy stop() {
        return SupervisorStrategy$.MODULE$.stop();
    }

    public abstract boolean loggingEnabled();

    public abstract Level logLevel();

    public abstract SupervisorStrategy withLoggingEnabled(boolean var1);

    public abstract SupervisorStrategy withLogLevel(Level var1);

    @InternalApi
    public static final class Backoff
    extends BackoffSupervisorStrategy
    implements RestartOrBackoff,
    Product,
    Serializable {
        private final FiniteDuration minBackoff;
        private final FiniteDuration maxBackoff;
        private final double randomFactor;
        private final FiniteDuration resetBackoffAfter;
        private final boolean loggingEnabled;
        private final Level logLevel;
        private final Level criticalLogLevel;
        private final int criticalLogLevelAfter;
        private final int maxRestarts;
        private final boolean stopChildren;
        private final int stashCapacity;

        public static Backoff apply(FiniteDuration finiteDuration, FiniteDuration finiteDuration2, double d, FiniteDuration finiteDuration3, boolean bl, Level level, Level level2, int n, int n2, boolean bl2, int n3) {
            return SupervisorStrategy$Backoff$.MODULE$.apply(finiteDuration, finiteDuration2, d, finiteDuration3, bl, level, level2, n, n2, bl2, n3);
        }

        public static Backoff fromProduct(Product product) {
            return SupervisorStrategy$Backoff$.MODULE$.fromProduct(product);
        }

        public static Backoff unapply(Backoff backoff) {
            return SupervisorStrategy$Backoff$.MODULE$.unapply(backoff);
        }

        public static boolean $lessinit$greater$default$5() {
            return SupervisorStrategy$Backoff$.MODULE$.$lessinit$greater$default$5();
        }

        public static Level $lessinit$greater$default$6() {
            return SupervisorStrategy$Backoff$.MODULE$.$lessinit$greater$default$6();
        }

        public static Level $lessinit$greater$default$7() {
            return SupervisorStrategy$Backoff$.MODULE$.$lessinit$greater$default$7();
        }

        public static int $lessinit$greater$default$8() {
            return SupervisorStrategy$Backoff$.MODULE$.$lessinit$greater$default$8();
        }

        public static int $lessinit$greater$default$9() {
            return SupervisorStrategy$Backoff$.MODULE$.$lessinit$greater$default$9();
        }

        public static boolean $lessinit$greater$default$10() {
            return SupervisorStrategy$Backoff$.MODULE$.$lessinit$greater$default$10();
        }

        public static int $lessinit$greater$default$11() {
            return SupervisorStrategy$Backoff$.MODULE$.$lessinit$greater$default$11();
        }

        public Backoff(FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, FiniteDuration resetBackoffAfter, boolean loggingEnabled, Level logLevel, Level criticalLogLevel, int criticalLogLevelAfter, int maxRestarts, boolean stopChildren, int stashCapacity) {
            this.minBackoff = minBackoff;
            this.maxBackoff = maxBackoff;
            this.randomFactor = randomFactor;
            this.resetBackoffAfter = resetBackoffAfter;
            this.loggingEnabled = loggingEnabled;
            this.logLevel = logLevel;
            this.criticalLogLevel = criticalLogLevel;
            this.criticalLogLevelAfter = criticalLogLevelAfter;
            this.maxRestarts = maxRestarts;
            this.stopChildren = stopChildren;
            this.stashCapacity = stashCapacity;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.minBackoff()));
            n = Statics.mix(n, Statics.anyHash(this.maxBackoff()));
            n = Statics.mix(n, Statics.doubleHash(this.randomFactor()));
            n = Statics.mix(n, Statics.anyHash(this.resetBackoffAfter()));
            n = Statics.mix(n, this.loggingEnabled() ? 1231 : 1237);
            n = Statics.mix(n, Statics.anyHash((Object)this.logLevel()));
            n = Statics.mix(n, Statics.anyHash((Object)this.criticalLogLevel()));
            n = Statics.mix(n, this.criticalLogLevelAfter());
            n = Statics.mix(n, this.maxRestarts());
            n = Statics.mix(n, this.stopChildren() ? 1231 : 1237);
            n = Statics.mix(n, this.stashCapacity());
            return Statics.finalizeHash(n, 11);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Backoff)) return false;
            Backoff backoff = (Backoff)object;
            if (this.randomFactor() != backoff.randomFactor()) return false;
            if (this.loggingEnabled() != backoff.loggingEnabled()) return false;
            if (this.criticalLogLevelAfter() != backoff.criticalLogLevelAfter()) return false;
            if (this.maxRestarts() != backoff.maxRestarts()) return false;
            if (this.stopChildren() != backoff.stopChildren()) return false;
            if (this.stashCapacity() != backoff.stashCapacity()) return false;
            FiniteDuration finiteDuration = this.minBackoff();
            FiniteDuration finiteDuration2 = backoff.minBackoff();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!((Object)finiteDuration).equals(finiteDuration2)) return false;
            FiniteDuration finiteDuration3 = this.maxBackoff();
            FiniteDuration finiteDuration4 = backoff.maxBackoff();
            if (finiteDuration3 == null) {
                if (finiteDuration4 != null) {
                    return false;
                }
            } else if (!((Object)finiteDuration3).equals(finiteDuration4)) return false;
            FiniteDuration finiteDuration5 = this.resetBackoffAfter();
            FiniteDuration finiteDuration6 = backoff.resetBackoffAfter();
            if (finiteDuration5 == null) {
                if (finiteDuration6 != null) {
                    return false;
                }
            } else if (!((Object)finiteDuration5).equals(finiteDuration6)) return false;
            Level level = this.logLevel();
            Level level2 = backoff.logLevel();
            if (level == null) {
                if (level2 != null) {
                    return false;
                }
            } else if (!((Object)((Object)level)).equals((Object)level2)) return false;
            Level level3 = this.criticalLogLevel();
            Level level4 = backoff.criticalLogLevel();
            if (level3 == null) {
                if (level4 == null) return true;
                return false;
            } else {
                if (!((Object)((Object)level3)).equals((Object)level4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Backoff;
        }

        @Override
        public int productArity() {
            return 11;
        }

        @Override
        public String productPrefix() {
            return "Backoff";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToDouble(this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return BoxesRunTime.boxToBoolean(this._5());
                }
                case 5: {
                    return this._6();
                }
                case 6: {
                    return this._7();
                }
                case 7: {
                    return BoxesRunTime.boxToInteger(this._8());
                }
                case 8: {
                    return BoxesRunTime.boxToInteger(this._9());
                }
                case 9: {
                    return BoxesRunTime.boxToBoolean(this._10());
                }
                case 10: {
                    return BoxesRunTime.boxToInteger(this._11());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "minBackoff";
                }
                case 1: {
                    return "maxBackoff";
                }
                case 2: {
                    return "randomFactor";
                }
                case 3: {
                    return "resetBackoffAfter";
                }
                case 4: {
                    return "loggingEnabled";
                }
                case 5: {
                    return "logLevel";
                }
                case 6: {
                    return "criticalLogLevel";
                }
                case 7: {
                    return "criticalLogLevelAfter";
                }
                case 8: {
                    return "maxRestarts";
                }
                case 9: {
                    return "stopChildren";
                }
                case 10: {
                    return "stashCapacity";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public FiniteDuration minBackoff() {
            return this.minBackoff;
        }

        public FiniteDuration maxBackoff() {
            return this.maxBackoff;
        }

        public double randomFactor() {
            return this.randomFactor;
        }

        @Override
        public FiniteDuration resetBackoffAfter() {
            return this.resetBackoffAfter;
        }

        @Override
        public boolean loggingEnabled() {
            return this.loggingEnabled;
        }

        @Override
        public Level logLevel() {
            return this.logLevel;
        }

        public Level criticalLogLevel() {
            return this.criticalLogLevel;
        }

        public int criticalLogLevelAfter() {
            return this.criticalLogLevelAfter;
        }

        @Override
        public int maxRestarts() {
            return this.maxRestarts;
        }

        @Override
        public boolean stopChildren() {
            return this.stopChildren;
        }

        @Override
        public int stashCapacity() {
            return this.stashCapacity;
        }

        @Override
        public BackoffSupervisorStrategy withResetBackoffAfter(FiniteDuration timeout) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), timeout, this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        @Override
        public BackoffSupervisorStrategy withResetBackoffAfter(Duration timeout) {
            return this.withResetBackoffAfter(JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(timeout)));
        }

        @Override
        public Duration getResetBackoffAfter() {
            return JavaDurationConverters$ScalaDurationOps$.MODULE$.asJava$extension(JavaDurationConverters$.MODULE$.ScalaDurationOps(this.resetBackoffAfter()));
        }

        @Override
        public BackoffSupervisorStrategy withMaxRestarts(int maxRestarts) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), maxRestarts, this.copy$default$10(), this.copy$default$11());
        }

        @Override
        public BackoffSupervisorStrategy withStopChildren(boolean enabled) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), enabled, this.copy$default$11());
        }

        @Override
        public BackoffSupervisorStrategy withStashCapacity(int capacity) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), capacity);
        }

        @Override
        public BackoffSupervisorStrategy withLoggingEnabled(boolean enabled) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), enabled, this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        @Override
        public BackoffSupervisorStrategy withLogLevel(Level level) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), level, this.copy$default$7(), this.copy$default$8(), this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        @Override
        public BackoffSupervisorStrategy withCriticalLogLevel(Level criticalLevel, int afterErrors) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), criticalLevel, afterErrors, this.copy$default$9(), this.copy$default$10(), this.copy$default$11());
        }

        public Backoff copy(FiniteDuration minBackoff, FiniteDuration maxBackoff, double randomFactor, FiniteDuration resetBackoffAfter, boolean loggingEnabled, Level logLevel, Level criticalLogLevel, int criticalLogLevelAfter, int maxRestarts, boolean stopChildren, int stashCapacity) {
            return new Backoff(minBackoff, maxBackoff, randomFactor, resetBackoffAfter, loggingEnabled, logLevel, criticalLogLevel, criticalLogLevelAfter, maxRestarts, stopChildren, stashCapacity);
        }

        public FiniteDuration copy$default$1() {
            return this.minBackoff();
        }

        public FiniteDuration copy$default$2() {
            return this.maxBackoff();
        }

        public double copy$default$3() {
            return this.randomFactor();
        }

        public FiniteDuration copy$default$4() {
            return this.resetBackoffAfter();
        }

        public boolean copy$default$5() {
            return this.loggingEnabled();
        }

        public Level copy$default$6() {
            return this.logLevel();
        }

        public Level copy$default$7() {
            return this.criticalLogLevel();
        }

        public int copy$default$8() {
            return this.criticalLogLevelAfter();
        }

        public int copy$default$9() {
            return this.maxRestarts();
        }

        public boolean copy$default$10() {
            return this.stopChildren();
        }

        public int copy$default$11() {
            return this.stashCapacity();
        }

        public FiniteDuration _1() {
            return this.minBackoff();
        }

        public FiniteDuration _2() {
            return this.maxBackoff();
        }

        public double _3() {
            return this.randomFactor();
        }

        public FiniteDuration _4() {
            return this.resetBackoffAfter();
        }

        public boolean _5() {
            return this.loggingEnabled();
        }

        public Level _6() {
            return this.logLevel();
        }

        public Level _7() {
            return this.criticalLogLevel();
        }

        public int _8() {
            return this.criticalLogLevelAfter();
        }

        public int _9() {
            return this.maxRestarts();
        }

        public boolean _10() {
            return this.stopChildren();
        }

        public int _11() {
            return this.stashCapacity();
        }
    }

    @InternalApi
    public static final class Restart
    extends RestartSupervisorStrategy
    implements RestartOrBackoff,
    Product,
    Serializable {
        private final int maxRestarts;
        private final FiniteDuration withinTimeRange;
        private final boolean loggingEnabled;
        private final Level logLevel;
        private final boolean stopChildren;
        private final int stashCapacity;

        public static Restart apply(int n, FiniteDuration finiteDuration, boolean bl, Level level, boolean bl2, int n2) {
            return SupervisorStrategy$Restart$.MODULE$.apply(n, finiteDuration, bl, level, bl2, n2);
        }

        public static Restart fromProduct(Product product) {
            return SupervisorStrategy$Restart$.MODULE$.fromProduct(product);
        }

        public static Restart unapply(Restart restart) {
            return SupervisorStrategy$Restart$.MODULE$.unapply(restart);
        }

        public static boolean $lessinit$greater$default$3() {
            return SupervisorStrategy$Restart$.MODULE$.$lessinit$greater$default$3();
        }

        public static Level $lessinit$greater$default$4() {
            return SupervisorStrategy$Restart$.MODULE$.$lessinit$greater$default$4();
        }

        public static boolean $lessinit$greater$default$5() {
            return SupervisorStrategy$Restart$.MODULE$.$lessinit$greater$default$5();
        }

        public static int $lessinit$greater$default$6() {
            return SupervisorStrategy$Restart$.MODULE$.$lessinit$greater$default$6();
        }

        public Restart(int maxRestarts, FiniteDuration withinTimeRange, boolean loggingEnabled, Level logLevel, boolean stopChildren, int stashCapacity) {
            this.maxRestarts = maxRestarts;
            this.withinTimeRange = withinTimeRange;
            this.loggingEnabled = loggingEnabled;
            this.logLevel = logLevel;
            this.stopChildren = stopChildren;
            this.stashCapacity = stashCapacity;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.maxRestarts());
            n = Statics.mix(n, Statics.anyHash(this.withinTimeRange()));
            n = Statics.mix(n, this.loggingEnabled() ? 1231 : 1237);
            n = Statics.mix(n, Statics.anyHash((Object)this.logLevel()));
            n = Statics.mix(n, this.stopChildren() ? 1231 : 1237);
            n = Statics.mix(n, this.stashCapacity());
            return Statics.finalizeHash(n, 6);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Restart)) return false;
            Restart restart = (Restart)object;
            if (this.maxRestarts() != restart.maxRestarts()) return false;
            if (this.loggingEnabled() != restart.loggingEnabled()) return false;
            if (this.stopChildren() != restart.stopChildren()) return false;
            if (this.stashCapacity() != restart.stashCapacity()) return false;
            FiniteDuration finiteDuration = this.withinTimeRange();
            FiniteDuration finiteDuration2 = restart.withinTimeRange();
            if (finiteDuration == null) {
                if (finiteDuration2 != null) {
                    return false;
                }
            } else if (!((Object)finiteDuration).equals(finiteDuration2)) return false;
            Level level = this.logLevel();
            Level level2 = restart.logLevel();
            if (level == null) {
                if (level2 == null) return true;
                return false;
            } else {
                if (!((Object)((Object)level)).equals((Object)level2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Restart;
        }

        @Override
        public int productArity() {
            return 6;
        }

        @Override
        public String productPrefix() {
            return "Restart";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToInteger(this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean(this._3());
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return BoxesRunTime.boxToBoolean(this._5());
                }
                case 5: {
                    return BoxesRunTime.boxToInteger(this._6());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "maxRestarts";
                }
                case 1: {
                    return "withinTimeRange";
                }
                case 2: {
                    return "loggingEnabled";
                }
                case 3: {
                    return "logLevel";
                }
                case 4: {
                    return "stopChildren";
                }
                case 5: {
                    return "stashCapacity";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public int maxRestarts() {
            return this.maxRestarts;
        }

        public FiniteDuration withinTimeRange() {
            return this.withinTimeRange;
        }

        @Override
        public boolean loggingEnabled() {
            return this.loggingEnabled;
        }

        @Override
        public Level logLevel() {
            return this.logLevel;
        }

        @Override
        public boolean stopChildren() {
            return this.stopChildren;
        }

        @Override
        public int stashCapacity() {
            return this.stashCapacity;
        }

        @Override
        public RestartSupervisorStrategy withLimit(int maxNrOfRetries, FiniteDuration withinTimeRange) {
            return this.copy(maxNrOfRetries, withinTimeRange, this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }

        @Override
        public RestartSupervisorStrategy withLimit(int maxNrOfRetries, Duration withinTimeRange) {
            return this.copy(maxNrOfRetries, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(withinTimeRange)), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }

        @Override
        public RestartSupervisorStrategy withStopChildren(boolean enabled) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), enabled, this.copy$default$6());
        }

        @Override
        public RestartSupervisorStrategy withStashCapacity(int capacity) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), capacity);
        }

        @Override
        public RestartSupervisorStrategy withLoggingEnabled(boolean enabled) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), enabled, this.copy$default$4(), this.copy$default$5(), this.copy$default$6());
        }

        @Override
        public RestartSupervisorStrategy withLogLevel(Level level) {
            return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), level, this.copy$default$5(), this.copy$default$6());
        }

        public Restart copy(int maxRestarts, FiniteDuration withinTimeRange, boolean loggingEnabled, Level logLevel, boolean stopChildren, int stashCapacity) {
            return new Restart(maxRestarts, withinTimeRange, loggingEnabled, logLevel, stopChildren, stashCapacity);
        }

        public int copy$default$1() {
            return this.maxRestarts();
        }

        public FiniteDuration copy$default$2() {
            return this.withinTimeRange();
        }

        public boolean copy$default$3() {
            return this.loggingEnabled();
        }

        public Level copy$default$4() {
            return this.logLevel();
        }

        public boolean copy$default$5() {
            return this.stopChildren();
        }

        public int copy$default$6() {
            return this.stashCapacity();
        }

        public int _1() {
            return this.maxRestarts();
        }

        public FiniteDuration _2() {
            return this.withinTimeRange();
        }

        public boolean _3() {
            return this.loggingEnabled();
        }

        public Level _4() {
            return this.logLevel();
        }

        public boolean _5() {
            return this.stopChildren();
        }

        public int _6() {
            return this.stashCapacity();
        }
    }

    @InternalApi
    public static interface RestartOrBackoff {
        public int maxRestarts();

        public boolean stopChildren();

        public int stashCapacity();

        public boolean loggingEnabled();

        public static boolean unlimitedRestarts$(RestartOrBackoff $this) {
            return $this.unlimitedRestarts();
        }

        default public boolean unlimitedRestarts() {
            return this.maxRestarts() == -1;
        }
    }

    @InternalApi
    public static class Resume
    extends SupervisorStrategy
    implements Product,
    Serializable {
        private final boolean loggingEnabled;
        private final Level logLevel;

        public static Resume apply(boolean bl, Level level) {
            return SupervisorStrategy$Resume$.MODULE$.apply(bl, level);
        }

        public static Resume fromProduct(Product product) {
            return SupervisorStrategy$Resume$.MODULE$.fromProduct(product);
        }

        public static Resume unapply(Resume resume) {
            return SupervisorStrategy$Resume$.MODULE$.unapply(resume);
        }

        public Resume(boolean loggingEnabled, Level logLevel) {
            this.loggingEnabled = loggingEnabled;
            this.logLevel = logLevel;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.loggingEnabled() ? 1231 : 1237);
            n = Statics.mix(n, Statics.anyHash((Object)this.logLevel()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Resume)) return false;
            Resume resume = (Resume)object;
            if (this.loggingEnabled() != resume.loggingEnabled()) return false;
            Level level = this.logLevel();
            Level level2 = resume.logLevel();
            if (level == null) {
                if (level2 != null) {
                    return false;
                }
            } else if (!((Object)((Object)level)).equals((Object)level2)) return false;
            if (!resume.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Resume;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Resume";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToBoolean(this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "loggingEnabled";
            }
            if (1 == n2) {
                return "logLevel";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public boolean loggingEnabled() {
            return this.loggingEnabled;
        }

        @Override
        public Level logLevel() {
            return this.logLevel;
        }

        @Override
        public SupervisorStrategy withLoggingEnabled(boolean enabled) {
            return this.copy(enabled, this.copy$default$2());
        }

        @Override
        public SupervisorStrategy withLogLevel(Level level) {
            return this.copy(this.copy$default$1(), level);
        }

        public Resume copy(boolean loggingEnabled, Level logLevel) {
            return new Resume(loggingEnabled, logLevel);
        }

        public boolean copy$default$1() {
            return this.loggingEnabled();
        }

        public Level copy$default$2() {
            return this.logLevel();
        }

        public boolean _1() {
            return this.loggingEnabled();
        }

        public Level _2() {
            return this.logLevel();
        }
    }

    @InternalApi
    public static class Stop
    extends SupervisorStrategy
    implements Product,
    Serializable {
        private final boolean loggingEnabled;
        private final Level logLevel;

        public static Stop apply(boolean bl, Level level) {
            return SupervisorStrategy$Stop$.MODULE$.apply(bl, level);
        }

        public static Stop fromProduct(Product product) {
            return SupervisorStrategy$Stop$.MODULE$.fromProduct(product);
        }

        public static Stop unapply(Stop stop) {
            return SupervisorStrategy$Stop$.MODULE$.unapply(stop);
        }

        public Stop(boolean loggingEnabled, Level logLevel) {
            this.loggingEnabled = loggingEnabled;
            this.logLevel = logLevel;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.loggingEnabled() ? 1231 : 1237);
            n = Statics.mix(n, Statics.anyHash((Object)this.logLevel()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Stop)) return false;
            Stop stop = (Stop)object;
            if (this.loggingEnabled() != stop.loggingEnabled()) return false;
            Level level = this.logLevel();
            Level level2 = stop.logLevel();
            if (level == null) {
                if (level2 != null) {
                    return false;
                }
            } else if (!((Object)((Object)level)).equals((Object)level2)) return false;
            if (!stop.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Stop;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Stop";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToBoolean(this._1());
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "loggingEnabled";
            }
            if (1 == n2) {
                return "logLevel";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public boolean loggingEnabled() {
            return this.loggingEnabled;
        }

        @Override
        public Level logLevel() {
            return this.logLevel;
        }

        @Override
        public SupervisorStrategy withLoggingEnabled(boolean enabled) {
            return this.copy(enabled, this.copy$default$2());
        }

        @Override
        public SupervisorStrategy withLogLevel(Level level) {
            return this.copy(this.copy$default$1(), level);
        }

        public Stop copy(boolean loggingEnabled, Level logLevel) {
            return new Stop(loggingEnabled, logLevel);
        }

        public boolean copy$default$1() {
            return this.loggingEnabled();
        }

        public Level copy$default$2() {
            return this.logLevel();
        }

        public boolean _1() {
            return this.loggingEnabled();
        }

        public Level _2() {
            return this.logLevel();
        }
    }
}

