/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed;

import java.io.Serializable;
import java.util.Optional;
import org.apache.pekko.actor.typed.LogOptions$;
import org.apache.pekko.actor.typed.LogOptions$LogOptionsImpl$;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.annotation.InternalApi;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.$less$colon$less$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@DoNotInherit
public abstract class LogOptions {
    public static LogOptions apply() {
        return LogOptions$.MODULE$.apply();
    }

    public static LogOptions create() {
        return LogOptions$.MODULE$.create();
    }

    public static int ordinal(LogOptions logOptions) {
        return LogOptions$.MODULE$.ordinal(logOptions);
    }

    public abstract LogOptions withEnabled(boolean var1);

    public abstract LogOptions withLevel(Level var1);

    public abstract LogOptions withLogger(Logger var1);

    public abstract boolean enabled();

    public abstract Level level();

    public abstract Option<Logger> logger();

    public abstract Optional<Logger> getLogger();

    @InternalApi
    public static final class LogOptionsImpl
    extends LogOptions
    implements Product,
    Serializable {
        private final boolean enabled;
        private final Level level;
        private final Option logger;

        public static LogOptionsImpl apply(boolean bl, Level level, Option<Logger> option) {
            return LogOptions$LogOptionsImpl$.MODULE$.apply(bl, level, option);
        }

        public static LogOptionsImpl fromProduct(Product product) {
            return LogOptions$LogOptionsImpl$.MODULE$.fromProduct(product);
        }

        public static LogOptionsImpl unapply(LogOptionsImpl logOptionsImpl) {
            return LogOptions$LogOptionsImpl$.MODULE$.unapply(logOptionsImpl);
        }

        public LogOptionsImpl(boolean enabled, Level level, Option<Logger> logger) {
            this.enabled = enabled;
            this.level = level;
            this.logger = logger;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.enabled() ? 1231 : 1237);
            n = Statics.mix(n, Statics.anyHash((Object)this.level()));
            n = Statics.mix(n, Statics.anyHash(this.logger()));
            return Statics.finalizeHash(n, 3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LogOptionsImpl)) return false;
            LogOptionsImpl logOptionsImpl = (LogOptionsImpl)object;
            if (this.enabled() != logOptionsImpl.enabled()) return false;
            Level level = this.level();
            Level level2 = logOptionsImpl.level();
            if (level == null) {
                if (level2 != null) {
                    return false;
                }
            } else if (!((Object)((Object)level)).equals((Object)level2)) return false;
            Option<Logger> option = this.logger();
            Option<Logger> option2 = logOptionsImpl.logger();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof LogOptionsImpl;
        }

        @Override
        public int productArity() {
            return 3;
        }

        @Override
        public String productPrefix() {
            return "LogOptionsImpl";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return BoxesRunTime.boxToBoolean(this._1());
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "enabled";
                }
                case 1: {
                    return "level";
                }
                case 2: {
                    return "logger";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public boolean enabled() {
            return this.enabled;
        }

        @Override
        public Level level() {
            return this.level;
        }

        @Override
        public Option<Logger> logger() {
            return this.logger;
        }

        @Override
        public LogOptions withEnabled(boolean enabled) {
            return this.copy(enabled, this.copy$default$2(), this.copy$default$3());
        }

        @Override
        public LogOptions withLevel(Level level) {
            return this.copy(this.copy$default$1(), level, this.copy$default$3());
        }

        @Override
        public LogOptions withLogger(Logger logger) {
            Option<Logger> option = Option$.MODULE$.apply(logger);
            boolean bl = this.copy$default$1();
            Level level = this.copy$default$2();
            return this.copy(bl, level, option);
        }

        @Override
        public Optional<Logger> getLogger() {
            return Optional.ofNullable(this.logger().orNull($less$colon$less$.MODULE$.refl()));
        }

        public LogOptionsImpl copy(boolean enabled, Level level, Option<Logger> logger) {
            return new LogOptionsImpl(enabled, level, logger);
        }

        public boolean copy$default$1() {
            return this.enabled();
        }

        public Level copy$default$2() {
            return this.level();
        }

        public Option<Logger> copy$default$3() {
            return this.logger();
        }

        public boolean _1() {
            return this.enabled();
        }

        public Level _2() {
            return this.level();
        }

        public Option<Logger> _3() {
            return this.logger();
        }
    }
}

