/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed;

import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.BoxedType$;
import scala.reflect.ClassTag;

public abstract class BehaviorInterceptor<Outer, Inner> {
    private final Class interceptMessageClass;

    public BehaviorInterceptor(Class<Outer> interceptMessageClass) {
        this.interceptMessageClass = interceptMessageClass;
    }

    public Class<Outer> interceptMessageClass() {
        return this.interceptMessageClass;
    }

    public BehaviorInterceptor(ClassTag<Outer> interceptMessageClassTag) {
        Class<?> runtimeClass = interceptMessageClassTag.runtimeClass();
        this(runtimeClass == null ? runtimeClass : BoxedType$.MODULE$.apply(runtimeClass));
    }

    public Behavior<Inner> aroundStart(TypedActorContext<Outer> ctx, PreStartTarget<Inner> target) {
        return target.start(ctx);
    }

    public abstract Behavior<Inner> aroundReceive(TypedActorContext<Outer> var1, Outer var2, ReceiveTarget<Inner> var3);

    public Behavior<Inner> aroundSignal(TypedActorContext<Outer> ctx, Signal signal, SignalTarget<Inner> target) {
        return target.apply(ctx, signal);
    }

    public boolean isSame(BehaviorInterceptor<Object, Object> other) {
        return this == other;
    }

    @DoNotInherit
    public static interface PreStartTarget<T> {
        public Behavior<T> start(TypedActorContext<?> var1);
    }

    @DoNotInherit
    public static interface ReceiveTarget<T> {
        public Behavior<T> apply(TypedActorContext<?> var1, T var2);

        @InternalApi
        public void signalRestart(TypedActorContext<?> var1);
    }

    @DoNotInherit
    public static interface SignalTarget<T> {
        public Behavior<T> apply(TypedActorContext<?> var1, Signal var2);
    }
}

