/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed;

import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefWithCell;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.typed.ActorRefResolver;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$ClassicActorSystemOps$;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$TypedActorRefOps$;
import org.apache.pekko.actor.typed.scaladsl.adapter.package$TypedActorSystemOps$;
import org.apache.pekko.annotation.InternalApi;

@InternalApi
public class ActorRefResolverImpl
extends ActorRefResolver {
    private final ActorSystem<?> system;
    private final ExtendedActorSystem classicSystem;

    public ActorRefResolverImpl(ActorSystem<?> system) {
        this.system = system;
        this.classicSystem = (ExtendedActorSystem)package$TypedActorSystemOps$.MODULE$.toClassic$extension(package$.MODULE$.TypedActorSystemOps(system));
    }

    @Override
    public <T> String toSerializationFormat(org.apache.pekko.actor.typed.ActorRef<T> ref) {
        ActorRef actorRef = package$TypedActorRefOps$.MODULE$.toClassic$extension(package$.MODULE$.TypedActorRefOps(ref));
        if (actorRef instanceof ActorRefWithCell) {
            ActorRefWithCell a = (ActorRefWithCell)actorRef;
            ExtendedActorSystem originSystem = (ExtendedActorSystem)a.underlying().system();
            if (originSystem == this.classicSystem) {
                return this.toSerializationFormatWithAddress$1(ref);
            }
            throw new IllegalArgumentException(new StringBuilder(125).append("ActorRefResolver for ActorSystem [").append(this.classicSystem.provider().getDefaultAddress()).append("] shouldn't be used for ").append("serialization of ActorRef that originates from another ActorSystem ").append(new StringBuilder(53).append("[").append(originSystem.provider().getDefaultAddress()).append("]. Use the ActorRefResolver for that system instead.").toString()).toString());
        }
        return this.toSerializationFormatWithAddress$1(ref);
    }

    @Override
    public <T> org.apache.pekko.actor.typed.ActorRef<T> resolveActorRef(String serializedActorRef) {
        ActorRef ref = this.classicSystem.provider().resolveActorRef(serializedActorRef);
        if (ref == this.classicSystem.provider().ignoreRef()) {
            return package$ClassicActorSystemOps$.MODULE$.toTyped$extension(package$.MODULE$.ClassicActorSystemOps(this.classicSystem)).ignoreRef();
        }
        return package$.MODULE$.actorRefAdapter(ref);
    }

    private final String toSerializationFormatWithAddress$1(org.apache.pekko.actor.typed.ActorRef ref$1) {
        return ref$1.path().toSerializationFormatWithAddress(this.system.address());
    }
}

