/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.dungeon;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorInterruptedException;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefScope;
import org.apache.pekko.actor.ChildRestartStats;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.PostRestartException$;
import org.apache.pekko.actor.PreRestartException;
import org.apache.pekko.actor.PreRestartException$;
import org.apache.pekko.actor.dungeon.ChildrenContainer;
import org.apache.pekko.actor.dungeon.ChildrenContainer$Creation$;
import org.apache.pekko.actor.dungeon.ChildrenContainer$Recreation$;
import org.apache.pekko.actor.dungeon.ChildrenContainer$Termination$;
import org.apache.pekko.actor.dungeon.FaultHandling$FailedFatally$;
import org.apache.pekko.actor.dungeon.FaultHandling$FailedRef$;
import org.apache.pekko.actor.dungeon.FaultHandling$NoFailedInfo$;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.dispatch.Envelope$;
import org.apache.pekko.dispatch.sysmsg.DeathWatchNotification$;
import org.apache.pekko.dispatch.sysmsg.Failed;
import org.apache.pekko.dispatch.sysmsg.Failed$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.Logging$Debug$;
import org.apache.pekko.event.Logging$Error$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public interface FaultHandling {
    public static void $init$(FaultHandling $this) {
        $this.org$apache$pekko$actor$dungeon$FaultHandling$$_failed_$eq(FaultHandling$NoFailedInfo$.MODULE$);
    }

    private void suspendNonRecursive() {
        ((ActorCell)this).dispatcher().suspend((ActorCell)this);
    }

    private void resumeNonRecursive() {
        ((ActorCell)this).dispatcher().resume((ActorCell)this);
    }

    public FailedInfo org$apache$pekko$actor$dungeon$FaultHandling$$_failed();

    public void org$apache$pekko$actor$dungeon$FaultHandling$$_failed_$eq(FailedInfo var1);

    private boolean isFailed() {
        return this.org$apache$pekko$actor$dungeon$FaultHandling$$_failed() instanceof FailedRef;
    }

    private boolean isFailedFatally() {
        return this.org$apache$pekko$actor$dungeon$FaultHandling$$_failed() == FaultHandling$FailedFatally$.MODULE$;
    }

    private ActorRef perpetrator() {
        FailedInfo failedInfo = this.org$apache$pekko$actor$dungeon$FaultHandling$$_failed();
        if (failedInfo instanceof FailedRef) {
            ActorRef actorRef;
            FailedRef failedRef = FaultHandling$FailedRef$.MODULE$.unapply((FailedRef)failedInfo);
            ActorRef ref = actorRef = failedRef._1();
            return ref;
        }
        return null;
    }

    public static void setFailed$(FaultHandling $this, ActorRef perpetrator) {
        $this.setFailed(perpetrator);
    }

    default public void setFailed(ActorRef perpetrator) {
        FailedInfo failedInfo = this.org$apache$pekko$actor$dungeon$FaultHandling$$_failed();
        this.org$apache$pekko$actor$dungeon$FaultHandling$$_failed_$eq(FaultHandling$FailedFatally$.MODULE$.equals(failedInfo) ? FaultHandling$FailedFatally$.MODULE$ : FaultHandling$FailedRef$.MODULE$.apply(perpetrator));
    }

    private void clearFailed() {
        FailedInfo failedInfo;
        FailedInfo failedInfo2 = this.org$apache$pekko$actor$dungeon$FaultHandling$$_failed();
        if (failedInfo2 instanceof FailedRef) {
            FailedRef failedRef = FaultHandling$FailedRef$.MODULE$.unapply((FailedRef)failedInfo2);
            ActorRef actorRef = failedRef._1();
            failedInfo = FaultHandling$NoFailedInfo$.MODULE$;
        } else {
            FailedInfo other;
            failedInfo = other = failedInfo2;
        }
        this.org$apache$pekko$actor$dungeon$FaultHandling$$_failed_$eq(failedInfo);
    }

    public static void setFailedFatally$(FaultHandling $this) {
        $this.setFailedFatally();
    }

    default public void setFailedFatally() {
        this.org$apache$pekko$actor$dungeon$FaultHandling$$_failed_$eq(FaultHandling$FailedFatally$.MODULE$);
    }

    public static void faultRecreate$(FaultHandling $this, Throwable cause) {
        $this.faultRecreate(cause);
    }

    default public void faultRecreate(Throwable cause) {
        if (((ActorCell)this).actor() == null) {
            ((ActorCell)this).system().eventStream().publish(Logging$Error$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), new StringBuilder(36).append("changing Recreate into Create after ").append(cause).toString()));
            this.faultCreate();
            return;
        }
        if (((ActorCell)this).isNormal()) {
            block13: {
                Actor failedActor = ((ActorCell)this).actor();
                if (((ActorCell)this).system().settings().DebugLifecycle()) {
                    ((ActorCell)this).publish(Logging$Debug$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(failedActor), "restarting"));
                }
                if (failedActor != null) {
                    None$ optionalMessage = ((ActorCell)this).currentMessage() != null ? Some$.MODULE$.apply(((ActorCell)this).currentMessage().message()) : None$.MODULE$;
                    try {
                        try {
                            if (!this.isFailedFatally()) {
                                failedActor.aroundPreRestart(cause, optionalMessage);
                            }
                        }
                        catch (Throwable ex$) {
                            PartialFunction<Throwable, BoxedUnit> $1$ = this.handleNonFatalOrInterruptedException(e -> {
                                PreRestartException ex = PreRestartException$.MODULE$.apply(((ActorCell)this).self(), (Throwable)e, cause, optionalMessage);
                                ((ActorCell)this).publish(Logging$Error$.MODULE$.apply(ex, ((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(failedActor), e.getMessage()));
                            });
                            if ($1$.isDefinedAt(ex$)) {
                                $1$.apply(ex$);
                                break block13;
                            }
                            throw ex$;
                        }
                    }
                    finally {
                        ((ActorCell)this).clearActorFields(failedActor, true);
                    }
                }
            }
            if (!((ActorCell)this).mailbox().isSuspended()) {
                throw Scala3RunTime$.MODULE$.assertFailed(new StringBuilder(49).append("mailbox must be suspended during restart, status=").append(((ActorCell)this).mailbox().currentStatus()).toString());
            }
            if (!((ActorCell)this).setChildrenTerminationReason(ChildrenContainer$Recreation$.MODULE$.apply(cause))) {
                this.finishRecreate(cause);
                return;
            }
            return;
        }
        this.faultResume(null);
    }

    public static void faultSuspend$(FaultHandling $this) {
        $this.faultSuspend();
    }

    default public void faultSuspend() {
        this.suspendNonRecursive();
        ((ActorCell)this).suspendChildren(((ActorCell)this).suspendChildren$default$1());
    }

    public static void faultResume$(FaultHandling $this, Throwable causedByFailure) {
        $this.faultResume(causedByFailure);
    }

    default public void faultResume(Throwable causedByFailure) {
        if (((ActorCell)this).actor() == null) {
            ((ActorCell)this).system().eventStream().publish(Logging$Error$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), new StringBuilder(34).append("changing Resume into Create after ").append(causedByFailure).toString()));
            this.faultCreate();
            return;
        }
        if (this.isFailedFatally() && causedByFailure != null) {
            ((ActorCell)this).system().eventStream().publish(Logging$Error$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), new StringBuilder(35).append("changing Resume into Restart after ").append(causedByFailure).toString()));
            this.faultRecreate(causedByFailure);
            return;
        }
        ActorRef perp = this.perpetrator();
        try {
            this.resumeNonRecursive();
        }
        finally {
            if (causedByFailure != null) {
                this.clearFailed();
            }
        }
        ((ActorCell)this).resumeChildren(causedByFailure, perp);
    }

    public static void faultCreate$(FaultHandling $this) {
        $this.faultCreate();
    }

    default public void faultCreate() {
        if (!((ActorCell)this).mailbox().isSuspended()) {
            throw Scala3RunTime$.MODULE$.assertFailed(new StringBuilder(57).append("mailbox must be suspended during failed creation, status=").append(((ActorCell)this).mailbox().currentStatus()).toString());
        }
        ActorRef actorRef = this.perpetrator();
        InternalActorRef internalActorRef = ((ActorCell)this).self();
        if (actorRef == null ? internalActorRef != null : !((Object)actorRef).equals(internalActorRef)) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        ((ActorCell)this).cancelReceiveTimeout();
        ((ActorCell)this).cancelReceiveTimeoutTask();
        ((ActorCell)this).children().foreach(actor -> ((ActorCell)this).stop((ActorRef)actor));
        if (!((ActorCell)this).setChildrenTerminationReason(ChildrenContainer$Creation$.MODULE$.apply())) {
            this.finishCreate();
            return;
        }
    }

    private void finishCreate() {
        try {
            this.resumeNonRecursive();
        }
        finally {
            this.clearFailed();
        }
        try {
            ((ActorCell)this).create(None$.MODULE$);
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $2$ = this.handleNonFatalOrInterruptedException(e -> this.handleInvokeFailure(package$.MODULE$.Nil(), (Throwable)e));
            if ($2$.isDefinedAt(ex$)) {
                $2$.apply(ex$);
            }
            throw ex$;
        }
    }

    public static void terminate$(FaultHandling $this) {
        $this.terminate();
    }

    default public void terminate() {
        ((ActorCell)this).cancelReceiveTimeout();
        ((ActorCell)this).cancelReceiveTimeoutTask();
        ((ActorCell)this).unwatchWatchedActors(((ActorCell)this).actor());
        ((ActorCell)this).children().foreach(actor -> ((ActorCell)this).stop((ActorRef)actor));
        if (((ActorCell)this).systemImpl().aborting()) {
            ((ActorCell)this).children().foreach(x$1 -> {
                ActorRef ref;
                ActorRef actorRef = x$1;
                if (actorRef instanceof ActorRefScope && !((ActorRefScope)((Object)(ref = (ActorRef)((Object)((ActorRefScope)((Object)actorRef)))))).isLocal()) {
                    ((ActorCell)this).self().sendSystemMessage(DeathWatchNotification$.MODULE$.apply(ref, true, false));
                    return;
                }
            });
        }
        boolean wasTerminating = ((ActorCell)this).isTerminating();
        if (((ActorCell)this).setChildrenTerminationReason(ChildrenContainer$Termination$.MODULE$)) {
            if (!wasTerminating) {
                this.suspendNonRecursive();
                this.setFailed(((ActorCell)this).self());
                if (((ActorCell)this).system().settings().DebugLifecycle()) {
                    ((ActorCell)this).publish(Logging$Debug$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), "stopping"));
                    return;
                }
                return;
            }
            return;
        }
        ((ActorCell)this).setTerminated();
        this.finishTerminate();
    }

    public static void handleInvokeFailure$(FaultHandling $this, Iterable childrenNotToSuspend, Throwable t) {
        $this.handleInvokeFailure(childrenNotToSuspend, t);
    }

    /*
     * Unable to fully structure code
     */
    @InternalStableApi
    default public void handleInvokeFailure(Iterable<ActorRef> childrenNotToSuspend, Throwable t) {
        try {
            this.suspendNonRecursive();
            var4_3 = ((ActorCell)this).currentMessage();
            if (var4_3 == null) ** GOTO lbl-1000
            var5_4 = Envelope$.MODULE$.unapply(var4_3);
            var6_5 = var5_4._1();
            var7_6 = var5_4._2();
            if (!(var6_5 instanceof Failed)) ** GOTO lbl-1000
            var8_7 = Failed$.MODULE$.unapply((Failed)var6_5);
            var9_8 = var8_7._1();
            var10_9 = var8_7._2();
            var11_10 = var8_7._3();
            child = var7_6;
            if (!this.isFailed()) {
                this.setFailed(child);
                v0 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new ActorRef[]{child}));
            } else if (!this.isFailed()) {
                this.setFailed(((ActorCell)this).self());
                v0 = Predef$.MODULE$.Set().empty();
            } else {
                v0 = Predef$.MODULE$.Set().empty();
            }
            skip = v0;
            ((ActorCell)this).suspendChildren((Set)skip.$plus$plus(childrenNotToSuspend));
            var13_13 = t;
            if (var13_13 instanceof InterruptedException) {
                ((ActorCell)this).parent().sendSystemMessage(Failed$.MODULE$.apply(((ActorCell)this).self(), new ActorInterruptedException(t), ((ActorCell)this).uid()));
            } else {
                ((ActorCell)this).parent().sendSystemMessage(Failed$.MODULE$.apply(((ActorCell)this).self(), t, ((ActorCell)this).uid()));
            }
        }
        catch (Throwable ex$) {
            $3$ = this.handleNonFatalOrInterruptedException((JProcedure1<Throwable>)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, $anonfun$3(java.lang.Throwable java.lang.Throwable ), (Ljava/lang/Throwable;)V)((FaultHandling)this, (Throwable)t));
            if ($3$.isDefinedAt(ex$)) {
                $3$.apply(ex$);
            }
            throw ex$;
        }
    }

    private void finishTerminate() {
        block137: {
            Actor a = ((ActorCell)this).actor();
            try {
                try {
                    if (a != null) {
                        a.aroundPostStop();
                    }
                }
                catch (Throwable ex$) {
                    PartialFunction<Throwable, BoxedUnit> $4$ = this.handleNonFatalOrInterruptedException(e -> ((ActorCell)this).publish(Logging$Error$.MODULE$.apply((Throwable)e, ((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(a), e.getMessage())));
                    if ($4$.isDefinedAt(ex$)) {
                        $4$.apply(ex$);
                        break block137;
                    }
                    throw ex$;
                }
            }
            finally {
                try {
                    ((ActorCell)this).stopFunctionRefs();
                }
                finally {
                    try {
                        ((ActorCell)this).dispatcher().detach((ActorCell)this);
                    }
                    finally {
                        try {
                            ((ActorCell)this).parent().sendSystemMessage(DeathWatchNotification$.MODULE$.apply(((ActorCell)this).self(), true, false));
                        }
                        finally {
                            try {
                                ((ActorCell)this).tellWatchersWeDied();
                            }
                            finally {
                                try {
                                    ((ActorCell)this).unwatchWatchedActors(a);
                                }
                                finally {
                                    if (((ActorCell)this).system().settings().DebugLifecycle()) {
                                        ((ActorCell)this).publish(Logging$Debug$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(a), "stopped"));
                                    }
                                    ((ActorCell)this).clearActorFields(a, false);
                                    ((ActorCell)this).clearFieldsForTermination();
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void finishRecreate(Throwable cause) {
        Iterable survivors = ((ActorCell)this).children();
        try {
            try {
                this.resumeNonRecursive();
            }
            finally {
                this.clearFailed();
            }
            Actor freshActor = ((ActorCell)this).newActor();
            freshActor.aroundPostRestart(cause);
            ((ActorCell)this).checkReceiveTimeout(true);
            if (((ActorCell)this).system().settings().DebugLifecycle()) {
                ((ActorCell)this).publish(Logging$Debug$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(freshActor), "restarted"));
            }
            survivors.foreach(child -> {
                try {
                    ((InternalActorRef)child).restart(cause);
                }
                catch (Throwable ex$) {
                    PartialFunction<Throwable, BoxedUnit> $6$ = this.handleNonFatalOrInterruptedException(e -> ((ActorCell)this).publish(Logging$Error$.MODULE$.apply((Throwable)e, ((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(freshActor), new StringBuilder(11).append("restarting ").append(child).toString())));
                    if ($6$.isDefinedAt(ex$)) {
                        $6$.apply(ex$);
                    }
                    throw ex$;
                }
            });
        }
        catch (Throwable ex$) {
            PartialFunction<Throwable, BoxedUnit> $5$ = this.handleNonFatalOrInterruptedException(e -> {
                this.setFailedFatally();
                ((ActorCell)this).clearActorFields(((ActorCell)this).actor(), false);
                this.handleInvokeFailure(survivors, PostRestartException$.MODULE$.apply(((ActorCell)this).self(), (Throwable)e, cause));
            });
            if ($5$.isDefinedAt(ex$)) {
                $5$.apply(ex$);
            }
            throw ex$;
        }
    }

    public static void handleFailure$(FaultHandling $this, Failed f) {
        $this.handleFailure(f);
    }

    default public void handleFailure(Failed f) {
        ((ActorCell)this).currentMessage_$eq(Envelope$.MODULE$.apply(f, f.child(), ((ActorCell)this).system()));
        Option option = ((ActorCell)this).getChildByRef(f.child());
        if (option instanceof Some) {
            ChildRestartStats childRestartStats = (ChildRestartStats)((Some)option).value();
            ChildRestartStats stats = childRestartStats;
            if (stats.uid() == f.uid()) {
                if (!((ActorCell)this).actor().supervisorStrategy().handleFailure((ActorContext)((Object)this), f.child(), f.cause(), stats, ((ActorCell)this).getAllChildStats())) {
                    throw f.cause();
                }
                return;
            }
            ChildRestartStats stats2 = childRestartStats;
            ((ActorCell)this).publish(Logging$Debug$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), new StringBuilder(44).append("dropping Failed(").append(f.cause()).append(") from old child ").append(f.child()).append(" (uid=").append(stats2.uid()).append(" != ").append(f.uid()).append(")").toString()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            ((ActorCell)this).publish(Logging$Debug$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), new StringBuilder(37).append("dropping Failed(").append(f.cause()).append(") from unknown child ").append(f.child()).toString()));
            return;
        }
        throw new MatchError(option);
    }

    public static void handleChildTerminated$(FaultHandling $this, ActorRef child) {
        $this.handleChildTerminated(child);
    }

    default public void handleChildTerminated(ActorRef child) {
        Option option;
        Option status = ((ActorCell)this).removeChildAndGetStateChange(child);
        if (((ActorCell)this).actor() != null) {
            try {
                ((ActorCell)this).actor().supervisorStrategy().handleChildTerminated((ActorContext)((Object)this), child, ((ActorCell)this).children());
            }
            catch (Throwable ex$) {
                PartialFunction<Throwable, BoxedUnit> $7$ = this.handleNonFatalOrInterruptedException(e -> {
                    ((ActorCell)this).publish(Logging$Error$.MODULE$.apply((Throwable)e, ((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), "handleChildTerminated failed"));
                    this.handleInvokeFailure(package$.MODULE$.Nil(), (Throwable)e);
                });
                if ($7$.isDefinedAt(ex$)) {
                    $7$.apply(ex$);
                }
                throw ex$;
            }
        }
        if ((option = status) instanceof Some) {
            ChildrenContainer.SuspendReason suspendReason = (ChildrenContainer.SuspendReason)((Some)option).value();
            if (suspendReason instanceof ChildrenContainer.Recreation) {
                Throwable throwable;
                ChildrenContainer.Recreation recreation = ChildrenContainer$Recreation$.MODULE$.unapply((ChildrenContainer.Recreation)suspendReason);
                Throwable cause = throwable = recreation._1();
                this.finishRecreate(cause);
                return;
            }
            if (suspendReason instanceof ChildrenContainer.Creation && ChildrenContainer$Creation$.MODULE$.unapply((ChildrenContainer.Creation)suspendReason)) {
                this.finishCreate();
                return;
            }
            if (ChildrenContainer$Termination$.MODULE$.equals(suspendReason)) {
                this.finishTerminate();
                return;
            }
        }
    }

    public static PartialFunction handleNonFatalOrInterruptedException$(FaultHandling $this, Function1 thunk) {
        return $this.handleNonFatalOrInterruptedException(thunk);
    }

    default public PartialFunction<Throwable, BoxedUnit> handleNonFatalOrInterruptedException(Function1<Throwable, BoxedUnit> thunk) {
        return new Serializable(thunk){
            private final Function1 thunk$1;
            {
                this.thunk$1 = thunk$2;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option<Throwable> option;
                Throwable throwable = x;
                if (throwable instanceof InterruptedException) {
                    InterruptedException e = (InterruptedException)throwable;
                    return true;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = option.get();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option<Throwable> option;
                Throwable throwable = x;
                if (throwable instanceof InterruptedException) {
                    InterruptedException e = (InterruptedException)throwable;
                    this.thunk$1.apply(e);
                    Thread.currentThread().interrupt();
                    return BoxedUnit.UNIT;
                }
                if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable e = throwable2 = option.get();
                    return this.thunk$1.apply(e);
                }
                return function1.apply(x);
            }
        };
    }

    private /* synthetic */ void $anonfun$3(Throwable t$1, Throwable e) {
        ((ActorCell)this).publish(Logging$Error$.MODULE$.apply(e, ((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), new StringBuilder(50).append("emergency stop: exception in failure handling for ").append(t$1.getClass()).append(Logging$.MODULE$.stackTraceFor(t$1)).toString()));
        try {
            ((ActorCell)this).children().foreach(actor -> ((ActorCell)this).stop((ActorRef)actor));
        }
        finally {
            this.finishTerminate();
        }
    }

    public static interface FailedInfo {
    }

    public static final class FailedRef
    implements FailedInfo,
    Product,
    Serializable {
        private final ActorRef ref;

        public static FailedRef apply(ActorRef actorRef) {
            return FaultHandling$FailedRef$.MODULE$.apply(actorRef);
        }

        public static FailedRef fromProduct(Product product) {
            return FaultHandling$FailedRef$.MODULE$.fromProduct(product);
        }

        public static FailedRef unapply(FailedRef failedRef) {
            return FaultHandling$FailedRef$.MODULE$.unapply(failedRef);
        }

        public FailedRef(ActorRef ref) {
            this.ref = ref;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FailedRef)) return false;
            FailedRef failedRef = (FailedRef)object;
            ActorRef actorRef = this.ref();
            ActorRef actorRef2 = failedRef.ref();
            if (actorRef != null) {
                if (!((Object)actorRef).equals(actorRef2)) return false;
                return true;
            }
            if (actorRef2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof FailedRef;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "FailedRef";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "ref";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorRef ref() {
            return this.ref;
        }

        public FailedRef copy(ActorRef ref) {
            return new FailedRef(ref);
        }

        public ActorRef copy$default$1() {
            return this.ref();
        }

        public ActorRef _1() {
            return this.ref();
        }
    }
}

