/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.dungeon;

import java.io.Serializable;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorCell$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefScope;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.sysmsg.DeathWatchNotification$;
import org.apache.pekko.dispatch.sysmsg.Unwatch$;
import org.apache.pekko.dispatch.sysmsg.Watch$;
import org.apache.pekko.event.AddressTerminatedTopic;
import org.apache.pekko.event.AddressTerminatedTopic$;
import org.apache.pekko.event.Logging$Debug$;
import org.apache.pekko.event.Logging$Warning$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public interface DeathWatch {
    public static void $init$(DeathWatch $this) {
        $this.org$apache$pekko$actor$dungeon$DeathWatch$$watching_$eq((Map<ActorRef, Option<Object>>)Predef$.MODULE$.Map().empty());
        $this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy_$eq(ActorCell$.MODULE$.emptyActorRefSet());
        $this.org$apache$pekko$actor$dungeon$DeathWatch$$terminatedQueued_$eq((Map<ActorRef, Option<Object>>)Predef$.MODULE$.Map().empty());
    }

    public Map<ActorRef, Option<Object>> org$apache$pekko$actor$dungeon$DeathWatch$$watching();

    public void org$apache$pekko$actor$dungeon$DeathWatch$$watching_$eq(Map<ActorRef, Option<Object>> var1);

    public Set<ActorRef> org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy();

    public void org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy_$eq(Set<ActorRef> var1);

    public Map<ActorRef, Option<Object>> org$apache$pekko$actor$dungeon$DeathWatch$$terminatedQueued();

    public void org$apache$pekko$actor$dungeon$DeathWatch$$terminatedQueued_$eq(Map<ActorRef, Option<Object>> var1);

    public static boolean isWatching$(DeathWatch $this, ActorRef ref) {
        return $this.isWatching(ref);
    }

    default public boolean isWatching(ActorRef ref) {
        return this.org$apache$pekko$actor$dungeon$DeathWatch$$watching().contains(ref);
    }

    public static ActorRef watch$(DeathWatch $this, ActorRef subject) {
        return $this.watch(subject);
    }

    default public ActorRef watch(ActorRef subject) {
        ActorRef actorRef = subject;
        if (actorRef instanceof InternalActorRef) {
            InternalActorRef a;
            InternalActorRef internalActorRef = a = (InternalActorRef)actorRef;
            InternalActorRef internalActorRef2 = ((ActorCell)this).self();
            if (internalActorRef == null ? internalActorRef2 != null : !((Object)internalActorRef).equals(internalActorRef2)) {
                if (!this.org$apache$pekko$actor$dungeon$DeathWatch$$watching().contains(a)) {
                    this.maintainAddressTerminatedSubscription(a, (Function0<Object> & Serializable)() -> {
                        this.watch$$anonfun$1(a);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    this.checkWatchingSame(a, None$.MODULE$);
                }
            }
            return a;
        }
        ActorRef unexpected = actorRef;
        throw new IllegalArgumentException(new StringBuilder(26).append("ActorRef is not internal: ").append(unexpected).toString());
    }

    public static ActorRef watchWith$(DeathWatch $this, ActorRef subject, Object msg) {
        return $this.watchWith(subject, msg);
    }

    default public ActorRef watchWith(ActorRef subject, Object msg) {
        ActorRef actorRef = subject;
        if (actorRef instanceof InternalActorRef) {
            InternalActorRef a;
            InternalActorRef internalActorRef = a = (InternalActorRef)actorRef;
            InternalActorRef internalActorRef2 = ((ActorCell)this).self();
            if (internalActorRef == null ? internalActorRef2 != null : !((Object)internalActorRef).equals(internalActorRef2)) {
                if (!this.org$apache$pekko$actor$dungeon$DeathWatch$$watching().contains(a)) {
                    this.maintainAddressTerminatedSubscription(a, (Function0<Object> & Serializable)() -> {
                        this.watchWith$$anonfun$1(a, msg);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    this.checkWatchingSame(a, Some$.MODULE$.apply(msg));
                }
            }
            return a;
        }
        ActorRef unexpected = actorRef;
        throw new IllegalArgumentException(new StringBuilder(26).append("ActorRef is not internal: ").append(unexpected).toString());
    }

    public static ActorRef unwatch$(DeathWatch $this, ActorRef subject) {
        return $this.unwatch(subject);
    }

    default public ActorRef unwatch(ActorRef subject) {
        ActorRef actorRef = subject;
        if (actorRef instanceof InternalActorRef) {
            InternalActorRef a;
            InternalActorRef internalActorRef = a = (InternalActorRef)actorRef;
            InternalActorRef internalActorRef2 = ((ActorCell)this).self();
            if ((internalActorRef == null ? internalActorRef2 != null : !((Object)internalActorRef).equals(internalActorRef2)) && this.org$apache$pekko$actor$dungeon$DeathWatch$$watching().contains(a)) {
                a.sendSystemMessage(Unwatch$.MODULE$.apply(a, ((ActorCell)this).self()));
                this.maintainAddressTerminatedSubscription(a, (Function0<Object> & Serializable)() -> {
                    this.unwatch$$anonfun$1(a);
                    return BoxedUnit.UNIT;
                });
            }
            this.org$apache$pekko$actor$dungeon$DeathWatch$$terminatedQueued_$eq((Map)this.org$apache$pekko$actor$dungeon$DeathWatch$$terminatedQueued().$minus(a));
            return a;
        }
        ActorRef unexpected = actorRef;
        throw new IllegalArgumentException(new StringBuilder(26).append("ActorRef is not internal: ").append(unexpected).toString());
    }

    public static void receivedTerminated$(DeathWatch $this, Terminated t) {
        $this.receivedTerminated(t);
    }

    default public void receivedTerminated(Terminated t) {
        this.org$apache$pekko$actor$dungeon$DeathWatch$$terminatedQueued().get(t.actor()).foreach(optionalMessage -> {
            this.org$apache$pekko$actor$dungeon$DeathWatch$$terminatedQueued_$eq((Map)this.org$apache$pekko$actor$dungeon$DeathWatch$$terminatedQueued().$minus(t.actor()));
            Option option = optionalMessage;
            if (option instanceof Some) {
                Object customTermination = ((Some)option).value();
                Envelope envelope = ((ActorCell)this).currentMessage();
                ((ActorCell)this).currentMessage_$eq(envelope.copy(customTermination, envelope.copy$default$2()));
                ((ActorCell)this).receiveMessage(customTermination);
                return;
            }
            if (None$.MODULE$.equals(option)) {
                ((ActorCell)this).receiveMessage(t);
                return;
            }
            throw new MatchError(option);
        });
    }

    public static void watchedActorTerminated$(DeathWatch $this, ActorRef actor, boolean existenceConfirmed, boolean addressTerminated) {
        $this.watchedActorTerminated(actor, existenceConfirmed, addressTerminated);
    }

    default public void watchedActorTerminated(ActorRef actor, boolean existenceConfirmed, boolean addressTerminated) {
        Option option = this.org$apache$pekko$actor$dungeon$DeathWatch$$watching().get(actor);
        if (!None$.MODULE$.equals(option)) {
            if (option instanceof Some) {
                Option optionalMessage = (Option)((Some)option).value();
                this.maintainAddressTerminatedSubscription(actor, (Function0<Object> & Serializable)() -> {
                    this.watchedActorTerminated$$anonfun$1(actor);
                    return BoxedUnit.UNIT;
                });
                if (!((ActorCell)this).isTerminating()) {
                    ((ActorCell)this).self().tell(Terminated$.MODULE$.apply(actor, existenceConfirmed, addressTerminated), actor);
                    this.terminatedQueuedFor(actor, optionalMessage);
                }
            } else {
                throw new MatchError(option);
            }
        }
        if (((ActorCell)this).childrenRefs().getByRef(actor).isDefined()) {
            ((ActorCell)this).handleChildTerminated(actor);
            return;
        }
    }

    public static void terminatedQueuedFor$(DeathWatch $this, ActorRef subject, Option customMessage) {
        $this.terminatedQueuedFor(subject, customMessage);
    }

    default public void terminatedQueuedFor(ActorRef subject, Option<Object> customMessage) {
        if (!this.org$apache$pekko$actor$dungeon$DeathWatch$$terminatedQueued().contains(subject)) {
            ActorRef actorRef = Predef$.MODULE$.ArrowAssoc(subject);
            this.org$apache$pekko$actor$dungeon$DeathWatch$$terminatedQueued_$eq((Map)this.org$apache$pekko$actor$dungeon$DeathWatch$$terminatedQueued().$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(actorRef, customMessage)));
            return;
        }
    }

    private void updateWatching(InternalActorRef ref, Option<Object> newMessage) {
        this.org$apache$pekko$actor$dungeon$DeathWatch$$watching_$eq((Map)this.org$apache$pekko$actor$dungeon$DeathWatch$$watching().updated(ref, newMessage));
    }

    private void checkWatchingSame(InternalActorRef ref, Option<Object> newMessage) {
        Option previous;
        Option option = previous = (Option)this.org$apache$pekko$actor$dungeon$DeathWatch$$watching().apply(ref);
        Option<Object> option2 = newMessage;
        if (option == null ? option2 != null : !option.equals(option2)) {
            throw new IllegalStateException(new StringBuilder(157).append("Watch(").append(((ActorCell)this).self()).append(", ").append(ref).append(") termination message was not overwritten from [").append(previous).append("] to [").append(newMessage).append("]. ").append("If this was intended, unwatch first before using `watch` / `watchWith` with another message.").toString());
        }
    }

    public static void tellWatchersWeDied$(DeathWatch $this) {
        $this.tellWatchersWeDied();
    }

    default public void tellWatchersWeDied() {
        if (this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy().nonEmpty()) {
            try {
                this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy().foreach(watcher -> this.sendTerminated$1(false, (ActorRef)watcher));
                this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy().foreach(watcher -> this.sendTerminated$1(true, (ActorRef)watcher));
            }
            finally {
                this.maintainAddressTerminatedSubscription(this.maintainAddressTerminatedSubscription$default$1(), (Function0<Object> & Serializable)() -> {
                    this.tellWatchersWeDied$$anonfun$3();
                    return BoxedUnit.UNIT;
                });
            }
            return;
        }
    }

    public static void unwatchWatchedActors$(DeathWatch $this, Actor actor) {
        $this.unwatchWatchedActors(actor);
    }

    default public void unwatchWatchedActors(Actor actor) {
        if (this.org$apache$pekko$actor$dungeon$DeathWatch$$watching().nonEmpty()) {
            this.maintainAddressTerminatedSubscription(this.maintainAddressTerminatedSubscription$default$1(), (Function0<Object> & Serializable)() -> {
                this.unwatchWatchedActors$$anonfun$1();
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static void addWatcher$(DeathWatch $this, ActorRef watchee, ActorRef watcher) {
        $this.addWatcher(watchee, watcher);
    }

    default public void addWatcher(ActorRef watchee, ActorRef watcher) {
        boolean watcherSelf;
        ActorRef actorRef = watchee;
        InternalActorRef internalActorRef = ((ActorCell)this).self();
        boolean watcheeSelf = !(actorRef != null ? !((Object)actorRef).equals(internalActorRef) : internalActorRef != null);
        ActorRef actorRef2 = watcher;
        InternalActorRef internalActorRef2 = ((ActorCell)this).self();
        boolean bl = !(actorRef2 != null ? !((Object)actorRef2).equals(internalActorRef2) : internalActorRef2 != null) ? true : (watcherSelf = false);
        if (watcheeSelf && !watcherSelf) {
            if (!this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy().contains(watcher)) {
                this.maintainAddressTerminatedSubscription(watcher, (Function0<Object> & Serializable)() -> {
                    this.addWatcher$$anonfun$1(watcher);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
        if (!watcheeSelf && watcherSelf) {
            this.watch(watchee);
            return;
        }
        ((ActorCell)this).publish(Logging$Warning$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("BUG: illegal Watch(%s,%s) for %s"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{watchee, watcher, ((ActorCell)this).self()}))));
    }

    public static void remWatcher$(DeathWatch $this, ActorRef watchee, ActorRef watcher) {
        $this.remWatcher(watchee, watcher);
    }

    default public void remWatcher(ActorRef watchee, ActorRef watcher) {
        boolean watcherSelf;
        ActorRef actorRef = watchee;
        InternalActorRef internalActorRef = ((ActorCell)this).self();
        boolean watcheeSelf = !(actorRef != null ? !((Object)actorRef).equals(internalActorRef) : internalActorRef != null);
        ActorRef actorRef2 = watcher;
        InternalActorRef internalActorRef2 = ((ActorCell)this).self();
        boolean bl = !(actorRef2 != null ? !((Object)actorRef2).equals(internalActorRef2) : internalActorRef2 != null) ? true : (watcherSelf = false);
        if (watcheeSelf && !watcherSelf) {
            if (this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy().contains(watcher)) {
                this.maintainAddressTerminatedSubscription(watcher, (Function0<Object> & Serializable)() -> {
                    this.remWatcher$$anonfun$1(watcher);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
        if (!watcheeSelf && watcherSelf) {
            this.unwatch(watchee);
            return;
        }
        ((ActorCell)this).publish(Logging$Warning$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("BUG: illegal Unwatch(%s,%s) for %s"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{watchee, watcher, ((ActorCell)this).self()}))));
    }

    public static void addressTerminated$(DeathWatch $this, Address address) {
        $this.addressTerminated(address);
    }

    default public void addressTerminated(Address address) {
        this.maintainAddressTerminatedSubscription(this.maintainAddressTerminatedSubscription$default$1(), (Function0<Object> & Serializable)() -> {
            this.addressTerminated$$anonfun$1(address);
            return BoxedUnit.UNIT;
        });
        ((IterableOps.WithFilter)this.org$apache$pekko$actor$dungeon$DeathWatch$$watching().withFilter((Function1<Tuple2<ActorRef, Option<Object>>, Object>)(Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ActorRef a = (ActorRef)tuple2._1();
                return true;
            }
            return false;
        }).withFilter((Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ActorRef a = (ActorRef)tuple2._1();
                Address address = a.path().address();
                Address address2 = address;
                return !(address != null ? !((Object)address).equals(address2) : address2 != null);
            }
            throw new MatchError(tuple2);
        })).foreach(x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ActorRef a = (ActorRef)tuple2._1();
                ((ActorCell)this).self().sendSystemMessage(DeathWatchNotification$.MODULE$.apply(a, ((ActorCell)this).childrenRefs().getByRef(a).isDefined(), true));
                return;
            }
            throw new MatchError(tuple2);
        });
    }

    private <T> T maintainAddressTerminatedSubscription(ActorRef change, Function0<T> block) {
        if (DeathWatch.isNonLocal$1(change)) {
            boolean had = this.hasNonLocalAddress$1();
            T result = block.apply();
            boolean has = this.hasNonLocalAddress$1();
            if (had && !has) {
                this.unsubscribeAddressTerminated();
            } else if (!had && has) {
                this.subscribeAddressTerminated();
            }
            return result;
        }
        return block.apply();
    }

    private <T> ActorRef maintainAddressTerminatedSubscription$default$1() {
        return null;
    }

    private void unsubscribeAddressTerminated() {
        ((AddressTerminatedTopic)AddressTerminatedTopic$.MODULE$.apply(((ActorCell)this).system())).unsubscribe(((ActorCell)this).self());
    }

    private void subscribeAddressTerminated() {
        ((AddressTerminatedTopic)AddressTerminatedTopic$.MODULE$.apply(((ActorCell)this).system())).subscribe(((ActorCell)this).self());
    }

    private void watch$$anonfun$1(InternalActorRef a$1) {
        a$1.sendSystemMessage(Watch$.MODULE$.apply(a$1, ((ActorCell)this).self()));
        this.updateWatching(a$1, None$.MODULE$);
    }

    private void watchWith$$anonfun$1(InternalActorRef a$2, Object msg$1) {
        a$2.sendSystemMessage(Watch$.MODULE$.apply(a$2, ((ActorCell)this).self()));
        this.updateWatching(a$2, Some$.MODULE$.apply(msg$1));
    }

    private void unwatch$$anonfun$1(InternalActorRef a$3) {
        this.org$apache$pekko$actor$dungeon$DeathWatch$$watching_$eq((Map)this.org$apache$pekko$actor$dungeon$DeathWatch$$watching().$minus(a$3));
    }

    private void watchedActorTerminated$$anonfun$1(ActorRef actor$1) {
        this.org$apache$pekko$actor$dungeon$DeathWatch$$watching_$eq((Map)this.org$apache$pekko$actor$dungeon$DeathWatch$$watching().$minus(actor$1));
    }

    private void sendTerminated$1(boolean ifLocal, ActorRef watcher) {
        if (((ActorRefScope)((Object)watcher)).isLocal() == ifLocal) {
            ActorRef actorRef = watcher;
            InternalActorRef internalActorRef = ((ActorCell)this).parent();
            if (actorRef == null ? internalActorRef != null : !((Object)actorRef).equals(internalActorRef)) {
                ((InternalActorRef)watcher).sendSystemMessage(DeathWatchNotification$.MODULE$.apply(((ActorCell)this).self(), true, false));
                return;
            }
        }
    }

    private void tellWatchersWeDied$$anonfun$3() {
        this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy_$eq(ActorCell$.MODULE$.emptyActorRefSet());
    }

    private void unwatchWatchedActors$$anonfun$1() {
        try {
            this.org$apache$pekko$actor$dungeon$DeathWatch$$watching().foreach(x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    ActorRef actorRef = (ActorRef)tuple2._1();
                    if (actorRef instanceof InternalActorRef) {
                        InternalActorRef watchee = (InternalActorRef)actorRef;
                        watchee.sendSystemMessage(Unwatch$.MODULE$.apply(watchee, ((ActorCell)this).self()));
                        return;
                    }
                    ActorRef watchee = actorRef;
                    throw new IllegalStateException(new StringBuilder(37).append("Expected InternalActorRef, but got [").append(watchee.getClass().getName()).append("]").toString());
                }
                throw new MatchError(tuple2);
            });
        }
        finally {
            this.org$apache$pekko$actor$dungeon$DeathWatch$$watching_$eq((Map<ActorRef, Option<Object>>)Predef$.MODULE$.Map().empty());
            this.org$apache$pekko$actor$dungeon$DeathWatch$$terminatedQueued_$eq((Map<ActorRef, Option<Object>>)Predef$.MODULE$.Map().empty());
        }
    }

    private void addWatcher$$anonfun$1(ActorRef watcher$1) {
        this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy_$eq((Set)this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy().$plus(watcher$1));
        if (((ActorCell)this).system().settings().DebugLifecycle()) {
            ((ActorCell)this).publish(Logging$Debug$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), new StringBuilder(15).append("now watched by ").append(watcher$1).toString()));
            return;
        }
    }

    private void remWatcher$$anonfun$1(ActorRef watcher$2) {
        this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy_$eq((Set)this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy().$minus(watcher$2));
        if (((ActorCell)this).system().settings().DebugLifecycle()) {
            ((ActorCell)this).publish(Logging$Debug$.MODULE$.apply(((ActorCell)this).self().path().toString(), ((ActorCell)this).clazz(((ActorCell)this).actor()), new StringBuilder(21).append("no longer watched by ").append(watcher$2).toString()));
            return;
        }
    }

    private void addressTerminated$$anonfun$1(Address address$1) {
        this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy().withFilter((Function1<ActorRef, boolean> & Serializable)a -> {
            Address address = a.path().address();
            Address address2 = address$1;
            return !(address != null ? !((Object)address).equals(address2) : address2 != null);
        }).foreach(a -> this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy_$eq((Set)this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy().$minus((ActorRef)a)));
    }

    private static boolean isNonLocal$1(ActorRef ref) {
        InternalActorRef a;
        ActorRef actorRef = ref;
        if (actorRef == null) {
            return true;
        }
        return actorRef instanceof InternalActorRef && !(a = (InternalActorRef)actorRef).isLocal();
    }

    private boolean hasNonLocalAddress$1() {
        return this.org$apache$pekko$actor$dungeon$DeathWatch$$watching().keysIterator().exists((Function1<ActorRef, boolean> & Serializable)ref -> DeathWatch.isNonLocal$1(ref)) || this.org$apache$pekko$actor$dungeon$DeathWatch$$watchedBy().exists((Function1<ActorRef, boolean> & Serializable)ref -> DeathWatch.isNonLocal$1(ref));
    }
}

