/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import java.lang.reflect.InvocationTargetException;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorInitializationException;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ChildRestartStats;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.SupervisorStrategy$;
import org.apache.pekko.actor.SupervisorStrategy$Escalate$;
import org.apache.pekko.actor.SupervisorStrategy$Restart$;
import org.apache.pekko.actor.SupervisorStrategy$Resume$;
import org.apache.pekko.actor.SupervisorStrategy$Stop$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.Logging;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.Logging$Error$;
import org.apache.pekko.event.Logging$LogEvent$;
import org.apache.pekko.japi.Function;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.deriving.Mirror;
import scala.util.control.NonFatal$;

public abstract class SupervisorStrategy {
    public static PartialFunction<Throwable, Directive> defaultDecider() {
        return SupervisorStrategy$.MODULE$.defaultDecider();
    }

    public static SupervisorStrategy defaultStrategy() {
        return SupervisorStrategy$.MODULE$.defaultStrategy();
    }

    public static SupervisorStrategy$Escalate$ escalate() {
        return SupervisorStrategy$.MODULE$.escalate();
    }

    public static Function1<Object, SupervisorStrategy$Escalate$> escalateDefault() {
        return SupervisorStrategy$.MODULE$.escalateDefault();
    }

    public static PartialFunction<Throwable, Directive> makeDecider(Function<Throwable, Directive> function) {
        return SupervisorStrategy$.MODULE$.makeDecider(function);
    }

    public static PartialFunction<Throwable, Directive> makeDecider(Iterable<Tuple2<Class<? extends Throwable>, Directive>> iterable) {
        return SupervisorStrategy$.MODULE$.makeDecider(iterable);
    }

    public static PartialFunction<Throwable, Directive> makeDecider(java.lang.Iterable<Class<? extends Throwable>> iterable) {
        return SupervisorStrategy$.MODULE$.makeDecider(iterable);
    }

    public static PartialFunction<Throwable, Directive> makeDecider(Seq<Class<? extends Throwable>> seq) {
        return SupervisorStrategy$.MODULE$.makeDecider(seq);
    }

    public static Option<Object> maxNrOfRetriesOption(int n) {
        return SupervisorStrategy$.MODULE$.maxNrOfRetriesOption(n);
    }

    public static SupervisorStrategy$Restart$ restart() {
        return SupervisorStrategy$.MODULE$.restart();
    }

    public static Directive restart(int n) {
        return SupervisorStrategy$.MODULE$.restart(n);
    }

    public static SupervisorStrategy$Resume$ resume() {
        return SupervisorStrategy$.MODULE$.resume();
    }

    public static Directive resume(int n) {
        return SupervisorStrategy$.MODULE$.resume(n);
    }

    public static PartialFunction<Throwable, Directive> seqCauseDirective2Decider(Iterable<Tuple2<Class<? extends Throwable>, Directive>> iterable) {
        return SupervisorStrategy$.MODULE$.seqCauseDirective2Decider((Iterable)iterable);
    }

    public static PartialFunction<Throwable, Directive> seqThrowable2Decider(Seq<Class<? extends Throwable>> seq) {
        return SupervisorStrategy$.MODULE$.seqThrowable2Decider(seq);
    }

    public static Seq<Tuple2<Class<? extends Throwable>, Directive>> sort(Iterable<Tuple2<Class<? extends Throwable>, Directive>> iterable) {
        return SupervisorStrategy$.MODULE$.sort(iterable);
    }

    public static SupervisorStrategy$Stop$ stop() {
        return SupervisorStrategy$.MODULE$.stop();
    }

    public static Directive stop(int n) {
        return SupervisorStrategy$.MODULE$.stop(n);
    }

    public static SupervisorStrategy stoppingStrategy() {
        return SupervisorStrategy$.MODULE$.stoppingStrategy();
    }

    public static Option<Duration> withinTimeRangeOption(Duration duration) {
        return SupervisorStrategy$.MODULE$.withinTimeRangeOption(duration);
    }

    public abstract PartialFunction<Throwable, Directive> decider();

    public abstract void handleChildTerminated(ActorContext var1, ActorRef var2, Iterable<ActorRef> var3);

    public abstract void processFailure(ActorContext var1, boolean var2, ActorRef var3, Throwable var4, ChildRestartStats var5, Iterable<ChildRestartStats> var6);

    public boolean handleFailure(ActorContext context, ActorRef child, Throwable cause, ChildRestartStats stats, Iterable<ChildRestartStats> children) {
        Directive directive = this.decider().applyOrElse(cause, SupervisorStrategy$.MODULE$.escalateDefault());
        Directive directive2 = directive;
        if (directive2 instanceof Resume) {
            this.logFailure(context, child, cause, directive);
            this.resumeChild(child, cause);
            return true;
        }
        if (directive2 instanceof Restart) {
            this.logFailure(context, child, cause, directive);
            this.processFailure(context, true, child, cause, stats, children);
            return true;
        }
        if (directive2 instanceof Stop) {
            this.logFailure(context, child, cause, directive);
            this.processFailure(context, false, child, cause, stats, children);
            return true;
        }
        if (SupervisorStrategy$Escalate$.MODULE$.equals(directive2)) {
            this.logFailure(context, child, cause, directive);
            return false;
        }
        throw new MatchError(directive2);
    }

    public boolean loggingEnabled() {
        return true;
    }

    public void logFailure(ActorContext context, ActorRef child, Throwable cause, Directive decision) {
        if (this.loggingEnabled()) {
            String string2;
            ActorInitializationException e;
            Throwable throwable = cause;
            if (throwable instanceof ActorInitializationException && (e = (ActorInitializationException)throwable).getCause() != null) {
                InvocationTargetException ex;
                Throwable throwable2 = e.getCause();
                if (throwable2 instanceof InvocationTargetException && (ex = (InvocationTargetException)throwable2).getCause() != null) {
                    string2 = ex.getCause().getMessage();
                } else {
                    Throwable ex2 = throwable2;
                    string2 = ex2.getMessage();
                }
            } else {
                Throwable e2 = throwable;
                string2 = e2.getMessage();
            }
            String logMessage = string2;
            Directive directive = decision;
            if (SupervisorStrategy$Escalate$.MODULE$.equals(directive)) {
                return;
            }
            Directive d = directive;
            if (d.logLevel() == Logging$.MODULE$.ErrorLevel()) {
                this.publish(context, Logging$Error$.MODULE$.apply(cause, child.path().toString(), this.getClass(), logMessage));
                return;
            }
            this.publish(context, Logging$LogEvent$.MODULE$.apply(d.logLevel(), child.path().toString(), this.getClass(), logMessage));
            return;
        }
    }

    private void publish(ActorContext context, Logging.LogEvent logEvent) {
        try {
            context.system().eventStream().publish(logEvent);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = option.get();
            }
            throw throwable;
        }
    }

    public final void resumeChild(ActorRef child, Throwable cause) {
        ((InternalActorRef)child).resume(cause);
    }

    public final void restartChild(ActorRef child, Throwable cause, boolean suspendFirst) {
        InternalActorRef c = (InternalActorRef)child;
        if (suspendFirst) {
            c.suspend();
        }
        c.restart(cause);
    }

    public static interface Directive {
        @InternalApi
        public int logLevel();
    }

    @InternalApi
    public static class Restart
    implements Directive {
        private final int logLevel;

        public static boolean canEqual(Object object) {
            return SupervisorStrategy$Restart$.MODULE$.canEqual(object);
        }

        public static Mirror.Singleton fromProduct(Product product) {
            return SupervisorStrategy$Restart$.MODULE$.fromProduct(product);
        }

        public static int productArity() {
            return SupervisorStrategy$Restart$.MODULE$.productArity();
        }

        public static Object productElement(int n) {
            return SupervisorStrategy$Restart$.MODULE$.productElement(n);
        }

        public static String productElementName(int n) {
            return SupervisorStrategy$Restart$.MODULE$.productElementName(n);
        }

        public static Iterator<String> productElementNames() {
            return SupervisorStrategy$Restart$.MODULE$.productElementNames();
        }

        public static Iterator<Object> productIterator() {
            return SupervisorStrategy$Restart$.MODULE$.productIterator();
        }

        public static String productPrefix() {
            return SupervisorStrategy$Restart$.MODULE$.productPrefix();
        }

        public Restart(int logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public int logLevel() {
            return this.logLevel;
        }
    }

    @InternalApi
    public static class Resume
    implements Directive {
        private final int logLevel;

        public static boolean canEqual(Object object) {
            return SupervisorStrategy$Resume$.MODULE$.canEqual(object);
        }

        public static Mirror.Singleton fromProduct(Product product) {
            return SupervisorStrategy$Resume$.MODULE$.fromProduct(product);
        }

        public static int productArity() {
            return SupervisorStrategy$Resume$.MODULE$.productArity();
        }

        public static Object productElement(int n) {
            return SupervisorStrategy$Resume$.MODULE$.productElement(n);
        }

        public static String productElementName(int n) {
            return SupervisorStrategy$Resume$.MODULE$.productElementName(n);
        }

        public static Iterator<String> productElementNames() {
            return SupervisorStrategy$Resume$.MODULE$.productElementNames();
        }

        public static Iterator<Object> productIterator() {
            return SupervisorStrategy$Resume$.MODULE$.productIterator();
        }

        public static String productPrefix() {
            return SupervisorStrategy$Resume$.MODULE$.productPrefix();
        }

        public Resume(int logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public int logLevel() {
            return this.logLevel;
        }
    }

    @InternalApi
    public static class Stop
    implements Directive {
        private final int logLevel;

        public static boolean canEqual(Object object) {
            return SupervisorStrategy$Stop$.MODULE$.canEqual(object);
        }

        public static Mirror.Singleton fromProduct(Product product) {
            return SupervisorStrategy$Stop$.MODULE$.fromProduct(product);
        }

        public static int productArity() {
            return SupervisorStrategy$Stop$.MODULE$.productArity();
        }

        public static Object productElement(int n) {
            return SupervisorStrategy$Stop$.MODULE$.productElement(n);
        }

        public static String productElementName(int n) {
            return SupervisorStrategy$Stop$.MODULE$.productElementName(n);
        }

        public static Iterator<String> productElementNames() {
            return SupervisorStrategy$Stop$.MODULE$.productElementNames();
        }

        public static Iterator<Object> productIterator() {
            return SupervisorStrategy$Stop$.MODULE$.productIterator();
        }

        public static String productPrefix() {
            return SupervisorStrategy$Stop$.MODULE$.productPrefix();
        }

        public Stop(int logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public int logLevel() {
            return this.logLevel;
        }
    }
}

