/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import java.io.Serializable;
import org.apache.pekko.actor.ActorCell;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorInitializationException$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.StashOverflowException;
import org.apache.pekko.actor.StashOverflowException$;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.dispatch.DequeBasedMessageQueueSemantics;
import org.apache.pekko.dispatch.Envelope;
import org.apache.pekko.dispatch.MessageQueue;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;

public interface StashSupport {
    public static void $init$(StashSupport $this) {
        $this.org$apache$pekko$actor$StashSupport$$theStash_$eq((Vector<Envelope>)package$.MODULE$.Vector().empty());
        $this.org$apache$pekko$actor$StashSupport$_setter_$org$apache$pekko$actor$StashSupport$$capacity_$eq($this.context().system().mailboxes().stashCapacity($this.context().props().dispatcher(), $this.context().props().mailbox()));
        MessageQueue messageQueue = $this.actorCell().mailbox().messageQueue();
        if (!(messageQueue instanceof DequeBasedMessageQueueSemantics)) {
            MessageQueue other = messageQueue;
            throw ActorInitializationException$.MODULE$.apply($this.self(), new StringBuilder(34).append("DequeBasedMailbox required, got: ").append(other.getClass().getName()).append("\n").append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("An (unbounded) deque-based mailbox can be configured as follows:\n          |  my-custom-mailbox {\n          |    mailbox-type = \"org.apache.pekko.dispatch.UnboundedDequeBasedMailbox\"\n          |  }\n          |"))).toString(), ActorInitializationException$.MODULE$.apply$default$3());
        }
        DequeBasedMessageQueueSemantics queue = (DequeBasedMessageQueueSemantics)((Object)messageQueue);
        $this.org$apache$pekko$actor$StashSupport$_setter_$mailbox_$eq(queue);
    }

    public ActorContext context();

    public ActorRef self();

    public Vector<Envelope> org$apache$pekko$actor$StashSupport$$theStash();

    public void org$apache$pekko$actor$StashSupport$$theStash_$eq(Vector<Envelope> var1);

    private ActorCell actorCell() {
        return (ActorCell)this.context();
    }

    public int org$apache$pekko$actor$StashSupport$$capacity();

    public void org$apache$pekko$actor$StashSupport$_setter_$org$apache$pekko$actor$StashSupport$$capacity_$eq(int var1);

    public DequeBasedMessageQueueSemantics mailbox();

    public void org$apache$pekko$actor$StashSupport$_setter_$mailbox_$eq(DequeBasedMessageQueueSemantics var1);

    public static void stash$(StashSupport $this) {
        $this.stash();
    }

    default public void stash() {
        Envelope currMsg = this.actorCell().currentMessage();
        if (this.org$apache$pekko$actor$StashSupport$$theStash().nonEmpty() && currMsg == this.org$apache$pekko$actor$StashSupport$$theStash().last()) {
            throw new IllegalStateException(new StringBuilder(44).append("Can't stash the same message ").append(currMsg).append(" more than once").toString());
        }
        if (this.org$apache$pekko$actor$StashSupport$$capacity() <= 0 || this.org$apache$pekko$actor$StashSupport$$theStash().size() < this.org$apache$pekko$actor$StashSupport$$capacity()) {
            this.org$apache$pekko$actor$StashSupport$$theStash_$eq((Vector)this.org$apache$pekko$actor$StashSupport$$theStash().$colon$plus(currMsg));
            return;
        }
        throw new StashOverflowException(new StringBuilder(44).append("Couldn't enqueue message ").append(currMsg.message().getClass().getName()).append(" from ").append(currMsg.sender()).append(" to stash of ").append(this.self()).toString(), StashOverflowException$.MODULE$.$lessinit$greater$default$2());
    }

    public static void prepend$(StashSupport $this, Seq others) {
        $this.prepend(others);
    }

    default public void prepend(Seq<Envelope> others) {
        this.org$apache$pekko$actor$StashSupport$$theStash_$eq(others.foldRight(this.org$apache$pekko$actor$StashSupport$$theStash(), (Function2<Envelope, Vector, Vector> & Serializable)(e, s2) -> (Vector)s2.$plus$colon(e)));
    }

    public static void unstash$(StashSupport $this) {
        $this.unstash();
    }

    default public void unstash() {
        if (this.org$apache$pekko$actor$StashSupport$$theStash().nonEmpty()) {
            try {
                this.enqueueFirst(this.org$apache$pekko$actor$StashSupport$$theStash().head());
            }
            finally {
                this.org$apache$pekko$actor$StashSupport$$theStash_$eq((Vector<Envelope>)this.org$apache$pekko$actor$StashSupport$$theStash().tail());
            }
            return;
        }
    }

    public static void unstashAll$(StashSupport $this) {
        $this.unstashAll();
    }

    default public void unstashAll() {
        this.unstashAll((Function1<Object, Object>)(Function1<Object, boolean> & Serializable)_$1 -> true);
    }

    public static void unstashAll$(StashSupport $this, Function1 filterPredicate) {
        $this.unstashAll(filterPredicate);
    }

    @InternalStableApi
    default public void unstashAll(Function1<Object, Object> filterPredicate) {
        try {
            Iterator<Envelope> i = this.org$apache$pekko$actor$StashSupport$$theStash().reverseIterator().filter((Function1<Envelope, Object>)(Function1<Envelope, boolean> & Serializable)envelope -> BoxesRunTime.unboxToBoolean(filterPredicate.apply(envelope.message())));
            while (i.hasNext()) {
                this.enqueueFirst(i.next());
            }
        }
        finally {
            this.org$apache$pekko$actor$StashSupport$$theStash_$eq((Vector<Envelope>)package$.MODULE$.Vector().empty());
        }
    }

    public static Vector clearStash$(StashSupport $this) {
        return $this.clearStash();
    }

    @InternalStableApi
    default public Vector<Envelope> clearStash() {
        Vector<Envelope> stashed = this.org$apache$pekko$actor$StashSupport$$theStash();
        this.org$apache$pekko$actor$StashSupport$$theStash_$eq((Vector<Envelope>)package$.MODULE$.Vector().empty());
        return stashed;
    }

    private void enqueueFirst(Envelope envelope) {
        this.mailbox().enqueueFirst(this.self(), envelope);
        Object object = envelope.message();
        if (object instanceof Terminated) {
            ActorRef actorRef;
            Terminated terminated = Terminated$.MODULE$.unapply((Terminated)object);
            ActorRef ref = actorRef = terminated._1();
            this.actorCell().terminatedQueuedFor(ref, (Option)None$.MODULE$);
            return;
        }
    }
}

