/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import com.typesafe.config.Config;
import java.io.Closeable;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.actor.LightArrayRevolverScheduler$;
import org.apache.pekko.actor.Scheduler;
import org.apache.pekko.actor.SchedulerException;
import org.apache.pekko.actor.SchedulerException$;
import org.apache.pekko.dispatch.AbstractNodeQueue;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.Helpers$ConfigOps$;
import org.apache.pekko.util.Helpers$Requiring$;
import org.apache.pekko.util.Unsafe;
import scala.Array$;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.util.control.NonFatal$;

public class LightArrayRevolverScheduler
implements Scheduler,
Closeable {
    public final LoggingAdapter org$apache$pekko$actor$LightArrayRevolverScheduler$$log;
    public final ThreadFactory org$apache$pekko$actor$LightArrayRevolverScheduler$$threadFactory;
    private final int WheelSize;
    private final FiniteDuration TickDuration;
    private final FiniteDuration ShutdownTimeout;
    private final double maxFrequency;
    public final long org$apache$pekko$actor$LightArrayRevolverScheduler$$start;
    public final long org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos;
    public final int org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask;
    public final TaskQueue org$apache$pekko$actor$LightArrayRevolverScheduler$$queue;
    public final AtomicReference<Promise<Seq<TimerTask>>> org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped;
    public volatile Thread org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread;

    public LightArrayRevolverScheduler(Config config, LoggingAdapter log, ThreadFactory threadFactory) {
        FiniteDuration finiteDuration;
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$log = log;
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$threadFactory = threadFactory;
        Integer n = (Integer)Helpers$.MODULE$.Requiring(BoxesRunTime.boxToInteger(config.getInt("pekko.scheduler.ticks-per-wheel")));
        this.WheelSize = BoxesRunTime.unboxToInt(Helpers$Requiring$.MODULE$.requiring$extension((Object)n, ticks -> (ticks & ticks - 1) == 0, LightArrayRevolverScheduler::$init$$$anonfun$2));
        FiniteDuration durationFromConfig = Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.scheduler.tick-duration");
        boolean errorOnVerificationFailed = config.getBoolean("pekko.scheduler.error-on-tick-duration-verification-failed");
        if (durationFromConfig.$less(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).millis())) {
            if (Helpers$.MODULE$.isWindows()) {
                if (errorOnVerificationFailed) {
                    throw new IllegalArgumentException("requirement failed: minimum supported pekko.scheduler.tick-duration on Windows is 10ms");
                }
                log.warning("requirement failed: minimum supported pekko.scheduler.tick-duration on Windows is 10ms, adjusted to 10ms now.");
                finiteDuration = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).millis();
            } else if (durationFromConfig.$less(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millis())) {
                if (errorOnVerificationFailed) {
                    throw new IllegalArgumentException("requirement failed: minimum supported pekko.scheduler.tick-duration is 1ms");
                }
                log.warning("requirement failed: minimum supported pekko.scheduler.tick-duration is 1ms, adjusted to 1ms now.");
                finiteDuration = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).millis();
            } else {
                finiteDuration = durationFromConfig;
            }
        } else {
            finiteDuration = durationFromConfig;
        }
        this.TickDuration = finiteDuration;
        this.ShutdownTimeout = Helpers$ConfigOps$.MODULE$.getMillisDuration$extension(Helpers$.MODULE$.ConfigOps(config), "pekko.scheduler.shutdown-timeout");
        this.maxFrequency = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second().$div(this.TickDuration());
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$start = this.clock();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos = this.TickDuration().toNanos();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask = this.WheelSize() - 1;
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue = new TaskQueue();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped = new AtomicReference();
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread = threadFactory.newThread(new Runnable(this){
            private int tick;
            private long totalTick;
            private final TaskQueue[] wheel;
            private TaskQueue spareTaskQueue;
            private final /* synthetic */ LightArrayRevolverScheduler $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.tick = $outer.startTick();
                this.totalTick = Int$.MODULE$.int2long(this.tick());
                this.wheel = (TaskQueue[])Array$.MODULE$.fill($outer.WheelSize(), LightArrayRevolverScheduler::org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$1$$_$$lessinit$greater$$anonfun$3, ClassTag$.MODULE$.apply(TaskQueue.class));
                this.spareTaskQueue = new TaskQueue();
            }

            public int tick() {
                return this.tick;
            }

            public void tick_$eq(int x$1) {
                this.tick = x$1;
            }

            public long totalTick() {
                return this.totalTick;
            }

            public void totalTick_$eq(long x$1) {
                this.totalTick = x$1;
            }

            public TaskQueue[] wheel() {
                return this.wheel;
            }

            public TaskQueue spareTaskQueue() {
                return this.spareTaskQueue;
            }

            public void spareTaskQueue_$eq(TaskQueue x$1) {
                this.spareTaskQueue = x$1;
            }

            private Seq clearAll() {
                return (Seq)((IterableOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.$outer.WheelSize()).flatMap((Function1<Object, IterableOnce> & Serializable)i -> this.clearAll$$anonfun$1(BoxesRunTime.unboxToInt(i)))).$plus$plus(LightArrayRevolverScheduler.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$1$$_$collect$1(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue, (Vector)package$.MODULE$.Vector().empty()));
            }

            private void checkQueue(long time) {
                AbstractNodeQueue.Node<T> node;
                while ((node = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue.pollNode()) != null) {
                    Serializable serializable;
                    AbstractNodeQueue.Node<T> node2 = node;
                    int n = ((TaskHolder)node2.value).ticks();
                    if (0 == n) {
                        serializable = BoxesRunTime.boxToBoolean(((TaskHolder)node2.value).executeTask());
                        continue;
                    }
                    int ticks = n;
                    int futureTick = (int)((time - this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$start + (long)ticks * this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos + this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos - 1L) / this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos);
                    int offset = futureTick - this.tick();
                    int bucket = futureTick & this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask;
                    ((TaskHolder)node2.value).ticks_$eq(offset);
                    this.wheel()[bucket].addNode(node2);
                    serializable = BoxedUnit.UNIT;
                }
                return;
            }

            public final void run() {
                try {
                    this.nextTick();
                }
                catch (Throwable t) {
                    Object object;
                    this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.error(t, "exception on LARS\u2019 timer thread");
                    Promise<Seq<TimerTask>> promise = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped.get();
                    if (promise == null) {
                        Object object2;
                        Thread thread = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$threadFactory.newThread(this);
                        this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.info("starting new LARS thread");
                        try {
                            thread.start();
                            object2 = BoxedUnit.UNIT;
                        }
                        catch (Throwable e) {
                            this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.error(e, "LARS cannot start new thread, ship\u2019s going down!");
                            this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped.set(Promise$.MODULE$.successful(package$.MODULE$.Nil()));
                            object2 = this.clearAll();
                        }
                        this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread = thread;
                        object = BoxedUnit.UNIT;
                    } else {
                        Promise<Seq<TimerTask>> p = promise;
                        if (!this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped.compareAndSet(p, Promise$.MODULE$.successful(package$.MODULE$.Nil()))) {
                            throw Scala3RunTime$.MODULE$.assertFailed("Stop signal violated in LARS");
                        }
                        object = p.success(this.clearAll());
                    }
                    throw t;
                }
            }

            public final void nextTick() {
                Promise<Seq<TimerTask>> promise;
                do {
                    long time = this.$outer.clock();
                    long sleepTime = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$start + this.totalTick() * this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos - time;
                    if (sleepTime > 0L) {
                        this.checkQueue(time);
                        this.$outer.waitNanos(sleepTime);
                        continue;
                    }
                    int bucket = this.tick() & this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$wheelMask;
                    TaskQueue tasks2 = this.wheel()[bucket];
                    TaskQueue putBack = this.spareTaskQueue();
                    this.executeBucket$1(tasks2, putBack);
                    this.wheel()[bucket] = putBack;
                    this.spareTaskQueue_$eq(tasks2);
                    this.tick_$eq(this.tick() + 1);
                    this.totalTick_$eq(this.totalTick() + 1L);
                } while ((promise = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped.get()) == null);
                Promise<Seq<TimerTask>> p = promise;
                if (!this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped.compareAndSet(p, Promise$.MODULE$.successful(package$.MODULE$.Nil()))) {
                    throw Scala3RunTime$.MODULE$.assertFailed("Stop signal violated in LARS");
                }
                p.success(this.clearAll());
            }

            private final /* synthetic */ IterableOnce clearAll$$anonfun$1(int i) {
                return LightArrayRevolverScheduler.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$1$$_$collect$1(this.wheel()[i], (Vector)package$.MODULE$.Vector().empty());
            }

            private final void executeBucket$1(TaskQueue tasks$1, TaskQueue putBack$1) {
                AbstractNodeQueue.Node<T> node;
                while ((node = tasks$1.pollNode()) != null) {
                    AbstractNodeQueue.Node<T> node2 = node;
                    TaskHolder task = (TaskHolder)node2.value;
                    if (task.isCancelled()) continue;
                    if (task.ticks() >= this.$outer.WheelSize()) {
                        task.ticks_$eq(task.ticks() - this.$outer.WheelSize());
                        putBack$1.addNode(node2);
                        continue;
                    }
                    task.executeTask();
                }
                return;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$1$$_$$lessinit$greater$$anonfun$3(), clearAll$$anonfun$adapted$1(java.lang.Object )}, serializedLambda);
            }
        });
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$timerThread.start();
    }

    public int WheelSize() {
        return this.WheelSize;
    }

    public FiniteDuration TickDuration() {
        return this.TickDuration;
    }

    public FiniteDuration ShutdownTimeout() {
        return this.ShutdownTimeout;
    }

    public FiniteDuration org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(FiniteDuration d) {
        long dn = d.toNanos();
        long r = ((dn - 1L) / this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos + 1L) * this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos;
        if (r != dn && r > 0L && dn > 0L) {
            return new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(r)).nanos();
        }
        return d;
    }

    public long clock() {
        return System.nanoTime();
    }

    public int startTick() {
        return 0;
    }

    public FiniteDuration getShutdownTimeout() {
        return this.ShutdownTimeout();
    }

    public void waitNanos(long nanos) {
        long sleepMs = Helpers$.MODULE$.isWindows() ? (nanos + 4999999L) / 10000000L * 10L : (nanos + 999999L) / 1000000L;
        try {
            Thread.sleep(sleepMs);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public Cancellable scheduleWithFixedDelay(FiniteDuration initialDelay, FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        this.checkPeriod(delay);
        this.checkMaxDelay(this.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(delay).toNanos());
        return Scheduler.scheduleWithFixedDelay$((Scheduler)this, initialDelay, delay, runnable, executor);
    }

    @Override
    public Cancellable schedule(FiniteDuration initialDelay, FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        this.checkPeriod(delay);
        this.checkMaxDelay(this.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(delay).toNanos());
        return new Scheduler.AtomicCancellable(executor, initialDelay, runnable, delay, this){
            public final ExecutionContext org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$2$$executor$1;
            private final FiniteDuration initialDelay$1;
            public final Runnable org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$2$$runnable$1;
            public final FiniteDuration org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$2$$delay$1;
            private final /* synthetic */ LightArrayRevolverScheduler $outer;
            {
                this.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$2$$executor$1 = executor$2;
                this.initialDelay$1 = initialDelay$3;
                this.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$2$$runnable$1 = runnable$2;
                this.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$2$$delay$1 = delay$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$$InitialRepeatMarker);
            }

            public final Cancellable scheduledFirst() {
                return this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(this.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$2$$executor$1, new Runnable(this.initialDelay$1, this){
                    private final /* synthetic */ $anon$2 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super($outer.org$apache$pekko$actor$LightArrayRevolverScheduler$_$$anon$$$outer().clock() + initialDelay$2.toNanos());
                    }

                    public void run() {
                        try {
                            this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$2$$runnable$1.run();
                            long driftNanos = this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$_$$anon$$$outer().clock() - this.getAndAdd(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$2$$delay$1.toNanos());
                            if (this.$outer.get() != null) {
                                this.$outer.swap(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$_$$anon$$$outer().org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$2$$executor$1, this, Duration$.MODULE$.fromNanos(Math.max(this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$2$$delay$1.toNanos() - driftNanos, 1L))));
                            }
                        }
                        catch (SchedulerException schedulerException) {}
                    }
                }, this.$outer.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(this.initialDelay$1));
            }

            public final /* synthetic */ LightArrayRevolverScheduler org$apache$pekko$actor$LightArrayRevolverScheduler$_$$anon$$$outer() {
                return this.$outer;
            }
        };
    }

    @Override
    public Cancellable scheduleOnce(FiniteDuration delay, Runnable runnable, ExecutionContext executor) {
        TimerTask timerTask;
        try {
            timerTask = this.org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(executor, runnable, this.org$apache$pekko$actor$LightArrayRevolverScheduler$$roundUp(delay));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof SchedulerException) {
                String string2;
                SchedulerException schedulerException = (SchedulerException)throwable2;
                SchedulerException schedulerException2 = SchedulerException$.MODULE$.unapply(schedulerException);
                String msg = string2 = schedulerException2._1();
                SchedulerException cause = schedulerException;
                throw new IllegalStateException(msg, cause);
            }
            throw throwable;
        }
        return timerTask;
    }

    @Override
    public void close() {
        ((IterableOnceOps)Await$.MODULE$.result(this.stop(), this.getShutdownTimeout())).foreach(x$1 -> {
            TimerTask timerTask = x$1;
            if (timerTask instanceof Scheduler.TaskRunOnClose) {
                TimerTask task = (TimerTask)((Object)((Scheduler.TaskRunOnClose)((Object)timerTask)));
                this.runTask$1(task);
                return;
            }
            if (timerTask instanceof TaskHolder) {
                TaskHolder holder = (TaskHolder)timerTask;
                Runnable runnable = holder.task();
                if (runnable instanceof Scheduler.TaskRunOnClose) {
                    Scheduler.TaskRunOnClose task = (Scheduler.TaskRunOnClose)runnable;
                    this.runTask$1(task);
                    return;
                }
                return;
            }
        });
    }

    @Override
    public double maxFrequency() {
        return this.maxFrequency;
    }

    public TimerTask org$apache$pekko$actor$LightArrayRevolverScheduler$$schedule(ExecutionContext ec, Runnable r, FiniteDuration delay) {
        if (delay.length() <= 0L) {
            if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped.get() != null) {
                throw SchedulerException$.MODULE$.apply("cannot enqueue after timer shutdown");
            }
            ec.execute(r);
            return LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$$NotCancellable;
        }
        if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped.get() != null) {
            throw SchedulerException$.MODULE$.apply("cannot enqueue after timer shutdown");
        }
        long delayNanos = delay.toNanos();
        this.checkMaxDelay(delayNanos);
        int ticks = (int)(delayNanos / this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos);
        TaskHolder task = new TaskHolder(r, ticks, ec);
        this.org$apache$pekko$actor$LightArrayRevolverScheduler$$queue.add(task);
        if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped.get() != null && task.cancel()) {
            throw SchedulerException$.MODULE$.apply("cannot enqueue after timer shutdown");
        }
        return task;
    }

    private void checkPeriod(FiniteDuration delay) {
        if (delay.length() <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(119).append("Task scheduled with [").append(delay.toSeconds()).append("] seconds delay, which means creating an infinite loop. ").append("The expected delay must be greater than 0.").toString());
        }
    }

    private void checkMaxDelay(long delayNanos) {
        if (delayNanos / this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new StringBuilder(38).append("Task scheduled with [").append(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(delayNanos)).nanos().toSeconds()).append("] seconds delay, ").append(new StringBuilder(55).append("which is too far in future, maximum delay is [").append(new package.DurationLong(scala.concurrent.duration.package$.MODULE$.DurationLong(this.org$apache$pekko$actor$LightArrayRevolverScheduler$$tickNanos * Integer.MAX_VALUE)).nanos().toSeconds() - 1L).append("] seconds").toString()).toString());
        }
    }

    private Future<Seq<TimerTask>> stop() {
        Promise p = Promise$.MODULE$.apply();
        if (this.org$apache$pekko$actor$LightArrayRevolverScheduler$$stopped.compareAndSet(null, p)) {
            return p.future();
        }
        return Future$.MODULE$.successful(package$.MODULE$.Nil());
    }

    private static final Object $init$$$anonfun$2() {
        return "ticks-per-wheel must be a power of 2";
    }

    public static final TaskQueue org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$1$$_$$lessinit$greater$$anonfun$3() {
        return new TaskQueue();
    }

    public static final Vector org$apache$pekko$actor$LightArrayRevolverScheduler$$anon$1$$_$collect$1(TaskQueue q, Vector acc) {
        TaskHolder taskHolder;
        while ((taskHolder = (TaskHolder)q.poll()) != null) {
            TaskHolder x = taskHolder;
            acc = (Vector)acc.$colon$plus(x);
        }
        return acc;
    }

    private final void runTask$1(Runnable task) {
        try {
            task.run();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (SchedulerException schedulerException) {
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = option.get();
                this.org$apache$pekko$actor$LightArrayRevolverScheduler$$log.error(e, "exception while executing timer task");
            }
            throw throwable;
        }
    }

    public static class TaskHolder
    implements TimerTask {
        private volatile Runnable task;
        private int ticks;
        private final ExecutionContext executionContext;

        public TaskHolder(Runnable task, int ticks, ExecutionContext executionContext) {
            this.task = task;
            this.ticks = ticks;
            this.executionContext = executionContext;
        }

        public Runnable task() {
            return this.task;
        }

        public void task_$eq(Runnable x$1) {
            this.task = x$1;
        }

        public int ticks() {
            return this.ticks;
        }

        public void ticks_$eq(int x$1) {
            this.ticks = x$1;
        }

        private final Runnable extractTask(Runnable replaceWith) {
            Runnable runnable;
            Runnable x;
            do {
                block8: {
                    block9: {
                        Runnable runnable2;
                        Runnable runnable3;
                        block7: {
                            runnable = this.task();
                            runnable3 = LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$$ExecutedTask;
                            runnable2 = runnable;
                            if (runnable3 != null) break block7;
                            if (runnable2 == null) break block8;
                            break block9;
                        }
                        if (runnable3.equals(runnable2)) break block8;
                    }
                    Runnable runnable4 = LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$$CancelledTask;
                    Runnable runnable5 = runnable;
                    if (runnable4 == null) {
                        if (runnable5 != null) {
                            continue;
                        }
                    } else if (!runnable4.equals(runnable5)) continue;
                }
                Runnable t = runnable;
                return t;
            } while (!Unsafe.instance.compareAndSwapObject(this, LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$$taskOffset, x = runnable, replaceWith));
            return x;
        }

        public final boolean executeTask() {
            boolean bl;
            Runnable runnable;
            block11: {
                block8: {
                    Runnable runnable2;
                    Runnable runnable3;
                    block10: {
                        block9: {
                            Runnable runnable4;
                            Runnable runnable5;
                            block7: {
                                runnable = this.extractTask(LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$$ExecutedTask);
                                runnable5 = LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$$ExecutedTask;
                                runnable4 = runnable;
                                if (runnable5 != null) break block7;
                                if (runnable4 == null) break block8;
                                break block9;
                            }
                            if (runnable5.equals(runnable4)) break block8;
                        }
                        runnable3 = LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$$CancelledTask;
                        runnable2 = runnable;
                        if (runnable3 != null) break block10;
                        if (runnable2 == null) break block8;
                        break block11;
                    }
                    if (!runnable3.equals(runnable2)) break block11;
                }
                return false;
            }
            Runnable other = runnable;
            try {
                this.executionContext.execute(other);
                bl = true;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                bl = false;
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    this.executionContext.reportFailure(e);
                    bl = false;
                }
                throw throwable;
            }
            return bl;
        }

        @Override
        public void run() {
            this.extractTask(LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$$ExecutedTask).run();
        }

        @Override
        public boolean cancel() {
            block6: {
                block3: {
                    Runnable runnable;
                    Runnable runnable2;
                    block5: {
                        Runnable runnable3;
                        block4: {
                            Runnable runnable4;
                            Runnable runnable5;
                            block2: {
                                runnable3 = this.extractTask(LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$$CancelledTask);
                                runnable5 = LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$$ExecutedTask;
                                runnable4 = runnable3;
                                if (runnable5 != null) break block2;
                                if (runnable4 == null) break block3;
                                break block4;
                            }
                            if (runnable5.equals(runnable4)) break block3;
                        }
                        runnable2 = LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$$CancelledTask;
                        runnable = runnable3;
                        if (runnable2 != null) break block5;
                        if (runnable == null) break block3;
                        break block6;
                    }
                    if (!runnable2.equals(runnable)) break block6;
                }
                return false;
            }
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.task() == LightArrayRevolverScheduler$.org$apache$pekko$actor$LightArrayRevolverScheduler$$$CancelledTask;
        }
    }

    public static class TaskQueue
    extends AbstractNodeQueue<TaskHolder> {
    }

    public static interface TimerTask
    extends Runnable,
    Cancellable {
    }
}

