/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorPath$;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Deploy;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.Deployer$;
import org.apache.pekko.actor.DynamicAccess;
import org.apache.pekko.actor.InvalidActorNameException$;
import org.apache.pekko.actor.NoScopeGiven$;
import org.apache.pekko.routing.NoRouter$;
import org.apache.pekko.routing.RouterConfig;
import org.apache.pekko.util.WildcardIndex;
import org.apache.pekko.util.WildcardIndex$;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Deployer {
    private final ActorSystem.Settings settings;
    private final DynamicAccess dynamicAccess;
    private final Config resizerEnabled;
    private final AtomicReference<WildcardIndex<Deploy>> deployments;
    private final Config default;
    private final scala.collection.immutable.Map routerTypeMapping;

    public Deployer(ActorSystem.Settings settings, DynamicAccess dynamicAccess) {
        this.settings = settings;
        this.dynamicAccess = dynamicAccess;
        this.resizerEnabled = ConfigFactory.parseString("resizer.enabled=on");
        this.deployments = new AtomicReference(WildcardIndex$.MODULE$.apply(WildcardIndex$.MODULE$.$lessinit$greater$default$1(), WildcardIndex$.MODULE$.$lessinit$greater$default$2()));
        Config config = settings.config().getConfig("pekko.actor.deployment");
        this.default = config.getConfig("default");
        this.routerTypeMapping = package$JavaConverters$.MODULE$.MapHasAsScala((Map)settings.config().getConfig("pekko.actor.router.type-mapping").root().unwrapped()).asScala().collect(new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    T2 T2 = tuple2._2();
                    String key2 = (String)tuple2._1();
                    if (T2 instanceof String) {
                        String value = (String)T2;
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    T2 T2 = tuple2._2();
                    String key2 = (String)tuple2._1();
                    if (T2 instanceof String) {
                        String value = (String)T2;
                        String string2 = Predef$.MODULE$.ArrowAssoc(key2);
                        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, value);
                    }
                }
                return function1.apply(x);
            }
        }).toMap($less$colon$less$.MODULE$.refl());
        ((IterableOnceOps)package$JavaConverters$.MODULE$.MapHasAsScala((Map)config.root()).asScala().flatMap((Function1<Tuple2, Option> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string2 = (String)tuple2._1();
                ConfigValue configValue = (ConfigValue)tuple2._2();
                if ("default".equals(string2)) {
                    return None$.MODULE$;
                }
                String key2 = string2;
                if (configValue instanceof ConfigObject) {
                    ConfigObject value = (ConfigObject)configValue;
                    return this.parseConfig(key2, value.toConfig());
                }
            }
            return None$.MODULE$;
        })).foreach(d -> this.deploy((Deploy)d));
    }

    public ActorSystem.Settings settings() {
        return this.settings;
    }

    public DynamicAccess dynamicAccess() {
        return this.dynamicAccess;
    }

    public Config default() {
        return this.default;
    }

    public scala.collection.immutable.Map<String, String> routerTypeMapping() {
        return this.routerTypeMapping;
    }

    public Option<Deploy> lookup(ActorPath path) {
        return this.lookup((Iterable)path.elements().drop(1));
    }

    public Option<Deploy> lookup(Iterable<String> path) {
        return this.deployments.get().find(path);
    }

    public void deploy(Deploy d) {
        Object object = Predef$.MODULE$.refArrayOps(d.path().split("/"));
        this.add$1((String[])ArrayOps$.MODULE$.drop$extension(object, 1), d);
    }

    public Option<Deploy> parseConfig(String key2, Config config) {
        Config deployment = config.withFallback(this.default());
        RouterConfig router = this.createRouterConfig(deployment.getString("router"), key2, config, deployment);
        String dispatcher = deployment.getString("dispatcher");
        String mailbox = deployment.getString("mailbox");
        return Some$.MODULE$.apply(Deploy$.MODULE$.apply(key2, deployment, router, NoScopeGiven$.MODULE$, dispatcher, mailbox));
    }

    public RouterConfig createRouterConfig(String routerType, String key2, Config config, Config deployment) {
        String string2 = routerType;
        String string3 = "from-code";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return NoRouter$.MODULE$;
        }
        Config deployment2 = config.hasPath("resizer") && !deployment.getBoolean("resizer.enabled") ? this.resizerEnabled.withFallback(deployment) : deployment;
        String fqn = (String)this.routerTypeMapping().getOrElse(routerType, () -> Deployer.$anonfun$1(routerType));
        Class<Config> clazz = Predef$.MODULE$.ArrowAssoc(Config.class);
        List args1 = (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(clazz, deployment2)), Nil$.MODULE$));
        Class<Config> clazz2 = Predef$.MODULE$.ArrowAssoc(Config.class);
        Class<DynamicAccess> clazz3 = Predef$.MODULE$.ArrowAssoc(DynamicAccess.class);
        List args2 = (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(clazz2, deployment2)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(clazz3, this.dynamicAccess())), Nil$.MODULE$)));
        return this.dynamicAccess().createInstanceFor(fqn, args1, ClassTag$.MODULE$.apply(RouterConfig.class)).recover(new Serializable(fqn, args2, key2, this){
            public final String org$apache$pekko$actor$Deployer$$anon$2$$fqn$2;
            public final List org$apache$pekko$actor$Deployer$$anon$2$$args2$1;
            public final String org$apache$pekko$actor$Deployer$$anon$2$$key$2;
            private final /* synthetic */ Deployer $outer;
            {
                this.org$apache$pekko$actor$Deployer$$anon$2$$fqn$2 = fqn$3;
                this.org$apache$pekko$actor$Deployer$$anon$2$$args2$1 = args2$2;
                this.org$apache$pekko$actor$Deployer$$anon$2$$key$2 = key$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof IllegalArgumentException || throwable instanceof ConfigException) {
                    RuntimeException e = (RuntimeException)throwable;
                    return true;
                }
                if (throwable instanceof NoSuchMethodException) {
                    NoSuchMethodException e = (NoSuchMethodException)throwable;
                    return true;
                }
                Throwable e = throwable;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof IllegalArgumentException || throwable instanceof ConfigException) {
                    RuntimeException e = (RuntimeException)throwable;
                    throw e;
                }
                if (throwable instanceof NoSuchMethodException) {
                    NoSuchMethodException e = (NoSuchMethodException)throwable;
                    return this.$outer.dynamicAccess().createInstanceFor(this.org$apache$pekko$actor$Deployer$$anon$2$$fqn$2, this.org$apache$pekko$actor$Deployer$$anon$2$$args2$1, ClassTag$.MODULE$.apply(RouterConfig.class)).recover(new Serializable(e, this){
                        private final NoSuchMethodException e$1;
                        private final /* synthetic */ $anon$2 $outer;
                        {
                            this.e$1 = e$2;
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public final boolean isDefinedAt(Throwable x) {
                            Throwable throwable = x;
                            if (throwable instanceof IllegalArgumentException || throwable instanceof ConfigException) {
                                RuntimeException innerException = (RuntimeException)throwable;
                                return true;
                            }
                            return true;
                        }

                        public final Object applyOrElse(Throwable x, Function1 function1) {
                            Throwable throwable = x;
                            if (throwable instanceof IllegalArgumentException || throwable instanceof ConfigException) {
                                RuntimeException innerException = (RuntimeException)throwable;
                                throw innerException;
                            }
                            throw Deployer.org$apache$pekko$actor$Deployer$$_$throwCannotInstantiateRouter$1(this.$outer.org$apache$pekko$actor$Deployer$$anon$2$$fqn$2, this.$outer.org$apache$pekko$actor$Deployer$$anon$2$$key$2, this.$outer.org$apache$pekko$actor$Deployer$$anon$2$$args2$1, this.e$1);
                        }
                    }).get();
                }
                Throwable e = throwable;
                throw Deployer.org$apache$pekko$actor$Deployer$$_$throwCannotInstantiateRouter$1(this.org$apache$pekko$actor$Deployer$$anon$2$$fqn$2, this.org$apache$pekko$actor$Deployer$$anon$2$$key$2, this.org$apache$pekko$actor$Deployer$$anon$2$$args2$1, e);
            }
        }).get();
    }

    private final void add$1(String[] path, Deploy d) {
        WildcardIndex<Deploy> w;
        do {
            w = this.deployments.get();
            Object object = Predef$.MODULE$.refArrayOps(path);
            ArrayOps$.MODULE$.indices$extension(object).foreach(i -> {
                String string2 = path[i];
                if ("".equals(string2)) {
                    throw InvalidActorNameException$.MODULE$.apply(new StringBuilder(45).append("Actor name in deployment [").append(d.path()).append("] must not be empty").toString());
                }
                String el = string2;
                ActorPath$.MODULE$.validatePathElement(el, d.path());
            });
        } while (!this.deployments.compareAndSet(w, w.insert(path, d)));
    }

    private static final String $anonfun$1(String routerType$1) {
        return routerType$1;
    }

    public static final Nothing$ org$apache$pekko$actor$Deployer$$_$throwCannotInstantiateRouter$1(String fqn$1, String key$1, Seq args, Throwable cause) {
        throw new IllegalArgumentException(new StringBuilder(45).append("Cannot instantiate router [").append(fqn$1).append("], defined in [").append(key$1).append("], ").append(new StringBuilder(49).append("make sure it extends [").append(RouterConfig.class).append("] and has constructor with ").toString()).append(new StringBuilder(28).append("[").append(((Class)((Tuple2)args.apply(false))._1()).getName()).append("] and optional [").append(((Class)((Tuple2)args.apply(true))._1()).getName()).append("] parameter").toString()).toString(), cause);
    }
}

