/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import java.io.Serializable;
import org.apache.pekko.actor.ActorCell$;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.IgnoreActorRef$;
import org.apache.pekko.actor.RootActorPath;
import org.apache.pekko.routing.MurmurHash$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class ChildActorPath
implements ActorPath {
    private static final long serialVersionUID = 1L;
    private final ActorPath parent;
    private final String name;
    private final int uid;
    private final int toStringOffset;

    public ChildActorPath(ActorPath parent, String name, int uid) {
        int n;
        this.parent = parent;
        this.name = name;
        this.uid = uid;
        if (name.indexOf(47) != -1) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("/ is a path separator and is not legal in ActorPath names: [%s]"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name})));
        }
        if (name.indexOf(35) != -1) {
            throw new IllegalArgumentException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("# is a fragment separator and is not legal in ActorPath names: [%s]"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{name})));
        }
        ActorPath actorPath = parent;
        if (actorPath instanceof RootActorPath) {
            RootActorPath r = (RootActorPath)actorPath;
            n = r.address().toString().length() + r.name().length();
        } else if (actorPath instanceof ChildActorPath) {
            ChildActorPath c = (ChildActorPath)actorPath;
            n = c.toStringLength() + 1;
        } else {
            throw new MatchError(actorPath);
        }
        this.toStringOffset = n;
    }

    @Override
    public ActorPath parent() {
        return this.parent;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int uid() {
        return this.uid;
    }

    @Override
    public Address address() {
        return this.root().address();
    }

    @Override
    public ActorPath $div(String child) {
        Tuple2<String, Object> tuple2 = ActorCell$.MODULE$.splitNameAndUid(child);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String childName = tuple2._1();
        int uid = BoxesRunTime.unboxToInt(tuple2._2());
        Tuple2<String, Integer> tuple22 = Tuple2$.MODULE$.apply(childName, BoxesRunTime.boxToInteger(uid));
        String childName2 = tuple22._1();
        int uid2 = BoxesRunTime.unboxToInt(tuple22._2());
        return new ChildActorPath(this, childName2, uid2);
    }

    @Override
    public Iterable<String> elements() {
        return ChildActorPath.rec$1(this, package$.MODULE$.Nil());
    }

    @Override
    public RootActorPath root() {
        return ChildActorPath.rec$2(this);
    }

    @Override
    public ActorPath withUid(int uid) {
        if (uid == this.uid()) {
            return this;
        }
        return new ChildActorPath(this.parent(), this.name(), uid);
    }

    public String toString() {
        int length = this.toStringLength();
        return this.buildToString(new StringBuilder(length), length, 0, (Function1<RootActorPath, String> & Serializable)_$1 -> _$1.toString()).toString();
    }

    @Override
    public String toSerializationFormat() {
        int length = this.toStringLength();
        StringBuilder sb = this.buildToString(new StringBuilder(length + 12), length, 0, (Function1<RootActorPath, String> & Serializable)_$2 -> _$2.toString());
        return this.appendUidFragment(sb).toString();
    }

    private int toStringLength() {
        return this.toStringOffset() + this.name().length();
    }

    private int toStringOffset() {
        return this.toStringOffset;
    }

    @Override
    public String toStringWithAddress(Address addr) {
        if (IgnoreActorRef$.MODULE$.isIgnoreRefPath(this)) {
            return this.toString();
        }
        int diff = this.addressStringLengthDiff(addr);
        int length = this.toStringLength() + diff;
        return this.buildToString(new StringBuilder(length), length, diff, (Function1<RootActorPath, String> & Serializable)_$3 -> _$3.toStringWithAddress(addr)).toString();
    }

    @Override
    public String toSerializationFormatWithAddress(Address addr) {
        if (IgnoreActorRef$.MODULE$.isIgnoreRefPath(this)) {
            return this.toString();
        }
        int diff = this.addressStringLengthDiff(addr);
        int length = this.toStringLength() + diff;
        StringBuilder sb = this.buildToString(new StringBuilder(length + 12), length, diff, (Function1<RootActorPath, String> & Serializable)_$4 -> _$4.toStringWithAddress(addr));
        return this.appendUidFragment(sb).toString();
    }

    private int addressStringLengthDiff(Address address) {
        RootActorPath r = this.root();
        if (r.address().host().isDefined()) {
            return 0;
        }
        return address.toString().length() - r.address().toString().length();
    }

    private StringBuilder buildToString(StringBuilder sb, int length, int diff, Function1<RootActorPath, String> rootString) {
        sb.setLength(length);
        return this.rec$3(rootString, sb, diff, this);
    }

    private StringBuilder appendUidFragment(StringBuilder sb) {
        if (this.uid() == 0) {
            return sb;
        }
        return sb.append("#").append(this.uid());
    }

    public boolean equals(Object other) {
        Object object = other;
        if (object instanceof ActorPath) {
            ActorPath p = (ActorPath)object;
            return ChildActorPath.rec$4(this, p);
        }
        return false;
    }

    public int hashCode() {
        return MurmurHash$.MODULE$.finalizeHash(this.rec$5(this, MurmurHash$.MODULE$.startHash(42), MurmurHash$.MODULE$.startMagicA(), MurmurHash$.MODULE$.startMagicB()));
    }

    @Override
    public int compareTo(ActorPath other) {
        return ChildActorPath.rec$6(this, other);
    }

    private static final Iterable rec$1(ActorPath p, List acc) {
        ActorPath actorPath;
        while (!((actorPath = p) instanceof RootActorPath)) {
            ActorPath actorPath2 = p.parent();
            String string2 = p.name();
            List<String> list = acc.$colon$colon(string2);
            p = actorPath2;
            acc = list;
        }
        return acc;
    }

    private static final RootActorPath rec$2(ActorPath p) {
        while (true) {
            ActorPath actorPath;
            if ((actorPath = p) instanceof RootActorPath) {
                RootActorPath r = (RootActorPath)actorPath;
                return r;
            }
            p = p.parent();
        }
    }

    private final StringBuilder rec$3(Function1 rootString$1, StringBuilder sb$1, int diff$1, ActorPath p) {
        ActorPath actorPath;
        while (true) {
            if ((actorPath = p) instanceof RootActorPath) {
                RootActorPath r = (RootActorPath)actorPath;
                String rootStr = (String)rootString$1.apply(r);
                return sb$1.replace(0, rootStr.length(), rootStr);
            }
            if (!(actorPath instanceof ChildActorPath)) break;
            ChildActorPath c = (ChildActorPath)actorPath;
            int start = c.toStringOffset() + diff$1;
            int end = start + c.name().length();
            sb$1.replace(start, end, c.name());
            if (c != this) {
                sb$1.replace(end, end + 1, "/");
            }
            p = c.parent();
        }
        throw new MatchError(actorPath);
    }

    private static final boolean rec$4(ActorPath left, ActorPath right) {
        while (true) {
            if (left == right) {
                return true;
            }
            if (left instanceof RootActorPath) {
                return left.equals(right);
            }
            if (right instanceof RootActorPath) {
                return right.equals(left);
            }
            String string2 = left.name();
            String string3 = right.name();
            if (string2 != null ? !string2.equals(string3) : string3 != null) break;
            ActorPath actorPath = left.parent();
            ActorPath actorPath2 = right.parent();
            left = actorPath;
            right = actorPath2;
        }
        return false;
    }

    private final int rec$5(ActorPath p, int h, int c, int k) {
        while (true) {
            ActorPath actorPath;
            if ((actorPath = p) instanceof RootActorPath) {
                RootActorPath r = (RootActorPath)actorPath;
                return MurmurHash$.MODULE$.extendHash(h, Statics.anyHash(r), c, k);
            }
            ActorPath actorPath2 = p.parent();
            int n = MurmurHash$.MODULE$.extendHash(h, MurmurHash$.MODULE$.stringHash(this.name()), c, k);
            int n2 = MurmurHash$.MODULE$.nextMagicA(c);
            int n3 = MurmurHash$.MODULE$.nextMagicB(k);
            p = actorPath2;
            h = n;
            c = n2;
            k = n3;
        }
    }

    private static final int rec$6(ActorPath left, ActorPath right) {
        int x;
        while (true) {
            if (left == right) {
                return 0;
            }
            if (left instanceof RootActorPath) {
                return left.compareTo(right);
            }
            if (right instanceof RootActorPath) {
                return -right.compareTo(left);
            }
            x = left.name().compareTo(right.name());
            if (x != 0) break;
            ActorPath actorPath = left.parent();
            ActorPath actorPath2 = right.parent();
            left = actorPath;
            right = actorPath2;
        }
        return x;
    }
}

