/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import java.io.Serializable;
import java.util.Optional;
import org.apache.pekko.actor.Address$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.OptionConverters$;
import org.apache.pekko.util.OptionConverters$RichOption$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.util.hashing.MurmurHash3$;
import scala.util.matching.Regex;

public final class Address
implements Product,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Address.class.getDeclaredField("toString$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Address.class.getDeclaredField("hashCode$lzy1"));
    private final String protocol;
    private final String system;
    private final Option host;
    private final Option port;
    private volatile transient Object hashCode$lzy1;
    private volatile transient Object toString$lzy1;

    public static Regex InvalidHostRegex() {
        return Address$.MODULE$.InvalidHostRegex();
    }

    public static Ordering<Address> addressOrdering() {
        return Address$.MODULE$.addressOrdering();
    }

    public static Address apply(String string2, String string3) {
        return Address$.MODULE$.apply(string2, string3);
    }

    public static Address apply(String string2, String string3, Option<String> option, Option<Object> option2) {
        return Address$.MODULE$.apply(string2, string3, option, option2);
    }

    public static Address apply(String string2, String string3, String string4, int n) {
        return Address$.MODULE$.apply(string2, string3, string4, n);
    }

    public static Address fromProduct(Product product) {
        return Address$.MODULE$.fromProduct(product);
    }

    public static Address unapply(Address address) {
        return Address$.MODULE$.unapply(address);
    }

    public Address(String protocol, String system, Option<String> host, Option<Object> port) {
        this.protocol = protocol;
        this.system = system;
        this.host = host;
        this.port = port;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Address)) return false;
        Address address = (Address)object;
        String string2 = this.protocol();
        String string3 = address.protocol();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        String string4 = this.system();
        String string5 = address.system();
        if (string4 == null) {
            if (string5 != null) {
                return false;
            }
        } else if (!string4.equals(string5)) return false;
        Option<String> option = this.host();
        Option<String> option2 = address.host();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Object> option3 = this.port();
        Option<Object> option4 = address.port();
        if (option3 == null) {
            if (option4 == null) return true;
            return false;
        } else {
            if (!option3.equals(option4)) return false;
            return true;
        }
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof Address;
    }

    @Override
    public int productArity() {
        return 4;
    }

    @Override
    public String productPrefix() {
        return "Address";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "protocol";
            }
            case 1: {
                return "system";
            }
            case 2: {
                return "host";
            }
            case 3: {
                return "port";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public String protocol() {
        return this.protocol;
    }

    public String system() {
        return this.system;
    }

    public Option<String> host() {
        return this.host;
    }

    public Option<Object> port() {
        return this.port;
    }

    public Address(String protocol, String system) {
        this(protocol, system, None$.MODULE$, None$.MODULE$);
    }

    public Address(String protocol, String system, String host, int port) {
        this(protocol, system, Option$.MODULE$.apply(host), Some$.MODULE$.apply(BoxesRunTime.boxToInteger(port)));
    }

    public Address copy(String protocol, String system, Option<String> host, Option<Object> port) {
        return Address$.MODULE$.apply(protocol, system, host, port);
    }

    public String copy$default$1() {
        return this.protocol();
    }

    public String copy$default$2() {
        return this.system();
    }

    public Option<String> copy$default$3() {
        return this.host();
    }

    public Option<Object> copy$default$4() {
        return this.port();
    }

    public Optional<String> getHost() {
        Option option = OptionConverters$.MODULE$.RichOption(this.host());
        return OptionConverters$RichOption$.MODULE$.toJava$extension(option);
    }

    public Optional<Integer> getPort() {
        Option option = OptionConverters$.MODULE$.RichOption(this.port());
        return OptionConverters$RichOption$.MODULE$.toJava$extension(option);
    }

    public boolean hasLocalScope() {
        return this.host().isEmpty();
    }

    public boolean hasGlobalScope() {
        return this.host().isDefined();
    }

    public int hashCode() {
        Object object = this.hashCode$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt(object);
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt(this.hashCode$lzyINIT1());
    }

    private Object hashCode$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.hashCode$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger(MurmurHash3$.MODULE$.productHash(this));
                        serializable = n == null ? LazyVals$NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.hashCode$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String toString() {
        Object object = this.toString$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (String)this.toString$lzyINIT1();
    }

    private Object toString$lzyINIT1() {
        Object object;
        block9: {
            while (true) {
                if ((object = this.toString$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string2 = null;
                    try {
                        StringBuilder sb = new StringBuilder(this.protocol()).append("://").append(this.system());
                        if (this.host().isDefined()) {
                            sb.append('@').append(this.host().get());
                        }
                        if (this.port().isDefined()) {
                            sb.append(':').append(BoxesRunTime.unboxToInt(this.port().get()));
                        }
                        object2 = (string2 = sb.toString()) == null ? LazyVals$NullValue$.MODULE$ : string2;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.toString$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$1, LazyVals$Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.toString$lzy1;
                        LazyVals$.MODULE$.objCAS(this, OFFSET$1, waiting, object2);
                        waiting.countDown();
                    }
                    return string2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block9;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$1, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String hostPort() {
        return this.toString().substring(this.protocol().length() + 3);
    }

    @InternalApi
    public boolean hasInvalidHostCharacters() {
        return this.host().exists((Function1<String, Object>)(Function1<String, boolean> & Serializable)_$1 -> Address$.MODULE$.InvalidHostRegex().findFirstIn((CharSequence)_$1).nonEmpty());
    }

    @InternalApi
    public void checkHostCharacters() {
        Predef$.MODULE$.require(!this.hasInvalidHostCharacters(), this::checkHostCharacters$$anonfun$1);
    }

    public String _1() {
        return this.protocol();
    }

    public String _2() {
        return this.system();
    }

    public Option<String> _3() {
        return this.host();
    }

    public Option<Object> _4() {
        return this.port();
    }

    private final Object checkHostCharacters$$anonfun$1() {
        return new StringBuilder(63).append("Using invalid host characters '").append(this.host()).append("' in the Address is not allowed.").toString();
    }
}

