/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorIdentity;
import org.apache.pekko.actor.ActorIdentity$;
import org.apache.pekko.actor.ActorNotFound$;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefWithCell;
import org.apache.pekko.actor.ActorSelection$;
import org.apache.pekko.actor.ActorSelectionMessage;
import org.apache.pekko.actor.ActorSelectionMessage$;
import org.apache.pekko.actor.Identify;
import org.apache.pekko.actor.Identify$;
import org.apache.pekko.actor.InternalActorRef;
import org.apache.pekko.actor.ScalaActorSelection;
import org.apache.pekko.actor.SelectionPathElement;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.pattern.AskableActorSelection$;
import org.apache.pekko.pattern.package$;
import org.apache.pekko.routing.MurmurHash$;
import org.apache.pekko.util.FutureConverters$;
import org.apache.pekko.util.FutureConverters$FutureOps$;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import org.apache.pekko.util.Timeout;
import org.apache.pekko.util.Timeout$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.Statics;
import scala.util.Success;
import scala.util.Try;

public abstract class ActorSelection
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ActorSelection.class.getDeclaredField("hashCode$lzy1"));
    private volatile Object hashCode$lzy1;

    public static ActorSelection apply(ActorRef actorRef, Iterable<String> iterable) {
        return ActorSelection$.MODULE$.apply(actorRef, iterable);
    }

    public static ActorSelection apply(ActorRef actorRef, String string2) {
        return ActorSelection$.MODULE$.apply(actorRef, string2);
    }

    public static void deliverSelection(InternalActorRef internalActorRef, ActorRef actorRef, ActorSelectionMessage actorSelectionMessage) {
        ActorSelection$.MODULE$.deliverSelection(internalActorRef, actorRef, actorSelectionMessage);
    }

    public static ScalaActorSelection toScala(ActorSelection actorSelection) {
        return ActorSelection$.MODULE$.toScala(actorSelection);
    }

    public abstract ActorRef anchor();

    public abstract IndexedSeq<SelectionPathElement> path();

    public void tell(Object msg, ActorRef sender) {
        ActorSelection$.MODULE$.deliverSelection((InternalActorRef)this.anchor(), sender, ActorSelectionMessage$.MODULE$.apply(msg, this.path(), false));
    }

    public void forward(Object message, ActorContext context) {
        this.tell(message, context.sender());
    }

    public Future<ActorRef> resolveOne(Timeout timeout) {
        ExecutionContext ec = ExecutionContexts$.MODULE$.parasitic();
        Promise p = Promise$.MODULE$.apply();
        ActorSelection actorSelection = package$.MODULE$.ask(this);
        Identify identify = Identify$.MODULE$.apply(None$.MODULE$);
        AskableActorSelection$.MODULE$.ask$extension(actorSelection, identify, timeout, AskableActorSelection$.MODULE$.ask$default$3$extension(actorSelection, identify)).onComplete((Function1<Try, Promise> & Serializable)x$1 -> {
            Object t;
            Try try_ = x$1;
            if (try_ instanceof Success && (t = ((Success)try_).value()) instanceof ActorIdentity) {
                ActorIdentity actorIdentity = ActorIdentity$.MODULE$.unapply((ActorIdentity)t);
                Object object = actorIdentity._1();
                Option<ActorRef> option = actorIdentity._2();
                if (option instanceof Some) {
                    ActorRef ref = (ActorRef)((Some)option).value();
                    return p.success(ref);
                }
            }
            return p.failure(ActorNotFound$.MODULE$.apply(this));
        }, ec);
        return p.future();
    }

    public Future<ActorRef> resolveOne(FiniteDuration timeout) {
        return this.resolveOne(Timeout$.MODULE$.durationToTimeout(timeout));
    }

    public CompletionStage<ActorRef> resolveOneCS(FiniteDuration timeout) {
        Future future = FutureConverters$.MODULE$.FutureOps(this.resolveOne(timeout));
        return FutureConverters$FutureOps$.MODULE$.asJava$extension(future);
    }

    public CompletionStage<ActorRef> resolveOneCS(Duration timeout) {
        return this.resolveOne(timeout);
    }

    public CompletionStage<ActorRef> resolveOne(Duration timeout) {
        Future future = FutureConverters$.MODULE$.FutureOps(this.resolveOne(JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(timeout))));
        return FutureConverters$FutureOps$.MODULE$.asJava$extension(future);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ActorSelection[Anchor(").append(this.anchor().path());
        if (this.anchor().path().uid() != 0) {
            builder.append("#").append(this.anchor().path().uid());
        }
        builder.append("), Path(").append(this.path().mkString("/", "/", "")).append(")]");
        return builder.toString();
    }

    public ActorPath anchorPath() {
        return this.anchor().path();
    }

    public String pathString() {
        return this.path().mkString("/", "/", "");
    }

    public String toSerializationFormat() {
        String string2;
        ActorRef actorRef = this.anchor();
        if (actorRef instanceof ActorRefWithCell) {
            ActorRefWithCell a = (ActorRefWithCell)actorRef;
            string2 = this.anchor().path().toStringWithAddress(a.provider().getDefaultAddress());
        } else {
            string2 = this.anchor().path().toString();
        }
        String anchorPath = string2;
        StringBuilder builder = new StringBuilder();
        builder.append(anchorPath);
        char lastChar = builder.charAt(builder.length() - 1);
        if (this.path().nonEmpty() && lastChar != '/') {
            builder.append(this.path().mkString("/", "/", ""));
        } else if (this.path().nonEmpty()) {
            builder.append(this.path().mkString("/"));
        }
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof ActorSelection)) return false;
        ActorSelection s2 = (ActorSelection)object;
        ActorRef actorRef = this.anchor();
        ActorRef actorRef2 = s2.anchor();
        if (actorRef == null) {
            if (actorRef2 != null) {
                return false;
            }
        } else if (!((Object)actorRef).equals(actorRef2)) return false;
        IndexedSeq<SelectionPathElement> indexedSeq = this.path();
        IndexedSeq<SelectionPathElement> indexedSeq2 = s2.path();
        if (indexedSeq == null) {
            if (indexedSeq2 == null) return true;
            return false;
        } else {
            if (!indexedSeq.equals(indexedSeq2)) return false;
            return true;
        }
    }

    public int hashCode() {
        Object object = this.hashCode$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt(object);
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt(this.hashCode$lzyINIT1());
    }

    private Object hashCode$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.hashCode$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Serializable serializable = null;
                    Integer n = null;
                    try {
                        int h = MurmurHash$.MODULE$.startHash(Statics.anyHash(this.anchor()));
                        h = MurmurHash$.MODULE$.extendHash(h, Statics.anyHash(this.path()), MurmurHash$.MODULE$.startMagicA(), MurmurHash$.MODULE$.startMagicB());
                        n = BoxesRunTime.boxToInteger(MurmurHash$.MODULE$.finalizeHash(h));
                        serializable = n == null ? LazyVals$NullValue$.MODULE$ : n;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, serializable)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.hashCode$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, serializable)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.hashCode$lzy1;
                        LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, serializable);
                        waiting.countDown();
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }
}

