/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor;

import java.io.Serializable;
import java.net.MalformedURLException;
import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorPathExtractor$;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.InvalidActorNameException$;
import org.apache.pekko.actor.RootActorPath$;
import scala.Char$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Nil$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;

public final class ActorPath$
implements Serializable {
    private static final Iterable emptyActorPath;
    public static final ActorPath$ MODULE$;

    private ActorPath$() {
    }

    static {
        MODULE$ = new ActorPath$();
        String ValidSymbols = "-_.*$+:@&=,!~';";
        int ValidPathCode = -1;
        int EmptyPathCode = -2;
        emptyActorPath = (Iterable)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)""), Nil$.MODULE$));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ActorPath$.class);
    }

    public ActorPath fromString(String s2) {
        Option<Tuple2<Address, Iterable<String>>> option;
        String string2 = s2;
        if (string2 != null && !(option = ActorPathExtractor$.MODULE$.unapply(string2)).isEmpty()) {
            Tuple2<Address, Iterable<String>> tuple2 = option.get();
            Address address = tuple2._1();
            Iterable<String> elems = tuple2._2();
            return RootActorPath$.MODULE$.apply(address, RootActorPath$.MODULE$.$lessinit$greater$default$2()).$div(elems);
        }
        throw new MalformedURLException(new StringBuilder(27).append("cannot parse as ActorPath: ").append(s2).toString());
    }

    public final void validatePathElement(String element) {
        this.validatePathElement(element, null);
    }

    public final void validatePathElement(String element, String fullPath) {
        int n = this.findInvalidPathElementCharPosition(element);
        if (-1 == n) {
            return;
        }
        if (-2 == n) {
            throw InvalidActorNameException$.MODULE$.apply(new StringBuilder(37).append("Actor path element must not be empty ").append(this.fullPathMsg$1(fullPath)).toString());
        }
        int invalidAt = n;
        throw InvalidActorNameException$.MODULE$.apply(new StringBuilder(105).append("Invalid actor path element [").append(element).append("]").append(this.fullPathMsg$1(fullPath)).append(", illegal character [").append(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(element), invalidAt)).append("] at position: ").append(invalidAt).append(". ").append("Actor paths MUST: ").append("not start with `$`, ").append(new StringBuilder(90).append("include only ASCII letters and can only contain these special characters: ").append("-_.*$+:@&=,!~';").append(".").toString()).toString());
    }

    public final boolean isValidPathElement(String s2) {
        return this.findInvalidPathElementCharPosition(s2) == -1;
    }

    private final int findInvalidPathElementCharPosition(String s2) {
        if (s2.isEmpty()) {
            return -2;
        }
        int len = s2.length();
        if (len > 0 && s2.charAt(0) != '$') {
            return this.validate$1(len, s2, 0);
        }
        return 0;
    }

    public final Iterable<String> emptyActorPath() {
        return emptyActorPath;
    }

    private final String fullPathMsg$1(String fullPath$1) {
        if (fullPath$1 != null) {
            return new StringBuilder(13).append(" (in path [").append(fullPath$1).append("])").toString();
        }
        return "";
    }

    private final boolean isValidChar$1(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || "-_.*$+:@&=,!~';".indexOf(Char$.MODULE$.char2int(c)) != -1;
    }

    private final boolean isHexChar$1(char c) {
        return c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    private final int validate$1(int len$1, String s$1, int pos) {
        while (pos < len$1) {
            char c = s$1.charAt(pos);
            char c2 = c;
            if (this.isValidChar$1(c2)) {
                ++pos;
                continue;
            }
            if ('%' == c && pos + 2 < len$1 && this.isHexChar$1(s$1.charAt(pos + 1)) && this.isHexChar$1(s$1.charAt(pos + 2))) {
                pos += 3;
                continue;
            }
            return pos;
        }
        return -1;
    }
}

