/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.output;

import io.bullet.borer.Borer;
import io.bullet.borer.ByteAccess;
import io.bullet.borer.Output;
import io.bullet.borer.internal.ByteBufferCache$;
import io.bullet.borer.output.ToByteBufferOutput$ToByteBufferProvider$;
import java.nio.ByteBuffer;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface ToByteBufferOutput {
    public static void $init$(ToByteBufferOutput $this) {
    }

    public static ToByteBufferOutput$ToByteBufferProvider$ ToByteBufferProvider$(ToByteBufferOutput $this) {
        return $this.ToByteBufferProvider();
    }

    default public ToByteBufferOutput$ToByteBufferProvider$ ToByteBufferProvider() {
        return new ToByteBufferOutput$ToByteBufferProvider$(this);
    }

    public final class Chunk {
        private final ByteBuffer buffer;
        private Chunk next;

        public Chunk(ByteBuffer buffer, Chunk next) {
            this.buffer = buffer;
            this.next = next;
        }

        public ByteBuffer buffer() {
            return this.buffer;
        }

        public Chunk next() {
            return this.next;
        }

        public void next_$eq(Chunk x$1) {
            this.next = x$1;
        }
    }

    public final class ToByteBuffer
    implements Output {
        private final int bufferSize;
        private final boolean allowBufferCaching;
        private ByteBuffer currentChunkBuffer;
        private Chunk rootChunk;
        private Chunk currentChunk;
        private long fullChunksSize;
        private final /* synthetic */ ToByteBufferOutput $outer;

        public ToByteBuffer(ToByteBufferOutput $outer, int bufferSize, boolean allowBufferCaching) {
            this.bufferSize = bufferSize;
            this.allowBufferCaching = allowBufferCaching;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public long size() {
            if (this.currentChunkBuffer != null) {
                return this.fullChunksSize + (long)this.currentChunkBuffer.position();
            }
            return 0L;
        }

        @Override
        public ToByteBuffer writeByte(byte by) {
            if (this.inline$currentChunkBuffer() == null) {
                this.inline$allocateBuffer();
            }
            if (!this.currentChunkBuffer.hasRemaining()) {
                this.appendChunk();
            }
            this.currentChunkBuffer.put(by);
            return this;
        }

        @Override
        public ToByteBuffer writeBytes(byte a, byte b) {
            if (this.inline$currentChunkBuffer() == null) {
                this.inline$allocateBuffer();
            }
            if (this.currentChunkBuffer.remaining() >= 2) {
                this.currentChunkBuffer.put(a);
                this.currentChunkBuffer.put(b);
                return this;
            }
            return this.writeByte(a).writeByte(b);
        }

        @Override
        public ToByteBuffer writeShort(short value) {
            if (this.inline$currentChunkBuffer() == null) {
                this.inline$allocateBuffer();
            }
            if (this.currentChunkBuffer.remaining() >= 2) {
                this.currentChunkBuffer.putShort(value);
                return this;
            }
            return this.writeByte((byte)(value >> 8)).writeByte((byte)value);
        }

        @Override
        public ToByteBuffer writeBytes(byte a, byte b, byte c) {
            if (this.inline$currentChunkBuffer() == null) {
                this.inline$allocateBuffer();
            }
            if (this.currentChunkBuffer.remaining() >= 3) {
                this.currentChunkBuffer.put(a);
                this.currentChunkBuffer.put(b);
                this.currentChunkBuffer.put(c);
                return this;
            }
            return this.writeByte(a).writeByte(b).writeByte(c);
        }

        @Override
        public ToByteBuffer writeBytes(byte a, byte b, byte c, byte d) {
            if (this.inline$currentChunkBuffer() == null) {
                this.inline$allocateBuffer();
            }
            if (this.currentChunkBuffer.remaining() >= 4) {
                this.currentChunkBuffer.put(a);
                this.currentChunkBuffer.put(b);
                this.currentChunkBuffer.put(c);
                this.currentChunkBuffer.put(d);
                return this;
            }
            return this.writeByte(a).writeByte(b).writeByte(c).writeByte(d);
        }

        @Override
        public ToByteBuffer writeInt(int value) {
            if (this.inline$currentChunkBuffer() == null) {
                this.inline$allocateBuffer();
            }
            if (this.currentChunkBuffer.remaining() >= 4) {
                this.currentChunkBuffer.putInt(value);
                return this;
            }
            return this.writeShort((short)(value >> 16)).writeShort((short)value);
        }

        @Override
        public ToByteBuffer writeLong(long value) {
            if (this.inline$currentChunkBuffer() == null) {
                this.inline$allocateBuffer();
            }
            if (this.currentChunkBuffer.remaining() >= 8) {
                this.currentChunkBuffer.putLong(value);
                return this;
            }
            return this.writeInt((int)(value >> 32)).writeInt((int)value);
        }

        @Override
        public <Bytes> ToByteBuffer writeBytes(Bytes bytes, ByteAccess<Bytes> byteAccess) {
            if (this.inline$currentChunkBuffer() == null) {
                this.inline$allocateBuffer();
            }
            return this.rec$1(byteAccess, bytes);
        }

        @Override
        public ByteBuffer result() {
            long longSize;
            int intSize;
            if (this.inline$currentChunkBuffer() == null) {
                this.inline$allocateBuffer();
            }
            if ((long)(intSize = (int)(longSize = this.size())) != longSize) {
                throw new Borer.Error.Overflow<ToByteBuffer>(this, StringOps$.MODULE$.format$extension("Output size of %,d bytes too large for ByteBuffer", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(longSize)})));
            }
            ByteBuffer buf = ByteBuffer.allocate(intSize);
            return this.rec$2(buf, this.rootChunk);
        }

        private void allocateBuffer() {
            this.currentChunkBuffer = this.allowBufferCaching ? ByteBufferCache$.MODULE$.acquire(this.bufferSize) : ByteBuffer.allocate(this.bufferSize);
            this.currentChunk = this.rootChunk = new Chunk(this.currentChunkBuffer, null);
            this.fullChunksSize = 0L;
        }

        private void appendChunk() {
            this.currentChunkBuffer = ByteBuffer.allocate(this.bufferSize);
            Chunk newChunk = new Chunk(this.currentChunkBuffer, null);
            this.currentChunk.next_$eq(newChunk);
            this.currentChunk = newChunk;
            this.fullChunksSize += (long)this.bufferSize;
        }

        public String toString() {
            return new StringBuilder(26).append("Output.ToByteBuffer index ").append(this.size()).toString();
        }

        public final ByteBuffer inline$currentChunkBuffer() {
            return this.currentChunkBuffer;
        }

        public final void inline$allocateBuffer() {
            this.allocateBuffer();
        }

        public final /* synthetic */ ToByteBufferOutput io$bullet$borer$output$ToByteBufferOutput$ToByteBuffer$$$outer() {
            return this.$outer;
        }

        private final ToByteBuffer rec$1(ByteAccess byteAccess$1, Object rest) {
            Object newRest;
            while (!byteAccess$1.isEmpty(newRest = byteAccess$1.copyToByteBuffer(rest, this.currentChunkBuffer))) {
                this.appendChunk();
                rest = newRest;
            }
            return this;
        }

        private final ByteBuffer rec$2(ByteBuffer buf$1, Chunk chunk) {
            while (chunk != null) {
                buf$1.put(chunk.buffer().flip());
                chunk = chunk.next();
            }
            if (this.allowBufferCaching) {
                ByteBufferCache$.MODULE$.release(this.currentChunkBuffer);
            }
            this.currentChunkBuffer = null;
            return buf$1.flip();
        }
    }
}

