/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.output;

import io.bullet.borer.Borer;
import io.bullet.borer.ByteAccess;
import io.bullet.borer.Output;
import io.bullet.borer.internal.ByteArrayCache$;
import io.bullet.borer.output.ToByteArrayOutput$ToByteArrayProvider$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface ToByteArrayOutput {
    public static void $init$(ToByteArrayOutput $this) {
    }

    public static ToByteArrayOutput$ToByteArrayProvider$ ToByteArrayProvider$(ToByteArrayOutput $this) {
        return $this.ToByteArrayProvider();
    }

    default public ToByteArrayOutput$ToByteArrayProvider$ ToByteArrayProvider() {
        return new ToByteArrayOutput$ToByteArrayProvider$(this);
    }

    public final class ArrayChunk {
        private final byte[] buffer;
        private ArrayChunk next;

        public ArrayChunk(byte[] buffer, ArrayChunk next) {
            this.buffer = buffer;
            this.next = next;
        }

        public byte[] buffer() {
            return this.buffer;
        }

        public ArrayChunk next() {
            return this.next;
        }

        public void next_$eq(ArrayChunk x$1) {
            this.next = x$1;
        }
    }

    public final class ToByteArray
    implements Output {
        private final int bufferSize;
        private final boolean allowBufferCaching;
        private byte[] currentChunkBuffer;
        private int currentChunkBufferCursor;
        private ArrayChunk rootChunk;
        private ArrayChunk currentChunk;
        private long filledChunksSize;
        private final /* synthetic */ ToByteArrayOutput $outer;

        public ToByteArray(ToByteArrayOutput $outer, int bufferSize, boolean allowBufferCaching) {
            this.bufferSize = bufferSize;
            this.allowBufferCaching = allowBufferCaching;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public ToByteArray writeByte(byte by) {
            if (this.inline$currentChunkBuffer() == null) {
                this.inline$allocateBuffer();
            }
            if (this.currentChunkBufferCursor == this.bufferSize) {
                this.appendChunk();
            }
            int cursor = this.currentChunkBufferCursor;
            this.currentChunkBuffer[cursor] = by;
            this.currentChunkBufferCursor = cursor + 1;
            return this;
        }

        @Override
        public ToByteArray writeBytes(byte a, byte b) {
            if (this.currentChunkBufferCursor < this.bufferSize - 1) {
                if (this.inline$currentChunkBuffer() == null) {
                    this.inline$allocateBuffer();
                }
                int cursor = this.currentChunkBufferCursor;
                this.currentChunkBuffer[cursor] = a;
                this.currentChunkBuffer[cursor + 1] = b;
                this.currentChunkBufferCursor = cursor + 2;
                return this;
            }
            return this.writeByte(a).writeByte(b);
        }

        @Override
        public ToByteArray writeBytes(byte a, byte b, byte c) {
            if (this.currentChunkBufferCursor < this.bufferSize - 2) {
                if (this.inline$currentChunkBuffer() == null) {
                    this.inline$allocateBuffer();
                }
                int cursor = this.currentChunkBufferCursor;
                this.currentChunkBuffer[cursor] = a;
                this.currentChunkBuffer[cursor + 1] = b;
                this.currentChunkBuffer[cursor + 2] = c;
                this.currentChunkBufferCursor = cursor + 3;
                return this;
            }
            return this.writeByte(a).writeByte(b).writeByte(c);
        }

        @Override
        public ToByteArray writeBytes(byte a, byte b, byte c, byte d) {
            if (this.currentChunkBufferCursor < this.bufferSize - 3) {
                if (this.inline$currentChunkBuffer() == null) {
                    this.inline$allocateBuffer();
                }
                int cursor = this.currentChunkBufferCursor;
                this.currentChunkBuffer[cursor] = a;
                this.currentChunkBuffer[cursor + 1] = b;
                this.currentChunkBuffer[cursor + 2] = c;
                this.currentChunkBuffer[cursor + 3] = d;
                this.currentChunkBufferCursor = cursor + 4;
                return this;
            }
            return this.writeByte(a).writeByte(b).writeByte(c).writeByte(d);
        }

        @Override
        public <Bytes> ToByteArray writeBytes(Bytes bytes, ByteAccess<Bytes> byteAccess) {
            if (this.inline$currentChunkBuffer() == null) {
                this.inline$allocateBuffer();
            }
            return this.rec$1(byteAccess, bytes);
        }

        public byte[] result() {
            long longSize;
            int intSize;
            if (this.inline$currentChunkBuffer() == null) {
                this.inline$allocateBuffer();
            }
            if ((long)(intSize = (int)(longSize = this.inline$filledChunksSize() + (long)this.inline$currentChunkBufferCursor())) != longSize) {
                throw new Borer.Error.Overflow<ToByteArray>(this, StringOps$.MODULE$.format$extension("Output size of %,d bytes too large for byte array", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(longSize)})));
            }
            byte[] array = new byte[intSize];
            return this.rec$2(array, this.rootChunk, 0);
        }

        private void allocateBuffer() {
            this.currentChunkBuffer = this.allowBufferCaching ? ByteArrayCache$.MODULE$.acquire(this.bufferSize) : new byte[this.bufferSize];
            this.currentChunkBufferCursor = 0;
            this.currentChunk = this.rootChunk = new ArrayChunk(this.currentChunkBuffer, null);
            this.filledChunksSize = 0L;
        }

        private void appendChunk() {
            this.currentChunkBuffer = new byte[this.bufferSize];
            ArrayChunk newChunk = new ArrayChunk(this.currentChunkBuffer, null);
            this.currentChunkBufferCursor = 0;
            this.currentChunk.next_$eq(newChunk);
            this.currentChunk = newChunk;
            this.filledChunksSize += (long)this.bufferSize;
        }

        public String toString() {
            return new StringBuilder(25).append("Output.ToByteArray index ").append(this.inline$filledChunksSize() + (long)this.inline$currentChunkBufferCursor()).toString();
        }

        public final long inline$filledChunksSize() {
            return this.filledChunksSize;
        }

        public final int inline$currentChunkBufferCursor() {
            return this.currentChunkBufferCursor;
        }

        public final byte[] inline$currentChunkBuffer() {
            return this.currentChunkBuffer;
        }

        public final void inline$allocateBuffer() {
            this.allocateBuffer();
        }

        public final /* synthetic */ ToByteArrayOutput io$bullet$borer$output$ToByteArrayOutput$ToByteArray$$$outer() {
            return this.$outer;
        }

        private final ToByteArray rec$1(ByteAccess byteAccess$1, Object rest) {
            long len;
            while (true) {
                int remaining = this.bufferSize - this.currentChunkBufferCursor;
                len = byteAccess$1.sizeOf(rest);
                Object newRest = byteAccess$1.copyToByteArray(rest, this.currentChunkBuffer, this.currentChunkBufferCursor);
                if (len <= (long)remaining) break;
                this.appendChunk();
                rest = newRest;
            }
            this.currentChunkBufferCursor += (int)len;
            if (this.currentChunkBufferCursor < 0) {
                throw new Borer.Error.Overflow<ToByteArray>(this, StringOps$.MODULE$.format$extension("Output size exceed 2^31 bytes", ScalaRunTime$.MODULE$.genericWrapArray(new Object[0])));
            }
            return this;
        }

        private final byte[] rec$2(byte[] array$1, ArrayChunk chunk, int cursor) {
            while (chunk != null) {
                int len = chunk.next() == null ? this.currentChunkBufferCursor : this.bufferSize;
                System.arraycopy(chunk.buffer(), 0, array$1, cursor, len);
                ArrayChunk arrayChunk = chunk.next();
                int n = cursor + this.bufferSize;
                chunk = arrayChunk;
                cursor = n;
            }
            if (this.allowBufferCaching) {
                ByteArrayCache$.MODULE$.release(this.currentChunkBuffer);
            }
            this.currentChunkBuffer = null;
            return array$1;
        }
    }
}

