/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.json;

import io.bullet.borer.Borer;
import io.bullet.borer.ByteAccess;
import io.bullet.borer.Output;
import io.bullet.borer.Output$;
import io.bullet.borer.Tag;
import io.bullet.borer.internal.Renderer;
import io.bullet.borer.internal.Util$;
import io.bullet.borer.json.JsonRenderer$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.math.package$;
import scala.runtime.Nothing$;
import scala.runtime.RichDouble$;
import scala.runtime.RichFloat$;

public final class JsonRenderer
extends Renderer {
    private Output out;
    private final int indent;
    private int level;
    private long levelType;
    private long levelCount;
    private boolean sepRequired;
    private int currentIndent;

    public static JsonRenderer apply(Output output, Borer.EncodingConfig encodingConfig) {
        return JsonRenderer$.MODULE$.apply(output, encodingConfig);
    }

    public static double apply$mcDDD$sp(double d, double d2) {
        return JsonRenderer$.MODULE$.apply$mcDDD$sp(d, d2);
    }

    public static double apply$mcDDI$sp(double d, int n) {
        return JsonRenderer$.MODULE$.apply$mcDDI$sp(d, n);
    }

    public static double apply$mcDDJ$sp(double d, long l) {
        return JsonRenderer$.MODULE$.apply$mcDDJ$sp(d, l);
    }

    public static double apply$mcDID$sp(int n, double d) {
        return JsonRenderer$.MODULE$.apply$mcDID$sp(n, d);
    }

    public static double apply$mcDII$sp(int n, int n2) {
        return JsonRenderer$.MODULE$.apply$mcDII$sp(n, n2);
    }

    public static double apply$mcDIJ$sp(int n, long l) {
        return JsonRenderer$.MODULE$.apply$mcDIJ$sp(n, l);
    }

    public static double apply$mcDJD$sp(long l, double d) {
        return JsonRenderer$.MODULE$.apply$mcDJD$sp(l, d);
    }

    public static double apply$mcDJI$sp(long l, int n) {
        return JsonRenderer$.MODULE$.apply$mcDJI$sp(l, n);
    }

    public static double apply$mcDJJ$sp(long l, long l2) {
        return JsonRenderer$.MODULE$.apply$mcDJJ$sp(l, l2);
    }

    public static float apply$mcFDD$sp(double d, double d2) {
        return JsonRenderer$.MODULE$.apply$mcFDD$sp(d, d2);
    }

    public static float apply$mcFDI$sp(double d, int n) {
        return JsonRenderer$.MODULE$.apply$mcFDI$sp(d, n);
    }

    public static float apply$mcFDJ$sp(double d, long l) {
        return JsonRenderer$.MODULE$.apply$mcFDJ$sp(d, l);
    }

    public static float apply$mcFID$sp(int n, double d) {
        return JsonRenderer$.MODULE$.apply$mcFID$sp(n, d);
    }

    public static float apply$mcFII$sp(int n, int n2) {
        return JsonRenderer$.MODULE$.apply$mcFII$sp(n, n2);
    }

    public static float apply$mcFIJ$sp(int n, long l) {
        return JsonRenderer$.MODULE$.apply$mcFIJ$sp(n, l);
    }

    public static float apply$mcFJD$sp(long l, double d) {
        return JsonRenderer$.MODULE$.apply$mcFJD$sp(l, d);
    }

    public static float apply$mcFJI$sp(long l, int n) {
        return JsonRenderer$.MODULE$.apply$mcFJI$sp(l, n);
    }

    public static float apply$mcFJJ$sp(long l, long l2) {
        return JsonRenderer$.MODULE$.apply$mcFJJ$sp(l, l2);
    }

    public static int apply$mcIDD$sp(double d, double d2) {
        return JsonRenderer$.MODULE$.apply$mcIDD$sp(d, d2);
    }

    public static int apply$mcIDI$sp(double d, int n) {
        return JsonRenderer$.MODULE$.apply$mcIDI$sp(d, n);
    }

    public static int apply$mcIDJ$sp(double d, long l) {
        return JsonRenderer$.MODULE$.apply$mcIDJ$sp(d, l);
    }

    public static int apply$mcIID$sp(int n, double d) {
        return JsonRenderer$.MODULE$.apply$mcIID$sp(n, d);
    }

    public static int apply$mcIII$sp(int n, int n2) {
        return JsonRenderer$.MODULE$.apply$mcIII$sp(n, n2);
    }

    public static int apply$mcIIJ$sp(int n, long l) {
        return JsonRenderer$.MODULE$.apply$mcIIJ$sp(n, l);
    }

    public static int apply$mcIJD$sp(long l, double d) {
        return JsonRenderer$.MODULE$.apply$mcIJD$sp(l, d);
    }

    public static int apply$mcIJI$sp(long l, int n) {
        return JsonRenderer$.MODULE$.apply$mcIJI$sp(l, n);
    }

    public static int apply$mcIJJ$sp(long l, long l2) {
        return JsonRenderer$.MODULE$.apply$mcIJJ$sp(l, l2);
    }

    public static long apply$mcJDD$sp(double d, double d2) {
        return JsonRenderer$.MODULE$.apply$mcJDD$sp(d, d2);
    }

    public static long apply$mcJDI$sp(double d, int n) {
        return JsonRenderer$.MODULE$.apply$mcJDI$sp(d, n);
    }

    public static long apply$mcJDJ$sp(double d, long l) {
        return JsonRenderer$.MODULE$.apply$mcJDJ$sp(d, l);
    }

    public static long apply$mcJID$sp(int n, double d) {
        return JsonRenderer$.MODULE$.apply$mcJID$sp(n, d);
    }

    public static long apply$mcJII$sp(int n, int n2) {
        return JsonRenderer$.MODULE$.apply$mcJII$sp(n, n2);
    }

    public static long apply$mcJIJ$sp(int n, long l) {
        return JsonRenderer$.MODULE$.apply$mcJIJ$sp(n, l);
    }

    public static long apply$mcJJD$sp(long l, double d) {
        return JsonRenderer$.MODULE$.apply$mcJJD$sp(l, d);
    }

    public static long apply$mcJJI$sp(long l, int n) {
        return JsonRenderer$.MODULE$.apply$mcJJI$sp(l, n);
    }

    public static long apply$mcJJJ$sp(long l, long l2) {
        return JsonRenderer$.MODULE$.apply$mcJJJ$sp(l, l2);
    }

    public static void apply$mcVDD$sp(double d, double d2) {
        JsonRenderer$.MODULE$.apply$mcVDD$sp(d, d2);
    }

    public static void apply$mcVDI$sp(double d, int n) {
        JsonRenderer$.MODULE$.apply$mcVDI$sp(d, n);
    }

    public static void apply$mcVDJ$sp(double d, long l) {
        JsonRenderer$.MODULE$.apply$mcVDJ$sp(d, l);
    }

    public static void apply$mcVID$sp(int n, double d) {
        JsonRenderer$.MODULE$.apply$mcVID$sp(n, d);
    }

    public static void apply$mcVII$sp(int n, int n2) {
        JsonRenderer$.MODULE$.apply$mcVII$sp(n, n2);
    }

    public static void apply$mcVIJ$sp(int n, long l) {
        JsonRenderer$.MODULE$.apply$mcVIJ$sp(n, l);
    }

    public static void apply$mcVJD$sp(long l, double d) {
        JsonRenderer$.MODULE$.apply$mcVJD$sp(l, d);
    }

    public static void apply$mcVJI$sp(long l, int n) {
        JsonRenderer$.MODULE$.apply$mcVJI$sp(l, n);
    }

    public static void apply$mcVJJ$sp(long l, long l2) {
        JsonRenderer$.MODULE$.apply$mcVJJ$sp(l, l2);
    }

    public static boolean apply$mcZDD$sp(double d, double d2) {
        return JsonRenderer$.MODULE$.apply$mcZDD$sp(d, d2);
    }

    public static boolean apply$mcZDI$sp(double d, int n) {
        return JsonRenderer$.MODULE$.apply$mcZDI$sp(d, n);
    }

    public static boolean apply$mcZDJ$sp(double d, long l) {
        return JsonRenderer$.MODULE$.apply$mcZDJ$sp(d, l);
    }

    public static boolean apply$mcZID$sp(int n, double d) {
        return JsonRenderer$.MODULE$.apply$mcZID$sp(n, d);
    }

    public static boolean apply$mcZII$sp(int n, int n2) {
        return JsonRenderer$.MODULE$.apply$mcZII$sp(n, n2);
    }

    public static boolean apply$mcZIJ$sp(int n, long l) {
        return JsonRenderer$.MODULE$.apply$mcZIJ$sp(n, l);
    }

    public static boolean apply$mcZJD$sp(long l, double d) {
        return JsonRenderer$.MODULE$.apply$mcZJD$sp(l, d);
    }

    public static boolean apply$mcZJI$sp(long l, int n) {
        return JsonRenderer$.MODULE$.apply$mcZJI$sp(l, n);
    }

    public static boolean apply$mcZJJ$sp(long l, long l2) {
        return JsonRenderer$.MODULE$.apply$mcZJJ$sp(l, l2);
    }

    public static Function1<Output, Function1<Borer.EncodingConfig, JsonRenderer>> curried() {
        return JsonRenderer$.MODULE$.curried();
    }

    public static Function1<Tuple2<Output, Borer.EncodingConfig>, JsonRenderer> tupled() {
        return JsonRenderer$.MODULE$.tupled();
    }

    public JsonRenderer(Output out, int indent) {
        this.out = out;
        this.indent = indent;
    }

    @Override
    public Output out() {
        return this.out;
    }

    public void out_$eq(Output x$1) {
        this.out = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onNull() {
        if ((this.inline$levelType() & (this.inline$levelCount() ^ 0xFFFFFFFFFFFFFFFFL) & 1L) == 0L) {
            void var1_2;
            Output underlying$proxy1 = this.writeSep(this.out());
            Output out$proxy1 = underlying$proxy1.writeBytes((byte)110, (byte)117, (byte)108, (byte)108);
            this.inline$levelCount_$eq(this.inline$levelCount() ^ 1L);
            this.inline$sepRequired_$eq(true);
            this.out_$eq((Output)var1_2);
            return;
        }
        throw this.failCannotBeMapKey(this.out(), "null");
    }

    @Override
    public void onUndefined() {
        throw this.failUnsupported(this.out(), "the `undefined` value");
    }

    @Override
    public void onBoolean(boolean value) {
        if ((this.inline$levelType() & (this.inline$levelCount() ^ 0xFFFFFFFFFFFFFFFFL) & 1L) == 0L) {
            Output output;
            Output o = this.writeSep(this.out());
            if (value) {
                Output underlying$proxy2 = o;
                output = underlying$proxy2.writeBytes((byte)116, (byte)114, (byte)117, (byte)101);
            } else {
                Output underlying$proxy3 = o;
                Output underlying$proxy4 = underlying$proxy3.writeByte((byte)102);
                output = underlying$proxy4.writeBytes((byte)97, (byte)108, (byte)115, (byte)101);
            }
            Output out$proxy2 = o = output;
            this.inline$levelCount_$eq(this.inline$levelCount() ^ 1L);
            this.inline$sepRequired_$eq(true);
            this.out_$eq(out$proxy2);
            return;
        }
        throw this.failCannotBeMapKey(this.out(), "boolean values");
    }

    @Override
    public void onInt(int value) {
        this.onLong(value);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onLong(long value) {
        if ((this.inline$levelType() & (this.inline$levelCount() ^ 0xFFFFFFFFFFFFFFFFL) & 1L) == 0L) {
            void var3_2;
            Output out$proxy3 = this.writeLongStr(this.writeSep(this.out()), value);
            this.inline$levelCount_$eq(this.inline$levelCount() ^ 1L);
            this.inline$sepRequired_$eq(true);
            this.out_$eq((Output)var3_2);
            return;
        }
        throw this.failCannotBeMapKey(this.out(), "integer values");
    }

    @Override
    public void onOverLong(boolean negative, long value) {
        if ((this.inline$levelType() & (this.inline$levelCount() ^ 0xFFFFFFFFFFFFFFFFL) & 1L) == 0L) {
            Output output;
            Output o = this.writeSep(this.out());
            if (negative) {
                long v = value + 1L;
                if (v == 0L) {
                    output = Output$.MODULE$.writeStringAsAsciiBytes(o, "-18446744073709551616");
                } else {
                    Output underlying$proxy5 = o;
                    output = this.writeOverLong(underlying$proxy5.writeByte((byte)45), v);
                }
            } else {
                output = this.writeOverLong(o, value);
            }
            Output out$proxy4 = o = output;
            this.inline$levelCount_$eq(this.inline$levelCount() ^ 1L);
            this.inline$sepRequired_$eq(true);
            this.out_$eq(out$proxy4);
            return;
        }
        throw this.failCannotBeMapKey(this.out(), "an Overlong");
    }

    @Override
    public void onFloat16(float value) {
        throw this.failUnsupported(this.out(), "Float16 values");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFloat(float value) {
        if ((this.inline$levelType() & (this.inline$levelCount() ^ 0xFFFFFFFFFFFFFFFFL) & 1L) == 0L) {
            if (!Predef$.MODULE$.float2Float(value).isNaN()) {
                if (!RichFloat$.MODULE$.isInfinity$extension(Predef$.MODULE$.floatWrapper(value))) {
                    void var2_2;
                    Output out$proxy5 = Output$.MODULE$.writeStringAsAsciiBytes(this.writeSep(this.out()), Util$.MODULE$.floatToString(value));
                    this.inline$levelCount_$eq(this.inline$levelCount() ^ 1L);
                    this.inline$sepRequired_$eq(true);
                    this.out_$eq((Output)var2_2);
                    return;
                }
                throw this.failUnsupported(this.out(), "`Infinity` floating point values");
            }
            throw this.failUnsupported(this.out(), "`NaN` floating point values");
        }
        throw this.failCannotBeMapKey(this.out(), "floating point values");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onDouble(double value) {
        if ((this.inline$levelType() & (this.inline$levelCount() ^ 0xFFFFFFFFFFFFFFFFL) & 1L) == 0L) {
            if (!Predef$.MODULE$.double2Double(value).isNaN()) {
                if (!RichDouble$.MODULE$.isInfinity$extension(Predef$.MODULE$.doubleWrapper(value))) {
                    void var3_2;
                    Output out$proxy6 = Output$.MODULE$.writeStringAsAsciiBytes(this.writeSep(this.out()), Util$.MODULE$.doubleToString(value));
                    this.inline$levelCount_$eq(this.inline$levelCount() ^ 1L);
                    this.inline$sepRequired_$eq(true);
                    this.out_$eq((Output)var3_2);
                    return;
                }
                throw this.failUnsupported(this.out(), "`Infinity` floating point values");
            }
            throw this.failUnsupported(this.out(), "`NaN` floating point values");
        }
        throw this.failCannotBeMapKey(this.out(), "floating point values");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onNumberString(String value) {
        if ((this.inline$levelType() & (this.inline$levelCount() ^ 0xFFFFFFFFFFFFFFFFL) & 1L) == 0L) {
            void var2_2;
            Output out$proxy7 = Output$.MODULE$.writeStringAsAsciiBytes(this.writeSep(this.out()), value);
            this.inline$levelCount_$eq(this.inline$levelCount() ^ 1L);
            this.inline$sepRequired_$eq(true);
            this.out_$eq((Output)var2_2);
            return;
        }
        throw this.failCannotBeMapKey(this.out(), "number strings");
    }

    @Override
    public <Bytes> void onBytes(Bytes value, ByteAccess<Bytes> evidence$1) {
        throw this.failUnsupported(this.out(), "byte strings");
    }

    @Override
    public void onBytesStart() {
        throw this.failUnsupported(this.out(), "byte string streams");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onString(String value) {
        void var2_4;
        Output underlying$proxy8 = this.writeSep(this.out());
        Output underlying$proxy9 = this.rec$1(value, underlying$proxy8.writeByte((byte)34), 0);
        Output out$proxy8 = underlying$proxy9.writeByte((byte)34);
        this.inline$levelCount_$eq(this.inline$levelCount() ^ 1L);
        this.inline$sepRequired_$eq(true);
        this.out_$eq((Output)var2_4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onChars(char[] buffer, int length) {
        void var3_5;
        Output underlying$proxy12 = this.writeSep(this.out());
        Output underlying$proxy13 = this.rec$2(length, buffer, underlying$proxy12.writeByte((byte)34), 0);
        Output out$proxy9 = underlying$proxy13.writeByte((byte)34);
        this.inline$levelCount_$eq(this.inline$levelCount() ^ 1L);
        this.inline$sepRequired_$eq(true);
        this.out_$eq((Output)var3_5);
    }

    @Override
    public <Bytes> void onText(Bytes value, ByteAccess<Bytes> evidence$1) {
        throw this.failUnsupported(this.out(), "text byte strings");
    }

    @Override
    public void onTextStart() {
        throw this.failUnsupported(this.out(), "text byte string streams");
    }

    @Override
    public void onArrayHeader(long length) {
        throw this.failUnsupported(this.out(), "definite-length arrays");
    }

    @Override
    public void onArrayStart() {
        if ((this.inline$levelType() & (this.inline$levelCount() ^ 0xFFFFFFFFFFFFFFFFL) & 1L) == 0L) {
            Output o = this.writeSep(this.out());
            ++this.level;
            if (this.level < 64) {
                this.levelType <<= 1;
                this.levelCount <<= 1;
            } else {
                throw this.failUnsupported(o, "more than 64 JSON Array/Object nesting levels");
            }
            this.sepRequired = false;
            this.currentIndent += this.indent;
            if (this.currentIndent > 0) {
                this.writeAndIndent(o, '[');
                return;
            }
            o.writeByte((byte)91);
            return;
        }
        throw this.failCannotBeMapKey(this.out(), "arrays");
    }

    @Override
    public void onMapHeader(long length) {
        throw this.failUnsupported(this.out(), "definite-length maps");
    }

    @Override
    public void onMapStart() {
        if ((this.inline$levelType() & (this.inline$levelCount() ^ 0xFFFFFFFFFFFFFFFFL) & 1L) == 0L) {
            Output o = this.writeSep(this.out());
            ++this.level;
            if (this.level < 64) {
                this.levelType = this.levelType << 1 | 1L;
                this.levelCount <<= 1;
            } else {
                throw this.failUnsupported(o, "more than 64 JSON Array/Object nesting levels");
            }
            this.sepRequired = false;
            this.currentIndent += this.indent;
            if (this.currentIndent > 0) {
                this.writeAndIndent(o, '{');
                return;
            }
            o.writeByte((byte)123);
            return;
        }
        throw this.failCannotBeMapKey(this.out(), "maps");
    }

    @Override
    public void onBreak() {
        Output output;
        int c;
        int n = c = (this.levelType & 1L) == 0L ? 93 : 125;
        if (this.level > 0) {
            --this.level;
            this.levelType >>>= 1;
            this.levelCount >>>= 1;
            this.currentIndent -= this.indent;
        } else {
            throw this.failValidation(this.out(), "Received BREAK without corresponding ArrayStart or MapStart");
        }
        if (this.indent > 0) {
            Output underlying$proxy14 = this.out();
            output = this.writeIndent(underlying$proxy14.writeByte((byte)10));
        } else {
            output = this.out();
        }
        Output o = output;
        Output out$proxy10 = o.writeByte((byte)c);
        this.inline$levelCount_$eq(this.inline$levelCount() ^ 1L);
        this.inline$sepRequired_$eq(true);
        this.out_$eq(out$proxy10);
    }

    @Override
    public void onTag(Tag value) {
        throw this.failUnsupported(this.out(), "CBOR tags");
    }

    @Override
    public void onSimpleValue(int value) {
        throw this.failUnsupported(this.out(), "CBOR Simple Values");
    }

    @Override
    public void onEndOfInput() {
    }

    private Output writeEscaped(Output out, char c) {
        return out.writeBytes((byte)92, (byte)c);
    }

    private Output writeUnicodeLiteral(Output out, char c) {
        int int$proxy1 = c >> 4;
        int i = int$proxy1 & 0xF;
        char int$proxy2 = c;
        int i2 = int$proxy2 & 0xF;
        return out.writeBytes((byte)92, (byte)117, (byte)48, (byte)48).writeBytes((byte)(48 + i + (0x27 & 9 - i >> 31)), (byte)(48 + i2 + (0x27 & 9 - i2 >> 31)));
    }

    private Output writeSep(Output out) {
        if (this.sepRequired) {
            if (this.indent == 0) {
                return out.writeByte((byte)(44 + (58 - 44 & ~(((int)this.levelType & (int)this.levelCount & 1) - 1))));
            }
            return this.writeSepIndented(out);
        }
        return out;
    }

    private Output writeSepIndented(Output out) {
        if ((this.levelType & this.levelCount & 1L) == 0L) {
            return this.writeAndIndent(out, ',');
        }
        return out.writeBytes((byte)58, (byte)32);
    }

    private Output writeAndIndent(Output out, char c) {
        return this.writeIndent(out.writeBytes((byte)c, (byte)10));
    }

    private Output writeIndent(Output out) {
        int ci;
        Output o = out;
        for (ci = this.currentIndent; ci >= 4; ci -= 4) {
            Output underlying$proxy15 = o;
            o = underlying$proxy15.writeBytes((byte)32, (byte)32, (byte)32, (byte)32);
        }
        if (ci >= 2) {
            Output underlying$proxy16 = o;
            o = underlying$proxy16.writeBytes((byte)32, (byte)32);
            ci -= 2;
        }
        if (ci > 0) {
            Output underlying$proxy17 = o;
            return underlying$proxy17.writeByte((byte)32);
        }
        return o;
    }

    private Output writeOverLong(Output out, long v) {
        long q = (v >>> 1) / 5L;
        long r = v - (q << 3) - (q << 1);
        Output underlying$proxy18 = this.writeLongStr(out, q);
        int i$proxy9 = 48 + (int)r;
        return underlying$proxy18.writeByte((byte)i$proxy9);
    }

    private Output writeLongStr(Output out, long value) {
        if (value != 0L) {
            if (value != Long.MIN_VALUE) {
                return JsonRenderer.phase1$1(value, out, package$.MODULE$.abs(value));
            }
            return Output$.MODULE$.writeStringAsAsciiBytes(out, "-9223372036854775808");
        }
        return out.writeByte((byte)48);
    }

    private Nothing$ failUnsupported(Output out, String what) {
        throw new Borer.Error.Unsupported<Output>(out, new StringBuilder(34).append("The JSON renderer doesn't support ").append(what).toString());
    }

    private Nothing$ failCannotBeMapKey(Output out, String what) {
        throw new Borer.Error.ValidationFailure<Output>(out, new StringBuilder(35).append("JSON does not support ").append(what).append(" as a map key").toString());
    }

    private Nothing$ failInvalidSurrogatePair(Output out, int ix) {
        return this.failValidation(out, new StringBuilder(46).append("Invalid UTF-16 surrogate pair at string index ").append(ix).toString());
    }

    private Nothing$ failValidation(Output out, String msg) {
        throw new Borer.Error.ValidationFailure<Output>(out, msg);
    }

    public final long inline$levelType() {
        return this.levelType;
    }

    public final long inline$levelCount() {
        return this.levelCount;
    }

    public final void inline$levelCount_$eq(long x$0) {
        this.levelCount = x$0;
    }

    public final boolean inline$sepRequired() {
        return this.sepRequired;
    }

    public final void inline$sepRequired_$eq(boolean x$0) {
        this.sepRequired = x$0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Output rec$1(String value$1, Output out, int ix) {
        while (ix < value$1.length()) {
            Output newOut;
            Output output;
            int index = ix;
            int n = value$1.charAt(ix);
            if (34 == n) {
                output = this.writeEscaped(out, '\"');
            } else if (92 == n) {
                output = this.writeEscaped(out, '\\');
            } else {
                int c = n;
                if (c >= 32) {
                    if (c > 127) {
                        Output output2;
                        int codePoint = c;
                        if (codePoint > 2047) {
                            Output output3;
                            if (55296 <= codePoint && codePoint < 57344) {
                                if (codePoint >= 56320) throw this.failInvalidSurrogatePair(out, ix);
                                if (++index >= value$1.length()) throw this.failValidation(out, "Truncated UTF-16 surrogate pair at end of string");
                                codePoint = Character.toCodePoint((char)c, value$1.charAt(index));
                                output3 = out.writeBytes((byte)(0xF0 | codePoint >> 18), (byte)(0x80 | codePoint >> 12 & 0x3F));
                            } else {
                                int i$proxy1 = 0xE0 | codePoint >> 12;
                                output3 = out.writeByte((byte)i$proxy1);
                            }
                            Output underlying$proxy6 = output3;
                            int i$proxy2 = 0x80 | codePoint >> 6 & 0x3F;
                            output2 = underlying$proxy6.writeByte((byte)i$proxy2);
                        } else {
                            int i$proxy3 = 0xC0 | codePoint >> 6;
                            output2 = out.writeByte((byte)i$proxy3);
                        }
                        Output underlying$proxy7 = output2;
                        int i$proxy4 = 0x80 | codePoint & 0x3F;
                        output = underlying$proxy7.writeByte((byte)i$proxy4);
                    } else {
                        output = out.writeByte((byte)c);
                    }
                } else {
                    switch (n) {
                        case 8: {
                            output = this.writeEscaped(out, 'b');
                            break;
                        }
                        case 12: {
                            output = this.writeEscaped(out, 'f');
                            break;
                        }
                        case 10: {
                            output = this.writeEscaped(out, 'n');
                            break;
                        }
                        case 13: {
                            output = this.writeEscaped(out, 'r');
                            break;
                        }
                        case 9: {
                            output = this.writeEscaped(out, 't');
                            break;
                        }
                        default: {
                            int c2 = n;
                            output = this.writeUnicodeLiteral(out, (char)c2);
                            break;
                        }
                    }
                }
            }
            Output output4 = newOut = output;
            int n2 = index + 1;
            out = output4;
            ix = n2;
        }
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Output rec$2(int length$1, char[] buffer$1, Output out, int ix) {
        while (ix < length$1) {
            Output newOut;
            Output output;
            int index = ix;
            int n = buffer$1[ix];
            if (34 == n) {
                output = this.writeEscaped(out, '\"');
            } else if (92 == n) {
                output = this.writeEscaped(out, '\\');
            } else {
                int c = n;
                if (c >= 32) {
                    if (c > 127) {
                        Output output2;
                        int codePoint = c;
                        if (codePoint > 2047) {
                            Output output3;
                            if (55296 <= codePoint && codePoint < 57344) {
                                if (codePoint >= 56320) throw this.failInvalidSurrogatePair(out, ix);
                                if (++index >= length$1) throw this.failValidation(out, "Truncated UTF-16 surrogate pair at end of string");
                                codePoint = Character.toCodePoint((char)c, buffer$1[index]);
                                output3 = out.writeBytes((byte)(0xF0 | codePoint >> 18), (byte)(0x80 | codePoint >> 12 & 0x3F));
                            } else {
                                int i$proxy5 = 0xE0 | codePoint >> 12;
                                output3 = out.writeByte((byte)i$proxy5);
                            }
                            Output underlying$proxy10 = output3;
                            int i$proxy6 = 0x80 | codePoint >> 6 & 0x3F;
                            output2 = underlying$proxy10.writeByte((byte)i$proxy6);
                        } else {
                            int i$proxy7 = 0xC0 | codePoint >> 6;
                            output2 = out.writeByte((byte)i$proxy7);
                        }
                        Output underlying$proxy11 = output2;
                        int i$proxy8 = 0x80 | codePoint & 0x3F;
                        output = underlying$proxy11.writeByte((byte)i$proxy8);
                    } else {
                        output = out.writeByte((byte)c);
                    }
                } else {
                    switch (n) {
                        case 8: {
                            output = this.writeEscaped(out, 'b');
                            break;
                        }
                        case 12: {
                            output = this.writeEscaped(out, 'f');
                            break;
                        }
                        case 10: {
                            output = this.writeEscaped(out, 'n');
                            break;
                        }
                        case 13: {
                            output = this.writeEscaped(out, 'r');
                            break;
                        }
                        case 9: {
                            output = this.writeEscaped(out, 't');
                            break;
                        }
                        default: {
                            int c2 = n;
                            output = this.writeUnicodeLiteral(out, (char)c2);
                            break;
                        }
                    }
                }
            }
            Output output4 = newOut = output;
            int n2 = index + 1;
            out = output4;
            ix = n2;
        }
        return out;
    }

    private static final Output phase2$1(long value$2, Output out$1, int i) {
        int q = i * 52429 >>> 19;
        int r = i - q * 10;
        Output newOut = q != 0 ? JsonRenderer.phase2$1(value$2, out$1, q) : (value$2 < 0L ? out$1.writeByte((byte)45) : out$1);
        int i$proxy10 = 48 + r;
        return newOut.writeByte((byte)i$proxy10);
    }

    private static final Output phase1$1(long value$3, Output out$2, long l) {
        if (l > 65535L) {
            long q = l / 100L;
            int r = (int)(l - q * 100L);
            int rq = r * 52429 >>> 19;
            return JsonRenderer.phase1$1(value$3, out$2, q).writeBytes((byte)(48 + rq), (byte)(48 + r - rq * 10));
        }
        return JsonRenderer.phase2$1(value$3, out$2, (int)l);
    }
}

