/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.json;

import io.bullet.borer.Borer;
import io.bullet.borer.ByteAccess;
import io.bullet.borer.Input;
import io.bullet.borer.Input$;
import io.bullet.borer.Receiver;
import io.bullet.borer.internal.CharArrayCache$;
import io.bullet.borer.internal.Parser;
import io.bullet.borer.json.JsonParser$;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import scala.Function3;
import scala.MatchError;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public final class JsonParser<Bytes>
extends Parser<Bytes> {
    private final Input input;
    private final Config config;
    private final ByteAccess<Bytes> byteAccess;
    private final boolean allowDoubleParsing;
    private char[] chars;
    private int state;
    private int cursorExtra;
    private long auxLong;
    private long _valueIndex;
    private int level;
    private long levelType;
    private int nextChar;

    public static int ARRAY_START() {
        return JsonParser$.MODULE$.ARRAY_START();
    }

    public static int DIGIT() {
        return JsonParser$.MODULE$.DIGIT();
    }

    public static int DQUOTE() {
        return JsonParser$.MODULE$.DQUOTE();
    }

    public static int EOI() {
        return JsonParser$.MODULE$.EOI();
    }

    public static int EXPECT_ARRAY_BREAK() {
        return JsonParser$.MODULE$.EXPECT_ARRAY_BREAK();
    }

    public static int EXPECT_ARRAY_VALUE() {
        return JsonParser$.MODULE$.EXPECT_ARRAY_VALUE();
    }

    public static int EXPECT_END_OF_INPUT() {
        return JsonParser$.MODULE$.EXPECT_END_OF_INPUT();
    }

    public static int EXPECT_MAP_BREAK() {
        return JsonParser$.MODULE$.EXPECT_MAP_BREAK();
    }

    public static int EXPECT_MAP_KEY() {
        return JsonParser$.MODULE$.EXPECT_MAP_KEY();
    }

    public static int EXPECT_MAP_VALUE() {
        return JsonParser$.MODULE$.EXPECT_MAP_VALUE();
    }

    public static int EXPECT_VALUE() {
        return JsonParser$.MODULE$.EXPECT_VALUE();
    }

    public static byte[] HexDigits() {
        return JsonParser$.MODULE$.HexDigits();
    }

    public static int ILLEGAL_CHAR() {
        return JsonParser$.MODULE$.ILLEGAL_CHAR();
    }

    public static int LOWER_F() {
        return JsonParser$.MODULE$.LOWER_F();
    }

    public static int LOWER_N() {
        return JsonParser$.MODULE$.LOWER_N();
    }

    public static int LOWER_T() {
        return JsonParser$.MODULE$.LOWER_T();
    }

    public static int MAP_START() {
        return JsonParser$.MODULE$.MAP_START();
    }

    public static int MINUS() {
        return JsonParser$.MODULE$.MINUS();
    }

    public static byte[] TokenTable() {
        return JsonParser$.MODULE$.TokenTable();
    }

    public static <Bytes, Conf extends Config> Function3<Input<Bytes>, ByteAccess<Bytes>, Conf, Parser<Bytes>> creator() {
        return JsonParser$.MODULE$.creator();
    }

    public static double[] double10pow() {
        return JsonParser$.MODULE$.double10pow();
    }

    public static long[] long10pow() {
        return JsonParser$.MODULE$.long10pow();
    }

    public JsonParser(Input<Bytes> input, Config config, ByteAccess<Bytes> byteAccess) {
        this.input = input;
        this.config = config;
        this.byteAccess = byteAccess;
        this.allowDoubleParsing = !config.readDecimalNumbersOnlyAsNumberStrings();
        this.chars = config.allowBufferCaching() ? CharArrayCache$.MODULE$.acquire(config.initialCharbufferSize()) : new char[config.initialCharbufferSize()];
        this.state = 5;
        this.nextChar = this.nextCharAfterWhitespace();
    }

    @Override
    public Input<Bytes> input() {
        return this.input;
    }

    public Config config() {
        return this.config;
    }

    @Override
    public long valueIndex() {
        return this._valueIndex - 1L;
    }

    public void release() {
        if (this.config().allowBufferCaching()) {
            CharArrayCache$.MODULE$.release(this.chars);
            this.chars = null;
            return;
        }
    }

    @Override
    public int pull(Receiver receiver) {
        this._valueIndex = this.input().cursor();
        int n = this.state;
        switch (n) {
            case 0: {
                return this.parseValue$1(receiver, 0, 2);
            }
            case 1: {
                return this.parseMapKey$1(receiver);
            }
            case 2: {
                return this.parseArrayBreak$1(receiver);
            }
            case 3: {
                return this.parseMapBreak$1(receiver);
            }
            case 4: {
                return this.parseValue$1(receiver, 1, 3);
            }
            case 5: {
                return this.parseValue$1(receiver, 7, 6);
            }
            case 6: {
                return this.parseEndOfInput$1(receiver);
            }
        }
        throw this.failSyntaxError(-2, "End of Input");
    }

    @Override
    public byte padByte() {
        ++this.cursorExtra;
        return -1;
    }

    @Override
    public char padDoubleByte(int remaining) {
        this.cursorExtra += 2 - remaining;
        if (remaining < 1) {
            return '\uffff';
        }
        return (char)(this.input().readByte() << 8 | 0xFF);
    }

    @Override
    public int padQuadByte(int remaining) {
        this.cursorExtra += 4 - remaining;
        int n = remaining;
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: {
                return this.input().readByte() << 24 | 0xFFFFFF;
            }
            case 2: {
                return this.input().readDoubleByteBigEndian() << 16 | 0xFFFF;
            }
            case 3: {
                return this.input().readDoubleByteBigEndian() << 16 | (this.input().readByte() & 0xFF) << 8 | 0xFF;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public long padOctaByte(int remaining) {
        this.cursorExtra += 8 - remaining;
        int n = remaining;
        switch (n) {
            case 0: {
                return -1L;
            }
            case 1: {
                return (long)this.input().readByte() << 56 | 0xFFFFFFFFFFFFFFL;
            }
            case 2: {
                return (long)this.input().readDoubleByteBigEndian() << 48 | 0xFFFFFFFFFFFFL;
            }
            case 3: {
                return (long)this.input().readDoubleByteBigEndian() << 48 | ((long)this.input().readByte() & 0xFFL) << 40 | 0xFFFFFFFFFFL;
            }
            case 4: {
                return (long)this.input().readQuadByteBigEndian() << 32 | 0xFFFFFFFFL;
            }
            case 5: {
                return (long)this.input().readQuadByteBigEndian() << 32 | ((long)this.input().readByte() & 0xFFL) << 24 | 0xFFFFFFL;
            }
            case 6: {
                return (long)this.input().readQuadByteBigEndian() << 32 | ((long)this.input().readDoubleByteBigEndian() & 0xFFFFL) << 16 | 0xFFFFL;
            }
            case 7: {
                return (long)this.input().readQuadByteBigEndian() << 32 | ((long)this.input().readDoubleByteBigEndian() & 0xFFFFL) << 16 | ((long)this.input().readByte() & 0xFFL) << 8 | 0xFFL;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public Bytes padBytes(Bytes rest, long missing) {
        throw new UnsupportedOperationException();
    }

    private int nextCharAfterWhitespace() {
        return this.nextCharAfterWhitespace(this.input().readBytePadded(this) & 0xFF);
    }

    private int nextCharAfterWhitespace(int nextChar) {
        if (nextChar <= 32) {
            return this.skip1$1();
        }
        return nextChar;
    }

    private long longFrom8Digits(long oct) {
        long x = oct * 266L;
        x = x >> 8 & 0xFF00FF00FF00FFL;
        x *= 65636L;
        x = x >> 16 & 0xFFFF0000FFFFL;
        return (x *= 4294977296L) >> 32;
    }

    private String antePrecedingBytesAsAsciiString(int len) {
        int count$proxy6 = len + 1;
        if (this.inline$cursorExtra() > 0) {
            this.unreadWithExtra$28(count$proxy6);
        } else {
            this.input().unread(count$proxy6);
        }
        Bytes bytes = this.input().readBytes(len, this);
        this.input().readBytePadded(this);
        return new String(this.byteAccess.toByteArray(bytes), StandardCharsets.ISO_8859_1);
    }

    private Nothing$ failStringTooLong(int offset) {
        return this.failOverflow(offset, new StringBuilder(57).append("JSON String longer than configured maximum of ").append(this.config().maxStringLength()).append(" characters").toString());
    }

    private Nothing$ failNumberMantissaTooLong(int offset) {
        return this.failOverflow(offset, new StringBuilder(62).append("JSON number mantissa longer than configured maximum of ").append(this.config().maxNumberMantissaDigits()).append(" digits").toString());
    }

    private Nothing$ failNumberExponentTooLarge(int offset) {
        return this.failOverflow(offset, new StringBuilder(61).append("absolute JSON number exponent larger than configured maximum ").append(this.config().maxNumberAbsExponent()).toString());
    }

    private Nothing$ failOverflow(int offset, String msg) {
        throw new Borer.Error.Overflow<Input.Position>(this.pos(offset), msg);
    }

    private Nothing$ failIllegalUtf8(int offset) {
        throw new Borer.Error.InvalidInputData<Input.Position>(this.pos(offset), "Illegal UTF-8 character encoding");
    }

    private Nothing$ failIllegalEscapeSeq(int offset) {
        throw new Borer.Error.InvalidInputData<Input.Position>(this.pos(offset), "Illegal JSON escape sequence");
    }

    private Nothing$ failSyntaxError(int offset, String expected) {
        throw new Borer.Error.InvalidInputData<Input.Position>(this.pos(offset), new StringBuilder(30).append("Invalid JSON syntax, expected ").append(expected).toString());
    }

    private Nothing$ failSyntaxError(String expected) {
        String actualChar = this.nextChar == 255 ? "end of input" : (Character.isISOControl(this.nextChar) ? StringOps$.MODULE$.format$extension("'\\u%04x'", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.nextChar)})) : new StringBuilder(2).append("'").append((char)this.nextChar).append("'").toString());
        throw new Borer.Error.InvalidInputData<Input.Position>(this.pos(-1), expected, actualChar);
    }

    private Input.Position pos(int offset) {
        return Input$.MODULE$.position(this.input(), this.input().cursor() + (long)this.cursorExtra + (long)offset);
    }

    public final int inline$nextChar() {
        return this.nextChar;
    }

    public final int inline$nextCharAfterWhitespace() {
        return this.nextCharAfterWhitespace();
    }

    public final void inline$nextChar_$eq(int x$0) {
        this.nextChar = x$0;
    }

    public final Nothing$ inline$failStringTooLong(int offset) {
        return this.failStringTooLong(offset);
    }

    public final char[] inline$chars() {
        return this.chars;
    }

    public final void inline$chars_$eq(char[] x$0) {
        this.chars = x$0;
    }

    public final int inline$cursorExtra() {
        return this.cursorExtra;
    }

    public final void inline$cursorExtra_$eq(int x$0) {
        this.cursorExtra = x$0;
    }

    private final void grow$1(int newCursor$1) {
        if (newCursor$1 > this.config().maxStringLength()) {
            throw this.inline$failStringTooLong(-newCursor$1);
        }
        int newLen = package$.MODULE$.max(this.inline$chars().length << 1, newCursor$1);
        this.inline$chars_$eq(Arrays.copyOf(this.inline$chars(), newLen));
    }

    private final int appendChar$1(int charCursor, char c) {
        int newCursor = charCursor + 1;
        if (newCursor > this.inline$chars().length) {
            this.grow$1(newCursor);
        }
        this.chars[charCursor] = c;
        return newCursor;
    }

    private final int parseNull$1(Receiver receiver$1) {
        int quad = this.input().readQuadByteBigEndianPadded(this);
        if (quad >>> 8 == 7695468) {
            this.nextChar = this.nextCharAfterWhitespace(quad & 0xFF);
            receiver$1.onNull();
            return 1;
        }
        throw this.failSyntaxError(-5, "`null`");
    }

    private final int parseFalse$1(Receiver receiver$2) {
        if (this.input().readQuadByteBigEndianPadded(this) == 1634497381) {
            this.inline$nextChar_$eq(this.inline$nextCharAfterWhitespace());
            receiver$2.onBoolean(false);
            return 4;
        }
        throw this.failSyntaxError(-6, "`false`");
    }

    private final int parseTrue$1(Receiver receiver$3) {
        int quad = this.input().readQuadByteBigEndianPadded(this);
        if (quad >>> 8 == 7501157) {
            this.nextChar = this.nextCharAfterWhitespace(quad & 0xFF);
            receiver$3.onBoolean(true);
            return 4;
        }
        throw this.failSyntaxError(-5, "`true`");
    }

    private final void unreadWithExtra$1() {
        int n;
        int n2 = 1 - this.inline$cursorExtra();
        if (n2 > 0) {
            this.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        this.inline$cursorExtra_$eq(n);
    }

    private final int parseNumberStringExponentPart$1(Receiver receiver$4, int len) {
        byte c = this.input().readBytePadded(this);
        int newLen = len;
        if (c != 45 && c != 43) {
            if (this.inline$cursorExtra() > 0) {
                this.unreadWithExtra$1();
            } else {
                this.input().unread(1);
            }
        } else {
            ++newLen;
        }
        newLen = this.parseInitialDigits$1(0L, newLen);
        if (newLen == len) {
            throw this.failSyntaxError("DIGIT");
        }
        int exp = -((int)this.auxLong);
        if (exp < 0 || this.config().maxNumberAbsExponent() < exp) {
            throw this.failNumberExponentTooLarge(newLen);
        }
        String numberString = this.antePrecedingBytesAsAsciiString(newLen);
        this.nextChar = this.nextCharAfterWhitespace(this.nextChar);
        receiver$4.onNumberString(numberString);
        return 512;
    }

    private static final void unreadWithExtra$2(int unreadCount$1, JsonParser JsonParser_this$1) {
        int n;
        int n2 = unreadCount$1 - JsonParser_this$1.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$1.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$1.inline$cursorExtra_$eq(n);
    }

    private static final void unreadWithExtra$3(int unreadCount$2, JsonParser JsonParser_this$2) {
        int n;
        int n2 = unreadCount$2 - JsonParser_this$2.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$2.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$2.inline$cursorExtra_$eq(n);
    }

    private static final void unreadWithExtra$4(int unreadCount$3, JsonParser JsonParser_this$3) {
        int n;
        int n2 = unreadCount$3 - JsonParser_this$3.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$3.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$3.inline$cursorExtra_$eq(n);
    }

    private static final void unreadWithExtra$5(int unreadCount$4, JsonParser JsonParser_this$4) {
        int n;
        int n2 = unreadCount$4 - JsonParser_this$4.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$4.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$4.inline$cursorExtra_$eq(n);
    }

    private static final void unreadWithExtra$6(int unreadCount$5, JsonParser JsonParser_this$5) {
        int n;
        int n2 = unreadCount$5 - JsonParser_this$5.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$5.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$5.inline$cursorExtra_$eq(n);
    }

    private static final void unreadWithExtra$7(int unreadCount$6, JsonParser JsonParser_this$6) {
        int n;
        int n2 = unreadCount$6 - JsonParser_this$6.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$6.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$6.inline$cursorExtra_$eq(n);
    }

    private static final void unreadWithExtra$8(int unreadCount$7, JsonParser JsonParser_this$7) {
        int n;
        int n2 = unreadCount$7 - JsonParser_this$7.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$7.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$7.inline$cursorExtra_$eq(n);
    }

    private static final void unreadWithExtra$9(int unreadCount$8, JsonParser JsonParser_this$8) {
        int n;
        int n2 = unreadCount$8 - JsonParser_this$8.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$8.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$8.inline$cursorExtra_$eq(n);
    }

    private final int parseInitialDigits$1(long firstDigit, int len) {
        long octa = this.input().readOctaByteBigEndianPadded(this);
        long digs = octa ^ 0x3030303030303030L;
        long mask = (digs & 0x7F7F7F7F7F7F7F7FL) + 0x7676767676767676L;
        mask = (octa | mask) & 0x8080808080808080L;
        int nlz = Long.numberOfLeadingZeros(mask);
        int digitCount = nlz >> 3;
        int stopChar = (int)(octa << nlz >>> 56);
        int newLen = len + digitCount;
        int unreadCount = 7 - digitCount;
        int n = digitCount;
        switch (n) {
            case 0: {
                JsonParser JsonParser_this = this;
                if (JsonParser_this.inline$cursorExtra() > 0) {
                    JsonParser.unreadWithExtra$2(unreadCount, JsonParser_this);
                } else {
                    JsonParser_this.input().unread(unreadCount);
                }
                this.nextChar = stopChar;
                this.auxLong = -firstDigit;
                return newLen;
            }
            case 1: {
                long value$proxy1 = firstDigit * 10L + (digs >>> 56);
                JsonParser JsonParser_this = this;
                if (JsonParser_this.inline$cursorExtra() > 0) {
                    JsonParser.unreadWithExtra$3(unreadCount, JsonParser_this);
                } else {
                    JsonParser_this.input().unread(unreadCount);
                }
                this.nextChar = stopChar;
                this.auxLong = -value$proxy1;
                return newLen;
            }
            case 2: {
                long x$proxy1 = firstDigit << 32 | digs >>> 56 << 16 | digs << 8 >>> 56;
                long value$proxy2 = x$proxy1 * 281517932938216L >> 48;
                JsonParser JsonParser_this = this;
                if (JsonParser_this.inline$cursorExtra() > 0) {
                    JsonParser.unreadWithExtra$4(unreadCount, JsonParser_this);
                } else {
                    JsonParser_this.input().unread(unreadCount);
                }
                this.nextChar = stopChar;
                this.auxLong = -value$proxy2;
                return newLen;
            }
            case 3: {
                long m = firstDigit << 48 | digs >>> 56 << 32 | (digs & 0xFF000000000000L) >>> 32 | digs << 16 >>> 56;
                long value$proxy3 = m * 281517932938216L >> 48;
                JsonParser JsonParser_this = this;
                if (JsonParser_this.inline$cursorExtra() > 0) {
                    JsonParser.unreadWithExtra$5(unreadCount, JsonParser_this);
                } else {
                    JsonParser_this.input().unread(unreadCount);
                }
                this.nextChar = stopChar;
                this.auxLong = -value$proxy3;
                return newLen;
            }
            case 4: {
                long value$proxy4 = this.longFrom8Digits(firstDigit << 32 | digs >>> 32);
                JsonParser JsonParser_this = this;
                if (JsonParser_this.inline$cursorExtra() > 0) {
                    JsonParser.unreadWithExtra$6(unreadCount, JsonParser_this);
                } else {
                    JsonParser_this.input().unread(unreadCount);
                }
                this.nextChar = stopChar;
                this.auxLong = -value$proxy4;
                return newLen;
            }
            case 5: {
                long value$proxy5 = this.longFrom8Digits(firstDigit << 40 | digs >>> 24);
                JsonParser JsonParser_this = this;
                if (JsonParser_this.inline$cursorExtra() > 0) {
                    JsonParser.unreadWithExtra$7(unreadCount, JsonParser_this);
                } else {
                    JsonParser_this.input().unread(unreadCount);
                }
                this.nextChar = stopChar;
                this.auxLong = -value$proxy5;
                return newLen;
            }
            case 6: {
                long value$proxy6 = this.longFrom8Digits(firstDigit << 48 | digs >>> 16);
                JsonParser JsonParser_this = this;
                if (JsonParser_this.inline$cursorExtra() > 0) {
                    JsonParser.unreadWithExtra$8(unreadCount, JsonParser_this);
                } else {
                    JsonParser_this.input().unread(unreadCount);
                }
                this.nextChar = stopChar;
                this.auxLong = -value$proxy6;
                return newLen;
            }
            case 7: {
                long value$proxy7 = this.longFrom8Digits(firstDigit << 56 | digs >>> 8);
                JsonParser JsonParser_this = this;
                if (JsonParser_this.inline$cursorExtra() > 0) {
                    JsonParser.unreadWithExtra$9(unreadCount, JsonParser_this);
                } else {
                    JsonParser_this.input().unread(unreadCount);
                }
                this.nextChar = stopChar;
                this.auxLong = -value$proxy7;
                return newLen;
            }
            case 8: {
                return this.parseSubsequentDigits$1(-this.longFrom8Digits(firstDigit << 56 | digs >>> 8) * 10L - (digs & 0xFFL), newLen);
            }
        }
        throw new MatchError(BoxesRunTime.boxToInteger(n));
    }

    private static final void unreadWithExtra$10(int unreadCount$9, JsonParser JsonParser_this$9) {
        int n;
        int n2 = unreadCount$9 - JsonParser_this$9.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$9.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$9.inline$cursorExtra_$eq(n);
    }

    private static final void unreadWithExtra$11(int unreadCount$10, JsonParser JsonParser_this$10) {
        int n;
        int n2 = unreadCount$10 - JsonParser_this$10.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$10.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$10.inline$cursorExtra_$eq(n);
    }

    private static final void unreadWithExtra$12(int unreadCount$11, JsonParser JsonParser_this$11) {
        int n;
        int n2 = unreadCount$11 - JsonParser_this$11.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$11.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$11.inline$cursorExtra_$eq(n);
    }

    private static final void unreadWithExtra$13(int unreadCount$12, JsonParser JsonParser_this$12) {
        int n;
        int n2 = unreadCount$12 - JsonParser_this$12.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$12.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$12.inline$cursorExtra_$eq(n);
    }

    private static final void unreadWithExtra$14(int unreadCount$13, JsonParser JsonParser_this$13) {
        int n;
        int n2 = unreadCount$13 - JsonParser_this$13.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$13.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$13.inline$cursorExtra_$eq(n);
    }

    private static final void unreadWithExtra$15(int unreadCount$14, JsonParser JsonParser_this$14) {
        int n;
        int n2 = unreadCount$14 - JsonParser_this$14.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$14.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$14.inline$cursorExtra_$eq(n);
    }

    private static final void unreadWithExtra$16(int unreadCount$15, JsonParser JsonParser_this$15) {
        int n;
        int n2 = unreadCount$15 - JsonParser_this$15.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$15.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$15.inline$cursorExtra_$eq(n);
    }

    private static final void unreadWithExtra$17(int unreadCount$16, JsonParser JsonParser_this$16) {
        int n;
        int n2 = unreadCount$16 - JsonParser_this$16.inline$cursorExtra();
        if (n2 > 0) {
            JsonParser_this$16.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        JsonParser_this$16.inline$cursorExtra_$eq(n);
    }

    private final int parseSubsequentDigits$1(long value, int len) {
        int n;
        block11: while (true) {
            long octa = this.input().readOctaByteBigEndianPadded(this);
            long digs = octa ^ 0x3030303030303030L;
            long mask = (digs & 0x7F7F7F7F7F7F7F7FL) + 0x7676767676767676L;
            mask = (octa | mask) & 0x8080808080808080L;
            int nlz = Long.numberOfLeadingZeros(mask);
            int digitCount = nlz >> 3;
            int stopChar = (int)(octa << nlz >>> 56);
            int newLen = len + digitCount;
            int unreadCount = 7 - digitCount;
            n = digitCount;
            switch (n) {
                case 0: {
                    JsonParser JsonParser_this = this;
                    if (JsonParser_this.inline$cursorExtra() > 0) {
                        JsonParser.unreadWithExtra$10(unreadCount, JsonParser_this);
                    } else {
                        JsonParser_this.input().unread(unreadCount);
                    }
                    this.nextChar = stopChar;
                    this.auxLong = value;
                    return newLen;
                }
                case 1: {
                    long value$proxy8 = 0L >= value && value >= -922337203685477580L ? value * 10L - (digs >>> 56) : 1L;
                    JsonParser JsonParser_this = this;
                    if (JsonParser_this.inline$cursorExtra() > 0) {
                        JsonParser.unreadWithExtra$11(unreadCount, JsonParser_this);
                    } else {
                        JsonParser_this.input().unread(unreadCount);
                    }
                    this.nextChar = stopChar;
                    this.auxLong = value$proxy8;
                    return newLen;
                }
                case 2: {
                    long value$proxy9 = 0L >= value && value >= -92233720368547758L ? value * 100L - (digs >>> 56) * 10L - (digs << 8 >>> 56) : 1L;
                    JsonParser JsonParser_this = this;
                    if (JsonParser_this.inline$cursorExtra() > 0) {
                        JsonParser.unreadWithExtra$12(unreadCount, JsonParser_this);
                    } else {
                        JsonParser_this.input().unread(unreadCount);
                    }
                    this.nextChar = stopChar;
                    this.auxLong = value$proxy9;
                    return newLen;
                }
                case 3: {
                    long l;
                    if (0L >= value && value >= -9223372036854775L) {
                        JsonParser JsonParser_this = this;
                        long x$proxy2 = digs >>> 56 << 32 | (digs & 0xFF000000000000L) >>> 32 | digs << 16 >>> 56;
                        l = value * 1000L - (x$proxy2 * 281517932938216L >> 48);
                    } else {
                        l = 1L;
                    }
                    long value$proxy10 = l;
                    JsonParser JsonParser_this = this;
                    if (JsonParser_this.inline$cursorExtra() > 0) {
                        JsonParser.unreadWithExtra$13(unreadCount, JsonParser_this);
                    } else {
                        JsonParser_this.input().unread(unreadCount);
                    }
                    this.nextChar = stopChar;
                    this.auxLong = value$proxy10;
                    return newLen;
                }
                case 4: {
                    long l;
                    if (0L >= value && value >= -922337203685477L) {
                        long x;
                        JsonParser JsonParser_this = this;
                        long a = digs >>> 48 << 32 | digs << 16 >>> 48;
                        long b = a & 0xFF000000FF00L;
                        long x$proxy3 = x = a ^ b | b << 8;
                        l = value * 10000L - (x$proxy3 * 281517932938216L >> 48);
                    } else {
                        l = 1L;
                    }
                    long value$proxy11 = l;
                    JsonParser JsonParser_this = this;
                    if (JsonParser_this.inline$cursorExtra() > 0) {
                        JsonParser.unreadWithExtra$14(unreadCount, JsonParser_this);
                    } else {
                        JsonParser_this.input().unread(unreadCount);
                    }
                    this.nextChar = stopChar;
                    this.auxLong = value$proxy11;
                    return newLen;
                }
                case 5: {
                    long value$proxy12 = 0L >= value && value >= -92233720368547L ? value * 100000L - this.longFrom8Digits(digs >>> 24) : 1L;
                    JsonParser JsonParser_this = this;
                    if (JsonParser_this.inline$cursorExtra() > 0) {
                        JsonParser.unreadWithExtra$15(unreadCount, JsonParser_this);
                    } else {
                        JsonParser_this.input().unread(unreadCount);
                    }
                    this.nextChar = stopChar;
                    this.auxLong = value$proxy12;
                    return newLen;
                }
                case 6: {
                    long value$proxy13 = 0L >= value && value >= -9223372036854L ? value * 1000000L - this.longFrom8Digits(digs >>> 16) : 1L;
                    JsonParser JsonParser_this = this;
                    if (JsonParser_this.inline$cursorExtra() > 0) {
                        JsonParser.unreadWithExtra$16(unreadCount, JsonParser_this);
                    } else {
                        JsonParser_this.input().unread(unreadCount);
                    }
                    this.nextChar = stopChar;
                    this.auxLong = value$proxy13;
                    return newLen;
                }
                case 7: {
                    long value$proxy14 = 0L >= value && value >= -922337203685L ? value * 10000000L - this.longFrom8Digits(digs >>> 8) : 1L;
                    JsonParser JsonParser_this = this;
                    if (JsonParser_this.inline$cursorExtra() > 0) {
                        JsonParser.unreadWithExtra$17(unreadCount, JsonParser_this);
                    } else {
                        JsonParser_this.input().unread(unreadCount);
                    }
                    this.nextChar = stopChar;
                    this.auxLong = value$proxy14;
                    return newLen;
                }
                case 8: {
                    long l = 0L >= value && value >= -92233720368L ? value * 100000000L - this.longFrom8Digits(digs) : 1L;
                    int n2 = newLen;
                    value = l;
                    len = n2;
                    continue block11;
                }
            }
            break;
        }
        throw new MatchError(BoxesRunTime.boxToInteger(n));
    }

    private final int dispatchNumberString$1(Receiver receiver$6, int len) {
        receiver$6.onNumberString(this.antePrecedingBytesAsAsciiString(len));
        return 512;
    }

    private static final int dispatchDouble$1(Receiver receiver$7, boolean negative$1, double d) {
        receiver$7.onDouble(negative$1 || d == 0.0 ? d : -d);
        return 256;
    }

    private final int dispatchIntOrLong$1(boolean negative$2, Receiver receiver$8, int len, long negValue) {
        block5: {
            long x$proxy4;
            long l;
            block4: {
                l = negValue;
                if (negative$2) break block4;
                if (negValue == Long.MIN_VALUE) break block5;
                l = -negValue;
                if (!true) break block5;
            }
            if ((x$proxy4 = l) >> 31 == x$proxy4 >> 63) {
                receiver$8.onInt((int)l);
                return 8;
            }
            receiver$8.onLong(l);
            return 16;
        }
        return this.dispatchNumberString$1(receiver$8, len);
    }

    private final int parseNumberStringExponentPartOrDispatchNumberString$1(Receiver receiver$14, int len, int stopChar) {
        if ((stopChar | 0x20) != 101) {
            int result = this.dispatchNumberString$1(receiver$14, len);
            this.nextChar = this.nextCharAfterWhitespace(stopChar);
            return result;
        }
        return this.parseNumberStringExponentPart$1(receiver$14, len + 1);
    }

    private final void unreadWithExtra$18() {
        int n;
        int n2 = 1 - this.inline$cursorExtra();
        if (n2 > 0) {
            this.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        this.inline$cursorExtra_$eq(n);
    }

    private final int parseNumber$1(Receiver receiver$5, long firstDigit, int strLen, boolean negative) {
        long negMantissa;
        long l;
        int len = strLen;
        int stopChar = 0;
        int maxMantissaEndLen = len + this.config().maxNumberMantissaDigits() - 1;
        if (firstDigit == 0L) {
            stopChar = this.input().readBytePadded(this) & 0xFF;
            if ((stopChar ^ 0x30) < 10) {
                this.nextChar = stopChar;
                throw this.failSyntaxError("'.', 'e' or 'E'");
            }
            l = firstDigit;
        } else {
            len = this.parseInitialDigits$1(firstDigit, len);
            stopChar = this.nextChar;
            l = negMantissa = this.auxLong;
        }
        if (negMantissa <= 0L) {
            int negFractionDigits = 0;
            if (stopChar == 46) {
                int len0 = len + 1;
                ++maxMantissaEndLen;
                len = this.parseSubsequentDigits$1(negMantissa, len0);
                stopChar = this.nextChar;
                negMantissa = this.auxLong;
                negFractionDigits = len0 - len;
                if (negFractionDigits == 0) {
                    throw this.failSyntaxError("DIGIT");
                }
            }
            if (len > maxMantissaEndLen) {
                throw this.failNumberMantissaTooLong(-len);
            }
            if (negMantissa <= 0L) {
                int exp;
                int n;
                boolean expNeg = false;
                int expDigits = 0;
                if ((stopChar | 0x20) == 101) {
                    int n2;
                    int c = this.input().readBytePadded(this) & 0xFF;
                    boolean bl = expNeg = c == 45;
                    if (!expNeg && c != 43) {
                        if (this.inline$cursorExtra() > 0) {
                            this.unreadWithExtra$18();
                        } else {
                            this.input().unread(1);
                        }
                        n2 = len + 1;
                    } else {
                        n2 = len + 2;
                    }
                    int len0 = n2;
                    len = this.parseInitialDigits$1(0L, len0);
                    stopChar = this.nextChar;
                    expDigits = len - len0;
                    if (expDigits == 0) {
                        throw this.failSyntaxError("DIGIT");
                    }
                    int e = -((int)this.auxLong);
                    if (e < 0 || this.config().maxNumberAbsExponent() < e) {
                        throw this.failNumberExponentTooLarge(-expDigits);
                    }
                    n = e;
                } else {
                    n = 0;
                }
                int posExp = n;
                int n3 = exp = expNeg ? negFractionDigits - posExp : negFractionDigits + posExp;
                int result = exp != 0 ? (exp > 0 ? (exp < 19 && negMantissa > JsonParser$.MODULE$.long10pow()[exp << 1] ? this.dispatchIntOrLong$1(negative, receiver$5, len, negMantissa * JsonParser$.MODULE$.long10pow()[(exp << 1) + 1]) : (this.allowDoubleParsing && negMantissa > -9007199254740992L && exp < 23 ? JsonParser.dispatchDouble$1(receiver$5, negative, (double)negMantissa * JsonParser$.MODULE$.double10pow()[exp]) : this.dispatchNumberString$1(receiver$5, len))) : (this.allowDoubleParsing && negMantissa > -9007199254740992L && exp > -23 ? JsonParser.dispatchDouble$1(receiver$5, negative, (double)negMantissa / JsonParser$.MODULE$.double10pow()[-exp]) : this.dispatchNumberString$1(receiver$5, len))) : this.dispatchIntOrLong$1(negative, receiver$5, len, negMantissa);
                this.nextChar = this.nextCharAfterWhitespace(stopChar);
                return result;
            }
            return this.parseNumberStringExponentPartOrDispatchNumberString$1(receiver$5, len, stopChar);
        }
        if (len > maxMantissaEndLen) {
            throw this.failNumberMantissaTooLong(-len);
        }
        if (stopChar == 46) {
            len = this.parseInitialDigits$1(1L, len + 1);
            stopChar = this.nextChar;
            if (len > maxMantissaEndLen + 1) {
                throw this.failNumberMantissaTooLong(-len);
            }
        }
        return this.parseNumberStringExponentPartOrDispatchNumberString$1(receiver$5, len, stopChar);
    }

    private final int parseNegNumber$1(Receiver receiver$15) {
        int c = this.input().readBytePadded(this) & 0xFF;
        long x = (long)c ^ 0x30L;
        if (x > 9L) {
            this.nextChar = c;
            throw this.failSyntaxError("DIGIT");
        }
        return this.parseNumber$1(receiver$15, x, 2, true);
    }

    private final void unreadWithExtra$19() {
        int n;
        int n2 = 2 - this.inline$cursorExtra();
        if (n2 > 0) {
            this.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        this.inline$cursorExtra_$eq(n);
    }

    private final void unreadWithExtra$20() {
        int n;
        int n2 = 2 - this.inline$cursorExtra();
        if (n2 > 0) {
            this.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        this.inline$cursorExtra_$eq(n);
    }

    private final int parseEscapeSeq$1(int charCursor) {
        char c;
        int cc = charCursor;
        byte by = this.input().readBytePadded(this);
        switch (by) {
            case 34: {
                c = 34;
                break;
            }
            case 47: {
                c = 47;
                break;
            }
            case 92: {
                c = 92;
                break;
            }
            case 98: {
                c = 8;
                break;
            }
            case 102: {
                c = 12;
                break;
            }
            case 110: {
                c = 10;
                break;
            }
            case 116: {
                c = 9;
                break;
            }
            case 114: {
                if (this.input().readDoubleByteBigEndianPadded(this) == '\u5c6e') {
                    cc = this.appendChar$1(cc, '\r');
                    c = 10;
                    break;
                }
                if (this.inline$cursorExtra() > 0) {
                    this.unreadWithExtra$19();
                } else {
                    this.input().unread(2);
                }
                c = 13;
                break;
            }
            case 117: {
                int q = this.input().readQuadByteBigEndianPadded(this);
                int c$proxy1 = q >>> 24;
                int c$proxy2 = q << 8 >>> 24;
                int c$proxy3 = q << 16 >>> 24;
                int c$proxy4 = q & 0xFF;
                int x = JsonParser$.MODULE$.HexDigits()[c$proxy1] << 12 | JsonParser$.MODULE$.HexDigits()[c$proxy2] << 8 | JsonParser$.MODULE$.HexDigits()[c$proxy3] << 4 | JsonParser$.MODULE$.HexDigits()[c$proxy4];
                if (x < 0) {
                    throw this.failIllegalEscapeSeq(-4);
                }
                if (this.input().readDoubleByteBigEndianPadded(this) == '\u5c75') {
                    q = this.input().readQuadByteBigEndianPadded(this);
                    cc = this.appendChar$1(cc, (char)x);
                    int c$proxy5 = q >>> 24;
                    int c$proxy6 = q << 8 >>> 24;
                    int c$proxy7 = q << 16 >>> 24;
                    int c$proxy8 = q & 0xFF;
                    x = JsonParser$.MODULE$.HexDigits()[c$proxy5] << 12 | JsonParser$.MODULE$.HexDigits()[c$proxy6] << 8 | JsonParser$.MODULE$.HexDigits()[c$proxy7] << 4 | JsonParser$.MODULE$.HexDigits()[c$proxy8];
                    if (x < 0) {
                        throw this.failIllegalEscapeSeq(-4);
                    }
                } else if (this.inline$cursorExtra() > 0) {
                    this.unreadWithExtra$20();
                } else {
                    this.input().unread(2);
                }
                c = (char)x;
                break;
            }
            default: {
                throw this.failIllegalEscapeSeq(-2);
            }
        }
        int c2 = c;
        return this.appendChar$1(cc, (char)c2);
    }

    private final Nothing$ fail$1() {
        return this.failIllegalUtf8(-5);
    }

    private final void unreadWithExtra$21(int count$proxy1$1) {
        int n;
        int n2 = count$proxy1$1 - this.inline$cursorExtra();
        if (n2 > 0) {
            this.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        this.inline$cursorExtra_$eq(n);
    }

    private final void unreadWithExtra$22(int unreadCount$17) {
        int n;
        int n2 = unreadCount$17 - this.inline$cursorExtra();
        if (n2 > 0) {
            this.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        this.inline$cursorExtra_$eq(n);
    }

    private final int parseMultiByteUtf8Char$1(int b1, int charCursor) {
        while (true) {
            int n;
            int byteCount = Integer.numberOfLeadingZeros(~b1) - 25;
            int quad = this.input().readQuadByteBigEndianPadded(this);
            int b2 = quad >> 24;
            int cc = charCursor;
            int n2 = (byteCount | 0x80) ^ b2 & 0xC0;
            switch (n2) {
                case 1: {
                    if ((b1 & 0x1E) == 0) {
                        throw this.fail$1();
                    }
                    n = b1 << 6 ^ b2 ^ 0xF80;
                    break;
                }
                case 2: {
                    int b3 = quad << 8 >> 24;
                    int c = b1 << 12 ^ b2 << 6 ^ b3 ^ 0xFFFE1F80;
                    if (b1 == 224 && (b2 & 0xE0) == 128 || (b3 & 0xC0) != 128 || c >> 11 == 27) {
                        throw this.fail$1();
                    }
                    n = c;
                    break;
                }
                case 3: {
                    int b3 = quad << 8 >> 24;
                    int b4 = quad << 16 >> 24;
                    int c = b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ b4 ^ 0x381F80;
                    if ((b3 & 0xC0) != 128 || (b4 & 0xC0) != 128 || c < 65536 || c > 0x10FFFF) {
                        throw this.fail$1();
                    }
                    cc = this.appendChar$1(charCursor, (char)(55232 + (c >> 10)));
                    n = 56320 + (c & 0x3FF);
                    break;
                }
                default: {
                    throw this.fail$1();
                }
            }
            int cp = n;
            cc = this.appendChar$1(cc, (char)cp);
            int unreadCount = 3 - byteCount;
            int nextByte = quad << (byteCount << 3) >> 24;
            if (nextByte >= 0) {
                int count$proxy1 = unreadCount + 1;
                if (this.inline$cursorExtra() > 0) {
                    this.unreadWithExtra$21(count$proxy1);
                } else {
                    this.input().unread(count$proxy1);
                }
                return cc;
            }
            if (this.inline$cursorExtra() > 0) {
                this.unreadWithExtra$22(unreadCount);
            } else {
                this.input().unread(unreadCount);
            }
            int n3 = nextByte;
            int n4 = cc;
            b1 = n3;
            charCursor = n4;
        }
    }

    private final void grow$2(int len$proxy1$1) {
        if (len$proxy1$1 > this.config().maxStringLength()) {
            throw this.inline$failStringTooLong(-len$proxy1$1);
        }
        int newLen = package$.MODULE$.max(this.inline$chars().length << 1, len$proxy1$1);
        this.inline$chars_$eq(Arrays.copyOf(this.inline$chars(), newLen));
    }

    private final void unreadWithExtra$23(int count$proxy2$1) {
        int n;
        int n2 = count$proxy2$1 - this.inline$cursorExtra();
        if (n2 > 0) {
            this.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        this.inline$cursorExtra_$eq(n);
    }

    private final void unreadWithExtra$24(int unreadCount$18) {
        int n;
        int n2 = unreadCount$18 - this.inline$cursorExtra();
        if (n2 > 0) {
            this.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        this.inline$cursorExtra_$eq(n);
    }

    private final void unreadWithExtra$25(int count$proxy3$1) {
        int n;
        int n2 = count$proxy3$1 - this.inline$cursorExtra();
        if (n2 > 0) {
            this.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        this.inline$cursorExtra_$eq(n);
    }

    private final void unreadWithExtra$26(int count$proxy4$1) {
        int n;
        int n2 = count$proxy4$1 - this.inline$cursorExtra();
        if (n2 > 0) {
            this.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        this.inline$cursorExtra_$eq(n);
    }

    private final int parseUtf8String$1(Receiver receiver$9, int charCursor) {
        while (true) {
            long octa = this.input().readOctaByteBigEndianPadded(this);
            long qMask = (octa ^ 0x5D5D5D5D5D5D5D5DL) + 0x101010101010101L;
            long bMask = (octa ^ 0x2323232323232323L) + 0x101010101010101L;
            long cMask = (octa | 0x1F1F1F1F1F1F1F1FL) - 0x2020202020202020L;
            long mask = (qMask | bMask | octa | cMask) & 0x8080808080808080L;
            int nlz = Long.numberOfLeadingZeros(mask);
            int charCount = nlz >> 3;
            int len$proxy1 = charCursor + 8;
            if (len$proxy1 > this.inline$chars().length) {
                this.grow$2(len$proxy1);
            }
            long x = octa & 0xFF00FF00FF00FF00L;
            long y = octa & 0xFF00FF00FF00FFL;
            this.chars[charCursor + 0] = (char)(octa >>> 56);
            this.chars[charCursor + 1] = (char)(y >>> 48);
            this.chars[charCursor + 2] = (char)(x >>> 40);
            this.chars[charCursor + 3] = (char)(y >>> 32);
            this.chars[charCursor + 4] = (char)(x >>> 24);
            this.chars[charCursor + 5] = (char)(y >>> 16);
            this.chars[charCursor + 6] = (char)(x >>> 8);
            this.chars[charCursor + 7] = (char)y;
            int newCursor = charCursor + charCount;
            if (nlz < 64) {
                long stopChar0 = octa << nlz;
                int stopChar = (int)(stopChar0 >>> 56);
                int unreadCount = 6 - charCount;
                if (stopChar == 34) {
                    int n;
                    long c = stopChar0 << 8 >>> 56;
                    if (c <= 32L) {
                        int count$proxy2 = unreadCount + 1;
                        if (this.inline$cursorExtra() > 0) {
                            this.unreadWithExtra$23(count$proxy2);
                        } else {
                            this.input().unread(count$proxy2);
                        }
                        n = this.nextCharAfterWhitespace();
                    } else {
                        if (this.inline$cursorExtra() > 0) {
                            this.unreadWithExtra$24(unreadCount);
                        } else {
                            this.input().unread(unreadCount);
                        }
                        n = (int)c;
                    }
                    this.nextChar = n;
                    receiver$9.onChars(this.chars, newCursor);
                    return 2048;
                }
                if (stopChar == 92) {
                    int count$proxy3 = unreadCount + 1;
                    if (this.inline$cursorExtra() > 0) {
                        this.unreadWithExtra$25(count$proxy3);
                    } else {
                        this.input().unread(count$proxy3);
                    }
                    charCursor = this.parseEscapeSeq$1(newCursor);
                    continue;
                }
                if (stopChar > 127) {
                    int count$proxy4 = unreadCount + 1;
                    if (this.inline$cursorExtra() > 0) {
                        this.unreadWithExtra$26(count$proxy4);
                    } else {
                        this.input().unread(count$proxy4);
                    }
                    charCursor = this.parseMultiByteUtf8Char$1((byte)stopChar, newCursor);
                    continue;
                }
                throw this.failSyntaxError(-2 - unreadCount, "JSON string character");
            }
            charCursor = newCursor;
        }
    }

    private final int pushMap$1(Receiver receiver$10) {
        if (this.level < 64) {
            this.levelType = this.levelType << 1 | 1L;
            ++this.level;
            this.inline$nextChar_$eq(this.inline$nextCharAfterWhitespace());
            this.state = this.nextChar == 125 ? 3 : 1;
            receiver$10.onMapStart();
            return 524288;
        }
        throw this.failOverflow(0, "This JSON parser does not support more than 64 Array/Object nesting levels");
    }

    private final int pushArray$1(Receiver receiver$11) {
        if (this.level < 64) {
            this.levelType <<= 1;
            ++this.level;
            this.inline$nextChar_$eq(this.inline$nextCharAfterWhitespace());
            this.state = this.nextChar == 93 ? 2 : 0;
            receiver$11.onArrayStart();
            return 131072;
        }
        throw this.failOverflow(0, "This JSON parser does not support more than 64 Array/Object nesting levels");
    }

    private final int popLevel$1(Receiver receiver$12) {
        int n;
        --this.level;
        this.levelType >>>= 1;
        this.inline$nextChar_$eq(this.inline$nextCharAfterWhitespace());
        if (this.level > 0) {
            int tpe = (int)this.levelType & 1;
            if (this.nextChar == 44) {
                this.inline$nextChar_$eq(this.inline$nextCharAfterWhitespace());
                n = tpe;
            } else {
                n = 2 | tpe;
            }
        } else {
            n = 6;
        }
        this.state = n;
        receiver$12.onBreak();
        return 0x100000;
    }

    private final int parseValue$1(Receiver receiver$16, int nextStateAfterComma, int nextStateNoComma) {
        int n;
        int n2;
        byte by = JsonParser$.MODULE$.TokenTable()[this.nextChar];
        switch (by) {
            case 0: {
                n2 = this.parseUtf8String$1(receiver$16, 0);
                break;
            }
            case 1: {
                return this.pushMap$1(receiver$16);
            }
            case 2: {
                return this.pushArray$1(receiver$16);
            }
            case 3: {
                n2 = this.parseNull$1(receiver$16);
                break;
            }
            case 4: {
                n2 = this.parseFalse$1(receiver$16);
                break;
            }
            case 5: {
                n2 = this.parseTrue$1(receiver$16);
                break;
            }
            case 6: {
                n2 = this.parseNegNumber$1(receiver$16);
                break;
            }
            case 7: {
                n2 = this.parseNumber$1(receiver$16, (long)this.nextChar ^ 0x30L, 1, false);
                break;
            }
            default: {
                throw this.failSyntaxError("JSON value");
            }
        }
        int result = n2;
        if (this.nextChar == 44) {
            this.inline$nextChar_$eq(this.inline$nextCharAfterWhitespace());
            n = nextStateAfterComma;
        } else {
            n = nextStateNoComma;
        }
        this.state = n;
        return result;
    }

    private final int parseMapKey$1(Receiver receiver$17) {
        if (this.nextChar == 34) {
            int result = this.parseUtf8String$1(receiver$17, 0);
            if (this.nextChar == 58) {
                this.inline$nextChar_$eq(this.inline$nextCharAfterWhitespace());
                this.state = 4;
                return result;
            }
            throw this.failSyntaxError("':'");
        }
        throw this.failSyntaxError("'\"'");
    }

    private final int parseArrayBreak$1(Receiver receiver$18) {
        if (this.nextChar == 93) {
            return this.popLevel$1(receiver$18);
        }
        throw this.failSyntaxError("',' or ']'");
    }

    private final int parseMapBreak$1(Receiver receiver$19) {
        if (this.nextChar == 125) {
            return this.popLevel$1(receiver$19);
        }
        throw this.failSyntaxError("',' or '}'");
    }

    private final int parseEndOfInput$1(Receiver receiver$13) {
        if (this.nextChar == 255) {
            receiver$13.onEndOfInput();
            return 0x800000;
        }
        throw this.failSyntaxError("end of input");
    }

    private final void unreadWithExtra$27(int count$proxy5$1) {
        int n;
        int n2 = count$proxy5$1 - this.inline$cursorExtra();
        if (n2 > 0) {
            this.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        this.inline$cursorExtra_$eq(n);
    }

    private final int skip8$1() {
        long octa;
        long mask;
        int nlz;
        do {
            octa = this.input().readOctaByteBigEndianPadded(this);
            mask = (octa & 0x7F7F7F7F7F7F7F7FL) + 0x5F5F5F5F5F5F5F5FL;
        } while ((nlz = Long.numberOfLeadingZeros(mask = (octa | mask) & 0x8080808080808080L)) >= 64);
        int count$proxy5 = 7 - (nlz >> 3);
        if (this.inline$cursorExtra() > 0) {
            this.unreadWithExtra$27(count$proxy5);
        } else {
            this.input().unread(count$proxy5);
        }
        return (int)(octa << nlz >>> 56);
    }

    private final int skip1$1() {
        int c = this.input().readBytePadded(this) & 0xFF;
        if (c <= 32) {
            return this.skip8$1();
        }
        return c;
    }

    private final void unreadWithExtra$28(int count$proxy6$1) {
        int n;
        int n2 = count$proxy6$1 - this.inline$cursorExtra();
        if (n2 > 0) {
            this.input().unread(n2);
            n = 0;
        } else {
            n = -n2;
        }
        this.inline$cursorExtra_$eq(n);
    }

    public static interface Config {
        public boolean readDecimalNumbersOnlyAsNumberStrings();

        public int maxStringLength();

        public int maxNumberMantissaDigits();

        public int maxNumberAbsExponent();

        public int initialCharbufferSize();

        public boolean allowBufferCaching();
    }
}

