/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.internal;

import io.bullet.borer.internal.ByteArrayAccess;
import io.bullet.borer.internal.Unsafe$;
import java.nio.ByteOrder;
import scala.Array$;

public final class Unsafe {
    public static sun.misc.Unsafe UNSAFE() {
        return Unsafe$.MODULE$.UNSAFE();
    }

    public static ByteArrayAccess byteArrayAccess() {
        return Unsafe$.MODULE$.byteArrayAccess();
    }

    public static final class BigEndianByteArrayAccess
    extends UnsafeByteArrayAccess {
        public BigEndianByteArrayAccess() {
            super(ByteOrder.BIG_ENDIAN);
        }

        @Override
        public char doubleByteBigEndian(byte[] byteArray, int ix) {
            return this._doubleByteBigEndian(byteArray, ix);
        }

        @Override
        public int quadByteBigEndian(byte[] byteArray, int ix) {
            return this._quadByteBigEndian(byteArray, ix);
        }

        @Override
        public long octaByteBigEndian(byte[] byteArray, int ix) {
            return this._octaByteBigEndian(byteArray, ix);
        }

        @Override
        public void setDoubleByteBigEndian(byte[] byteArray, int ix, char value) {
            this._setDoubleByteBigEndian(byteArray, ix, value);
        }

        @Override
        public void setQuadByteBigEndian(byte[] byteArray, int ix, int value) {
            this._setQuadByteBigEndian(byteArray, ix, value);
        }

        @Override
        public void setOctaByteBigEndian(byte[] byteArray, int ix, long value) {
            this._setOctaByteBigEndian(byteArray, ix, value);
        }
    }

    public static final class LittleEndianByteArrayAccess
    extends UnsafeByteArrayAccess {
        public LittleEndianByteArrayAccess() {
            super(ByteOrder.LITTLE_ENDIAN);
        }

        @Override
        public char doubleByteBigEndian(byte[] byteArray, int ix) {
            return Character.reverseBytes(this._doubleByteBigEndian(byteArray, ix));
        }

        @Override
        public int quadByteBigEndian(byte[] byteArray, int ix) {
            return Integer.reverseBytes(this._quadByteBigEndian(byteArray, ix));
        }

        @Override
        public long octaByteBigEndian(byte[] byteArray, int ix) {
            return Long.reverseBytes(this._octaByteBigEndian(byteArray, ix));
        }

        @Override
        public void setDoubleByteBigEndian(byte[] byteArray, int ix, char value) {
            this._setDoubleByteBigEndian(byteArray, ix, Character.reverseBytes(value));
        }

        @Override
        public void setQuadByteBigEndian(byte[] byteArray, int ix, int value) {
            this._setQuadByteBigEndian(byteArray, ix, Integer.reverseBytes(value));
        }

        @Override
        public void setOctaByteBigEndian(byte[] byteArray, int ix, long value) {
            this._setOctaByteBigEndian(byteArray, ix, Long.reverseBytes(value));
        }
    }

    public static abstract class UnsafeByteArrayAccess
    extends ByteArrayAccess {
        private final ByteOrder byteOrder;

        public UnsafeByteArrayAccess(ByteOrder byteOrder) {
            this.byteOrder = byteOrder;
        }

        public final char _doubleByteBigEndian(byte[] byteArray, int ix) {
            return Unsafe$.MODULE$.UNSAFE().getChar(byteArray, (long)ix + Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET);
        }

        public final int _quadByteBigEndian(byte[] byteArray, int ix) {
            return Unsafe$.MODULE$.UNSAFE().getInt(byteArray, (long)ix + Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET);
        }

        public final long _octaByteBigEndian(byte[] byteArray, int ix) {
            return Unsafe$.MODULE$.UNSAFE().getLong(byteArray, (long)ix + Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET);
        }

        public final void _setDoubleByteBigEndian(byte[] byteArray, int ix, char value) {
            Unsafe$.MODULE$.UNSAFE().putChar(byteArray, (long)ix + Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET, value);
        }

        public final void _setQuadByteBigEndian(byte[] byteArray, int ix, int value) {
            Unsafe$.MODULE$.UNSAFE().putInt(byteArray, (long)ix + Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET, value);
        }

        public final void _setOctaByteBigEndian(byte[] byteArray, int ix, long value) {
            Unsafe$.MODULE$.UNSAFE().putLong(byteArray, (long)ix + Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET, value);
        }

        @Override
        public byte[] shortArrayToByteArray(short[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                short[] sArray;
                ByteOrder byteOrder2 = this.byteOrder;
                ByteOrder byteOrder3 = byteOrder;
                if (byteOrder2 == null ? byteOrder3 != null : !byteOrder2.equals(byteOrder3)) {
                    short[] array = new short[source.length];
                    sArray = this.rec$1(array, source, 0);
                } else {
                    sArray = source;
                }
                short[] copySource = sArray;
                byte[] target = new byte[source.length << 1];
                Unsafe$.MODULE$.UNSAFE().copyMemory(copySource, Unsafe$.io$bullet$borer$internal$Unsafe$$$SHORT_ARRAY_BASE_OFFSET, target, Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET, target.length);
                return target;
            }
            return Array$.MODULE$.emptyByteArray();
        }

        @Override
        public byte[] intArrayToByteArray(int[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                int[] nArray;
                ByteOrder byteOrder2 = this.byteOrder;
                ByteOrder byteOrder3 = byteOrder;
                if (byteOrder2 == null ? byteOrder3 != null : !byteOrder2.equals(byteOrder3)) {
                    int[] array = new int[source.length];
                    nArray = this.rec$2(array, source, 0);
                } else {
                    nArray = source;
                }
                int[] copySource = nArray;
                byte[] target = new byte[source.length << 2];
                Unsafe$.MODULE$.UNSAFE().copyMemory(copySource, Unsafe$.io$bullet$borer$internal$Unsafe$$$INT_ARRAY_BASE_OFFSET, target, Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET, target.length);
                return target;
            }
            return Array$.MODULE$.emptyByteArray();
        }

        @Override
        public byte[] longArrayToByteArray(long[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                long[] lArray;
                ByteOrder byteOrder2 = this.byteOrder;
                ByteOrder byteOrder3 = byteOrder;
                if (byteOrder2 == null ? byteOrder3 != null : !byteOrder2.equals(byteOrder3)) {
                    long[] array = new long[source.length];
                    lArray = this.rec$3(array, source, 0);
                } else {
                    lArray = source;
                }
                long[] copySource = lArray;
                byte[] target = new byte[source.length << 3];
                Unsafe$.MODULE$.UNSAFE().copyMemory(copySource, Unsafe$.io$bullet$borer$internal$Unsafe$$$LONG_ARRAY_BASE_OFFSET, target, Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET, target.length);
                return target;
            }
            return Array$.MODULE$.emptyByteArray();
        }

        @Override
        public byte[] floatArrayToByteArray(float[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                int[] copySource = new int[source.length];
                ByteOrder byteOrder2 = this.byteOrder;
                ByteOrder byteOrder3 = byteOrder;
                int[] nArray = (byteOrder2 == null ? byteOrder3 != null : !byteOrder2.equals(byteOrder3)) ? this.rec$4(copySource, source, 0) : this.rec$5(copySource, source, 0);
                byte[] target = new byte[source.length << 2];
                Unsafe$.MODULE$.UNSAFE().copyMemory(copySource, Unsafe$.io$bullet$borer$internal$Unsafe$$$INT_ARRAY_BASE_OFFSET, target, Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET, target.length);
                return target;
            }
            return Array$.MODULE$.emptyByteArray();
        }

        @Override
        public byte[] doubleArrayToByteArray(double[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                long[] copySource = new long[source.length];
                ByteOrder byteOrder2 = this.byteOrder;
                ByteOrder byteOrder3 = byteOrder;
                long[] lArray = (byteOrder2 == null ? byteOrder3 != null : !byteOrder2.equals(byteOrder3)) ? this.rec$6(copySource, source, 0) : this.rec$7(copySource, source, 0);
                byte[] target = new byte[source.length << 3];
                Unsafe$.MODULE$.UNSAFE().copyMemory(copySource, Unsafe$.io$bullet$borer$internal$Unsafe$$$LONG_ARRAY_BASE_OFFSET, target, Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET, target.length);
                return target;
            }
            return Array$.MODULE$.emptyByteArray();
        }

        @Override
        public short[] byteArrayToShortArray(byte[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                if ((source.length & 1) != 0) {
                    throw new IllegalArgumentException(new StringBuilder(39).append("source Array[Byte] has illegal length: ").append(source.length).toString());
                }
                short[] target = new short[source.length >> 1];
                Unsafe$.MODULE$.UNSAFE().copyMemory(source, Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET, target, Unsafe$.io$bullet$borer$internal$Unsafe$$$SHORT_ARRAY_BASE_OFFSET, source.length);
                ByteOrder byteOrder2 = this.byteOrder;
                ByteOrder byteOrder3 = byteOrder;
                if (byteOrder2 == null ? byteOrder3 != null : !byteOrder2.equals(byteOrder3)) {
                    return this.rec$8(target, 0);
                }
                return target;
            }
            return Array$.MODULE$.emptyShortArray();
        }

        @Override
        public int[] byteArrayToIntArray(byte[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                if ((source.length & 3) != 0) {
                    throw new IllegalArgumentException(new StringBuilder(39).append("source Array[Byte] has illegal length: ").append(source.length).toString());
                }
                int[] target = new int[source.length >> 2];
                Unsafe$.MODULE$.UNSAFE().copyMemory(source, Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET, target, Unsafe$.io$bullet$borer$internal$Unsafe$$$INT_ARRAY_BASE_OFFSET, source.length);
                ByteOrder byteOrder2 = this.byteOrder;
                ByteOrder byteOrder3 = byteOrder;
                if (byteOrder2 == null ? byteOrder3 != null : !byteOrder2.equals(byteOrder3)) {
                    return this.rec$9(target, 0);
                }
                return target;
            }
            return Array$.MODULE$.emptyIntArray();
        }

        @Override
        public long[] byteArrayToLongArray(byte[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                if ((source.length & 7) != 0) {
                    throw new IllegalArgumentException(new StringBuilder(39).append("source Array[Byte] has illegal length: ").append(source.length).toString());
                }
                long[] target = new long[source.length >> 3];
                Unsafe$.MODULE$.UNSAFE().copyMemory(source, Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET, target, Unsafe$.io$bullet$borer$internal$Unsafe$$$LONG_ARRAY_BASE_OFFSET, source.length);
                ByteOrder byteOrder2 = this.byteOrder;
                ByteOrder byteOrder3 = byteOrder;
                if (byteOrder2 == null ? byteOrder3 != null : !byteOrder2.equals(byteOrder3)) {
                    return this.rec$10(target, 0);
                }
                return target;
            }
            return Array$.MODULE$.emptyLongArray();
        }

        @Override
        public float[] byteArrayToFloatArray(byte[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                if ((source.length & 3) != 0) {
                    throw new IllegalArgumentException(new StringBuilder(39).append("source Array[Byte] has illegal length: ").append(source.length).toString());
                }
                int[] ints = new int[source.length >> 2];
                Unsafe$.MODULE$.UNSAFE().copyMemory(source, Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET, ints, Unsafe$.io$bullet$borer$internal$Unsafe$$$INT_ARRAY_BASE_OFFSET, source.length);
                float[] target = new float[ints.length];
                ByteOrder byteOrder2 = this.byteOrder;
                ByteOrder byteOrder3 = byteOrder;
                if (byteOrder2 == null ? byteOrder3 != null : !byteOrder2.equals(byteOrder3)) {
                    return this.rec$11(target, ints, 0);
                }
                return this.rec$12(target, ints, 0);
            }
            return Array$.MODULE$.emptyFloatArray();
        }

        @Override
        public double[] byteArrayToDoubleArray(byte[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                if ((source.length & 7) != 0) {
                    throw new IllegalArgumentException(new StringBuilder(39).append("source Array[Byte] has illegal length: ").append(source.length).toString());
                }
                long[] longs = new long[source.length >> 3];
                Unsafe$.MODULE$.UNSAFE().copyMemory(source, Unsafe$.io$bullet$borer$internal$Unsafe$$$BYTE_ARRAY_BASE_OFFSET, longs, Unsafe$.io$bullet$borer$internal$Unsafe$$$LONG_ARRAY_BASE_OFFSET, source.length);
                double[] target = new double[longs.length];
                ByteOrder byteOrder2 = this.byteOrder;
                ByteOrder byteOrder3 = byteOrder;
                if (byteOrder2 == null ? byteOrder3 != null : !byteOrder2.equals(byteOrder3)) {
                    return this.rec$13(target, longs, 0);
                }
                return this.rec$14(target, longs, 0);
            }
            return Array$.MODULE$.emptyDoubleArray();
        }

        private final short[] rec$1(short[] array$1, short[] source$1, int ix) {
            while (ix < array$1.length) {
                array$1[ix] = Short.reverseBytes(source$1[ix]);
                ++ix;
            }
            return array$1;
        }

        private final int[] rec$2(int[] array$2, int[] source$2, int ix) {
            while (ix < array$2.length) {
                array$2[ix] = Integer.reverseBytes(source$2[ix]);
                ++ix;
            }
            return array$2;
        }

        private final long[] rec$3(long[] array$3, long[] source$3, int ix) {
            while (ix < array$3.length) {
                array$3[ix] = Long.reverseBytes(source$3[ix]);
                ++ix;
            }
            return array$3;
        }

        private final int[] rec$4(int[] copySource$1, float[] source$4, int ix) {
            while (ix < copySource$1.length) {
                copySource$1[ix] = Integer.reverseBytes(Float.floatToIntBits(source$4[ix]));
                ++ix;
            }
            return copySource$1;
        }

        private final int[] rec$5(int[] copySource$2, float[] source$5, int ix) {
            while (ix < copySource$2.length) {
                copySource$2[ix] = Float.floatToIntBits(source$5[ix]);
                ++ix;
            }
            return copySource$2;
        }

        private final long[] rec$6(long[] copySource$3, double[] source$6, int ix) {
            while (ix < copySource$3.length) {
                copySource$3[ix] = Long.reverseBytes(Double.doubleToLongBits(source$6[ix]));
                ++ix;
            }
            return copySource$3;
        }

        private final long[] rec$7(long[] copySource$4, double[] source$7, int ix) {
            while (ix < copySource$4.length) {
                copySource$4[ix] = Double.doubleToLongBits(source$7[ix]);
                ++ix;
            }
            return copySource$4;
        }

        private final short[] rec$8(short[] target$1, int ix) {
            while (ix < target$1.length) {
                target$1[ix] = Short.reverseBytes(target$1[ix]);
                ++ix;
            }
            return target$1;
        }

        private final int[] rec$9(int[] target$2, int ix) {
            while (ix < target$2.length) {
                target$2[ix] = Integer.reverseBytes(target$2[ix]);
                ++ix;
            }
            return target$2;
        }

        private final long[] rec$10(long[] target$3, int ix) {
            while (ix < target$3.length) {
                target$3[ix] = Long.reverseBytes(target$3[ix]);
                ++ix;
            }
            return target$3;
        }

        private final float[] rec$11(float[] target$4, int[] ints$1, int ix) {
            while (ix < target$4.length) {
                target$4[ix] = Float.intBitsToFloat(Integer.reverseBytes(ints$1[ix]));
                ++ix;
            }
            return target$4;
        }

        private final float[] rec$12(float[] target$5, int[] ints$2, int ix) {
            while (ix < target$5.length) {
                target$5[ix] = Float.intBitsToFloat(ints$2[ix]);
                ++ix;
            }
            return target$5;
        }

        private final double[] rec$13(double[] target$6, long[] longs$1, int ix) {
            while (ix < target$6.length) {
                target$6[ix] = Double.longBitsToDouble(Long.reverseBytes(longs$1[ix]));
                ++ix;
            }
            return target$6;
        }

        private final double[] rec$14(double[] target$7, long[] longs$2, int ix) {
            while (ix < target$7.length) {
                target$7[ix] = Double.longBitsToDouble(longs$2[ix]);
                ++ix;
            }
            return target$7;
        }
    }
}

