/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.internal;

import io.bullet.borer.internal.Util$;
import java.util.NoSuchElementException;

public final class ResizableRingBuffer<T> {
    private final int maxCapacity;
    private Object[] array;
    private int mask;
    private int writeIx;
    private int readIx;

    public ResizableRingBuffer(int initialCapacity, int maxCapacity) {
        this.maxCapacity = maxCapacity;
        if (!Util$.MODULE$.isPowerOf2(maxCapacity) || maxCapacity <= 0 || !Util$.MODULE$.isPowerOf2(initialCapacity) || initialCapacity <= 0 || maxCapacity < initialCapacity) {
            throw new IllegalArgumentException();
        }
        this.array = new Object[initialCapacity];
        this.mask = this.array.length - 1;
    }

    public int maxCapacity() {
        return this.maxCapacity;
    }

    public boolean append(T value) {
        do {
            if (this.inline$writeIx() - this.inline$readIx() >= this.inline$array().length) continue;
            int w = this.writeIx;
            this.array[w & this.mask] = value;
            this.writeIx = w + 1;
            return true;
        } while (this.grow());
        return false;
    }

    public boolean prepend(T value) {
        do {
            if (this.inline$writeIx() - this.inline$readIx() >= this.inline$array().length) continue;
            int r = this.readIx - 1;
            this.array[r & this.mask] = value;
            this.readIx = r;
            return true;
        } while (this.grow());
        return false;
    }

    public T read() {
        if (this.inline$writeIx() != this.inline$readIx()) {
            return this.unsafeRead();
        }
        throw new NoSuchElementException();
    }

    public T unsafeRead() {
        int r = this.readIx;
        this.readIx = r + 1;
        int ix = r & this.mask;
        Object res = this.array[ix];
        this.array[ix] = null;
        return (T)res;
    }

    public T unsafeRead_NoZero() {
        int r = this.readIx;
        this.readIx = r + 1;
        return (T)this.array[r & this.mask];
    }

    public T peekNext() {
        if (this.inline$writeIx() != this.inline$readIx()) {
            return (T)this.array[this.readIx & this.mask];
        }
        throw new NoSuchElementException();
    }

    public T peekFromEnd(int offset) {
        if (this.inline$writeIx() != this.inline$readIx()) {
            return (T)this.array[this.writeIx + offset & this.mask];
        }
        throw new NoSuchElementException();
    }

    public void dropNext(int n) {
        if (n <= this.inline$writeIx() - this.inline$readIx()) {
            this.readIx += n;
            return;
        }
        throw new IllegalArgumentException("Cannot drop more elements than currently in the buffer");
    }

    public void dropLast(int n) {
        if (n <= this.inline$writeIx() - this.inline$readIx()) {
            this.writeIx -= n;
            return;
        }
        throw new IllegalArgumentException("Cannot drop more elements than currently in the buffer");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean grow() {
        if (this.array.length >= this.maxCapacity()) return false;
        int r = this.readIx & this.mask;
        Object[] newArray = new Object[this.array.length << 1];
        System.arraycopy(this.array, r, newArray, 0, this.array.length - r);
        System.arraycopy(this.array, 0, newArray, this.array.length - r, r);
        this.array = newArray;
        this.mask = newArray.length - 1;
        this.writeIx = this.inline$writeIx() - this.inline$readIx();
        this.readIx = 0;
        if (!true) return false;
        return true;
    }

    public String toString() {
        return new StringBuilder(51).append("ResizableRingBuffer(len=").append(this.array.length).append(", size=").append(this.inline$writeIx() - this.inline$readIx()).append(", writeIx=").append(this.writeIx).append(", readIx=").append(this.readIx).append(")").toString();
    }

    public final int inline$writeIx() {
        return this.writeIx;
    }

    public final void inline$writeIx_$eq(int x$0) {
        this.writeIx = x$0;
    }

    public final int inline$readIx() {
        return this.readIx;
    }

    public final void inline$readIx_$eq(int x$0) {
        this.readIx = x$0;
    }

    public final Object[] inline$array() {
        return this.array;
    }
}

