/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.internal;

import io.bullet.borer.internal.ByteArrayAccess$;
import io.bullet.borer.internal.Util$;
import java.util.NoSuchElementException;

public final class ResizableByteRingBuffer {
    private final int maxCapacity;
    private byte[] array;
    private int mask;
    private int writeIx;
    private int readIx;

    public ResizableByteRingBuffer(int initialCapacity, int maxCapacity) {
        this.maxCapacity = maxCapacity;
        if (!Util$.MODULE$.isPowerOf2(maxCapacity) || maxCapacity <= 0 || !Util$.MODULE$.isPowerOf2(initialCapacity) || initialCapacity <= 0 || maxCapacity < initialCapacity) {
            throw new IllegalArgumentException();
        }
        this.array = new byte[initialCapacity];
        this.mask = this.array.length - 1;
    }

    public int maxCapacity() {
        return this.maxCapacity;
    }

    public boolean append1(byte value) {
        do {
            if (this.inline$writeIx() - this.inline$readIx() >= this.inline$array().length) continue;
            int ix = this.writeIx;
            this.writeIx = ix + 1;
            this.inline$array()[ix & this.inline$mask()] = value;
            return true;
        } while (this.grow());
        return false;
    }

    public boolean prepend1(byte value) {
        do {
            int ix;
            if (this.inline$writeIx() - this.inline$readIx() >= this.inline$array().length) continue;
            this.readIx = ix = this.readIx - 1;
            this.inline$array()[ix & this.inline$mask()] = value;
            return true;
        } while (this.grow());
        return false;
    }

    public boolean append2(byte a, byte b) {
        do {
            if (this.inline$writeIx() - this.inline$readIx() > this.inline$array().length - 2) continue;
            int ix = this.writeIx;
            this.writeIx = ix + 2;
            this.inline$array()[ix & this.inline$mask()] = a;
            this.inline$array()[ix + 1 & this.inline$mask()] = b;
            return true;
        } while (this.grow());
        return false;
    }

    public boolean prepend2(byte a, byte b) {
        do {
            int ix;
            if (this.inline$writeIx() - this.inline$readIx() > this.inline$array().length - 2) continue;
            this.readIx = ix = this.readIx - 2;
            this.inline$array()[ix & this.inline$mask()] = a;
            this.inline$array()[ix + 1 & this.inline$mask()] = b;
            return true;
        } while (this.grow());
        return false;
    }

    public boolean append4(int value) {
        do {
            if (this.inline$writeIx() - this.inline$readIx() > this.inline$array().length - 4) continue;
            int ix = this.writeIx;
            this.writeIx = ix + 4;
            return this.write4(value, ix);
        } while (this.grow());
        return false;
    }

    public boolean prepend4(int value) {
        do {
            int ix;
            if (this.inline$writeIx() - this.inline$readIx() > this.inline$array().length - 4) continue;
            this.readIx = ix = this.readIx - 4;
            return this.write4(value, ix);
        } while (this.grow());
        return false;
    }

    public boolean append5(byte by, int n) {
        do {
            if (this.inline$writeIx() - this.inline$readIx() > this.inline$array().length - 5) continue;
            int ix = this.writeIx;
            this.writeIx = ix + 5;
            return this.write5(by, n, ix);
        } while (this.grow());
        return false;
    }

    public boolean prepend5(byte by, int n) {
        do {
            int ix;
            if (this.inline$writeIx() - this.inline$readIx() > this.inline$array().length - 5) continue;
            this.readIx = ix = this.readIx - 5;
            return this.write5(by, n, ix);
        } while (this.grow());
        return false;
    }

    public boolean append8(long value) {
        do {
            if (this.inline$writeIx() - this.inline$readIx() > this.inline$array().length - 8) continue;
            int ix = this.writeIx;
            this.writeIx = ix + 8;
            return this.write8(value, ix);
        } while (this.grow());
        return false;
    }

    public boolean prepend8(long value) {
        do {
            int ix;
            if (this.inline$writeIx() - this.inline$readIx() > this.inline$array().length - 8) continue;
            this.readIx = ix = this.readIx - 8;
            return this.write8(value, ix);
        } while (this.grow());
        return false;
    }

    public boolean append9(byte by, long l) {
        do {
            if (this.inline$writeIx() - this.inline$readIx() >= this.inline$array().length - 8) continue;
            int ix = this.writeIx;
            this.writeIx = ix + 9;
            return this.write9(by, l, ix);
        } while (this.grow());
        return false;
    }

    public boolean prepend9(byte by, long l) {
        do {
            int ix;
            if (this.inline$writeIx() - this.inline$readIx() >= this.inline$array().length - 8) continue;
            this.readIx = ix = this.readIx - 9;
            return this.write9(by, l, ix);
        } while (this.grow());
        return false;
    }

    private boolean write4(int value, int ix) {
        int masked = ix & this.mask;
        if (masked <= this.array.length - 4) {
            ByteArrayAccess$.MODULE$.instance().setQuadByteBigEndian(this.array, masked, value);
        } else {
            this.array[masked] = (byte)(value >> 24);
            this.array[ix + 1 & this.mask] = (byte)(value >> 16);
            this.array[ix + 2 & this.mask] = (byte)(value >> 8);
            this.array[ix + 3 & this.mask] = (byte)(value >> 0);
        }
        return true;
    }

    private boolean write5(byte by, int n, int ix) {
        this.array[ix & this.mask] = by;
        int masked = ix + 1 & this.mask;
        if (masked <= this.array.length - 4) {
            ByteArrayAccess$.MODULE$.instance().setQuadByteBigEndian(this.array, masked, n);
        } else {
            this.array[masked] = (byte)(n >> 24);
            this.array[ix + 2 & this.mask] = (byte)(n >> 16);
            this.array[ix + 3 & this.mask] = (byte)(n >> 8);
            this.array[ix + 4 & this.mask] = (byte)(n >> 0);
        }
        return true;
    }

    private boolean write8(long value, int ix) {
        int masked = ix & this.mask;
        if (masked <= this.array.length - 8) {
            ByteArrayAccess$.MODULE$.instance().setOctaByteBigEndian(this.array, masked, value);
        } else {
            this.array[masked] = (byte)(value >> 56);
            this.array[ix + 1 & this.mask] = (byte)(value >> 48);
            this.array[ix + 2 & this.mask] = (byte)(value >> 40);
            this.array[ix + 3 & this.mask] = (byte)(value >> 32);
            this.array[ix + 4 & this.mask] = (byte)(value >> 24);
            this.array[ix + 5 & this.mask] = (byte)(value >> 16);
            this.array[ix + 6 & this.mask] = (byte)(value >> 8);
            this.array[ix + 7 & this.mask] = (byte)(value >> 0);
        }
        return true;
    }

    private boolean write9(byte by, long l, int ix) {
        this.array[ix & this.mask] = by;
        int masked = ix + 1 & this.mask;
        if (masked <= this.array.length - 8) {
            ByteArrayAccess$.MODULE$.instance().setOctaByteBigEndian(this.array, masked, l);
        } else {
            this.array[masked] = (byte)(l >> 56);
            this.array[ix + 2 & this.mask] = (byte)(l >> 48);
            this.array[ix + 3 & this.mask] = (byte)(l >> 40);
            this.array[ix + 4 & this.mask] = (byte)(l >> 32);
            this.array[ix + 5 & this.mask] = (byte)(l >> 24);
            this.array[ix + 6 & this.mask] = (byte)(l >> 16);
            this.array[ix + 7 & this.mask] = (byte)(l >> 8);
            this.array[ix + 8 & this.mask] = (byte)(l >> 0);
        }
        return true;
    }

    public byte readByte() {
        if (this.inline$writeIx() != this.inline$readIx()) {
            return this.unsafeReadByte();
        }
        throw new NoSuchElementException();
    }

    public byte unsafeReadByte() {
        int r = this.readIx;
        this.readIx = r + 1;
        return this.array[r & this.mask];
    }

    public int unsafeReadQuadByte() {
        int r = this.readIx;
        this.readIx = r + 4;
        int ix = r & this.mask;
        if (ix <= this.array.length - 4) {
            return ByteArrayAccess$.MODULE$.instance().quadByteBigEndian(this.array, ix);
        }
        return this.array[ix] << 24 | (this.array[r + 1 & this.mask] & 0xFF) << 16 | (this.array[r + 2 & this.mask] & 0xFF) << 8 | (this.array[r + 3 & this.mask] & 0xFF) << 0;
    }

    public long unsafeReadOctaByte() {
        int r = this.readIx;
        this.readIx = r + 8;
        int ix = r & this.mask;
        if (ix <= this.array.length - 8) {
            return ByteArrayAccess$.MODULE$.instance().octaByteBigEndian(this.array, ix);
        }
        return (long)this.array[ix] << 56 | ((long)this.array[r + 1 & this.mask] & 0xFFL) << 48 | ((long)this.array[r + 2 & this.mask] & 0xFFL) << 40 | ((long)this.array[r + 3 & this.mask] & 0xFFL) << 32 | ((long)this.array[r + 4 & this.mask] & 0xFFL) << 24 | ((long)this.array[r + 5 & this.mask] & 0xFFL) << 16 | ((long)this.array[r + 6 & this.mask] & 0xFFL) << 8 | ((long)this.array[r + 7 & this.mask] & 0xFFL) << 0;
    }

    public long peekLastOctaByte() {
        if (this.inline$writeIx() - this.inline$readIx() >= 8) {
            int w = this.writeIx - 8;
            int ix = w & this.mask;
            if (ix <= this.array.length - 8) {
                return ByteArrayAccess$.MODULE$.instance().octaByteBigEndian(this.array, ix);
            }
            return (long)this.array[ix] << 56 | ((long)this.array[w + 1 & this.mask] & 0xFFL) << 48 | ((long)this.array[w + 2 & this.mask] & 0xFFL) << 40 | ((long)this.array[w + 3 & this.mask] & 0xFFL) << 32 | ((long)this.array[w + 4 & this.mask] & 0xFFL) << 24 | ((long)this.array[w + 5 & this.mask] & 0xFFL) << 16 | ((long)this.array[w + 6 & this.mask] & 0xFFL) << 8 | ((long)this.array[w + 7 & this.mask] & 0xFFL) << 0;
        }
        throw new NoSuchElementException();
    }

    public void patchLastOctaByte(long value) {
        if (this.inline$writeIx() - this.inline$readIx() >= 8) {
            this.write8(value, this.writeIx - 8);
            return;
        }
        throw new NoSuchElementException();
    }

    public void dropNext(int n) {
        if (n <= this.inline$writeIx() - this.inline$readIx()) {
            this.readIx += n;
            return;
        }
        throw new NoSuchElementException();
    }

    public void dropLast(int n) {
        if (n <= this.inline$writeIx() - this.inline$readIx()) {
            this.writeIx -= n;
            return;
        }
        throw new NoSuchElementException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean grow() {
        if (this.array.length >= this.maxCapacity()) return false;
        int r = this.readIx & this.mask;
        byte[] newArray = new byte[this.array.length << 1];
        System.arraycopy(this.array, r, newArray, 0, this.array.length - r);
        System.arraycopy(this.array, 0, newArray, this.array.length - r, r);
        this.array = newArray;
        this.mask = newArray.length - 1;
        this.writeIx = this.inline$writeIx() - this.inline$readIx();
        this.readIx = 0;
        if (!true) return false;
        return true;
    }

    public String toString() {
        return new StringBuilder(55).append("ResizableByteRingBuffer(len=").append(this.array.length).append(", size=").append(this.inline$writeIx() - this.inline$readIx()).append(", writeIx=").append(this.writeIx).append(", readIx=").append(this.readIx).append(")").toString();
    }

    public final int inline$writeIx() {
        return this.writeIx;
    }

    public final void inline$writeIx_$eq(int x$0) {
        this.writeIx = x$0;
    }

    public final int inline$readIx() {
        return this.readIx;
    }

    public final void inline$readIx_$eq(int x$0) {
        this.readIx = x$0;
    }

    public final byte[] inline$array() {
        return this.array;
    }

    public final int inline$mask() {
        return this.mask;
    }
}

