/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.internal;

import io.bullet.borer.ByteAccess;
import io.bullet.borer.InputReader;
import io.bullet.borer.Reader;
import io.bullet.borer.Receiver;
import io.bullet.borer.Tag;
import io.bullet.borer.internal.ElementDeque$;
import io.bullet.borer.internal.ResizableByteRingBuffer;
import io.bullet.borer.internal.ResizableRingBuffer;
import scala.MatchError;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class ElementDeque {
    private final int maxBufferSize;
    private final ElementDeque next;
    public final ResizableByteRingBuffer io$bullet$borer$internal$ElementDeque$$byteBuffer;
    public final ResizableRingBuffer<Object> io$bullet$borer$internal$ElementDeque$$objBuffer;
    private final Receiver prependReceiver;
    private final Receiver appendReceiver;

    public static ElementDeque $lessinit$greater$default$2() {
        return ElementDeque$.MODULE$.$lessinit$greater$default$2();
    }

    public ElementDeque(int maxBufferSize, ElementDeque next) {
        this.maxBufferSize = maxBufferSize;
        this.next = next;
        this.io$bullet$borer$internal$ElementDeque$$byteBuffer = new ResizableByteRingBuffer(16, package$.MODULE$.max(16, maxBufferSize));
        this.io$bullet$borer$internal$ElementDeque$$objBuffer = new ResizableRingBuffer(16, package$.MODULE$.max(16, maxBufferSize));
        this.prependReceiver = new Receiver(this){
            private final /* synthetic */ ElementDeque $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onNull() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)0));
            }

            public void onUndefined() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)1));
            }

            public void onBoolean(boolean value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend2((byte)2, value ? (byte)1 : 0));
            }

            public void onInt(int value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend5((byte)3, value));
            }

            public void onLong(long value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend9((byte)4, value));
            }

            public void onOverLong(boolean negative, long value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)5) && this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend9(negative ? (byte)1 : 0, value));
            }

            public void onFloat16(float value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend5((byte)6, Float.floatToIntBits(value)));
            }

            public void onFloat(float value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend5((byte)7, Float.floatToIntBits(value)));
            }

            public void onDouble(double value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend9((byte)8, Double.doubleToLongBits(value)));
            }

            public void onNumberString(String value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)9) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.prepend(value));
            }

            public void onBytes(Object value, ByteAccess ba) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)14) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.prepend(ba) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.prepend(value));
            }

            public void onBytesStart() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)15));
            }

            public void onString(String value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)10) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.prepend(value));
            }

            public void onChars(char[] buffer, int length) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)10) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.prepend(new String(buffer, 0, length)));
            }

            public void onText(Object value, ByteAccess ba) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)12) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.prepend(ba) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.prepend(value));
            }

            public void onTextStart() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)13));
            }

            public void onArrayHeader(long length) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend9((byte)16, length));
            }

            public void onArrayStart() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)17));
            }

            public void onMapHeader(long length) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend9((byte)18, length));
            }

            public void onMapStart() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)19));
            }

            public void onBreak() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)20));
            }

            public void onTag(Tag value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)21) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.prepend(value));
            }

            public void onSimpleValue(int value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend5((byte)22, value));
            }

            public void onEndOfInput() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.prepend1((byte)23));
            }
        };
        this.appendReceiver = new Receiver(this){
            private final /* synthetic */ ElementDeque $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onNull() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)0));
            }

            public void onUndefined() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)1));
            }

            public void onBoolean(boolean value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append2((byte)2, value ? (byte)1 : 0));
            }

            public void onInt(int value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append5((byte)3, value));
            }

            public void onLong(long value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append9((byte)4, value));
            }

            public void onOverLong(boolean negative, long value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)5) && this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append9(negative ? (byte)1 : 0, value));
            }

            public void onFloat16(float value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append5((byte)6, Float.floatToIntBits(value)));
            }

            public void onFloat(float value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append5((byte)7, Float.floatToIntBits(value)));
            }

            public void onDouble(double value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append9((byte)8, Double.doubleToLongBits(value)));
            }

            public void onNumberString(String value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)9) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.append(value));
            }

            public void onBytes(Object value, ByteAccess ba) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)14) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.append(value) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.append(ba));
            }

            public void onBytesStart() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)15));
            }

            public void onString(String value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)10) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.append(value));
            }

            public void onChars(char[] buffer, int length) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)10) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.append(new String(buffer, 0, length)));
            }

            public void onText(Object value, ByteAccess ba) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)12) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.append(value) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.append(ba));
            }

            public void onTextStart() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)13));
            }

            public void onArrayHeader(long length) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append9((byte)16, length));
            }

            public void onArrayStart() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)17));
            }

            public void onMapHeader(long length) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append9((byte)18, length));
            }

            public void onMapStart() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)19));
            }

            public void onBreak() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)20));
            }

            public void onTag(Tag value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)21) && this.$outer.io$bullet$borer$internal$ElementDeque$$objBuffer.append(value));
            }

            public void onSimpleValue(int value) {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append5((byte)22, value));
            }

            public void onEndOfInput() {
                this.$outer.io$bullet$borer$internal$ElementDeque$$ret(this.$outer.io$bullet$borer$internal$ElementDeque$$byteBuffer.append1((byte)23));
            }
        };
    }

    public int maxBufferSize() {
        return this.maxBufferSize;
    }

    public ElementDeque next() {
        return this.next;
    }

    public Receiver prependReceiver() {
        return this.prependReceiver;
    }

    public Receiver appendReceiver() {
        return this.appendReceiver;
    }

    public int pull(Receiver receiver) {
        byte shift;
        byte by = shift = this.io$bullet$borer$internal$ElementDeque$$byteBuffer.unsafeReadByte();
        switch (by) {
            case 0: {
                receiver.onNull();
                break;
            }
            case 1: {
                receiver.onUndefined();
                break;
            }
            case 2: {
                receiver.onBoolean(this.io$bullet$borer$internal$ElementDeque$$byteBuffer.unsafeReadByte() != 0);
                break;
            }
            case 3: {
                receiver.onInt(this.io$bullet$borer$internal$ElementDeque$$byteBuffer.unsafeReadQuadByte());
                break;
            }
            case 4: {
                receiver.onLong(this.io$bullet$borer$internal$ElementDeque$$byteBuffer.unsafeReadOctaByte());
                break;
            }
            case 5: {
                receiver.onOverLong(this.io$bullet$borer$internal$ElementDeque$$byteBuffer.unsafeReadByte() != 0, this.io$bullet$borer$internal$ElementDeque$$byteBuffer.unsafeReadOctaByte());
                break;
            }
            case 6: {
                receiver.onFloat16(Float.intBitsToFloat(this.io$bullet$borer$internal$ElementDeque$$byteBuffer.unsafeReadQuadByte()));
                break;
            }
            case 7: {
                receiver.onFloat(Float.intBitsToFloat(this.io$bullet$borer$internal$ElementDeque$$byteBuffer.unsafeReadQuadByte()));
                break;
            }
            case 8: {
                receiver.onDouble(Double.longBitsToDouble(this.io$bullet$borer$internal$ElementDeque$$byteBuffer.unsafeReadOctaByte()));
                break;
            }
            case 9: {
                receiver.onNumberString((String)this.io$bullet$borer$internal$ElementDeque$$objBuffer.unsafeRead());
                break;
            }
            case 14: {
                receiver.onBytes(this.io$bullet$borer$internal$ElementDeque$$objBuffer.unsafeRead(), (ByteAccess)this.io$bullet$borer$internal$ElementDeque$$objBuffer.unsafeRead());
                break;
            }
            case 15: {
                receiver.onBytesStart();
                break;
            }
            case 10: {
                receiver.onString((String)this.io$bullet$borer$internal$ElementDeque$$objBuffer.unsafeRead());
                break;
            }
            case 12: {
                receiver.onText(this.io$bullet$borer$internal$ElementDeque$$objBuffer.unsafeRead(), (ByteAccess)this.io$bullet$borer$internal$ElementDeque$$objBuffer.unsafeRead());
                break;
            }
            case 13: {
                receiver.onTextStart();
                break;
            }
            case 16: {
                receiver.onArrayHeader(this.io$bullet$borer$internal$ElementDeque$$byteBuffer.unsafeReadOctaByte());
                break;
            }
            case 17: {
                receiver.onArrayStart();
                break;
            }
            case 18: {
                receiver.onMapHeader(this.io$bullet$borer$internal$ElementDeque$$byteBuffer.unsafeReadOctaByte());
                break;
            }
            case 19: {
                receiver.onMapStart();
                break;
            }
            case 20: {
                receiver.onBreak();
                break;
            }
            case 21: {
                receiver.onTag((Tag)this.io$bullet$borer$internal$ElementDeque$$objBuffer.unsafeRead());
                break;
            }
            case 22: {
                receiver.onSimpleValue(this.io$bullet$borer$internal$ElementDeque$$byteBuffer.unsafeReadQuadByte());
                break;
            }
            case 23: {
                receiver.onEndOfInput();
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToByte(by));
            }
        }
        return 1 << shift;
    }

    public void pullAll(Receiver receiver) {
        ResizableByteRingBuffer ResizableByteRingBuffer_this;
        while ((ResizableByteRingBuffer_this = this.inline$byteBuffer()).inline$writeIx() != ResizableByteRingBuffer_this.inline$readIx()) {
            this.pull(receiver);
        }
    }

    public Object dataItemValueFromEnd(int offset) {
        return this.io$bullet$borer$internal$ElementDeque$$objBuffer.peekFromEnd(offset);
    }

    public int appendElementFrom(InputReader<? extends Reader.Config> r) {
        int first = r.receiveInto(this.appendReceiver());
        if ((first & 0xFA000) != 0) {
            this.pullComplex$1(r, first, 0);
        }
        return first;
    }

    public void dropLastStringDataItem() {
        this.io$bullet$borer$internal$ElementDeque$$byteBuffer.dropLast(1);
        this.io$bullet$borer$internal$ElementDeque$$objBuffer.dropLast(1);
    }

    public void dropLastTextDataItem() {
        this.io$bullet$borer$internal$ElementDeque$$byteBuffer.dropLast(1);
        this.io$bullet$borer$internal$ElementDeque$$objBuffer.dropLast(2);
    }

    public void dropLastBreakDataItem() {
        this.io$bullet$borer$internal$ElementDeque$$byteBuffer.dropLast(1);
    }

    public boolean io$bullet$borer$internal$ElementDeque$$ret(boolean result) {
        if (result) {
            return true;
        }
        throw new Overflow();
    }

    public final ResizableByteRingBuffer inline$byteBuffer() {
        return this.io$bullet$borer$internal$ElementDeque$$byteBuffer;
    }

    public final ResizableRingBuffer<Object> inline$objBuffer() {
        return this.io$bullet$borer$internal$ElementDeque$$objBuffer;
    }

    private final void pullN$1(InputReader r$2, int level$1, long remaining) {
        while (remaining > 0L) {
            int dataItem = r$2.receiveInto(this.appendReceiver());
            if ((dataItem & 0xFA000) != 0) {
                this.pullComplex$1(r$2, dataItem, level$1 + 1);
            }
            --remaining;
        }
    }

    private final void pullUntilBreak$1(InputReader r$3, int level$2) {
        int dataItem;
        do {
            if (((dataItem = r$3.receiveInto(this.appendReceiver())) & 0xFA000) == 0) continue;
            this.pullComplex$1(r$3, dataItem, level$2 + 1);
        } while (dataItem != 0x100000);
    }

    private final void pullComplex$1(InputReader r$1, int dataItem, int level) {
        if (level < 100) {
            int n = dataItem;
            if (65536 == n) {
                this.pullN$1(r$1, level, this.io$bullet$borer$internal$ElementDeque$$byteBuffer.peekLastOctaByte());
                return;
            }
            if (262144 == n) {
                long elemsToPull = this.io$bullet$borer$internal$ElementDeque$$byteBuffer.peekLastOctaByte() << 1;
                if (elemsToPull >= 0L) {
                    this.pullN$1(r$1, level, elemsToPull);
                    return;
                }
                throw scala.sys.package$.MODULE$.error("Maps with more than 2^62 elements are not supported");
            }
            this.pullUntilBreak$1(r$1, level);
            return;
        }
        throw scala.sys.package$.MODULE$.error("Structures with more than 100 nesting levels are not supported");
    }

    public static class Overflow
    extends RuntimeException {
    }
}

