/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.internal;

import io.bullet.borer.internal.ByteArrayAccess$;
import java.nio.ByteOrder;
import scala.Array$;

public abstract class ByteArrayAccess {
    public static ByteArrayAccess instance() {
        return ByteArrayAccess$.MODULE$.instance();
    }

    public abstract char doubleByteBigEndian(byte[] var1, int var2);

    public abstract int quadByteBigEndian(byte[] var1, int var2);

    public abstract long octaByteBigEndian(byte[] var1, int var2);

    public abstract void setDoubleByteBigEndian(byte[] var1, int var2, char var3);

    public abstract void setQuadByteBigEndian(byte[] var1, int var2, int var3);

    public abstract void setOctaByteBigEndian(byte[] var1, int var2, long var3);

    public abstract byte[] shortArrayToByteArray(short[] var1, ByteOrder var2);

    public abstract byte[] intArrayToByteArray(int[] var1, ByteOrder var2);

    public abstract byte[] longArrayToByteArray(long[] var1, ByteOrder var2);

    public abstract byte[] floatArrayToByteArray(float[] var1, ByteOrder var2);

    public abstract byte[] doubleArrayToByteArray(double[] var1, ByteOrder var2);

    public abstract short[] byteArrayToShortArray(byte[] var1, ByteOrder var2);

    public abstract int[] byteArrayToIntArray(byte[] var1, ByteOrder var2);

    public abstract long[] byteArrayToLongArray(byte[] var1, ByteOrder var2);

    public abstract float[] byteArrayToFloatArray(byte[] var1, ByteOrder var2);

    public abstract double[] byteArrayToDoubleArray(byte[] var1, ByteOrder var2);

    public static final class Default
    extends ByteArrayAccess {
        @Override
        public char doubleByteBigEndian(byte[] byteArray, int ix) {
            return (char)(byteArray[ix] << 8 | byteArray[ix + 1] & 0xFF);
        }

        @Override
        public int quadByteBigEndian(byte[] byteArray, int ix) {
            return byteArray[ix] << 24 | (byteArray[ix + 1] & 0xFF) << 16 | (byteArray[ix + 2] & 0xFF) << 8 | byteArray[ix + 3] & 0xFF;
        }

        @Override
        public long octaByteBigEndian(byte[] byteArray, int ix) {
            return (long)byteArray[ix] << 56 | ((long)byteArray[ix + 1] & 0xFFL) << 48 | ((long)byteArray[ix + 2] & 0xFFL) << 40 | ((long)byteArray[ix + 3] & 0xFFL) << 32 | ((long)byteArray[ix + 4] & 0xFFL) << 24 | ((long)byteArray[ix + 5] & 0xFFL) << 16 | ((long)byteArray[ix + 6] & 0xFFL) << 8 | (long)byteArray[ix + 7] & 0xFFL;
        }

        @Override
        public void setDoubleByteBigEndian(byte[] byteArray, int ix, char value) {
            byteArray[ix + 0] = (byte)(value >> 8);
            byteArray[ix + 1] = (byte)value;
        }

        @Override
        public void setQuadByteBigEndian(byte[] byteArray, int ix, int value) {
            byteArray[ix + 0] = (byte)(value >> 24);
            byteArray[ix + 1] = (byte)(value >> 16);
            byteArray[ix + 2] = (byte)(value >> 8);
            byteArray[ix + 3] = (byte)value;
        }

        @Override
        public void setOctaByteBigEndian(byte[] byteArray, int ix, long value) {
            byteArray[ix + 0] = (byte)(value >> 56);
            byteArray[ix + 1] = (byte)(value >> 48);
            byteArray[ix + 2] = (byte)(value >> 40);
            byteArray[ix + 3] = (byte)(value >> 32);
            byteArray[ix + 4] = (byte)(value >> 24);
            byteArray[ix + 5] = (byte)(value >> 16);
            byteArray[ix + 6] = (byte)(value >> 8);
            byteArray[ix + 7] = (byte)value;
        }

        @Override
        public byte[] shortArrayToByteArray(short[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                byte[] bytes = new byte[source.length << 1];
                ByteOrder byteOrder2 = byteOrder;
                ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
                if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
                    return this.recBigEndian$1(source, bytes, 0, 0);
                }
                return this.recLittleEndian$1(source, bytes, 0, 0);
            }
            return Array$.MODULE$.emptyByteArray();
        }

        @Override
        public byte[] intArrayToByteArray(int[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                byte[] bytes = new byte[source.length << 2];
                ByteOrder byteOrder2 = byteOrder;
                ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
                if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
                    return this.recBigEndian$2(source, bytes, 0, 0);
                }
                return this.recLittleEndian$2(source, bytes, 0, 0);
            }
            return Array$.MODULE$.emptyByteArray();
        }

        @Override
        public byte[] longArrayToByteArray(long[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                byte[] bytes = new byte[source.length << 3];
                ByteOrder byteOrder2 = byteOrder;
                ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
                if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
                    return this.recBigEndian$3(source, bytes, 0, 0);
                }
                return this.recLittleEndian$3(source, bytes, 0, 0);
            }
            return Array$.MODULE$.emptyByteArray();
        }

        @Override
        public byte[] floatArrayToByteArray(float[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                byte[] bytes = new byte[source.length << 2];
                ByteOrder byteOrder2 = byteOrder;
                ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
                if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
                    return this.recBigEndian$4(source, bytes, 0, 0);
                }
                return this.recLittleEndian$4(source, bytes, 0, 0);
            }
            return Array$.MODULE$.emptyByteArray();
        }

        @Override
        public byte[] doubleArrayToByteArray(double[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                byte[] bytes = new byte[source.length << 3];
                ByteOrder byteOrder2 = byteOrder;
                ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
                if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
                    return this.recBigEndian$5(source, bytes, 0, 0);
                }
                return this.recLittleEndian$5(source, bytes, 0, 0);
            }
            return Array$.MODULE$.emptyByteArray();
        }

        @Override
        public short[] byteArrayToShortArray(byte[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                if ((source.length & 1) != 0) {
                    throw new IllegalArgumentException(new StringBuilder(39).append("source Array[Byte] has illegal length: ").append(source.length).toString());
                }
                short[] target = new short[source.length >> 1];
                ByteOrder byteOrder2 = byteOrder;
                ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
                if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
                    return this.recBigEndian$6(target, source, 0, 0);
                }
                return this.recLittleEndian$6(target, source, 0, 0);
            }
            return Array$.MODULE$.emptyShortArray();
        }

        @Override
        public int[] byteArrayToIntArray(byte[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                if ((source.length & 3) != 0) {
                    throw new IllegalArgumentException(new StringBuilder(39).append("source Array[Byte] has illegal length: ").append(source.length).toString());
                }
                int[] target = new int[source.length >> 2];
                ByteOrder byteOrder2 = byteOrder;
                ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
                if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
                    return this.recBigEndian$7(target, source, 0, 0);
                }
                return this.recLittleEndian$7(target, source, 0, 0);
            }
            return Array$.MODULE$.emptyIntArray();
        }

        @Override
        public long[] byteArrayToLongArray(byte[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                if ((source.length & 7) != 0) {
                    throw new IllegalArgumentException(new StringBuilder(39).append("source Array[Byte] has illegal length: ").append(source.length).toString());
                }
                long[] target = new long[source.length >> 3];
                ByteOrder byteOrder2 = byteOrder;
                ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
                if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
                    return this.recBigEndian$8(target, source, 0, 0);
                }
                return this.recLittleEndian$8(target, source, 0, 0);
            }
            return Array$.MODULE$.emptyLongArray();
        }

        @Override
        public float[] byteArrayToFloatArray(byte[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                if ((source.length & 3) != 0) {
                    throw new IllegalArgumentException(new StringBuilder(39).append("source Array[Byte] has illegal length: ").append(source.length).toString());
                }
                float[] target = new float[source.length >> 2];
                ByteOrder byteOrder2 = byteOrder;
                ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
                if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
                    return this.recBigEndian$9(target, source, 0, 0);
                }
                return this.recLittleEndian$9(target, source, 0, 0);
            }
            return Array$.MODULE$.emptyFloatArray();
        }

        @Override
        public double[] byteArrayToDoubleArray(byte[] source, ByteOrder byteOrder) {
            if (source.length > 0) {
                if ((source.length & 7) != 0) {
                    throw new IllegalArgumentException(new StringBuilder(39).append("source Array[Byte] has illegal length: ").append(source.length).toString());
                }
                double[] target = new double[source.length >> 3];
                ByteOrder byteOrder2 = byteOrder;
                ByteOrder byteOrder3 = ByteOrder.BIG_ENDIAN;
                if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
                    return this.recBigEndian$10(target, source, 0, 0);
                }
                return this.recLittleEndian$10(target, source, 0, 0);
            }
            return Array$.MODULE$.emptyDoubleArray();
        }

        private final byte[] recBigEndian$1(short[] source$1, byte[] bytes$1, int sourceIx, int targetIx) {
            while (sourceIx < source$1.length) {
                short value = source$1[sourceIx];
                bytes$1[targetIx] = (byte)(value >>> 8);
                bytes$1[targetIx + 1] = (byte)value;
                int n = sourceIx + 1;
                int n2 = targetIx + 2;
                sourceIx = n;
                targetIx = n2;
            }
            return bytes$1;
        }

        private final byte[] recLittleEndian$1(short[] source$2, byte[] bytes$2, int sourceIx, int targetIx) {
            while (sourceIx < source$2.length) {
                short value = source$2[sourceIx];
                bytes$2[targetIx] = (byte)value;
                bytes$2[targetIx + 1] = (byte)(value >>> 8);
                int n = sourceIx + 1;
                int n2 = targetIx + 2;
                sourceIx = n;
                targetIx = n2;
            }
            return bytes$2;
        }

        private final byte[] recBigEndian$2(int[] source$3, byte[] bytes$3, int sourceIx, int targetIx) {
            while (sourceIx < source$3.length) {
                int value = source$3[sourceIx];
                bytes$3[targetIx] = (byte)(value >>> 24);
                bytes$3[targetIx + 1] = (byte)(value >>> 16);
                bytes$3[targetIx + 2] = (byte)(value >>> 8);
                bytes$3[targetIx + 3] = (byte)value;
                int n = sourceIx + 1;
                int n2 = targetIx + 4;
                sourceIx = n;
                targetIx = n2;
            }
            return bytes$3;
        }

        private final byte[] recLittleEndian$2(int[] source$4, byte[] bytes$4, int sourceIx, int targetIx) {
            while (sourceIx < source$4.length) {
                int value = source$4[sourceIx];
                bytes$4[targetIx] = (byte)value;
                bytes$4[targetIx + 1] = (byte)(value >>> 8);
                bytes$4[targetIx + 2] = (byte)(value >>> 16);
                bytes$4[targetIx + 3] = (byte)(value >>> 24);
                int n = sourceIx + 1;
                int n2 = targetIx + 4;
                sourceIx = n;
                targetIx = n2;
            }
            return bytes$4;
        }

        private final byte[] recBigEndian$3(long[] source$5, byte[] bytes$5, int sourceIx, int targetIx) {
            while (sourceIx < source$5.length) {
                long value = source$5[sourceIx];
                bytes$5[targetIx] = (byte)(value >>> 56);
                bytes$5[targetIx + 1] = (byte)(value >>> 48);
                bytes$5[targetIx + 2] = (byte)(value >>> 40);
                bytes$5[targetIx + 3] = (byte)(value >>> 32);
                bytes$5[targetIx + 4] = (byte)(value >>> 24);
                bytes$5[targetIx + 5] = (byte)(value >>> 16);
                bytes$5[targetIx + 6] = (byte)(value >>> 8);
                bytes$5[targetIx + 7] = (byte)value;
                int n = sourceIx + 1;
                int n2 = targetIx + 8;
                sourceIx = n;
                targetIx = n2;
            }
            return bytes$5;
        }

        private final byte[] recLittleEndian$3(long[] source$6, byte[] bytes$6, int sourceIx, int targetIx) {
            while (sourceIx < source$6.length) {
                long value = source$6[sourceIx];
                bytes$6[targetIx] = (byte)value;
                bytes$6[targetIx + 1] = (byte)(value >>> 8);
                bytes$6[targetIx + 2] = (byte)(value >>> 16);
                bytes$6[targetIx + 3] = (byte)(value >>> 24);
                bytes$6[targetIx + 4] = (byte)(value >>> 32);
                bytes$6[targetIx + 5] = (byte)(value >>> 40);
                bytes$6[targetIx + 6] = (byte)(value >>> 48);
                bytes$6[targetIx + 7] = (byte)(value >>> 56);
                int n = sourceIx + 1;
                int n2 = targetIx + 8;
                sourceIx = n;
                targetIx = n2;
            }
            return bytes$6;
        }

        private final byte[] recBigEndian$4(float[] source$7, byte[] bytes$7, int sourceIx, int targetIx) {
            while (sourceIx < source$7.length) {
                int value = Float.floatToIntBits(source$7[sourceIx]);
                bytes$7[targetIx] = (byte)(value >>> 24);
                bytes$7[targetIx + 1] = (byte)(value >>> 16);
                bytes$7[targetIx + 2] = (byte)(value >>> 8);
                bytes$7[targetIx + 3] = (byte)value;
                int n = sourceIx + 1;
                int n2 = targetIx + 4;
                sourceIx = n;
                targetIx = n2;
            }
            return bytes$7;
        }

        private final byte[] recLittleEndian$4(float[] source$8, byte[] bytes$8, int sourceIx, int targetIx) {
            while (sourceIx < source$8.length) {
                int value = Float.floatToIntBits(source$8[sourceIx]);
                bytes$8[targetIx] = (byte)value;
                bytes$8[targetIx + 1] = (byte)(value >>> 8);
                bytes$8[targetIx + 2] = (byte)(value >>> 16);
                bytes$8[targetIx + 3] = (byte)(value >>> 24);
                int n = sourceIx + 1;
                int n2 = targetIx + 4;
                sourceIx = n;
                targetIx = n2;
            }
            return bytes$8;
        }

        private final byte[] recBigEndian$5(double[] source$9, byte[] bytes$9, int sourceIx, int targetIx) {
            while (sourceIx < source$9.length) {
                long value = Double.doubleToLongBits(source$9[sourceIx]);
                bytes$9[targetIx] = (byte)(value >>> 56);
                bytes$9[targetIx + 1] = (byte)(value >>> 48);
                bytes$9[targetIx + 2] = (byte)(value >>> 40);
                bytes$9[targetIx + 3] = (byte)(value >>> 32);
                bytes$9[targetIx + 4] = (byte)(value >>> 24);
                bytes$9[targetIx + 5] = (byte)(value >>> 16);
                bytes$9[targetIx + 6] = (byte)(value >>> 8);
                bytes$9[targetIx + 7] = (byte)value;
                int n = sourceIx + 1;
                int n2 = targetIx + 8;
                sourceIx = n;
                targetIx = n2;
            }
            return bytes$9;
        }

        private final byte[] recLittleEndian$5(double[] source$10, byte[] bytes$10, int sourceIx, int targetIx) {
            while (sourceIx < source$10.length) {
                long value = Double.doubleToLongBits(source$10[sourceIx]);
                bytes$10[targetIx] = (byte)value;
                bytes$10[targetIx + 1] = (byte)(value >>> 8);
                bytes$10[targetIx + 2] = (byte)(value >>> 16);
                bytes$10[targetIx + 3] = (byte)(value >>> 24);
                bytes$10[targetIx + 4] = (byte)(value >>> 32);
                bytes$10[targetIx + 5] = (byte)(value >>> 40);
                bytes$10[targetIx + 6] = (byte)(value >>> 48);
                bytes$10[targetIx + 7] = (byte)(value >>> 56);
                int n = sourceIx + 1;
                int n2 = targetIx + 8;
                sourceIx = n;
                targetIx = n2;
            }
            return bytes$10;
        }

        private final short[] recBigEndian$6(short[] target$1, byte[] source$11, int sourceIx, int targetIx) {
            while (targetIx < target$1.length) {
                target$1[targetIx] = (short)(source$11[sourceIx] << 8 | source$11[sourceIx + 1] & 0xFF);
                int n = sourceIx + 2;
                int n2 = targetIx + 1;
                sourceIx = n;
                targetIx = n2;
            }
            return target$1;
        }

        private final short[] recLittleEndian$6(short[] target$2, byte[] source$12, int sourceIx, int targetIx) {
            while (targetIx < target$2.length) {
                target$2[targetIx] = (short)(source$12[sourceIx] & 0xFF | source$12[sourceIx + 1] << 8);
                int n = sourceIx + 2;
                int n2 = targetIx + 1;
                sourceIx = n;
                targetIx = n2;
            }
            return target$2;
        }

        private final int[] recBigEndian$7(int[] target$3, byte[] source$13, int sourceIx, int targetIx) {
            while (targetIx < target$3.length) {
                target$3[targetIx] = source$13[sourceIx] << 24 | (source$13[sourceIx + 1] & 0xFF) << 16 | (source$13[sourceIx + 2] & 0xFF) << 8 | source$13[sourceIx + 3] & 0xFF;
                int n = sourceIx + 4;
                int n2 = targetIx + 1;
                sourceIx = n;
                targetIx = n2;
            }
            return target$3;
        }

        private final int[] recLittleEndian$7(int[] target$4, byte[] source$14, int sourceIx, int targetIx) {
            while (targetIx < target$4.length) {
                target$4[targetIx] = source$14[sourceIx] & 0xFF | (source$14[sourceIx + 1] & 0xFF) << 8 | (source$14[sourceIx + 2] & 0xFF) << 16 | source$14[sourceIx + 3] << 24;
                int n = sourceIx + 4;
                int n2 = targetIx + 1;
                sourceIx = n;
                targetIx = n2;
            }
            return target$4;
        }

        private final long[] recBigEndian$8(long[] target$5, byte[] source$15, int sourceIx, int targetIx) {
            while (targetIx < target$5.length) {
                target$5[targetIx] = (long)source$15[sourceIx] << 56 | ((long)source$15[sourceIx + 1] & 0xFFL) << 48 | ((long)source$15[sourceIx + 2] & 0xFFL) << 40 | ((long)source$15[sourceIx + 3] & 0xFFL) << 32 | ((long)source$15[sourceIx + 4] & 0xFFL) << 24 | ((long)source$15[sourceIx + 5] & 0xFFL) << 16 | ((long)source$15[sourceIx + 6] & 0xFFL) << 8 | (long)source$15[sourceIx + 7] & 0xFFL;
                int n = sourceIx + 8;
                int n2 = targetIx + 1;
                sourceIx = n;
                targetIx = n2;
            }
            return target$5;
        }

        private final long[] recLittleEndian$8(long[] target$6, byte[] source$16, int sourceIx, int targetIx) {
            while (targetIx < target$6.length) {
                target$6[targetIx] = (long)source$16[sourceIx] & 0xFFL | ((long)source$16[sourceIx + 1] & 0xFFL) << 8 | ((long)source$16[sourceIx + 2] & 0xFFL) << 16 | ((long)source$16[sourceIx + 3] & 0xFFL) << 24 | ((long)source$16[sourceIx + 4] & 0xFFL) << 32 | ((long)source$16[sourceIx + 5] & 0xFFL) << 40 | ((long)source$16[sourceIx + 6] & 0xFFL) << 48 | (long)source$16[sourceIx + 7] << 56;
                int n = sourceIx + 8;
                int n2 = targetIx + 1;
                sourceIx = n;
                targetIx = n2;
            }
            return target$6;
        }

        private final float[] recBigEndian$9(float[] target$7, byte[] source$17, int sourceIx, int targetIx) {
            while (targetIx < target$7.length) {
                target$7[targetIx] = Float.intBitsToFloat(source$17[sourceIx] << 24 | (source$17[sourceIx + 1] & 0xFF) << 16 | (source$17[sourceIx + 2] & 0xFF) << 8 | source$17[sourceIx + 3] & 0xFF);
                int n = sourceIx + 4;
                int n2 = targetIx + 1;
                sourceIx = n;
                targetIx = n2;
            }
            return target$7;
        }

        private final float[] recLittleEndian$9(float[] target$8, byte[] source$18, int sourceIx, int targetIx) {
            while (targetIx < target$8.length) {
                target$8[targetIx] = Float.intBitsToFloat(source$18[sourceIx] & 0xFF | (source$18[sourceIx + 1] & 0xFF) << 8 | (source$18[sourceIx + 2] & 0xFF) << 16 | source$18[sourceIx + 3] << 24);
                int n = sourceIx + 4;
                int n2 = targetIx + 1;
                sourceIx = n;
                targetIx = n2;
            }
            return target$8;
        }

        private final double[] recBigEndian$10(double[] target$9, byte[] source$19, int sourceIx, int targetIx) {
            while (targetIx < target$9.length) {
                target$9[targetIx] = Double.longBitsToDouble((long)source$19[sourceIx] << 56 | ((long)source$19[sourceIx + 1] & 0xFFL) << 48 | ((long)source$19[sourceIx + 2] & 0xFFL) << 40 | ((long)source$19[sourceIx + 3] & 0xFFL) << 32 | ((long)source$19[sourceIx + 4] & 0xFFL) << 24 | ((long)source$19[sourceIx + 5] & 0xFFL) << 16 | ((long)source$19[sourceIx + 6] & 0xFFL) << 8 | (long)source$19[sourceIx + 7] & 0xFFL);
                int n = sourceIx + 8;
                int n2 = targetIx + 1;
                sourceIx = n;
                targetIx = n2;
            }
            return target$9;
        }

        private final double[] recLittleEndian$10(double[] target$10, byte[] source$20, int sourceIx, int targetIx) {
            while (targetIx < target$10.length) {
                target$10[targetIx] = Double.longBitsToDouble((long)source$20[sourceIx] & 0xFFL | ((long)source$20[sourceIx + 1] & 0xFFL) << 8 | ((long)source$20[sourceIx + 2] & 0xFFL) << 16 | ((long)source$20[sourceIx + 3] & 0xFFL) << 24 | ((long)source$20[sourceIx + 4] & 0xFFL) << 32 | ((long)source$20[sourceIx + 5] & 0xFFL) << 40 | ((long)source$20[sourceIx + 6] & 0xFFL) << 48 | (long)source$20[sourceIx + 7] << 56);
                int n = sourceIx + 8;
                int n2 = targetIx + 1;
                sourceIx = n;
                targetIx = n2;
            }
            return target$10;
        }
    }
}

