/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.input;

import io.bullet.borer.Input;
import io.bullet.borer.input.FromByteBufferInput$FromByteBufferProvider$;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.Array$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.math.package$;

public interface FromByteBufferInput {
    public static void $init$(FromByteBufferInput $this) {
    }

    public static FromByteBufferInput$FromByteBufferProvider$ FromByteBufferProvider$(FromByteBufferInput $this) {
        return $this.FromByteBufferProvider();
    }

    default public FromByteBufferInput$FromByteBufferProvider$ FromByteBufferProvider() {
        return new FromByteBufferInput$FromByteBufferProvider$(this);
    }

    public static Input fromByteBuffer$(FromByteBufferInput $this, ByteBuffer value) {
        return $this.fromByteBuffer(value);
    }

    default public Input<byte[]> fromByteBuffer(ByteBuffer value) {
        ByteOrder byteOrder = value.order();
        ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
        if (byteOrder == null ? byteOrder2 != null : !byteOrder.equals(byteOrder2)) {
            throw new IllegalArgumentException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("borer requires all input ByteBuffers to have BIG ENDIAN byte order for correct parsing,\n          |but the given one is configured as LITTLE ENDIAN.\n          |Please set `ByteOrder.BIG_ENDIAN` before parsing!\n          |Note that you can switch the byte order back to LITTLE ENDIAN after parsing if needed.")));
        }
        return new FromByteBuffer(value);
    }

    public final class FromByteBuffer
    implements Input<byte[]> {
        private final ByteBuffer buffer;

        public FromByteBuffer(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public long cursor() {
            return this.buffer.position();
        }

        @Override
        public FromByteBuffer unread(int numberOfBytes) {
            this.buffer.position(this.buffer.position() - numberOfBytes);
            return this;
        }

        @Override
        public byte readByte() {
            return this.buffer.get();
        }

        @Override
        public byte readBytePadded(Input.PaddingProvider<byte[]> pp) {
            if (this.buffer.hasRemaining()) {
                return this.readByte();
            }
            return pp.padByte();
        }

        @Override
        public char readDoubleByteBigEndian() {
            return this.buffer.getChar();
        }

        @Override
        public char readDoubleByteBigEndianPadded(Input.PaddingProvider<byte[]> pp) {
            int remaining = this.buffer.remaining();
            if (remaining >= 2) {
                return this.readDoubleByteBigEndian();
            }
            return pp.padDoubleByte(remaining);
        }

        @Override
        public int readQuadByteBigEndian() {
            return this.buffer.getInt();
        }

        @Override
        public int readQuadByteBigEndianPadded(Input.PaddingProvider<byte[]> pp) {
            int remaining = this.buffer.remaining();
            if (remaining >= 4) {
                return this.readQuadByteBigEndian();
            }
            return pp.padQuadByte(remaining);
        }

        @Override
        public long readOctaByteBigEndian() {
            return this.buffer.getLong();
        }

        @Override
        public long readOctaByteBigEndianPadded(Input.PaddingProvider<byte[]> pp) {
            int remaining = this.buffer.remaining();
            if (remaining >= 8) {
                return this.readOctaByteBigEndian();
            }
            return pp.padOctaByte(remaining);
        }

        @Override
        public byte[] readBytes(long length, Input.PaddingProvider<byte[]> pp) {
            byte[] bytes;
            byte[] byArray;
            long remaining = this.buffer.remaining();
            int len = (int)package$.MODULE$.min(remaining, length);
            if (len > 0) {
                byte[] bytes2 = new byte[len];
                this.buffer.get(bytes2, 0, len);
                byArray = bytes2;
            } else {
                byArray = bytes = Array$.MODULE$.emptyByteArray();
            }
            if (length <= remaining) {
                return bytes;
            }
            return pp.padBytes(bytes, length - remaining);
        }
    }
}

