/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.input;

import io.bullet.borer.Input;
import io.bullet.borer.input.FromByteArrayInput$FromByteArrayProvider$;
import io.bullet.borer.internal.ByteArrayAccess$;
import scala.Array$;
import scala.math.package$;

public interface FromByteArrayInput {
    public static void $init$(FromByteArrayInput $this) {
    }

    public static FromByteArrayInput$FromByteArrayProvider$ FromByteArrayProvider$(FromByteArrayInput $this) {
        return $this.FromByteArrayProvider();
    }

    default public FromByteArrayInput$FromByteArrayProvider$ FromByteArrayProvider() {
        return new FromByteArrayInput$FromByteArrayProvider$(this);
    }

    public static Input fromByteArray$(FromByteArrayInput $this, byte[] value) {
        return $this.fromByteArray(value);
    }

    default public Input<byte[]> fromByteArray(byte[] value) {
        return new FromByteArray(value);
    }

    public final class FromByteArray
    implements Input<byte[]> {
        private final byte[] byteArray;
        private int _cursor;

        public FromByteArray(byte[] byteArray) {
            this.byteArray = byteArray;
        }

        @Override
        public long cursor() {
            return this._cursor;
        }

        @Override
        public FromByteArray unread(int numberOfBytes) {
            this._cursor -= numberOfBytes;
            return this;
        }

        @Override
        public byte readByte() {
            int c = this._cursor;
            this._cursor = c + 1;
            return this.byteArray[c];
        }

        @Override
        public byte readBytePadded(Input.PaddingProvider<byte[]> pp) {
            if (this._cursor >= this.byteArray.length) {
                return pp.padByte();
            }
            return this.readByte();
        }

        @Override
        public char readDoubleByteBigEndian() {
            int c = this._cursor;
            this._cursor = c + 2;
            return ByteArrayAccess$.MODULE$.instance().doubleByteBigEndian(this.byteArray, c);
        }

        @Override
        public char readDoubleByteBigEndianPadded(Input.PaddingProvider<byte[]> pp) {
            int remaining = this.byteArray.length - this._cursor;
            if (remaining >= 2) {
                return this.readDoubleByteBigEndian();
            }
            return pp.padDoubleByte(remaining);
        }

        @Override
        public int readQuadByteBigEndian() {
            int c = this._cursor;
            this._cursor = c + 4;
            return ByteArrayAccess$.MODULE$.instance().quadByteBigEndian(this.byteArray, c);
        }

        @Override
        public int readQuadByteBigEndianPadded(Input.PaddingProvider<byte[]> pp) {
            int remaining = this.byteArray.length - this._cursor;
            if (remaining >= 4) {
                return this.readQuadByteBigEndian();
            }
            return pp.padQuadByte(remaining);
        }

        @Override
        public long readOctaByteBigEndian() {
            int c = this._cursor;
            this._cursor = c + 8;
            return ByteArrayAccess$.MODULE$.instance().octaByteBigEndian(this.byteArray, c);
        }

        @Override
        public long readOctaByteBigEndianPadded(Input.PaddingProvider<byte[]> pp) {
            int remaining = this.byteArray.length - this._cursor;
            if (remaining >= 8) {
                return this.readOctaByteBigEndian();
            }
            return pp.padOctaByte(remaining);
        }

        @Override
        public byte[] readBytes(long length, Input.PaddingProvider<byte[]> pp) {
            byte[] bytes;
            byte[] byArray;
            long remaining = this.byteArray.length - this._cursor;
            int len = (int)package$.MODULE$.min(remaining, length);
            if (len > 0) {
                byte[] result = new byte[len];
                int c = this._cursor;
                this._cursor = c + len;
                System.arraycopy(this.byteArray, c, result, 0, len);
                byArray = result;
            } else {
                byArray = bytes = Array$.MODULE$.emptyByteArray();
            }
            if (length <= remaining) {
                return bytes;
            }
            return pp.padBytes(bytes, length - remaining);
        }
    }
}

