/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.input;

import io.bullet.borer.Input;
import io.bullet.borer.internal.Unsafe;
import scala.Array$;
import scala.math.package$;

public final class DirectFromByteArrayInput
implements Input<byte[]> {
    private final byte[] byteArray;
    private final Unsafe.LittleEndianByteArrayAccess baa;
    private int _cursor;

    public DirectFromByteArrayInput(byte[] byteArray, Unsafe.LittleEndianByteArrayAccess baa) {
        this.byteArray = byteArray;
        this.baa = baa;
    }

    @Override
    public long cursor() {
        return this._cursor;
    }

    @Override
    public DirectFromByteArrayInput unread(int numberOfBytes) {
        this._cursor -= numberOfBytes;
        return this;
    }

    @Override
    public byte readByte() {
        int c = this._cursor;
        this._cursor = c + 1;
        return this.byteArray[c];
    }

    @Override
    public byte readBytePadded(Input.PaddingProvider<byte[]> pp) {
        if (this._cursor >= this.byteArray.length) {
            return pp.padByte();
        }
        return this.readByte();
    }

    @Override
    public char readDoubleByteBigEndian() {
        int c = this._cursor;
        this._cursor = c + 2;
        return this.baa.doubleByteBigEndian(this.byteArray, c);
    }

    @Override
    public char readDoubleByteBigEndianPadded(Input.PaddingProvider<byte[]> pp) {
        int remaining = this.byteArray.length - this._cursor;
        if (remaining >= 2) {
            return this.readDoubleByteBigEndian();
        }
        return pp.padDoubleByte(remaining);
    }

    @Override
    public int readQuadByteBigEndian() {
        int c = this._cursor;
        this._cursor = c + 4;
        return this.baa.quadByteBigEndian(this.byteArray, c);
    }

    @Override
    public int readQuadByteBigEndianPadded(Input.PaddingProvider<byte[]> pp) {
        int remaining = this.byteArray.length - this._cursor;
        if (remaining >= 4) {
            return this.readQuadByteBigEndian();
        }
        return pp.padQuadByte(remaining);
    }

    @Override
    public long readOctaByteBigEndian() {
        int c = this._cursor;
        this._cursor = c + 8;
        return this.baa.octaByteBigEndian(this.byteArray, c);
    }

    @Override
    public long readOctaByteBigEndianPadded(Input.PaddingProvider<byte[]> pp) {
        int remaining = this.byteArray.length - this._cursor;
        if (remaining >= 8) {
            return this.readOctaByteBigEndian();
        }
        return pp.padOctaByte(remaining);
    }

    @Override
    public byte[] readBytes(long length, Input.PaddingProvider<byte[]> pp) {
        byte[] bytes;
        byte[] byArray;
        long remaining = this.byteArray.length - this._cursor;
        int len = (int)package$.MODULE$.min(remaining, length);
        if (len > 0) {
            byte[] result = new byte[len];
            int c = this._cursor;
            this._cursor = c + len;
            System.arraycopy(this.byteArray, c, result, 0, len);
            byArray = result;
        } else {
            byArray = bytes = Array$.MODULE$.emptyByteArray();
        }
        if (length <= remaining) {
            return bytes;
        }
        return pp.padBytes(bytes, length - remaining);
    }
}

