/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.encodings;

import io.bullet.borer.encodings.LookupBaseEncoding;
import io.bullet.borer.encodings.Util$;
import io.bullet.borer.internal.ByteArrayAccess;
import io.bullet.borer.internal.ByteArrayAccess$;
import java.io.Serializable;
import scala.MatchError;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;

public final class ZBase32$
extends LookupBaseEncoding
implements Serializable {
    public static final ZBase32$ MODULE$ = new ZBase32$();

    private ZBase32$() {
        super("z-base32", 5, "ybndrfg8ejkmcpqxot1uwisza345h769");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ZBase32$.class);
    }

    @Override
    public char[] encode(byte[] bytes) {
        return this.encode((long)bytes.length << 3, bytes);
    }

    public char[] encode(long bitCount, byte[] bytes) {
        int sl = bytes.length;
        if (sl > 0x4FFFFFFF) {
            throw this.failOverflow$1(sl);
        }
        if ((long)sl << 3 < bitCount) {
            throw this.failBitCountMismatch$1(sl, bitCount);
        }
        char[] result = new char[(int)((bitCount + 4L) / 5L)];
        ByteArrayAccess baa = ByteArrayAccess$.MODULE$.instance();
        return this.encode5$1(baa, bytes, result, sl, bitCount, 0, 0);
    }

    @Override
    public byte[] decode(char[] chars) {
        long sl = chars.length;
        return this.decode((sl << 2) + sl, chars);
    }

    public byte[] decode(long bitCount, char[] chars) {
        int sl = chars.length;
        if ((long)((sl << 2) + sl) < bitCount) {
            throw this.failBitCountMismatch$2(sl, bitCount);
        }
        int dlen = (int)(bitCount + 7L >> 3);
        byte[] result = new byte[dlen];
        ByteArrayAccess baa = ByteArrayAccess$.MODULE$.instance();
        return this.decode8$1(baa, result, chars, dlen, bitCount, 0, 0);
    }

    private final Nothing$ failOverflow$1(int sl$1) {
        throw new IllegalArgumentException(new StringBuilder(70).append("Overflow: Cannot ").append(this.name()).append("-encode a byte array with size > 1.342.177.279 (was: ").append(sl$1).toString());
    }

    private final Nothing$ failBitCountMismatch$1(int sl$2, long bitCount$1) {
        throw new IllegalArgumentException(new StringBuilder(75).append("BitCount mismatch: The given byte array with length ").append(sl$2).append(" doesn't contain ").append(bitCount$1).append(" bits.").toString());
    }

    private final char[] encodeRest$1(int sl$3, byte[] bytes$1, ByteArrayAccess baa$1, char[] result$1, long bitsRemaining, int si, int di) {
        long l;
        int n = sl$3 - si;
        switch (n) {
            case 1: {
                l = (long)bytes$1[si] << 56;
                break;
            }
            case 2: {
                l = (long)baa$1.doubleByteBigEndian(bytes$1, si) << 48;
                break;
            }
            case 3: {
                l = (long)baa$1.doubleByteBigEndian(bytes$1, si) << 48 | ((long)bytes$1[si + 2] & 0xFFL) << 40;
                break;
            }
            case 4: {
                l = (long)baa$1.quadByteBigEndian(bytes$1, si) << 32;
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
        }
        long fullBytes = l;
        long bits = fullBytes & (-1L >>> (int)bitsRemaining ^ 0xFFFFFFFFFFFFFFFFL);
        result$1[di] = this.alphabetChars()[(int)(bits >>> 59)];
        if (bitsRemaining > 5L) {
            result$1[di + 1] = this.alphabetChars()[(int)(bits << 5 >>> 59)];
        }
        if (bitsRemaining > 10L) {
            result$1[di + 2] = this.alphabetChars()[(int)(bits << 10 >>> 59)];
        }
        if (bitsRemaining > 15L) {
            result$1[di + 3] = this.alphabetChars()[(int)(bits << 15 >>> 59)];
        }
        if (bitsRemaining > 20L) {
            result$1[di + 4] = this.alphabetChars()[(int)(bits << 20 >>> 59)];
        }
        if (bitsRemaining > 25L) {
            result$1[di + 5] = this.alphabetChars()[(int)(bits << 25 >>> 59)];
        }
        if (bitsRemaining > 30L) {
            result$1[di + 6] = this.alphabetChars()[(int)(bits << 30 >>> 59)];
        }
        if (bitsRemaining > 35L) {
            result$1[di + 7] = this.alphabetChars()[(int)(bits << 35 >>> 59)];
        }
        return result$1;
    }

    private final char[] encode5$1(ByteArrayAccess baa$2, byte[] bytes$2, char[] result$2, int sl$4, long bitsRemaining, int si, int di) {
        while (bitsRemaining >= 40L) {
            long octa = (long)baa$2.quadByteBigEndian(bytes$2, si) << 32 | ((long)bytes$2[si + 4] & 0xFFL) << 24;
            result$2[di + 0] = this.alphabetChars()[(int)(octa << 0 >>> 59)];
            result$2[di + 1] = this.alphabetChars()[(int)(octa << 5 >>> 59)];
            result$2[di + 2] = this.alphabetChars()[(int)(octa << 10 >>> 59)];
            result$2[di + 3] = this.alphabetChars()[(int)(octa << 15 >>> 59)];
            result$2[di + 4] = this.alphabetChars()[(int)(octa << 20 >>> 59)];
            result$2[di + 5] = this.alphabetChars()[(int)(octa << 25 >>> 59)];
            result$2[di + 6] = this.alphabetChars()[(int)(octa << 30 >>> 59)];
            result$2[di + 7] = this.alphabetChars()[(int)(octa << 35 >>> 59)];
            long l = bitsRemaining - 40L;
            int n = si + 5;
            int n2 = di + 8;
            bitsRemaining = l;
            si = n;
            di = n2;
        }
        if (bitsRemaining > 0L) {
            return this.encodeRest$1(sl$4, bytes$2, baa$2, result$2, bitsRemaining, si, di);
        }
        return result$2;
    }

    private final Nothing$ failBitCountMismatch$2(int sl$5, long bitCount$2) {
        throw new IllegalArgumentException(new StringBuilder(71).append("BitCount mismatch: Given chat array with length ").append(sl$5).append(" doesn't contain ").append(bitCount$2).append(" bits.").toString());
    }

    private final Nothing$ fail$1(char[] chars$2, char c$1, int ix$1) {
        throw new IllegalArgumentException(new StringBuilder(71).append("\"").append(Util$.MODULE$.show(chars$2)).append("\" is not a valid ").append(this.name()).append(" encoding. '").append(c$1).append("' at index ").append(ix$1).append(" is not part of the ").append(this.name()).append(" alphabet.").toString());
    }

    private final long decode$1(char[] chars$1, int ix) {
        char c = chars$1[ix];
        if (c > '\u007f') {
            throw this.fail$1(chars$1, c, ix);
        }
        byte b = this.lookup()[c];
        if (b < 0) {
            throw this.fail$1(chars$1, c, ix);
        }
        return b;
    }

    private final byte[] decodeRest$1(int dlen$1, byte[] result$3, ByteArrayAccess baa$3, char[] chars$3, long bitsRemaining, int si, int di) {
        long fullBytes = this.decode$1(chars$3, si) << 59;
        if (bitsRemaining > 5L) {
            fullBytes |= this.decode$1(chars$3, si + 1) << 54;
        }
        if (bitsRemaining > 10L) {
            fullBytes |= this.decode$1(chars$3, si + 2) << 49;
        }
        if (bitsRemaining > 15L) {
            fullBytes |= this.decode$1(chars$3, si + 3) << 44;
        }
        if (bitsRemaining > 20L) {
            fullBytes |= this.decode$1(chars$3, si + 4) << 39;
        }
        if (bitsRemaining > 25L) {
            fullBytes |= this.decode$1(chars$3, si + 5) << 34;
        }
        if (bitsRemaining > 30L) {
            fullBytes |= this.decode$1(chars$3, si + 6) << 29;
        }
        if (bitsRemaining > 35L) {
            fullBytes |= this.decode$1(chars$3, si + 7) << 24;
        }
        long bits = fullBytes & (-1L >>> (int)bitsRemaining ^ 0xFFFFFFFFFFFFFFFFL);
        int n = dlen$1 - di;
        switch (n) {
            case 1: {
                result$3[di] = (byte)(bits >>> 56);
                break;
            }
            case 2: {
                baa$3.setDoubleByteBigEndian(result$3, di, (char)(bits >>> 48));
                break;
            }
            case 3: {
                baa$3.setDoubleByteBigEndian(result$3, di, (char)(bits >>> 48));
                result$3[di + 2] = (byte)(bits >>> 40);
                break;
            }
            case 4: {
                baa$3.setQuadByteBigEndian(result$3, di, (int)(bits >>> 32));
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
        }
        return result$3;
    }

    private final byte[] decode8$1(ByteArrayAccess baa$4, byte[] result$4, char[] chars$4, int dlen$2, long bitsRemaining, int si, int di) {
        while (bitsRemaining >= 40L) {
            long l = this.decode$1(chars$4, si + 0) << 35 | this.decode$1(chars$4, si + 1) << 30 | this.decode$1(chars$4, si + 2) << 25 | this.decode$1(chars$4, si + 3) << 20 | this.decode$1(chars$4, si + 4) << 15 | this.decode$1(chars$4, si + 5) << 10 | this.decode$1(chars$4, si + 6) << 5 | this.decode$1(chars$4, si + 7);
            baa$4.setQuadByteBigEndian(result$4, di, (int)(l >>> 8));
            result$4[di + 4] = (byte)l;
            long l2 = bitsRemaining - 40L;
            int n = si + 8;
            int n2 = di + 5;
            bitsRemaining = l2;
            si = n;
            di = n2;
        }
        if (bitsRemaining > 0L) {
            return this.decodeRest$1(dlen$2, result$4, baa$4, chars$4, bitsRemaining, si, di);
        }
        return result$4;
    }
}

