/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.encodings;

import io.bullet.borer.encodings.LookupBaseEncoding;
import io.bullet.borer.encodings.Util$;
import io.bullet.borer.internal.ByteArrayAccess;
import io.bullet.borer.internal.ByteArrayAccess$;
import scala.Array$;
import scala.MatchError;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class Base64
extends LookupBaseEncoding {
    private final String name;

    public Base64(String name, String alphabet) {
        this.name = name;
        super(name, 6, alphabet);
        if (this.alphabetChars().length != 64) {
            throw new IllegalArgumentException();
        }
    }

    private String alphabet$accessor() {
        return super.alphabet();
    }

    @Override
    public char[] encode(byte[] bytes) {
        int sl = bytes.length;
        if (sl > 0x5FFFFFFF) {
            throw this.failOverflow$1(sl);
        }
        char[] result = new char[(sl + 2) / 3 << 2];
        ByteArrayAccess baa = ByteArrayAccess$.MODULE$.instance();
        int sl3 = sl - 3;
        return this.encode3$1(sl3, baa, bytes, result, sl, 0, 0);
    }

    @Override
    public byte[] decode(char[] chars) {
        int sl = chars.length;
        if (sl > 0) {
            if ((sl & 3) != 0) {
                throw Base64.failIllegalLength$1(sl);
            }
            ByteArrayAccess baa = ByteArrayAccess$.MODULE$.instance();
            int sl4 = sl - 4;
            int x = sl >> 2;
            int baseLen = (x << 1) + x;
            long c1 = (long)chars[sl - 1] & 0xFFL;
            if (c1 == 61L) {
                int oddBytes = ((long)chars[sl - 2] & 0xFFL) == 61L ? 1 : 2;
                byte[] result = new byte[baseLen - 3 + oddBytes];
                return this.rec$1(sl4, result, baa, chars, oddBytes, 0, 0);
            }
            byte[] result = new byte[baseLen];
            return this.rec$2(sl, result, baa, chars, 0, 0);
        }
        return Array$.MODULE$.emptyByteArray();
    }

    private final Nothing$ failOverflow$1(int sl$1) {
        throw new IllegalArgumentException(new StringBuilder(70).append("Overflow: Cannot ").append(this.name).append("-encode a byte array with size > 1.610.612.735 (was: ").append(sl$1).toString());
    }

    private final char[] encodeRest$1(int sl$2, byte[] bytes$1, char[] result$1, ByteArrayAccess baa$1, int si, int di) {
        int n = sl$2 - si;
        if (1 == n) {
            int n2 = bytes$1[si] << 24;
            result$1[di + 0] = this.alphabetChars()[n2 << 0 >>> 26];
            result$1[di + 1] = this.alphabetChars()[n2 << 6 >>> 26];
            result$1[di + 2] = 61;
            result$1[di + 3] = 61;
        } else if (2 == n) {
            int n3 = baa$1.doubleByteBigEndian(bytes$1, si) << 16;
            result$1[di + 0] = this.alphabetChars()[n3 << 0 >>> 26];
            result$1[di + 1] = this.alphabetChars()[n3 << 6 >>> 26];
            result$1[di + 2] = this.alphabetChars()[n3 << 12 >>> 26];
            result$1[di + 3] = 61;
        } else {
            throw new MatchError(BoxesRunTime.boxToInteger(n));
        }
        return result$1;
    }

    private final char[] encode3$1(int sl3$1, ByteArrayAccess baa$2, byte[] bytes$2, char[] result$2, int sl$3, int si, int di) {
        while (si <= sl3$1) {
            int quad = baa$2.doubleByteBigEndian(bytes$2, si) << 16 | (bytes$2[si + 2] & 0xFF) << 8;
            result$2[di + 0] = this.alphabetChars()[quad << 0 >>> 26];
            result$2[di + 1] = this.alphabetChars()[quad << 6 >>> 26];
            result$2[di + 2] = this.alphabetChars()[quad << 12 >>> 26];
            result$2[di + 3] = this.alphabetChars()[quad << 18 >>> 26];
            int n = si + 3;
            int n2 = di + 4;
            si = n;
            di = n2;
        }
        if (si < sl$3) {
            return this.encodeRest$1(sl$3, bytes$2, result$2, baa$2, si, di);
        }
        return result$2;
    }

    private static final Nothing$ failIllegalLength$1(int sl$4) {
        throw new IllegalArgumentException(new StringBuilder(89).append("Illegal Encoding: The given char array has a length that is not evenly divisible by 4 (").append(sl$4).append(").").toString());
    }

    private final Nothing$ failIllegalPadding$1() {
        throw new IllegalArgumentException(new StringBuilder(84).append("Illegal Padding: The given encoding has a padding that doesn't conform to the ").append(this.name).append(" spec.").toString());
    }

    private final Nothing$ fail$1(char[] chars$2, char c$1, int ix$1) {
        throw new IllegalArgumentException(new StringBuilder(71).append("\"").append(Util$.MODULE$.show(chars$2)).append("\" is not a valid ").append(this.name).append(" encoding. '").append(c$1).append("' at index ").append(ix$1).append(" is not part of the ").append(this.name).append(" alphabet.").toString());
    }

    private final long decode$1(char[] chars$1, int ix) {
        char c = chars$1[ix];
        if (c > '\u007f') {
            throw this.fail$1(chars$1, c, ix);
        }
        byte b = this.lookup()[c];
        if (b < 0) {
            throw this.fail$1(chars$1, c, ix);
        }
        return b;
    }

    private final void decode4$1(ByteArrayAccess baa$3, char[] chars$3, byte[] result, int si, int di) {
        long quad = this.decode$1(chars$3, si + 0) << 18 | this.decode$1(chars$3, si + 1) << 12 | this.decode$1(chars$3, si + 2) << 6 | this.decode$1(chars$3, si + 3);
        baa$3.setDoubleByteBigEndian(result, di, (char)(quad >> 8));
        result[di + 2] = (byte)quad;
    }

    private final byte[] decodeRest$1(int oddBytes$1, byte[] result$3, ByteArrayAccess baa$4, char[] chars$4, int si, int di) {
        int n = oddBytes$1;
        if (1 == n) {
            result$3[di] = (byte)(this.decode$1(chars$4, si + 0) << 2 | this.decode$1(chars$4, si + 1) >> 4);
        } else if (2 == n) {
            baa$4.setDoubleByteBigEndian(result$3, di, (char)(this.decode$1(chars$4, si + 0) << 10 | this.decode$1(chars$4, si + 1) << 4 | this.decode$1(chars$4, si + 2) >> 2));
        } else {
            throw this.failIllegalPadding$1();
        }
        return result$3;
    }

    private final byte[] rec$1(int sl4$1, byte[] result$4, ByteArrayAccess baa$5, char[] chars$5, int oddBytes$2, int si, int di) {
        while (si < sl4$1) {
            this.decode4$1(baa$5, chars$5, result$4, si, di);
            int n = si + 4;
            int n2 = di + 3;
            si = n;
            di = n2;
        }
        return this.decodeRest$1(oddBytes$2, result$4, baa$5, chars$5, si, di);
    }

    private final byte[] rec$2(int sl$5, byte[] result$5, ByteArrayAccess baa$6, char[] chars$6, int si, int di) {
        while (si < sl$5) {
            this.decode4$1(baa$6, chars$6, result$5, si, di);
            int n = si + 4;
            int n2 = di + 3;
            si = n;
            di = n2;
        }
        return result$5;
    }
}

