/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.encodings;

import io.bullet.borer.encodings.LookupBaseEncoding;
import io.bullet.borer.encodings.Util$;
import io.bullet.borer.internal.ByteArrayAccess;
import io.bullet.borer.internal.ByteArrayAccess$;
import scala.Array$;
import scala.MatchError;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class Base32
extends LookupBaseEncoding {
    private final String name;

    public Base32(String name, String alphabet) {
        this.name = name;
        super(name, 5, alphabet);
        if (this.alphabetChars().length != 32) {
            throw new IllegalArgumentException();
        }
    }

    private String alphabet$accessor() {
        return super.alphabet();
    }

    @Override
    public char[] encode(byte[] bytes) {
        int sl = bytes.length;
        if (sl > 0x4FFFFFFF) {
            throw this.failOverflow$1(sl);
        }
        char[] result = new char[(sl + 4) / 5 << 3];
        ByteArrayAccess baa = ByteArrayAccess$.MODULE$.instance();
        int sl5 = sl - 5;
        return this.encode5$1(sl5, baa, bytes, result, sl, 0, 0);
    }

    @Override
    public byte[] decode(char[] chars) {
        int sl = chars.length;
        if (sl > 0) {
            if ((sl & 7) != 0) {
                throw Base32.failIllegalLength$1(sl);
            }
            ByteArrayAccess baa = ByteArrayAccess$.MODULE$.instance();
            int sl8 = sl - 8;
            int x = sl >> 3;
            int baseLen = (x << 2) + x;
            long c1 = (long)chars[sl - 1] & 0xFFL;
            if (c1 == 61L) {
                long final6 = ((long)chars[sl - 6] & 0xFFL) << 40 | ((long)chars[sl - 5] & 0xFFL) << 32 | ((long)chars[sl - 4] & 0xFFL) << 24 | ((long)chars[sl - 3] & 0xFFL) << 16 | ((long)chars[sl - 2] & 0xFFL) << 8 | c1;
                int ntz = Long.numberOfTrailingZeros(final6 ^ 0x3D3D3D3D3D3D3D3DL);
                int oddBytes = (int)(281483616977920L >> (ntz & 0xF8)) & 0xF;
                byte[] result = new byte[baseLen - 5 + oddBytes];
                return this.rec$1(sl8, result, baa, chars, oddBytes, 0, 0);
            }
            byte[] result = new byte[baseLen];
            return this.rec$2(sl, result, baa, chars, 0, 0);
        }
        return Array$.MODULE$.emptyByteArray();
    }

    private final Nothing$ failOverflow$1(int sl$1) {
        throw new IllegalArgumentException(new StringBuilder(70).append("Overflow: Cannot ").append(this.name).append("-encode a byte array with size > 1.342.177.279 (was: ").append(sl$1).toString());
    }

    private final char[] encodeRest$1(int sl$2, byte[] bytes$1, char[] result$1, ByteArrayAccess baa$1, int si, int di) {
        int n = sl$2 - si;
        switch (n) {
            case 1: {
                int n2 = bytes$1[si] << 24;
                result$1[di + 0] = this.alphabetChars()[n2 << 0 >>> 27];
                result$1[di + 1] = this.alphabetChars()[n2 << 5 >>> 27];
                result$1[di + 2] = 61;
                result$1[di + 3] = 61;
                result$1[di + 4] = 61;
                result$1[di + 5] = 61;
                result$1[di + 6] = 61;
                result$1[di + 7] = 61;
                break;
            }
            case 2: {
                int n3 = baa$1.doubleByteBigEndian(bytes$1, si) << 16;
                result$1[di + 0] = this.alphabetChars()[n3 << 0 >>> 27];
                result$1[di + 1] = this.alphabetChars()[n3 << 5 >>> 27];
                result$1[di + 2] = this.alphabetChars()[n3 << 10 >>> 27];
                result$1[di + 3] = this.alphabetChars()[n3 << 15 >>> 27];
                result$1[di + 4] = 61;
                result$1[di + 5] = 61;
                result$1[di + 6] = 61;
                result$1[di + 7] = 61;
                break;
            }
            case 3: {
                int n4 = baa$1.doubleByteBigEndian(bytes$1, si) << 16 | (bytes$1[si + 2] & 0xFF) << 8;
                result$1[di + 0] = this.alphabetChars()[n4 << 0 >>> 27];
                result$1[di + 1] = this.alphabetChars()[n4 << 5 >>> 27];
                result$1[di + 2] = this.alphabetChars()[n4 << 10 >>> 27];
                result$1[di + 3] = this.alphabetChars()[n4 << 15 >>> 27];
                result$1[di + 4] = this.alphabetChars()[n4 << 20 >>> 27];
                result$1[di + 5] = 61;
                result$1[di + 6] = 61;
                result$1[di + 7] = 61;
                break;
            }
            case 4: {
                long octa = (long)baa$1.quadByteBigEndian(bytes$1, si) << 32;
                result$1[di + 0] = this.alphabetChars()[(int)(octa << 0 >>> 59)];
                result$1[di + 1] = this.alphabetChars()[(int)(octa << 5 >>> 59)];
                result$1[di + 2] = this.alphabetChars()[(int)(octa << 10 >>> 59)];
                result$1[di + 3] = this.alphabetChars()[(int)(octa << 15 >>> 59)];
                result$1[di + 4] = this.alphabetChars()[(int)(octa << 20 >>> 59)];
                result$1[di + 5] = this.alphabetChars()[(int)(octa << 25 >>> 59)];
                result$1[di + 6] = this.alphabetChars()[(int)(octa << 30 >>> 59)];
                result$1[di + 7] = 61;
                break;
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
        }
        return result$1;
    }

    private final char[] encode5$1(int sl5$1, ByteArrayAccess baa$2, byte[] bytes$2, char[] result$2, int sl$3, int si, int di) {
        while (si <= sl5$1) {
            long octa = (long)baa$2.quadByteBigEndian(bytes$2, si) << 32 | ((long)bytes$2[si + 4] & 0xFFL) << 24;
            result$2[di + 0] = this.alphabetChars()[(int)(octa << 0 >>> 59)];
            result$2[di + 1] = this.alphabetChars()[(int)(octa << 5 >>> 59)];
            result$2[di + 2] = this.alphabetChars()[(int)(octa << 10 >>> 59)];
            result$2[di + 3] = this.alphabetChars()[(int)(octa << 15 >>> 59)];
            result$2[di + 4] = this.alphabetChars()[(int)(octa << 20 >>> 59)];
            result$2[di + 5] = this.alphabetChars()[(int)(octa << 25 >>> 59)];
            result$2[di + 6] = this.alphabetChars()[(int)(octa << 30 >>> 59)];
            result$2[di + 7] = this.alphabetChars()[(int)(octa << 35 >>> 59)];
            int n = si + 5;
            int n2 = di + 8;
            si = n;
            di = n2;
        }
        if (si < sl$3) {
            return this.encodeRest$1(sl$3, bytes$2, result$2, baa$2, si, di);
        }
        return result$2;
    }

    private static final Nothing$ failIllegalLength$1(int sl$4) {
        throw new IllegalArgumentException(new StringBuilder(89).append("Illegal Encoding: The given char array has a length that is not evenly divisible by 8 (").append(sl$4).append(").").toString());
    }

    private final Nothing$ failIllegalPadding$1() {
        throw new IllegalArgumentException(new StringBuilder(84).append("Illegal Padding: The given encoding has a padding that doesn't conform to the ").append(this.name).append(" spec.").toString());
    }

    private final Nothing$ fail$1(char[] chars$2, char c$1, int ix$1) {
        throw new IllegalArgumentException(new StringBuilder(71).append("\"").append(Util$.MODULE$.show(chars$2)).append("\" is not a valid ").append(this.name).append(" encoding. '").append(c$1).append("' at index ").append(ix$1).append(" is not part of the ").append(this.name).append(" alphabet.").toString());
    }

    private final long decode$1(char[] chars$1, int ix) {
        char c = chars$1[ix];
        if (c > '\u007f') {
            throw this.fail$1(chars$1, c, ix);
        }
        byte b = this.lookup()[c];
        if (b < 0) {
            throw this.fail$1(chars$1, c, ix);
        }
        return b;
    }

    private final void decode8$1(ByteArrayAccess baa$3, char[] chars$3, byte[] result, int si, int di) {
        long octa = this.decode$1(chars$3, si + 0) << 35 | this.decode$1(chars$3, si + 1) << 30 | this.decode$1(chars$3, si + 2) << 25 | this.decode$1(chars$3, si + 3) << 20 | this.decode$1(chars$3, si + 4) << 15 | this.decode$1(chars$3, si + 5) << 10 | this.decode$1(chars$3, si + 6) << 5 | this.decode$1(chars$3, si + 7);
        baa$3.setQuadByteBigEndian(result, di, (int)(octa >> 8));
        result[di + 4] = (byte)octa;
    }

    private final byte[] decodeRest$1(int oddBytes$1, byte[] result$3, ByteArrayAccess baa$4, char[] chars$4, int si, int di) {
        int n = oddBytes$1;
        switch (n) {
            case 1: {
                result$3[di] = (byte)(this.decode$1(chars$4, si + 0) << 3 | this.decode$1(chars$4, si + 1) >> 2);
                break;
            }
            case 2: {
                long bytes = this.decode$1(chars$4, si + 0) << 11 | this.decode$1(chars$4, si + 1) << 6 | this.decode$1(chars$4, si + 2) << 1 | this.decode$1(chars$4, si + 3) >> 4;
                baa$4.setDoubleByteBigEndian(result$3, di, (char)bytes);
                break;
            }
            case 3: {
                long bytes = this.decode$1(chars$4, si + 0) << 19 | this.decode$1(chars$4, si + 1) << 14 | this.decode$1(chars$4, si + 2) << 9 | this.decode$1(chars$4, si + 3) << 4 | this.decode$1(chars$4, si + 4) >> 1;
                baa$4.setDoubleByteBigEndian(result$3, di, (char)(bytes >> 8));
                result$3[di + 2] = (byte)bytes;
                break;
            }
            case 4: {
                long bytes = this.decode$1(chars$4, si + 0) << 27 | this.decode$1(chars$4, si + 1) << 22 | this.decode$1(chars$4, si + 2) << 17 | this.decode$1(chars$4, si + 3) << 12 | this.decode$1(chars$4, si + 4) << 7 | this.decode$1(chars$4, si + 5) << 2 | this.decode$1(chars$4, si + 6) >> 3;
                baa$4.setQuadByteBigEndian(result$3, di, (int)bytes);
                break;
            }
            default: {
                throw this.failIllegalPadding$1();
            }
        }
        return result$3;
    }

    private final byte[] rec$1(int sl8$1, byte[] result$4, ByteArrayAccess baa$5, char[] chars$5, int oddBytes$2, int si, int di) {
        while (si < sl8$1) {
            this.decode8$1(baa$5, chars$5, result$4, si, di);
            int n = si + 8;
            int n2 = di + 5;
            si = n;
            di = n2;
        }
        return this.decodeRest$1(oddBytes$2, result$4, baa$5, chars$5, si, di);
    }

    private final byte[] rec$2(int sl$5, byte[] result$5, ByteArrayAccess baa$6, char[] chars$6, int si, int di) {
        while (si < sl$5) {
            this.decode8$1(baa$6, chars$6, result$5, si, di);
            int n = si + 8;
            int n2 = di + 5;
            si = n;
            di = n2;
        }
        return result$5;
    }
}

