/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.compat;

import io.bullet.borer.ByteAccess;
import io.bullet.borer.Codec;
import io.bullet.borer.Input;
import io.bullet.borer.Output;
import io.bullet.borer.compat.pekko$;
import io.bullet.borer.compat.pekko$ByteStringByteAccess$;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import org.apache.pekko.util.ByteStringBuilder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class pekko {
    public static Codec<ByteString> ByteStringCodec() {
        return pekko$.MODULE$.ByteStringCodec();
    }

    public static Codec<ActorRef> actorRefCodec(ActorSystem actorSystem) {
        return pekko$.MODULE$.actorRefCodec(actorSystem);
    }

    public static <T> Codec<org.apache.pekko.actor.typed.ActorRef<T>> typedActorRefCodec(ActorSystem actorSystem) {
        return pekko$.MODULE$.typedActorRefCodec(actorSystem);
    }

    public static ActorSystem actorRefCodec$default$1() {
        return pekko$.MODULE$.actorRefCodec$default$1();
    }

    public static <T> ActorSystem typedActorRefCodec$default$1() {
        return pekko$.MODULE$.typedActorRefCodec$default$1();
    }

    public static final class ByteStringOutput
    implements Output {
        private final ByteStringBuilder builder = ByteString$.MODULE$.newBuilder();

        public int cursor() {
            return this.builder.length();
        }

        @Override
        public ByteStringOutput writeByte(byte by) {
            this.builder.$plus$eq(BoxesRunTime.boxToByte(by));
            return this;
        }

        @Override
        public ByteStringOutput writeBytes(byte a, byte b) {
            this.builder.$plus$eq(BoxesRunTime.boxToByte(a));
            this.builder.$plus$eq(BoxesRunTime.boxToByte(b));
            return this;
        }

        @Override
        public ByteStringOutput writeBytes(byte a, byte b, byte c) {
            this.builder.$plus$eq(BoxesRunTime.boxToByte(a));
            this.builder.$plus$eq(BoxesRunTime.boxToByte(b));
            this.builder.$plus$eq(BoxesRunTime.boxToByte(c));
            return this;
        }

        @Override
        public ByteStringOutput writeBytes(byte a, byte b, byte c, byte d) {
            this.builder.$plus$eq(BoxesRunTime.boxToByte(a));
            this.builder.$plus$eq(BoxesRunTime.boxToByte(b));
            this.builder.$plus$eq(BoxesRunTime.boxToByte(c));
            this.builder.$plus$eq(BoxesRunTime.boxToByte(d));
            return this;
        }

        @Override
        public <Bytes> ByteStringOutput writeBytes(Bytes bytes, ByteAccess<Bytes> evidence$1) {
            this.builder.$plus$plus$eq((ByteString)pekko$ByteStringByteAccess$.MODULE$.convert(bytes, evidence$1));
            return this;
        }

        @Override
        public ByteString result() {
            return this.builder.result();
        }
    }

    public static final class FromByteString
    implements Input<ByteString> {
        private final ByteString byteString;
        private int _cursor;

        public FromByteString(ByteString byteString) {
            this.byteString = byteString;
        }

        @Override
        public long cursor() {
            return this._cursor;
        }

        @Override
        public FromByteString unread(int numberOfBytes) {
            this._cursor -= numberOfBytes;
            return this;
        }

        @Override
        public byte readByte() {
            int c = this._cursor;
            this._cursor = c + 1;
            return this.byteString.apply(c);
        }

        @Override
        public byte readBytePadded(Input.PaddingProvider<ByteString> pp) {
            if (this._cursor < this.byteString.length()) {
                return this.readByte();
            }
            return pp.padByte();
        }

        @Override
        public char readDoubleByteBigEndian() {
            int c = this._cursor;
            this._cursor = c + 2;
            return (char)(this.byteString.apply(c) << 8 | this.byteString.apply(c + 1) & 0xFF);
        }

        @Override
        public char readDoubleByteBigEndianPadded(Input.PaddingProvider<ByteString> pp) {
            int remaining = this.byteString.length() - this._cursor;
            if (remaining >= 2) {
                return this.readDoubleByteBigEndian();
            }
            return pp.padDoubleByte(remaining);
        }

        @Override
        public int readQuadByteBigEndian() {
            int c = this._cursor;
            this._cursor = c + 4;
            return this.byteString.apply(c) << 24 | (this.byteString.apply(c + 1) & 0xFF) << 16 | (this.byteString.apply(c + 2) & 0xFF) << 8 | this.byteString.apply(c + 3) & 0xFF;
        }

        @Override
        public int readQuadByteBigEndianPadded(Input.PaddingProvider<ByteString> pp) {
            int remaining = this.byteString.length() - this._cursor;
            if (remaining >= 4) {
                return this.readQuadByteBigEndian();
            }
            return pp.padQuadByte(remaining);
        }

        @Override
        public long readOctaByteBigEndian() {
            int c = this._cursor;
            this._cursor = c + 8;
            return (long)this.byteString.apply(c) << 56 | ((long)this.byteString.apply(c + 1) & 0xFFL) << 48 | ((long)this.byteString.apply(c + 2) & 0xFFL) << 40 | ((long)this.byteString.apply(c + 3) & 0xFFL) << 32 | ((long)this.byteString.apply(c + 4) & 0xFFL) << 24 | ((long)this.byteString.apply(c + 5) & 0xFFL) << 16 | ((long)this.byteString.apply(c + 6) & 0xFFL) << 8 | (long)this.byteString.apply(c + 7) & 0xFFL;
        }

        @Override
        public long readOctaByteBigEndianPadded(Input.PaddingProvider<ByteString> pp) {
            int remaining = this.byteString.length() - this._cursor;
            if (remaining >= 8) {
                return this.readOctaByteBigEndian();
            }
            return pp.padOctaByte(remaining);
        }

        @Override
        public ByteString readBytes(long length, Input.PaddingProvider<ByteString> pp) {
            ByteString bytes;
            ByteString byteString;
            long remaining = this.byteString.length() - this._cursor;
            int len = (int)package$.MODULE$.min(remaining, length);
            if (len > 0) {
                int c = this._cursor;
                this._cursor = c + len;
                byteString = this.byteString.slice(c, this._cursor);
            } else {
                byteString = bytes = ByteString$.MODULE$.empty();
            }
            if (length <= remaining) {
                return bytes;
            }
            return pp.padBytes(bytes, length - remaining);
        }
    }
}

