/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.cbor;

import io.bullet.borer.Borer;
import io.bullet.borer.ByteAccess;
import io.bullet.borer.DataItem$;
import io.bullet.borer.Tag;
import io.bullet.borer.Tag$BigFloat$;
import io.bullet.borer.Tag$DateTimeString$;
import io.bullet.borer.Tag$DecimalFraction$;
import io.bullet.borer.Tag$EmbeddedCBOR$;
import io.bullet.borer.Tag$EpochDateTime$;
import io.bullet.borer.Tag$HintBase16$;
import io.bullet.borer.Tag$HintBase64$;
import io.bullet.borer.Tag$HintBase64url$;
import io.bullet.borer.Tag$MagicHeader$;
import io.bullet.borer.Tag$NegativeBigNum$;
import io.bullet.borer.Tag$Other$;
import io.bullet.borer.Tag$PositiveBigNum$;
import io.bullet.borer.Tag$TextBase64$;
import io.bullet.borer.Tag$TextBase64Url$;
import io.bullet.borer.Tag$TextMime$;
import io.bullet.borer.Tag$TextRegex$;
import io.bullet.borer.Tag$TextUri$;
import io.bullet.borer.cbor.CborValidation$;
import java.util.Arrays;
import scala.Function2;
import scala.MatchError;
import scala.Tuple3$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class CborValidation {
    public static <C extends Config> Function2<io.bullet.borer.Receiver, C, io.bullet.borer.Receiver> wrapper() {
        return CborValidation$.MODULE$.wrapper();
    }

    public static interface Config {
        public long maxArrayLength();

        public long maxMapLength();

        public int maxNestingLevels();
    }

    public static final class Receiver
    extends io.bullet.borer.Receiver {
        private final io.bullet.borer.Receiver target;
        private final Config config;
        private long[] levelRemaining;
        private int[] levelMasks;
        private int level;
        private int mask;

        public Receiver(io.bullet.borer.Receiver target, Config config) {
            this.target = target;
            this.config = config;
            int DEFAULT_MASK = 0xEFFFFF;
            int MAP = 0x40000000;
            int UNBOUNDED = Integer.MIN_VALUE;
            this.levelRemaining = new long[4];
            this.levelMasks = new int[4];
            this.level = -1;
            this.mask = 0xEFFFFF;
        }

        @Override
        public void onNull() {
            this.checkAllowed(1);
            this.count();
            this.target.onNull();
        }

        @Override
        public void onUndefined() {
            this.checkAllowed(2);
            this.count();
            this.target.onUndefined();
        }

        @Override
        public void onBoolean(boolean value) {
            this.checkAllowed(4);
            this.count();
            this.target.onBoolean(value);
        }

        @Override
        public void onInt(int value) {
            this.checkAllowed(8);
            this.count();
            this.target.onInt(value);
        }

        @Override
        public void onLong(long value) {
            this.checkAllowed(16);
            this.count();
            this.target.onLong(value);
        }

        @Override
        public void onOverLong(boolean negative, long value) {
            this.checkAllowed(32);
            this.count();
            this.target.onOverLong(negative, value);
        }

        @Override
        public void onFloat16(float value) {
            this.checkAllowed(64);
            this.count();
            this.target.onFloat16(value);
        }

        @Override
        public void onFloat(float value) {
            this.checkAllowed(128);
            this.count();
            this.target.onFloat(value);
        }

        @Override
        public void onDouble(double value) {
            this.checkAllowed(256);
            this.count();
            this.target.onDouble(value);
        }

        @Override
        public void onNumberString(String value) {
            this.checkAllowed(512);
            this.count();
            this.target.onNumberString(value);
        }

        @Override
        public <Bytes> void onBytes(Bytes value, ByteAccess<Bytes> evidence$1) {
            this.checkAllowed(16384);
            this.count();
            this.target.onBytes(value, evidence$1);
        }

        @Override
        public void onBytesStart() {
            this.checkAllowed(32768);
            this.enterLevel(0L, -2147434496);
            this.target.onBytesStart();
        }

        @Override
        public void onString(String value) {
            this.checkAllowed(1024);
            this.count();
            this.target.onString(value);
        }

        @Override
        public void onChars(char[] buffer, int length) {
            this.checkAllowed(2048);
            this.count();
            this.target.onChars(buffer, length);
        }

        @Override
        public <Bytes> void onText(Bytes value, ByteAccess<Bytes> evidence$1) {
            this.checkAllowed(4096);
            this.count();
            this.target.onText(value, evidence$1);
        }

        @Override
        public void onTextStart() {
            this.checkAllowed(8192);
            this.enterLevel(0L, -2147468288);
            this.target.onTextStart();
        }

        @Override
        public void onArrayHeader(long length) {
            this.checkAllowed(65536);
            if (length <= this.config.maxArrayLength()) {
                if (length > 0L) {
                    this.enterLevel(length, 0xEFFFFF);
                } else {
                    this.count();
                }
                this.target.onArrayHeader(length);
                return;
            }
            String msg = new StringBuilder(56).append("Array length ").append(length).append(" is greater than the configured maximum of ").append(this.config.maxArrayLength()).toString();
            throw new Borer.Error.Unsupported<Object>(null, msg);
        }

        @Override
        public void onArrayStart() {
            this.checkAllowed(131072);
            this.enterLevel(0L, -2131755009);
            this.target.onArrayStart();
        }

        @Override
        public void onMapHeader(long length) {
            this.checkAllowed(262144);
            if (length <= this.config.maxMapLength()) {
                if (length > 0L) {
                    this.enterLevel(length << 1, 1089470463);
                } else {
                    this.count();
                }
                this.target.onMapHeader(length);
                return;
            }
            String msg = new StringBuilder(54).append("Map length ").append(length).append(" is greater than the configured maximum of ").append(this.config.maxMapLength()).toString();
            throw new Borer.Error.Unsupported<Object>(null, msg);
        }

        @Override
        public void onMapStart() {
            this.checkAllowed(524288);
            this.enterLevel(0L, -1058013185);
            this.target.onMapStart();
        }

        @Override
        public void onBreak() {
            if (this.level >= 0 && (this.inline$mask() & Integer.MIN_VALUE) != 0 && (!((this.inline$mask() & 0x40000000) != 0) || (this.inline$levelRemaining()[this.inline$level()] & 1L) == 0L)) {
                this.exitLevel();
                this.count();
                this.target.onBreak();
                return;
            }
            throw this.failBreak$1();
        }

        @Override
        public void onTag(Tag value) {
            Tag tag = value;
            if (Tag$EpochDateTime$.MODULE$.equals(tag)) {
                this.checkAllowed(0x200000);
                this.enterLevel(1L, 984);
            } else if (Tag$PositiveBigNum$.MODULE$.equals(tag) || Tag$NegativeBigNum$.MODULE$.equals(tag)) {
                this.checkAllowed(0x200000);
                this.enterLevel(1L, 49152);
            } else if (Tag$EmbeddedCBOR$.MODULE$.equals(tag)) {
                this.checkAllowed(0x200000);
                this.enterLevel(1L, 49152);
            } else if (Tag$DateTimeString$.MODULE$.equals(tag) || Tag$TextUri$.MODULE$.equals(tag) || Tag$TextBase64Url$.MODULE$.equals(tag) || Tag$TextBase64$.MODULE$.equals(tag) || Tag$TextRegex$.MODULE$.equals(tag) || Tag$TextMime$.MODULE$.equals(tag)) {
                this.checkAllowed(0x200000);
                this.enterLevel(1L, 7168);
            } else if (Tag$DecimalFraction$.MODULE$.equals(tag) || Tag$BigFloat$.MODULE$.equals(tag)) {
                this.checkAllowed(0x200000);
                this.enterLevel(1L, 65536);
            } else {
                if (!(Tag$HintBase64url$.MODULE$.equals(tag) || Tag$HintBase64$.MODULE$.equals(tag) || Tag$HintBase16$.MODULE$.equals(tag) || Tag$MagicHeader$.MODULE$.equals(tag))) {
                    if (!(tag instanceof Tag.Other)) {
                        throw new MatchError(tag);
                    }
                    Tag.Other other = Tag$Other$.MODULE$.unapply((Tag.Other)tag);
                    long l = other._1();
                }
                this.checkAllowed(0x200000);
            }
            this.target.onTag(value);
        }

        @Override
        public void onSimpleValue(int value) {
            this.checkAllowed(0x400000);
            this.count();
            this.target.onSimpleValue(value);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void onEndOfInput() {
            block4: {
                block7: {
                    block8: {
                        block9: {
                            block5: {
                                block6: {
                                    if (this.level < 0) break block4;
                                    var2_1 = Tuple3$.MODULE$.apply(BoxesRunTime.boxToBoolean((this.inline$mask() & 0x40000000) != 0), BoxesRunTime.boxToBoolean((this.inline$mask() & -2147483648) != 0), BoxesRunTime.boxToBoolean((this.inline$levelRemaining()[this.inline$level()] & 1L) == 0L));
                                    if (var2_1 == null) ** GOTO lbl-1000
                                    var3_2 = BoxesRunTime.unboxToBoolean(var2_1._1());
                                    var4_3 = BoxesRunTime.unboxToBoolean(var2_1._2());
                                    var5_4 = BoxesRunTime.unboxToBoolean(var2_1._3());
                                    if (var3_2) break block5;
                                    if (var4_3) break block6;
                                    v0 = new StringBuilder(41).append(this.remaining$3()).append(" more data items of definite-length array").toString();
                                    break block7;
                                }
                                if (!var4_3) break block5;
                                v0 = "next array data item or BREAK";
                                break block7;
                            }
                            if (!var3_2) ** GOTO lbl-1000
                            if (var4_3) break block8;
                            if (var5_4) break block9;
                            v0 = new StringBuilder(60).append("next map data value and ").append(this.remaining$3() / 2L).append(" more entries of definite-length map").toString();
                            break block7;
                        }
                        if (!var5_4) break block8;
                        v0 = new StringBuilder(39).append(this.remaining$3()).append(" more data items of definite-length map").toString();
                        break block7;
                    }
                    if (!var4_3) ** GOTO lbl-1000
                    if (!var5_4) {
                        v0 = "next map data value";
                    } else if (var5_4) {
                        v0 = "next map entry or BREAK";
                    } else lbl-1000:
                    // 4 sources

                    {
                        throw new MatchError(var2_1);
                    }
                }
                msg = v0;
                throw new Borer.Error.UnexpectedEndOfInput<Object>(null, msg);
            }
            this.target.onEndOfInput();
        }

        private void checkAllowed(int dataItem) {
            if (!((this.inline$mask() & dataItem) != 0)) {
                throw new Borer.Error.InvalidInputData<Object>(null, DataItem$.MODULE$.stringify(this.mask), DataItem$.MODULE$.stringify(dataItem));
            }
        }

        private void count() {
            int l;
            while ((l = this.level) >= 0) {
                long remaining = this.levelRemaining[l] - 1L;
                if ((this.inline$mask() & Integer.MIN_VALUE) != 0) {
                    if ((this.inline$mask() & 0x40000000) != 0) {
                        if (remaining < -this.config.maxMapLength()) {
                            throw this.overflow$1(remaining, "map", this.config.maxMapLength());
                        }
                        this.ok$1(l, remaining);
                        return;
                    }
                    if (remaining < -this.config.maxArrayLength()) {
                        throw this.overflow$1(remaining, "array", this.config.maxArrayLength());
                    }
                    this.ok$1(l, remaining);
                    return;
                }
                if (remaining == 0L) {
                    this.exitLevel();
                    continue;
                }
                this.ok$1(l, remaining);
                return;
            }
        }

        private void enterLevel(long remaining, int mask) {
            int l = this.level + 1;
            if (l <= this.config.maxNestingLevels()) {
                if (l == this.levelMasks.length) {
                    int l2 = l << 1;
                    int newLen = l2 >= 0 ? l2 : Integer.MAX_VALUE;
                    this.levelRemaining = Arrays.copyOf(this.levelRemaining, newLen);
                    this.levelMasks = Arrays.copyOf(this.levelMasks, newLen);
                }
                this.level = l;
                this.levelRemaining[l] = remaining;
                this.levelMasks[l] = mask;
                this.mask = mask;
                return;
            }
            throw new Borer.Error.Overflow<Object>(null, new StringBuilder(42).append("Exceeded ").append(this.config.maxNestingLevels()).append(" maximum array/map nesting levels").toString());
        }

        private void exitLevel() {
            int l;
            this.level = l = this.level - 1;
            this.mask = l >= 0 ? this.levelMasks[l] : 0xEFFFFF;
        }

        private Nothing$ failInvalid(String expected, String actual) {
            throw new Borer.Error.InvalidInputData<Object>(null, expected, actual);
        }

        public final int inline$mask() {
            return this.mask;
        }

        public final long[] inline$levelRemaining() {
            return this.levelRemaining;
        }

        public final int inline$level() {
            return this.level;
        }

        private final Nothing$ failBreak$1() {
            if (this.level == 0) {
                if ((this.inline$mask() & Integer.MIN_VALUE) != 0) {
                    return this.failInvalid("map entry value data item", "BREAK");
                }
                String tpe = (this.inline$mask() & 0x40000000) != 0 ? "map" : "array";
                return this.failInvalid(new StringBuilder(36).append(this.levelRemaining[this.level]).append(" more data items of definite-length ").append(tpe).toString(), "BREAK");
            }
            return this.failInvalid("next data item on outermost CBOR structure level", "BREAK");
        }

        private final long remaining$3() {
            return this.levelRemaining[this.level];
        }

        private final void ok$1(int l$1, long remaining$1) {
            this.levelRemaining[l$1] = remaining$1;
        }

        private final Nothing$ overflow$1(long remaining$2, String tpe, long max2) {
            String msg = new StringBuilder(61).append("Unbounded ").append(tpe).append(" length ").append(-remaining$2).append(" is greater than the configured maximum of ").append(max2).toString();
            throw new Borer.Error.Overflow<Object>(null, msg);
        }
    }
}

