/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.cbor;

import io.bullet.borer.Borer;
import io.bullet.borer.ByteAccess;
import io.bullet.borer.ByteAccess$ForByteArray$;
import io.bullet.borer.Float16$;
import io.bullet.borer.Output;
import io.bullet.borer.SimpleValue$;
import io.bullet.borer.Tag;
import io.bullet.borer.Utf8$;
import io.bullet.borer.cbor.CborRenderer$;
import io.bullet.borer.internal.Renderer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import scala.Function1;
import scala.Tuple2;

public final class CborRenderer
extends Renderer {
    private Output out;

    public static CborRenderer apply(Output output, Borer.EncodingConfig encodingConfig) {
        return CborRenderer$.MODULE$.apply(output, encodingConfig);
    }

    public static double apply$mcDDD$sp(double d, double d2) {
        return CborRenderer$.MODULE$.apply$mcDDD$sp(d, d2);
    }

    public static double apply$mcDDI$sp(double d, int n) {
        return CborRenderer$.MODULE$.apply$mcDDI$sp(d, n);
    }

    public static double apply$mcDDJ$sp(double d, long l) {
        return CborRenderer$.MODULE$.apply$mcDDJ$sp(d, l);
    }

    public static double apply$mcDID$sp(int n, double d) {
        return CborRenderer$.MODULE$.apply$mcDID$sp(n, d);
    }

    public static double apply$mcDII$sp(int n, int n2) {
        return CborRenderer$.MODULE$.apply$mcDII$sp(n, n2);
    }

    public static double apply$mcDIJ$sp(int n, long l) {
        return CborRenderer$.MODULE$.apply$mcDIJ$sp(n, l);
    }

    public static double apply$mcDJD$sp(long l, double d) {
        return CborRenderer$.MODULE$.apply$mcDJD$sp(l, d);
    }

    public static double apply$mcDJI$sp(long l, int n) {
        return CborRenderer$.MODULE$.apply$mcDJI$sp(l, n);
    }

    public static double apply$mcDJJ$sp(long l, long l2) {
        return CborRenderer$.MODULE$.apply$mcDJJ$sp(l, l2);
    }

    public static float apply$mcFDD$sp(double d, double d2) {
        return CborRenderer$.MODULE$.apply$mcFDD$sp(d, d2);
    }

    public static float apply$mcFDI$sp(double d, int n) {
        return CborRenderer$.MODULE$.apply$mcFDI$sp(d, n);
    }

    public static float apply$mcFDJ$sp(double d, long l) {
        return CborRenderer$.MODULE$.apply$mcFDJ$sp(d, l);
    }

    public static float apply$mcFID$sp(int n, double d) {
        return CborRenderer$.MODULE$.apply$mcFID$sp(n, d);
    }

    public static float apply$mcFII$sp(int n, int n2) {
        return CborRenderer$.MODULE$.apply$mcFII$sp(n, n2);
    }

    public static float apply$mcFIJ$sp(int n, long l) {
        return CborRenderer$.MODULE$.apply$mcFIJ$sp(n, l);
    }

    public static float apply$mcFJD$sp(long l, double d) {
        return CborRenderer$.MODULE$.apply$mcFJD$sp(l, d);
    }

    public static float apply$mcFJI$sp(long l, int n) {
        return CborRenderer$.MODULE$.apply$mcFJI$sp(l, n);
    }

    public static float apply$mcFJJ$sp(long l, long l2) {
        return CborRenderer$.MODULE$.apply$mcFJJ$sp(l, l2);
    }

    public static int apply$mcIDD$sp(double d, double d2) {
        return CborRenderer$.MODULE$.apply$mcIDD$sp(d, d2);
    }

    public static int apply$mcIDI$sp(double d, int n) {
        return CborRenderer$.MODULE$.apply$mcIDI$sp(d, n);
    }

    public static int apply$mcIDJ$sp(double d, long l) {
        return CborRenderer$.MODULE$.apply$mcIDJ$sp(d, l);
    }

    public static int apply$mcIID$sp(int n, double d) {
        return CborRenderer$.MODULE$.apply$mcIID$sp(n, d);
    }

    public static int apply$mcIII$sp(int n, int n2) {
        return CborRenderer$.MODULE$.apply$mcIII$sp(n, n2);
    }

    public static int apply$mcIIJ$sp(int n, long l) {
        return CborRenderer$.MODULE$.apply$mcIIJ$sp(n, l);
    }

    public static int apply$mcIJD$sp(long l, double d) {
        return CborRenderer$.MODULE$.apply$mcIJD$sp(l, d);
    }

    public static int apply$mcIJI$sp(long l, int n) {
        return CborRenderer$.MODULE$.apply$mcIJI$sp(l, n);
    }

    public static int apply$mcIJJ$sp(long l, long l2) {
        return CborRenderer$.MODULE$.apply$mcIJJ$sp(l, l2);
    }

    public static long apply$mcJDD$sp(double d, double d2) {
        return CborRenderer$.MODULE$.apply$mcJDD$sp(d, d2);
    }

    public static long apply$mcJDI$sp(double d, int n) {
        return CborRenderer$.MODULE$.apply$mcJDI$sp(d, n);
    }

    public static long apply$mcJDJ$sp(double d, long l) {
        return CborRenderer$.MODULE$.apply$mcJDJ$sp(d, l);
    }

    public static long apply$mcJID$sp(int n, double d) {
        return CborRenderer$.MODULE$.apply$mcJID$sp(n, d);
    }

    public static long apply$mcJII$sp(int n, int n2) {
        return CborRenderer$.MODULE$.apply$mcJII$sp(n, n2);
    }

    public static long apply$mcJIJ$sp(int n, long l) {
        return CborRenderer$.MODULE$.apply$mcJIJ$sp(n, l);
    }

    public static long apply$mcJJD$sp(long l, double d) {
        return CborRenderer$.MODULE$.apply$mcJJD$sp(l, d);
    }

    public static long apply$mcJJI$sp(long l, int n) {
        return CborRenderer$.MODULE$.apply$mcJJI$sp(l, n);
    }

    public static long apply$mcJJJ$sp(long l, long l2) {
        return CborRenderer$.MODULE$.apply$mcJJJ$sp(l, l2);
    }

    public static void apply$mcVDD$sp(double d, double d2) {
        CborRenderer$.MODULE$.apply$mcVDD$sp(d, d2);
    }

    public static void apply$mcVDI$sp(double d, int n) {
        CborRenderer$.MODULE$.apply$mcVDI$sp(d, n);
    }

    public static void apply$mcVDJ$sp(double d, long l) {
        CborRenderer$.MODULE$.apply$mcVDJ$sp(d, l);
    }

    public static void apply$mcVID$sp(int n, double d) {
        CborRenderer$.MODULE$.apply$mcVID$sp(n, d);
    }

    public static void apply$mcVII$sp(int n, int n2) {
        CborRenderer$.MODULE$.apply$mcVII$sp(n, n2);
    }

    public static void apply$mcVIJ$sp(int n, long l) {
        CborRenderer$.MODULE$.apply$mcVIJ$sp(n, l);
    }

    public static void apply$mcVJD$sp(long l, double d) {
        CborRenderer$.MODULE$.apply$mcVJD$sp(l, d);
    }

    public static void apply$mcVJI$sp(long l, int n) {
        CborRenderer$.MODULE$.apply$mcVJI$sp(l, n);
    }

    public static void apply$mcVJJ$sp(long l, long l2) {
        CborRenderer$.MODULE$.apply$mcVJJ$sp(l, l2);
    }

    public static boolean apply$mcZDD$sp(double d, double d2) {
        return CborRenderer$.MODULE$.apply$mcZDD$sp(d, d2);
    }

    public static boolean apply$mcZDI$sp(double d, int n) {
        return CborRenderer$.MODULE$.apply$mcZDI$sp(d, n);
    }

    public static boolean apply$mcZDJ$sp(double d, long l) {
        return CborRenderer$.MODULE$.apply$mcZDJ$sp(d, l);
    }

    public static boolean apply$mcZID$sp(int n, double d) {
        return CborRenderer$.MODULE$.apply$mcZID$sp(n, d);
    }

    public static boolean apply$mcZII$sp(int n, int n2) {
        return CborRenderer$.MODULE$.apply$mcZII$sp(n, n2);
    }

    public static boolean apply$mcZIJ$sp(int n, long l) {
        return CborRenderer$.MODULE$.apply$mcZIJ$sp(n, l);
    }

    public static boolean apply$mcZJD$sp(long l, double d) {
        return CborRenderer$.MODULE$.apply$mcZJD$sp(l, d);
    }

    public static boolean apply$mcZJI$sp(long l, int n) {
        return CborRenderer$.MODULE$.apply$mcZJI$sp(l, n);
    }

    public static boolean apply$mcZJJ$sp(long l, long l2) {
        return CborRenderer$.MODULE$.apply$mcZJJ$sp(l, l2);
    }

    public static Function1<Output, Function1<Borer.EncodingConfig, CborRenderer>> curried() {
        return CborRenderer$.MODULE$.curried();
    }

    public static Function1<Tuple2<Output, Borer.EncodingConfig>, CborRenderer> tupled() {
        return CborRenderer$.MODULE$.tupled();
    }

    public CborRenderer(Output out) {
        this.out = out;
    }

    @Override
    public Output out() {
        return this.out;
    }

    public void out_$eq(Output x$1) {
        this.out = x$1;
    }

    @Override
    public void onNull() {
        Output underlying$proxy1 = this.out();
        this.out_$eq(underlying$proxy1.writeByte((byte)246));
    }

    @Override
    public void onUndefined() {
        Output underlying$proxy2 = this.out();
        this.out_$eq(underlying$proxy2.writeByte((byte)247));
    }

    @Override
    public void onBoolean(boolean value) {
        Output underlying$proxy3 = this.out();
        int i$proxy1 = value ? 245 : 244;
        this.out_$eq(underlying$proxy3.writeByte((byte)i$proxy1));
    }

    @Override
    public void onInt(int value) {
        this.onLong(value);
    }

    @Override
    public void onLong(long value) {
        this.out_$eq(value < 0L ? this.writeInteger(value ^ 0xFFFFFFFFFFFFFFFFL, 32) : this.writeInteger(value, 0));
    }

    @Override
    public void onOverLong(boolean negative, long value) {
        Output underlying$proxy4 = this.out();
        int i$proxy2 = negative ? 59 : 27;
        this.out_$eq(underlying$proxy4.writeByte((byte)i$proxy2).writeLong(value));
    }

    @Override
    public void onFloat16(float value) {
        Output underlying$proxy5 = this.out();
        this.out_$eq(underlying$proxy5.writeByte((byte)249).writeShort((short)Float16$.MODULE$.floatToShort(value)));
    }

    @Override
    public void onFloat(float value) {
        Output underlying$proxy6 = this.out();
        this.out_$eq(underlying$proxy6.writeByte((byte)250).writeInt(Float.floatToIntBits(value)));
    }

    @Override
    public void onDouble(double value) {
        Output underlying$proxy7 = this.out();
        this.out_$eq(underlying$proxy7.writeByte((byte)251).writeLong(Double.doubleToLongBits(value)));
    }

    @Override
    public void onNumberString(String value) {
        throw new Borer.Error.InvalidInputData<Output>(this.out(), "The CBOR renderer doesn't support writing number strings");
    }

    @Override
    public <Bytes> void onBytes(Bytes value, ByteAccess<Bytes> byteAccess) {
        this.out_$eq(this.writeInteger(byteAccess.sizeOf(value), 64).writeBytes(value, byteAccess));
    }

    @Override
    public void onBytesStart() {
        Output underlying$proxy8 = this.out();
        this.out_$eq(underlying$proxy8.writeByte((byte)95));
    }

    @Override
    public void onString(String value) {
        this.onText(value.getBytes(StandardCharsets.UTF_8), ByteAccess$ForByteArray$.MODULE$);
    }

    @Override
    public void onChars(char[] buffer, int length) {
        this.onText(Utf8$.MODULE$.encode(length == buffer.length ? buffer : Arrays.copyOfRange(buffer, 0, length)), ByteAccess$ForByteArray$.MODULE$);
    }

    @Override
    public <Bytes> void onText(Bytes value, ByteAccess<Bytes> byteAccess) {
        this.out_$eq(this.writeInteger(byteAccess.sizeOf(value), 96).writeBytes(value, byteAccess));
    }

    @Override
    public void onTextStart() {
        Output underlying$proxy9 = this.out();
        this.out_$eq(underlying$proxy9.writeByte((byte)127));
    }

    @Override
    public void onArrayHeader(long length) {
        if (length < 0L) {
            throw new IllegalArgumentException(new StringBuilder(29).append("length").append(" must be >= 0, but was ").append(length).toString());
        }
        this.out_$eq(this.writeInteger(length, 128));
    }

    @Override
    public void onArrayStart() {
        Output underlying$proxy10 = this.out();
        this.out_$eq(underlying$proxy10.writeByte((byte)159));
    }

    @Override
    public void onMapHeader(long length) {
        if (length < 0L) {
            throw new IllegalArgumentException(new StringBuilder(29).append("length").append(" must be >= 0, but was ").append(length).toString());
        }
        this.out_$eq(this.writeInteger(length, 160));
    }

    @Override
    public void onMapStart() {
        Output underlying$proxy11 = this.out();
        this.out_$eq(underlying$proxy11.writeByte((byte)191));
    }

    @Override
    public void onBreak() {
        Output underlying$proxy12 = this.out();
        this.out_$eq(underlying$proxy12.writeByte((byte)255));
    }

    @Override
    public void onTag(Tag value) {
        this.out_$eq(this.writeInteger(value.code(), 192));
    }

    @Override
    public void onSimpleValue(int value) {
        if (!SimpleValue$.MODULE$.isLegal(value)) {
            String msg = new StringBuilder(32).append(value).append(" must be in the range ").append(SimpleValue$.MODULE$.legalRange()).append(", but was ").append(value).toString();
            throw new Borer.Error.InvalidInputData<Output>(this.out(), msg);
        }
        this.out_$eq(this.writeInteger(value, 224));
    }

    @Override
    public void onEndOfInput() {
    }

    private Output writeInteger(long value, int majorType) {
        Output output;
        long v = value;
        if (v > 23L) {
            if (v >> 8 != 0L) {
                Output output2;
                if (v >> 16 != 0L) {
                    Output output3;
                    if (v >> 32 != 0L) {
                        Output underlying$proxy13 = this.out();
                        int i$proxy3 = 27 + majorType;
                        output3 = underlying$proxy13.writeByte((byte)i$proxy3).writeInt((int)(v >> 32));
                    } else {
                        Output underlying$proxy14 = this.out();
                        int i$proxy4 = 26 + majorType;
                        output3 = underlying$proxy14.writeByte((byte)i$proxy4);
                    }
                    output2 = output3.writeShort((short)(v >> 16));
                } else {
                    Output underlying$proxy15 = this.out();
                    int i$proxy5 = 25 + majorType;
                    output2 = underlying$proxy15.writeByte((byte)i$proxy5);
                }
                output = output2.writeByte((byte)(v >> 8));
            } else {
                Output underlying$proxy16 = this.out();
                int i$proxy6 = 24 + majorType;
                output = underlying$proxy16.writeByte((byte)i$proxy6);
            }
        } else {
            v += (long)majorType;
            output = this.out();
        }
        return output.writeByte((byte)v);
    }
}

