/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer.cbor;

import io.bullet.borer.Borer;
import io.bullet.borer.ByteAccess;
import io.bullet.borer.Float16$;
import io.bullet.borer.Input;
import io.bullet.borer.Input$;
import io.bullet.borer.Receiver;
import io.bullet.borer.SimpleValue$;
import io.bullet.borer.Tag;
import io.bullet.borer.Tag$BigFloat$;
import io.bullet.borer.Tag$DateTimeString$;
import io.bullet.borer.Tag$DecimalFraction$;
import io.bullet.borer.Tag$EmbeddedCBOR$;
import io.bullet.borer.Tag$EpochDateTime$;
import io.bullet.borer.Tag$HintBase16$;
import io.bullet.borer.Tag$HintBase64$;
import io.bullet.borer.Tag$HintBase64url$;
import io.bullet.borer.Tag$MagicHeader$;
import io.bullet.borer.Tag$NegativeBigNum$;
import io.bullet.borer.Tag$Other$;
import io.bullet.borer.Tag$PositiveBigNum$;
import io.bullet.borer.Tag$TextBase64$;
import io.bullet.borer.Tag$TextBase64Url$;
import io.bullet.borer.Tag$TextMime$;
import io.bullet.borer.Tag$TextRegex$;
import io.bullet.borer.Tag$TextUri$;
import io.bullet.borer.cbor.CborParser$;
import io.bullet.borer.internal.Parser;
import scala.Function3;
import scala.MatchError;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class CborParser<Bytes>
extends Parser<Bytes> {
    private final Input input;
    private final ByteAccess<Bytes> evidence$1;
    private long _valueIndex;

    public static <Bytes, Conf extends Config> Function3<Input<Bytes>, ByteAccess<Bytes>, Conf, Parser<Bytes>> creator() {
        return CborParser$.MODULE$.creator();
    }

    public CborParser(Input<Bytes> input, ByteAccess<Bytes> evidence$1, Config x$2) {
        this.input = input;
        this.evidence$1 = evidence$1;
    }

    @Override
    public Input<Bytes> input() {
        return this.input;
    }

    @Override
    public long valueIndex() {
        return this._valueIndex;
    }

    @Override
    public int pull(Receiver receiver) {
        this._valueIndex = -1L;
        byte by = this.input().readBytePadded(this);
        if (this._valueIndex < 0L) {
            long l;
            int info;
            this._valueIndex = this.input().cursor() - 1L;
            int majorType = by << 24 >>> 29;
            int n = info = by & 0x1F;
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    l = info;
                    break;
                }
                case 24: {
                    l = (long)this.input().readBytePadded(this) & 0xFFL;
                    break;
                }
                case 25: {
                    l = (long)this.input().readDoubleByteBigEndianPadded(this) & 0xFFFFL;
                    break;
                }
                case 26: {
                    l = (long)this.input().readQuadByteBigEndianPadded(this) & 0xFFFFFFFFL;
                    break;
                }
                case 27: {
                    l = this.input().readOctaByteBigEndianPadded(this);
                    break;
                }
                default: {
                    if (info == 31 && 2 <= majorType && majorType <= 5 || majorType == 7) {
                        l = 0L;
                        break;
                    }
                    throw this.failInvalidInput(new StringBuilder(45).append("Additional info `").append(info).append("` is invalid (major type `").append(majorType).append("`)").toString());
                }
            }
            long uLong = l;
            int n2 = majorType;
            switch (n2) {
                case 0: {
                    return CborParser.decodePositiveInteger$1(receiver, uLong);
                }
                case 1: {
                    return CborParser.decodeNegativeInteger$1(receiver, uLong);
                }
                case 2: {
                    return this.decodeByteString$1(receiver, uLong, info == 31);
                }
                case 3: {
                    return this.decodeTextString$1(receiver, uLong, info == 31);
                }
                case 4: {
                    return this.decodeArray$1(receiver, uLong, info == 31);
                }
                case 5: {
                    return this.decodeMap$1(receiver, uLong, info == 31);
                }
                case 6: {
                    return CborParser.decodeTag$1(receiver, uLong);
                }
                case 7: {
                    return this.decodeExtra$1(receiver, info, uLong);
                }
            }
            throw new MatchError(BoxesRunTime.boxToInteger(n2));
        }
        receiver.onEndOfInput();
        return 0x800000;
    }

    @Override
    public byte padByte() {
        if (this._valueIndex < 0L) {
            this._valueIndex = 0L;
            return 0;
        }
        throw this.failUnexpectedEOI("8-bit integer");
    }

    public Nothing$ padDoubleByte(int remaining) {
        return this.failUnexpectedEOI("16-bit integer");
    }

    public Nothing$ padQuadByte(int remaining) {
        return this.failUnexpectedEOI("32-bit integer");
    }

    public Nothing$ padOctaByte(int remaining) {
        return this.failUnexpectedEOI("64-bit integer");
    }

    @Override
    public Nothing$ padBytes(Bytes rest, long missing) {
        return this.failUnexpectedEOI(new StringBuilder(20).append("at least ").append(missing).append(" more bytes").toString());
    }

    private Nothing$ failUnexpectedEOI(String expected) {
        throw new Borer.Error.UnexpectedEndOfInput<Input.Position>(this.lastPos(), expected);
    }

    private Nothing$ failInvalidInput(String msg) {
        throw new Borer.Error.InvalidInputData<Input.Position>(this.lastPos(), msg);
    }

    private Nothing$ failOverflow(String msg) {
        throw new Borer.Error.Overflow<Input.Position>(this.lastPos(), msg);
    }

    private Nothing$ failUnsupported(String msg) {
        throw new Borer.Error.Unsupported<Input.Position>(this.lastPos(), msg);
    }

    private Input.Position lastPos() {
        return Input$.MODULE$.position(this.input(), this._valueIndex);
    }

    private static final int decodePositiveInteger$1(Receiver receiver$1, long uLong) {
        if (uLong >> 31 == 0L) {
            receiver$1.onInt((int)uLong);
            return 8;
        }
        if (uLong >= 0L) {
            receiver$1.onLong(uLong);
            return 16;
        }
        receiver$1.onOverLong(false, uLong);
        return 32;
    }

    private static final int decodeNegativeInteger$1(Receiver receiver$2, long uLong) {
        if (uLong >> 31 == 0L) {
            receiver$2.onInt((int)(uLong ^ 0xFFFFFFFFFFFFFFFFL));
            return 8;
        }
        if (uLong >= 0L) {
            receiver$2.onLong(uLong ^ 0xFFFFFFFFFFFFFFFFL);
            return 16;
        }
        receiver$2.onOverLong(true, uLong);
        return 32;
    }

    private final int decodeByteString$1(Receiver receiver$3, long uLong, boolean indefiniteLength) {
        if (indefiniteLength) {
            receiver$3.onBytesStart();
            return 32768;
        }
        if (uLong >= 0L) {
            receiver$3.onBytes(this.input().readBytes(uLong, this), this.evidence$1);
            return 16384;
        }
        throw this.failOverflow("This decoder does not support byte strings with size >= 2^63");
    }

    private final int decodeTextString$1(Receiver receiver$4, long uLong, boolean indefiniteLength) {
        if (indefiniteLength) {
            receiver$4.onTextStart();
            return 8192;
        }
        if (uLong >= 0L) {
            receiver$4.onText(this.input().readBytes(uLong, this), this.evidence$1);
            return 4096;
        }
        throw this.failOverflow("This decoder does not support text strings with size >= 2^63");
    }

    private final int decodeArray$1(Receiver receiver$5, long uLong, boolean indefiniteLength) {
        if (indefiniteLength) {
            receiver$5.onArrayStart();
            return 131072;
        }
        if (uLong >= 0L) {
            receiver$5.onArrayHeader(uLong);
            return 65536;
        }
        throw this.failOverflow("This decoder does not support arrays with size >= 2^63");
    }

    private final int decodeMap$1(Receiver receiver$6, long uLong, boolean indefiniteLength) {
        if (indefiniteLength) {
            receiver$6.onMapStart();
            return 524288;
        }
        if (uLong >= 0L) {
            receiver$6.onMapHeader(uLong);
            return 262144;
        }
        throw this.failOverflow("This decoder does not support maps with size >= 2^63");
    }

    private static final int decodeTag$1(Receiver receiver$7, long uLong) {
        Tag tag;
        long l = uLong;
        if (0L == l) {
            tag = Tag$DateTimeString$.MODULE$;
        } else if (1L == l) {
            tag = Tag$EpochDateTime$.MODULE$;
        } else if (2L == l) {
            tag = Tag$PositiveBigNum$.MODULE$;
        } else if (3L == l) {
            tag = Tag$NegativeBigNum$.MODULE$;
        } else if (4L == l) {
            tag = Tag$DecimalFraction$.MODULE$;
        } else if (5L == l) {
            tag = Tag$BigFloat$.MODULE$;
        } else if (21L == l) {
            tag = Tag$HintBase64url$.MODULE$;
        } else if (22L == l) {
            tag = Tag$HintBase64$.MODULE$;
        } else if (23L == l) {
            tag = Tag$HintBase16$.MODULE$;
        } else if (24L == l) {
            tag = Tag$EmbeddedCBOR$.MODULE$;
        } else if (32L == l) {
            tag = Tag$TextUri$.MODULE$;
        } else if (33L == l) {
            tag = Tag$TextBase64Url$.MODULE$;
        } else if (34L == l) {
            tag = Tag$TextBase64$.MODULE$;
        } else if (35L == l) {
            tag = Tag$TextRegex$.MODULE$;
        } else if (36L == l) {
            tag = Tag$TextMime$.MODULE$;
        } else if (55799L == l) {
            tag = Tag$MagicHeader$.MODULE$;
        } else {
            long x = l;
            tag = Tag$Other$.MODULE$.apply(x);
        }
        Tag tag2 = tag;
        receiver$7.onTag(tag2);
        return 0x200000;
    }

    private final int decodeExtra$1(Receiver receiver$8, int info, long uLong) {
        int n = info;
        switch (n) {
            case 20: 
            case 21: {
                receiver$8.onBoolean(info == 21);
                return 4;
            }
            case 22: {
                receiver$8.onNull();
                return 1;
            }
            case 23: {
                receiver$8.onUndefined();
                return 2;
            }
            case 24: {
                int n2;
                int x = n2 = (int)uLong;
                if (!SimpleValue$.MODULE$.isLegal(x)) {
                    int x2 = n2;
                    throw this.failInvalidInput(new StringBuilder(44).append("Simple value must be in the range ").append(SimpleValue$.MODULE$.legalRange()).append(", but was ").append(x2).toString());
                }
                receiver$8.onSimpleValue(x);
                return 0x400000;
            }
            case 25: {
                receiver$8.onFloat16(Float16$.MODULE$.shortToFloat((int)uLong));
                return 64;
            }
            case 26: {
                receiver$8.onFloat(Float.intBitsToFloat((int)uLong));
                return 128;
            }
            case 27: {
                receiver$8.onDouble(Double.longBitsToDouble(uLong));
                return 256;
            }
            case 31: {
                receiver$8.onBreak();
                return 0x100000;
            }
        }
        int x = n;
        if (SimpleValue$.MODULE$.isLegal(x)) {
            receiver$8.onSimpleValue(x);
            return 0x400000;
        }
        throw this.failUnsupported(new StringBuilder(54).append("CBOR major type 7 code ").append(x).append(" is unsupported by this decoder").toString());
    }

    public static interface Config {
        public int maxByteStringLength();

        public int maxTextStringLength();
    }
}

