/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer;

import io.bullet.borer.ByteAccess;
import io.bullet.borer.Encoder;
import io.bullet.borer.Json$;
import io.bullet.borer.Output;
import io.bullet.borer.Receiver;
import io.bullet.borer.Tag;
import io.bullet.borer.Target;
import io.bullet.borer.Writer$Script$;
import io.bullet.borer.internal.Util$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.LinearSeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public final class Writer {
    private final Output output;
    private Receiver receiver;
    private final Target target;
    private final Config config;

    public Writer(Output output, Receiver receiver, Target target, Config config) {
        this.output = output;
        this.receiver = receiver;
        this.target = target;
        this.config = config;
    }

    public Output output() {
        return this.output;
    }

    public Receiver receiver() {
        return this.receiver;
    }

    public void receiver_$eq(Receiver x$1) {
        this.receiver = x$1;
    }

    public Target target() {
        return this.target;
    }

    public Writer writeNull() {
        this.receiver().onNull();
        return this;
    }

    public Writer writeUndefined() {
        this.receiver().onUndefined();
        return this;
    }

    public Writer writeBoolean(boolean value) {
        this.receiver().onBoolean(value);
        return this;
    }

    public Writer writeChar(char value) {
        return this.writeInt(value);
    }

    public Writer writeByte(byte value) {
        return this.writeInt(value);
    }

    public Writer writeShort(short value) {
        return this.writeInt(value);
    }

    public Writer writeInt(int value) {
        this.receiver().onInt(value);
        return this;
    }

    public Writer writeLong(long value) {
        this.receiver().onLong(value);
        return this;
    }

    public Writer writeOverLong(boolean negative, long value) {
        this.receiver().onOverLong(negative, value);
        return this;
    }

    public Writer writeFloat16(float value) {
        this.receiver().onFloat16(value);
        return this;
    }

    public Writer writeFloat(float value) {
        if (this.config.compressFloatingPointValues() && Util$.MODULE$.canBeRepresentedAsFloat16(value)) {
            this.receiver().onFloat16(value);
        } else {
            this.receiver().onFloat(value);
        }
        return this;
    }

    public Writer writeDouble(double value) {
        Object object;
        if (this.config.compressFloatingPointValues() && (Predef$.MODULE$.double2Double(value).isNaN() || (double)((float)value) == value)) {
            object = this.writeFloat((float)value);
        } else {
            this.receiver().onDouble(value);
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    public Writer writeNumberString(String value) {
        this.receiver().onNumberString(value);
        return this;
    }

    public Writer writeString(String value) {
        this.receiver().onString(value);
        return this;
    }

    public Writer writeChars(char[] value) {
        this.receiver().onChars(value, value.length);
        return this;
    }

    public <Bytes> Writer writeBytes(Bytes value, ByteAccess<Bytes> evidence$1) {
        this.receiver().onBytes(value, evidence$1);
        return this;
    }

    public <Bytes> Writer writeText(Bytes value, ByteAccess<Bytes> evidence$1) {
        this.receiver().onText(value, evidence$1);
        return this;
    }

    public Writer writeTag(Tag value) {
        this.receiver().onTag(value);
        return this;
    }

    public Writer writeSimpleValue(int value) {
        this.receiver().onSimpleValue(value);
        return this;
    }

    public Writer writeBytesStart() {
        this.receiver().onBytesStart();
        return this;
    }

    public Writer writeTextStart() {
        this.receiver().onTextStart();
        return this;
    }

    public Writer writeArrayHeader(int length) {
        return this.writeArrayHeader((long)length);
    }

    public Writer writeArrayHeader(long length) {
        this.receiver().onArrayHeader(length);
        return this;
    }

    public Writer writeArrayStart() {
        this.receiver().onArrayStart();
        return this;
    }

    public Writer writeMapHeader(int length) {
        return this.writeMapHeader((long)length);
    }

    public Writer writeMapHeader(long length) {
        this.receiver().onMapHeader(length);
        return this;
    }

    public Writer writeMapStart() {
        this.receiver().onMapStart();
        return this;
    }

    public Writer writeBreak() {
        this.receiver().onBreak();
        return this;
    }

    public Writer writeEndOfInput() {
        this.receiver().onEndOfInput();
        return this;
    }

    public <T> Writer write(T value, Encoder<T> encoder) {
        return encoder.write(this, value);
    }

    public Writer writeEmptyArray() {
        return this.writeArrayOpen(0).writeArrayClose();
    }

    public <T> Writer writeToArray(T x, Encoder<T> evidence$1) {
        return this.writeArrayOpen(1).write(x, evidence$1).writeArrayClose();
    }

    public <A, B> Writer writeToArray(A a, B b, Encoder<A> evidence$1, Encoder<B> evidence$2) {
        return this.writeArrayOpen(2).write(a, evidence$1).write(b, evidence$2).writeArrayClose();
    }

    public <A, B, C> Writer writeToArray(A a, B b, C c, Encoder<A> evidence$1, Encoder<B> evidence$2, Encoder<C> evidence$3) {
        return this.writeArrayOpen(3).write(a, evidence$1).write(b, evidence$2).write(c, evidence$3).writeArrayClose();
    }

    public Writer writeEmptyMap() {
        if (this.target() == Json$.MODULE$) {
            return this.writeMapStart().writeBreak();
        }
        return this.writeMapHeader(0);
    }

    public <T> Writer writeIndexedSeq(IndexedSeq<T> x, Encoder<T> evidence$1) {
        this.writeArrayOpen(x.size());
        this.rec$1(x, evidence$1, 0);
        return this.writeArrayClose();
    }

    public <T> Writer writeLinearSeq(LinearSeq<T> x, Encoder<T> evidence$1) {
        if (this.target() == Json$.MODULE$ || x.nonEmpty()) {
            this.writeArrayStart();
            this.rec$2(evidence$1, x);
            return this.writeBreak();
        }
        return this.writeEmptyArray();
    }

    public <T> Writer writeIterableOnce(IterableOnce<T> iterableOnce, Encoder<T> evidence$1) {
        int size = iterableOnce.knownSize();
        if (size > 0) {
            this.writeArrayOpen(size);
            Iterator<T> iterator = iterableOnce.iterator();
            while (iterator.hasNext()) {
                this.write(iterator.next(), evidence$1);
            }
            return this.writeArrayClose();
        }
        if (size < 0) {
            return this.writeIterator(iterableOnce.iterator(), evidence$1);
        }
        return this.writeEmptyArray();
    }

    public <T> Writer writeIterator(Iterator<T> iterator, Encoder<T> evidence$1) {
        if (iterator.hasNext()) {
            this.writeArrayStart();
            while (iterator.hasNext()) {
                this.write(iterator.next(), evidence$1);
            }
            return this.writeBreak();
        }
        return this.writeEmptyArray();
    }

    public <Bytes> Writer writeBytesIterator(Iterator<Bytes> iterator, ByteAccess<Bytes> evidence$1) {
        this.writeBytesStart();
        while (iterator.hasNext()) {
            this.writeBytes(iterator.next(), evidence$1);
        }
        return this.writeBreak();
    }

    public Writer writeStringIterator(Iterator<String> iterator) {
        this.writeTextStart();
        while (iterator.hasNext()) {
            this.writeString(iterator.next());
        }
        return this.writeBreak();
    }

    public <A, B> Writer writeMap(Map<A, B> x, Encoder<A> evidence$1, Encoder<B> evidence$2) {
        if (x.nonEmpty()) {
            Iterator iterator = x.iterator();
            if (this.target() == Json$.MODULE$) {
                this.writeMapStart();
                this.writeEntries$1(iterator, evidence$1, evidence$2);
                return this.writeBreak();
            }
            this.writeMapHeader(x.size());
            this.writeEntries$1(iterator, evidence$1, evidence$2);
            return this;
        }
        return this.writeEmptyMap();
    }

    public <A, B> Writer writeMapMember(A key2, B value, Encoder<A> evidence$1, Encoder<B> evidence$2) {
        return this.write(key2, evidence$1).write(value, evidence$2);
    }

    public Writer writeArrayOpen(int size) {
        if (this.target() == Json$.MODULE$) {
            return this.writeArrayStart();
        }
        return this.writeArrayHeader(size);
    }

    public Writer writeArrayClose() {
        if (this.target() == Json$.MODULE$) {
            return this.writeBreak();
        }
        return this;
    }

    public Writer writeMapOpen(int size) {
        if (this.target() == Json$.MODULE$) {
            return this.writeMapStart();
        }
        return this.writeMapHeader(size);
    }

    public Writer writeMapClose() {
        if (this.target() == Json$.MODULE$) {
            return this.writeBreak();
        }
        return this;
    }

    private final void rec$1(IndexedSeq x$1, Encoder evidence$1$1, int ix) {
        while (ix < x$1.size()) {
            this.write(x$1.apply(ix), evidence$1$1);
            ++ix;
        }
    }

    private final void rec$2(Encoder evidence$1$2, LinearSeq x) {
        while (x.nonEmpty()) {
            this.write(x.head(), evidence$1$2);
            x = (LinearSeq)x.tail();
        }
    }

    private final void writeEntries$1(Iterator iterator$1, Encoder evidence$1$3, Encoder evidence$2$1) {
        while (iterator$1.hasNext()) {
            Tuple2 tuple2 = (Tuple2)iterator$1.next();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Object k = tuple2._1();
            Object v = tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(k, v);
            Object k2 = tuple22._1();
            Object v2 = tuple22._2();
            this.write(k2, evidence$1$3).write(v2, evidence$2$1);
        }
    }

    public static interface Config {
        public boolean compressFloatingPointValues();
    }

    public static final class Script
    implements Product,
    Serializable {
        private final Function1 encode;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Writer$Script$.class.getDeclaredField("given_Encoder_Script$lzy1"));

        public static Script ArrayStart() {
            return Writer$Script$.MODULE$.ArrayStart();
        }

        public static Script Break() {
            return Writer$Script$.MODULE$.Break();
        }

        public static Script BytesStart() {
            return Writer$Script$.MODULE$.BytesStart();
        }

        public static Script MapStart() {
            return Writer$Script$.MODULE$.MapStart();
        }

        public static Script TextStart() {
            return Writer$Script$.MODULE$.TextStart();
        }

        public static Script Undefined() {
            return Writer$Script$.MODULE$.Undefined();
        }

        public static Script apply(Function1<Writer, Writer> function1) {
            return Writer$Script$.MODULE$.apply(function1);
        }

        public static Script fromProduct(Product product) {
            return Writer$Script$.MODULE$.fromProduct(product);
        }

        public static Encoder<Script> given_Encoder_Script() {
            return Writer$Script$.MODULE$.given_Encoder_Script();
        }

        public static Script unapply(Script script) {
            return Writer$Script$.MODULE$.unapply(script);
        }

        public Script(Function1<Writer, Writer> encode) {
            this.encode = encode;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Script)) return false;
            Script script = (Script)object;
            Function1<Writer, Writer> function1 = this.encode();
            Function1<Writer, Writer> function12 = script.encode();
            if (function1 != null) {
                if (!function1.equals(function12)) return false;
                return true;
            }
            if (function12 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Script;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Script";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "encode";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Function1<Writer, Writer> encode() {
            return this.encode;
        }

        public Script copy(Function1<Writer, Writer> encode) {
            return new Script(encode);
        }

        public Function1<Writer, Writer> copy$default$1() {
            return this.encode();
        }

        public Function1<Writer, Writer> _1() {
            return this.encode();
        }
    }
}

