/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer;

import io.bullet.borer.Borer;
import io.bullet.borer.CommonApi;
import io.bullet.borer.Decoder;
import io.bullet.borer.Encoder;
import io.bullet.borer.InputReader;
import io.bullet.borer.Reader;
import io.bullet.borer.Receiver;
import io.bullet.borer.Target;
import io.bullet.borer.Writer;
import io.bullet.borer.internal.ElementDeque;
import io.bullet.borer.internal.ElementDeque$;
import io.bullet.borer.internal.ElementDequeCache$;
import io.bullet.borer.internal.Parser;
import scala.Function2;
import scala.Option;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class TranscodingSetup {

    public static interface DecodingApi<Config extends Reader.Config>
    extends CommonApi<Config> {
        public <T> Sealed<T> to(Decoder<T> var1);
    }

    public static final class DecodingApiImpl<A, EC extends Borer.TransEncodingConfig, DC extends Reader.Config>
    extends CommonApi.Impl<DC>
    implements DecodingApi<DC>,
    Sealed<Object> {
        private final A valueToEncode;
        private final Target target;
        private final EC encConfig;
        private final Function2<Receiver, EC, Receiver> encWrapper;
        private final Encoder<A> evidence$1;
        private boolean prefixOnly;
        private Decoder<Object> decoder;

        public DecodingApiImpl(A valueToEncode, Target target, EC encConfig, Function2<Receiver, EC, Receiver> encWrapper, DC defaultDecConfig, Function2<Receiver, DC, Receiver> defaultDecWrapper, Encoder<A> evidence$1) {
            this.valueToEncode = valueToEncode;
            this.target = target;
            this.encConfig = encConfig;
            this.encWrapper = encWrapper;
            this.evidence$1 = evidence$1;
            super(defaultDecConfig, defaultDecWrapper);
        }

        public DecodingApiImpl withPrefixOnly() {
            this.prefixOnly = true;
            return this;
        }

        @Override
        public <T> Sealed<T> to(Decoder<T> decoder) {
            this.decoder = decoder;
            return this;
        }

        @Override
        public Object value() {
            Object object;
            try {
                object = this.transcode();
            }
            catch (Borer.Error e) {
                throw e.withUnit();
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    throw new Borer.Error.General<BoxedUnit>(BoxedUnit.UNIT, e);
                }
                throw throwable;
            }
            return object;
        }

        @Override
        public Try<Object> valueTry() {
            Try try_;
            try {
                try_ = Success$.MODULE$.apply(this.transcode());
            }
            catch (Borer.Error e) {
                try_ = Failure$.MODULE$.apply(e.withUnit());
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    try_ = Failure$.MODULE$.apply(new Borer.Error.General<BoxedUnit>(BoxedUnit.UNIT, e));
                }
                throw throwable;
            }
            return try_;
        }

        @Override
        public Either<Borer.Error<BoxedUnit>, Object> valueEither() {
            Either either;
            try {
                either = package$.MODULE$.Right().apply(this.transcode());
            }
            catch (Borer.Error e) {
                either = package$.MODULE$.Left().apply(e.withUnit());
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    either = package$.MODULE$.Left().apply(new Borer.Error.General<BoxedUnit>(BoxedUnit.UNIT, e));
                }
                throw throwable;
            }
            return either;
        }

        private Object transcode() {
            Object object;
            ElementDeque deque = ((Borer.TransEncodingConfig)this.encConfig).allowBufferCaching() ? ElementDequeCache$.MODULE$.acquire(((Borer.TransEncodingConfig)this.encConfig).maxBufferSize()) : new ElementDeque(((Borer.TransEncodingConfig)this.encConfig).maxBufferSize(), ElementDeque$.MODULE$.$lessinit$greater$default$2());
            try {
                Writer writer = new Writer(null, this.encWrapper.apply(deque.appendReceiver(), this.encConfig), this.target, (Writer.Config)this.encConfig);
                writer.write(this.valueToEncode, this.evidence$1).writeEndOfInput();
                InputReader<Reader.Config> reader = new InputReader<Reader.Config>(new Parser.DequeParser(deque), null, this.receiverTransformer(), (Reader.Config)this.config(), this.target);
                Object value = this.decoder.read(reader);
                if (!this.prefixOnly) {
                    reader.readEndOfInput();
                }
                object = value;
            }
            finally {
                if (((Borer.TransEncodingConfig)this.encConfig).allowBufferCaching()) {
                    ElementDequeCache$.MODULE$.release(deque);
                }
            }
            return object;
        }
    }

    public static interface EncodingApi<EncodingConfig extends Borer.TransEncodingConfig, DecodingConfig extends Reader.Config>
    extends CommonApi<EncodingConfig> {
        public DecodingApi<DecodingConfig> transDecode();
    }

    public static final class EncodingApiImpl<A, EC extends Borer.TransEncodingConfig, DC extends Reader.Config>
    extends CommonApi.Impl<EC>
    implements EncodingApi<EC, DC> {
        private final A value;
        private final Target target;
        private final DC defaultDecConfig;
        private final Function2<Receiver, DC, Receiver> defaultDecWrapper;
        private final Encoder<A> evidence$1;

        public EncodingApiImpl(A value, Target target, EC defaultEncConfig, Function2<Receiver, EC, Receiver> defaultEncWrapper, DC defaultDecConfig, Function2<Receiver, DC, Receiver> defaultDecWrapper, Encoder<A> evidence$1) {
            this.value = value;
            this.target = target;
            this.defaultDecConfig = defaultDecConfig;
            this.defaultDecWrapper = defaultDecWrapper;
            this.evidence$1 = evidence$1;
            super(defaultEncConfig, defaultEncWrapper);
        }

        @Override
        public DecodingApi<DC> transDecode() {
            return new DecodingApiImpl<A, Borer.TransEncodingConfig, DC>(this.value, this.target, (Borer.TransEncodingConfig)this.config(), this.receiverTransformer(), this.defaultDecConfig, this.defaultDecWrapper, this.evidence$1);
        }
    }

    public static interface Sealed<T> {
        public T value();

        public Try<T> valueTry();

        public Either<Borer.Error<BoxedUnit>, T> valueEither();
    }
}

