/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer;

import io.bullet.borer.ByteAccess;
import io.bullet.borer.Receiver$;
import io.bullet.borer.Tag;
import scala.Function2;
import scala.Predef$;
import scala.collection.StringOps$;

public abstract class Receiver {
    public static <Config> Function2<Receiver, Config, Receiver> nopTransformer() {
        return Receiver$.MODULE$.nopTransformer();
    }

    public abstract void onNull();

    public abstract void onUndefined();

    public abstract void onBoolean(boolean var1);

    public abstract void onInt(int var1);

    public abstract void onLong(long var1);

    public abstract void onOverLong(boolean var1, long var2);

    public abstract void onFloat16(float var1);

    public abstract void onFloat(float var1);

    public abstract void onDouble(double var1);

    public abstract void onNumberString(String var1);

    public abstract <Bytes> void onBytes(Bytes var1, ByteAccess<Bytes> var2);

    public abstract void onBytesStart();

    public abstract void onString(String var1);

    public abstract void onChars(char[] var1, int var2);

    public abstract <Bytes> void onText(Bytes var1, ByteAccess<Bytes> var2);

    public abstract void onTextStart();

    public abstract void onArrayHeader(long var1);

    public abstract void onArrayStart();

    public abstract void onMapHeader(long var1);

    public abstract void onMapStart();

    public abstract void onBreak();

    public abstract void onTag(Tag var1);

    public abstract void onSimpleValue(int var1);

    public abstract void onEndOfInput();

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static abstract class WithDefault
    extends Receiver {
        @Override
        public void onNull() {
            this.default("`null`");
        }

        @Override
        public void onUndefined() {
            this.default("`undefined`");
        }

        @Override
        public void onBoolean(boolean value) {
            this.default(new StringBuilder(14).append("the Boolean `").append(value).append("`").toString());
        }

        @Override
        public void onInt(int value) {
            this.default(new StringBuilder(10).append("the Int `").append(value).append("`").toString());
        }

        @Override
        public void onLong(long value) {
            this.default(new StringBuilder(11).append("the Long `").append(value).append("`").toString());
        }

        @Override
        public void onOverLong(boolean negative, long value) {
            this.default(new StringBuilder(15).append("the OverLong `").append(value).append("`").toString());
        }

        @Override
        public void onFloat16(float value) {
            this.default(new StringBuilder(14).append("the Float16 `").append(value).append("`").toString());
        }

        @Override
        public void onFloat(float value) {
            this.default(new StringBuilder(12).append("the Float `").append(value).append("`").toString());
        }

        @Override
        public void onDouble(double value) {
            this.default(new StringBuilder(13).append("the Double `").append(value).append("`").toString());
        }

        @Override
        public void onNumberString(String value) {
            this.default(new StringBuilder(19).append("the NumberString `").append(value).append("`").toString());
        }

        @Override
        public <Bytes> void onBytes(Bytes value, ByteAccess<Bytes> evidence$1) {
            this.default(new StringBuilder(26).append("a `Bytes` value of length ").append(evidence$1.sizeOf(value)).toString());
        }

        @Override
        public void onBytesStart() {
            this.default("`BytesStart`");
        }

        @Override
        public void onString(String value) {
            this.default(new StringBuilder(13).append("the String `").append(value.length() > 20 ? new StringBuilder(3).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(value), 20)).append("...").toString() : value).append("`").toString());
        }

        @Override
        public void onChars(char[] buffer, int length) {
            this.default(new StringBuilder(18).append("Chars with length ").append(length).toString());
        }

        @Override
        public <Bytes> void onText(Bytes value, ByteAccess<Bytes> evidence$1) {
            this.default(new StringBuilder(25).append("a `Text` value of length ").append(evidence$1.sizeOf(value)).toString());
        }

        @Override
        public void onTextStart() {
            this.default("`TextStart`");
        }

        @Override
        public void onArrayHeader(long length) {
            this.default(new StringBuilder(14).append("`ArrayHeader(").append(length).append(")").toString());
        }

        @Override
        public void onArrayStart() {
            this.default("`ArrayStart`");
        }

        @Override
        public void onMapHeader(long length) {
            this.default(new StringBuilder(12).append("`MapHeader(").append(length).append(")").toString());
        }

        @Override
        public void onMapStart() {
            this.default("`MapStart`");
        }

        @Override
        public void onBreak() {
            this.default("`Break`");
        }

        @Override
        public void onTag(Tag value) {
            this.default(new StringBuilder(2).append("`").append(value).append("`").toString());
        }

        @Override
        public void onSimpleValue(int value) {
            this.default(new StringBuilder(14).append("`SimpleValue(").append(value).append(")").toString());
        }

        @Override
        public void onEndOfInput() {
            this.default("`End Of Input`");
        }

        public abstract void default(String var1);
    }
}

