/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer;

import io.bullet.borer.ByteAccess;
import io.bullet.borer.Logging;
import io.bullet.borer.Logging$;
import io.bullet.borer.Logging$ElementType$;
import io.bullet.borer.Logging$ElementType$ArrayElement$;
import io.bullet.borer.Logging$ElementType$MapKey$;
import io.bullet.borer.Logging$ElementType$MapValue$;
import io.bullet.borer.Logging$ElementType$UnboundedByteStringElement$;
import io.bullet.borer.Logging$ElementType$UnboundedTextStringElement$;
import io.bullet.borer.Tag;
import io.bullet.borer.internal.Util$;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class Logging {
    public static <Config> Function2<io.bullet.borer.Receiver, Config, io.bullet.borer.Receiver> transformer(Function1<LevelInfo, Logger> function1) {
        return Logging$.MODULE$.transformer(function1);
    }

    public static interface ElementType {
        public static int ordinal(ElementType elementType) {
            return Logging$ElementType$.MODULE$.ordinal(elementType);
        }
    }

    public static interface LevelInfo {
        public int level();

        public long levelCount();

        public long levelSize();

        public ElementType elementType();

        public static boolean isUnbounded$(LevelInfo $this) {
            return $this.isUnbounded();
        }

        default public boolean isUnbounded() {
            return this.levelSize() < 0L;
        }
    }

    public static abstract class LineFormatLogger
    implements Logger {
        private int gutterWidth;

        public int gutterWidth() {
            return this.gutterWidth;
        }

        public void gutterWidth_$eq(int x$1) {
            this.gutterWidth = x$1;
        }

        public abstract LevelInfo info();

        public abstract int maxShownByteArrayPrefixLen();

        public abstract int maxShownStringPrefixLen();

        public abstract int maxShownArrayElems();

        public abstract int maxShownMapEntries();

        public abstract int initialGutterWidth();

        public abstract boolean renderLevelCount();

        public abstract boolean renderEndOfInput();

        public abstract boolean renderCommas();

        public abstract String indentation();

        public abstract String mapKeySep();

        public abstract void renderLine(String var1);

        @Override
        public void onNull() {
            this.render("null", this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onUndefined() {
            this.render("undefined", this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onBool(boolean value) {
            this.render(BoxesRunTime.boxToBoolean(value).toString(), this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onInt(int value) {
            this.render(BoxesRunTime.boxToInteger(value).toString(), this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onLong(long value) {
            this.render(new StringBuilder(1).append(value).append("L").toString(), this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onOverLong(boolean negative, long value) {
            this.render(this.formatOverLong(negative, value), this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onFloat16(float value) {
            this.render(new StringBuilder(3).append(Util$.MODULE$.doubleToString(value)).append("f16").toString(), this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onFloat(float value) {
            this.render(new StringBuilder(1).append(Util$.MODULE$.doubleToString(value)).append("f").toString(), this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onDouble(double value) {
            this.render(new StringBuilder(1).append(Util$.MODULE$.doubleToString(value)).append("d").toString(), this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onDecimal(long integer, int fraction) {
            this.render(new StringBuilder(2).append(integer).append(".").append(fraction).append("d").toString(), this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onNumberString(String value) {
            this.render(new StringBuilder(1).append(value).append("s").toString(), this.render$default$2(), this.render$default$3());
        }

        @Override
        public <Bytes> void onBytes(Bytes value, ByteAccess<Bytes> evidence$1) {
            this.render(this.formatBytes("B[", value, evidence$1), this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onBytesStart() {
            this.render("B*[", true, this.render$default$3());
        }

        @Override
        public void onString(String value) {
            this.render(this.formatString(value), this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onChars(char[] buffer, int length) {
            this.render(this.formatString(new String(buffer, 0, length)), this.render$default$2(), this.render$default$3());
        }

        @Override
        public <Bytes> void onText(Bytes value, ByteAccess<Bytes> evidence$1) {
            this.render(this.formatString(value, evidence$1), this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onTextStart() {
            this.render("T*[", true, this.render$default$3());
        }

        @Override
        public void onArrayStart() {
            this.render("*[", true, this.render$default$3());
        }

        @Override
        public void onMapStart() {
            this.render("*{", true, this.render$default$3());
        }

        @Override
        public void onTag(Tag value) {
            this.render(new StringBuilder(1).append("@").append(value).toString(), this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onSimpleValue(int value) {
            this.render(new StringBuilder(8).append("Simple(").append(value).append(")").toString(), this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onEndOfInput() {
            if (this.renderEndOfInput()) {
                this.render("END", this.render$default$2(), this.render$default$3());
                return;
            }
        }

        @Override
        public void onArrayHeader(long length) {
            if (length > 0L) {
                this.render("[", true, this.render$default$3());
                return;
            }
            this.render("[]", this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onMapHeader(long length) {
            if (length > 0L) {
                this.render("{", true, this.render$default$3());
                return;
            }
            this.render("{}", this.render$default$2(), this.render$default$3());
        }

        @Override
        public void onLevelExited(ElementType levelType, boolean bl) {
            String string2 = levelType instanceof ElementType.MapEntry ? "}" : "]";
            boolean bl2 = this.render$default$2();
            this.render(string2, bl2, true);
        }

        public <Bytes> String formatBytes(String opener, Bytes value, ByteAccess<Bytes> ba) {
            Object object = Predef$.MODULE$.byteArrayOps(ba.toByteArray(value));
            Object object2 = Predef$.MODULE$.byteArrayOps((byte[])ArrayOps$.MODULE$.take$extension(object, this.maxShownByteArrayPrefixLen()));
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, Logging$::io$bullet$borer$Logging$LineFormatLogger$$_$formatBytes$$anonfun$adapted$1, ClassTag$.MODULE$.apply(String.class))).mkString(opener, " ", ba.sizeOf(value) > (long)this.maxShownByteArrayPrefixLen() ? " ...]" : "]");
        }

        public String formatOverLong(boolean negative, long value) {
            BigInteger x = new BigInteger(1, Util$.MODULE$.toBigEndianBytes(value));
            BigInteger y = negative ? x.not() : x;
            return new StringBuilder(2).append(y.toString()).append("LL").toString();
        }

        public <Bytes> String formatString(Bytes value, ByteAccess<Bytes> ba) {
            return this.formatString(new String(ba.toByteArray(value), StandardCharsets.UTF_8));
        }

        public String formatString(String value) {
            StringBuilder sb2 = new StringBuilder();
            boolean tooLong = value.length() > this.maxShownStringPrefixLen();
            String string2 = tooLong ? value.substring(0, this.maxShownStringPrefixLen()) : value;
            return StringOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.augmentString(string2), sb2.append('\"'), (Function2<Object, Object, StringBuilder> & Serializable)(sb, object) -> this.formatString$$anonfun$1((StringBuilder)sb, BoxesRunTime.unboxToChar(object))).append(tooLong ? "...\"" : "\"").toString();
        }

        public StringBuilder appendChar(StringBuilder sb, char c) {
            char c2 = c;
            switch (c2) {
                case '\"': {
                    return sb.append("\\\"");
                }
                case '\t': {
                    return sb.append("\\t");
                }
                case '\r': {
                    return sb.append("\\r");
                }
                case '\n': {
                    return sb.append("\\n");
                }
            }
            char x = c2;
            if (Character.isISOControl(x)) {
                return sb.append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%04x"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(x)})));
            }
            char x2 = c2;
            return sb.append(x2);
        }

        public StringBuilder appendIndent(StringBuilder sb, int level) {
            return this.rec$1(level, sb);
        }

        public StringBuilder appendLevelCount(StringBuilder sb, long count, long size) {
            StringBuilder stringBuilder;
            String countStr = BoxesRunTime.boxToLong(count).toString();
            this.gutterWidth_$eq(package$.MODULE$.max(this.gutterWidth(), this.initialGutterWidth()));
            if (size >= 0L) {
                String sizeStr = BoxesRunTime.boxToLong(size).toString();
                this.gutterWidth_$eq(package$.MODULE$.max(this.gutterWidth(), sizeStr.length() * 2 + 1));
                this.pad$1(this.gutterWidth() - sizeStr.length() - countStr.length() - 1, sb).append(countStr);
                stringBuilder = sb.append('/').append(sizeStr);
            } else {
                this.gutterWidth_$eq(package$.MODULE$.max(this.gutterWidth(), countStr.length()));
                stringBuilder = this.pad$1(this.gutterWidth() - countStr.length(), sb).append(countStr);
            }
            return sb.append('|').append(' ');
        }

        public void render(String item, boolean levelOpen, boolean levelClose) {
            LevelInfo inf = this.info();
            int level = inf.level();
            long levelCount = inf.levelCount();
            long levelSize = inf.levelSize();
            ElementType levelType = inf.elementType();
            int maxShown = levelType instanceof ElementType.MapEntry ? this.maxShownMapEntries() : this.maxShownArrayElems();
            int shownHalf = maxShown >> 1;
            long ellipsisCount = levelSize - (long)shownHalf;
            if (levelSize <= (long)maxShown || levelCount <= (long)(shownHalf + (maxShown & 1)) || levelCount > ellipsisCount) {
                StringBuilder sb = new StringBuilder();
                if (this.renderLevelCount()) {
                    this.appendLevelCount(sb, levelCount, levelSize);
                }
                this.appendIndent(sb, level);
                ElementType elementType = levelType;
                Logging$ElementType$MapValue$ logging$ElementType$MapValue$ = Logging$ElementType$MapValue$.MODULE$;
                if (!(elementType != null ? !elementType.equals(logging$ElementType$MapValue$) : logging$ElementType$MapValue$ != null) && !levelClose) {
                    sb.append(this.mapKeySep());
                }
                sb.append(item);
                if (this.renderCommas() && level > 0 && !levelOpen) {
                    ElementType elementType2 = levelType;
                    Logging$ElementType$MapKey$ logging$ElementType$MapKey$ = Logging$ElementType$MapKey$.MODULE$;
                    if ((elementType2 == null ? logging$ElementType$MapKey$ != null : !elementType2.equals(logging$ElementType$MapKey$)) && (levelSize < 0L || levelCount < levelSize)) {
                        sb.append(',');
                    }
                }
                this.renderLine(sb.toString());
                return;
            }
            if (levelCount == ellipsisCount) {
                ElementType elementType = levelType;
                Logging$ElementType$MapKey$ logging$ElementType$MapKey$ = Logging$ElementType$MapKey$.MODULE$;
                if (elementType == null ? logging$ElementType$MapKey$ != null : !elementType.equals(logging$ElementType$MapKey$)) {
                    StringBuilder sb = new StringBuilder();
                    this.appendIndent(sb, level);
                    sb.append("...");
                    this.renderLine(sb.toString());
                    return;
                }
            }
        }

        public boolean render$default$2() {
            return false;
        }

        public boolean render$default$3() {
            return false;
        }

        private final /* synthetic */ StringBuilder formatString$$anonfun$1(StringBuilder sb, char c) {
            return this.appendChar(sb, c);
        }

        private final StringBuilder rec$1(int remaining, StringBuilder sb) {
            while (remaining > 0) {
                int n = remaining - 1;
                StringBuilder stringBuilder = sb.append(this.indentation());
                remaining = n;
                sb = stringBuilder;
            }
            return sb;
        }

        private final StringBuilder pad$1(int remaining, StringBuilder sb) {
            while (remaining > 0) {
                int n = remaining - 1;
                StringBuilder stringBuilder = sb.append(' ');
                remaining = n;
                sb = stringBuilder;
            }
            return sb;
        }
    }

    public static interface Logger {
        public void onNull();

        public void onUndefined();

        public void onBool(boolean var1);

        public void onInt(int var1);

        public void onLong(long var1);

        public void onOverLong(boolean var1, long var2);

        public void onFloat16(float var1);

        public void onFloat(float var1);

        public void onDouble(double var1);

        public void onDecimal(long var1, int var3);

        public void onNumberString(String var1);

        public <Bytes> void onBytes(Bytes var1, ByteAccess<Bytes> var2);

        public void onBytesStart();

        public void onString(String var1);

        public void onChars(char[] var1, int var2);

        public <Bytes> void onText(Bytes var1, ByteAccess<Bytes> var2);

        public void onTextStart();

        public void onArrayHeader(long var1);

        public void onArrayStart();

        public void onMapHeader(long var1);

        public void onMapStart();

        public void onTag(Tag var1);

        public void onSimpleValue(int var1);

        public void onLevelExited(ElementType var1, boolean var2);

        public void onEndOfInput();
    }

    public static class PrintLogger
    extends LineFormatLogger {
        private final LevelInfo info;
        private final int maxShownByteArrayPrefixLen;
        private final int maxShownStringPrefixLen;
        private final int maxShownArrayElems;
        private final int maxShownMapEntries;
        private final int initialGutterWidth;
        private final boolean renderLevelCount;
        private final boolean renderEndOfInput;
        private final boolean renderCommas;
        private final String indentation;
        private final String mapKeySep;

        public PrintLogger(LevelInfo info, int maxShownByteArrayPrefixLen, int maxShownStringPrefixLen, int maxShownArrayElems, int maxShownMapEntries, int initialGutterWidth, boolean renderLevelCount, boolean renderEndOfInput, boolean renderCommas, String indentation, String mapKeySep) {
            this.info = info;
            this.maxShownByteArrayPrefixLen = maxShownByteArrayPrefixLen;
            this.maxShownStringPrefixLen = maxShownStringPrefixLen;
            this.maxShownArrayElems = maxShownArrayElems;
            this.maxShownMapEntries = maxShownMapEntries;
            this.initialGutterWidth = initialGutterWidth;
            this.renderLevelCount = renderLevelCount;
            this.renderEndOfInput = renderEndOfInput;
            this.renderCommas = renderCommas;
            this.indentation = indentation;
            this.mapKeySep = mapKeySep;
        }

        @Override
        public LevelInfo info() {
            return this.info;
        }

        @Override
        public int maxShownByteArrayPrefixLen() {
            return this.maxShownByteArrayPrefixLen;
        }

        @Override
        public int maxShownStringPrefixLen() {
            return this.maxShownStringPrefixLen;
        }

        @Override
        public int maxShownArrayElems() {
            return this.maxShownArrayElems;
        }

        @Override
        public int maxShownMapEntries() {
            return this.maxShownMapEntries;
        }

        @Override
        public int initialGutterWidth() {
            return this.initialGutterWidth;
        }

        @Override
        public boolean renderLevelCount() {
            return this.renderLevelCount;
        }

        @Override
        public boolean renderEndOfInput() {
            return this.renderEndOfInput;
        }

        @Override
        public boolean renderCommas() {
            return this.renderCommas;
        }

        @Override
        public String indentation() {
            return this.indentation;
        }

        @Override
        public String mapKeySep() {
            return this.mapKeySep;
        }

        @Override
        public void renderLine(String line) {
            Predef$.MODULE$.println(line);
        }
    }

    public static final class Receiver
    extends io.bullet.borer.Receiver
    implements LevelInfo {
        private final io.bullet.borer.Receiver target;
        private final Logger logger;
        private int _level;
        private long[] _levelCount;
        private long[] _levelSize;

        public Receiver(io.bullet.borer.Receiver target, Function1<LevelInfo, Logger> createLogger) {
            this.target = target;
            this.logger = createLogger.apply(this);
            this._level = 0;
            this._levelCount = new long[4];
            this._levelSize = new long[4];
            this._levelCount[0] = -1L;
        }

        @Override
        public int level() {
            return this._level;
        }

        @Override
        public long levelCount() {
            if (this._level >= 0) {
                long count = this._levelCount[this._level];
                long size = this._levelSize[this._level];
                long rawCount = count >= 0L ? (size >= 0L ? count : count >> 1) : (size == 1L ? (count ^ 0xFFFFFFFFFFFFFFFFL) >> 1 : count ^ 0xFFFFFFFFFFFFFFFFL);
                return rawCount + 1L;
            }
            return 0L;
        }

        @Override
        public long levelSize() {
            if (this._level >= 0) {
                long count = this._levelCount[this._level];
                if (count >= 0L) {
                    long size = this._levelSize[this._level];
                    if (size >= 0L) {
                        return size;
                    }
                    return (size ^ 0xFFFFFFFFFFFFFFFFL) >> 1;
                }
                return -1L;
            }
            return -1L;
        }

        @Override
        public ElementType elementType() {
            if (this._level >= 0) {
                ElementType elementType;
                long count = this._levelCount[this._level];
                long size = this._levelSize[this._level];
                if (count >= 0L) {
                    if (size >= 0L) {
                        return Logging$ElementType$ArrayElement$.MODULE$;
                    }
                    return (ElementType)((Object)((count & 1L) == 0L ? Logging$ElementType$MapKey$.MODULE$ : Logging$ElementType$MapValue$.MODULE$));
                }
                long l = size;
                if (0L == l) {
                    elementType = Logging$ElementType$ArrayElement$.MODULE$;
                } else if (1L == l) {
                    elementType = (count & 1L) != 0L ? Logging$ElementType$MapKey$.MODULE$ : Logging$ElementType$MapValue$.MODULE$;
                } else if (2L == l) {
                    elementType = Logging$ElementType$UnboundedByteStringElement$.MODULE$;
                } else if (3L == l) {
                    elementType = Logging$ElementType$UnboundedTextStringElement$.MODULE$;
                } else {
                    throw new IllegalStateException();
                }
                return elementType;
            }
            return Logging$ElementType$ArrayElement$.MODULE$;
        }

        @Override
        public void onNull() {
            this.logger.onNull();
            this.count();
            this.target.onNull();
        }

        @Override
        public void onUndefined() {
            this.logger.onUndefined();
            this.count();
            this.target.onUndefined();
        }

        @Override
        public void onBoolean(boolean value) {
            this.logger.onBool(value);
            this.count();
            this.target.onBoolean(value);
        }

        @Override
        public void onInt(int value) {
            this.logger.onInt(value);
            this.count();
            this.target.onInt(value);
        }

        @Override
        public void onLong(long value) {
            this.logger.onLong(value);
            this.count();
            this.target.onLong(value);
        }

        @Override
        public void onOverLong(boolean negative, long value) {
            this.logger.onOverLong(negative, value);
            this.count();
            this.target.onOverLong(negative, value);
        }

        @Override
        public void onFloat16(float value) {
            this.logger.onFloat16(value);
            this.count();
            this.target.onFloat16(value);
        }

        @Override
        public void onFloat(float value) {
            this.logger.onFloat(value);
            this.count();
            this.target.onFloat(value);
        }

        @Override
        public void onDouble(double value) {
            this.logger.onDouble(value);
            this.count();
            this.target.onDouble(value);
        }

        @Override
        public void onNumberString(String value) {
            this.logger.onNumberString(value);
            this.count();
            this.target.onNumberString(value);
        }

        @Override
        public <Bytes> void onBytes(Bytes value, ByteAccess<Bytes> evidence$1) {
            this.logger.onBytes(value, evidence$1);
            this.count();
            this.target.onBytes(value, evidence$1);
        }

        @Override
        public void onBytesStart() {
            this.logger.onBytesStart();
            this.enterLevel(-1L, 2L);
            this.target.onBytesStart();
        }

        @Override
        public void onString(String value) {
            this.logger.onString(value);
            this.count();
            this.target.onString(value);
        }

        @Override
        public void onChars(char[] buffer, int length) {
            this.logger.onChars(buffer, length);
            this.count();
            this.target.onChars(buffer, length);
        }

        @Override
        public <Bytes> void onText(Bytes value, ByteAccess<Bytes> evidence$1) {
            this.logger.onText(value, evidence$1);
            this.count();
            this.target.onText(value, evidence$1);
        }

        @Override
        public void onTextStart() {
            this.logger.onTextStart();
            this.enterLevel(-1L, 3L);
            this.target.onTextStart();
        }

        @Override
        public void onArrayHeader(long length) {
            this.logger.onArrayHeader(length);
            if (length > 0L) {
                this.enterLevel(0L, length);
            } else {
                this.count();
            }
            this.target.onArrayHeader(length);
        }

        @Override
        public void onArrayStart() {
            this.logger.onArrayStart();
            this.enterLevel(-1L, 0L);
            this.target.onArrayStart();
        }

        @Override
        public void onMapHeader(long length) {
            this.logger.onMapHeader(length);
            if (length > 0L) {
                this.enterLevel(0L, length << 1 ^ 0xFFFFFFFFFFFFFFFFL);
            } else {
                this.count();
            }
            this.target.onMapHeader(length);
        }

        @Override
        public void onMapStart() {
            this.logger.onMapStart();
            this.enterLevel(-1L, 1L);
            this.target.onMapStart();
        }

        @Override
        public void onBreak() {
            ElementType exitedLevelType = this.elementType();
            this.exitLevel();
            this.logger.onLevelExited(exitedLevelType, true);
            this.count();
            this.target.onBreak();
        }

        @Override
        public void onTag(Tag value) {
            this.logger.onTag(value);
            this.target.onTag(value);
        }

        @Override
        public void onSimpleValue(int value) {
            this.logger.onSimpleValue(value);
            this.count();
            this.target.onSimpleValue(value);
        }

        @Override
        public void onEndOfInput() {
            this.logger.onEndOfInput();
            this.target.onEndOfInput();
        }

        private void count() {
            while (this._level >= 0) {
                long cnt = this._levelCount[this._level];
                if (cnt >= 0L) {
                    long size;
                    long newCount = cnt + 1L;
                    long rawSize = this._levelSize[this._level];
                    long l = size = rawSize >= 0L ? rawSize : rawSize ^ 0xFFFFFFFFFFFFFFFFL;
                    if (newCount == size) {
                        ElementType exitedLevelType = this.elementType();
                        this.exitLevel();
                        this.logger.onLevelExited(exitedLevelType, false);
                        continue;
                    }
                    this._levelCount[this._level] = newCount;
                    return;
                }
                this._levelCount[this._level] = cnt - 1L;
                return;
            }
        }

        private void enterLevel(long count, long size) {
            int newLevel = this._level + 1;
            if (newLevel == this._levelCount.length) {
                int l2 = newLevel << 1;
                int newLen = l2 >= 0 ? l2 : Integer.MAX_VALUE;
                this._levelCount = Arrays.copyOf(this._levelCount, newLen);
                this._levelSize = Arrays.copyOf(this._levelSize, newLen);
            }
            this._level = newLevel;
            this._levelCount[newLevel] = count;
            this._levelSize[newLevel] = size;
        }

        private void exitLevel() {
            --this._level;
        }
    }

    public static class ToStringLogger
    extends LineFormatLogger {
        private final LevelInfo info;
        private final StringBuilder stringBuilder;
        private final int maxShownByteArrayPrefixLen;
        private final int maxShownStringPrefixLen;
        private final int maxShownArrayElems;
        private final int maxShownMapEntries;
        private final int initialGutterWidth;
        private final boolean renderLevelCount;
        private final boolean renderEndOfInput;
        private final boolean renderCommas;
        private final String indentation;
        private final String mapKeySep;
        private final String lineSep;
        private final boolean mapValueOnNewLine;

        public ToStringLogger(LevelInfo info, StringBuilder stringBuilder, int maxShownByteArrayPrefixLen, int maxShownStringPrefixLen, int maxShownArrayElems, int maxShownMapEntries, int initialGutterWidth, boolean renderLevelCount, boolean renderEndOfInput, boolean renderCommas, String indentation, String mapKeySep, String lineSep, boolean mapValueOnNewLine) {
            this.info = info;
            this.stringBuilder = stringBuilder;
            this.maxShownByteArrayPrefixLen = maxShownByteArrayPrefixLen;
            this.maxShownStringPrefixLen = maxShownStringPrefixLen;
            this.maxShownArrayElems = maxShownArrayElems;
            this.maxShownMapEntries = maxShownMapEntries;
            this.initialGutterWidth = initialGutterWidth;
            this.renderLevelCount = renderLevelCount;
            this.renderEndOfInput = renderEndOfInput;
            this.renderCommas = renderCommas;
            this.indentation = indentation;
            this.mapKeySep = mapKeySep;
            this.lineSep = lineSep;
            this.mapValueOnNewLine = mapValueOnNewLine;
        }

        @Override
        public LevelInfo info() {
            return this.info;
        }

        public StringBuilder stringBuilder() {
            return this.stringBuilder;
        }

        @Override
        public int maxShownByteArrayPrefixLen() {
            return this.maxShownByteArrayPrefixLen;
        }

        @Override
        public int maxShownStringPrefixLen() {
            return this.maxShownStringPrefixLen;
        }

        @Override
        public int maxShownArrayElems() {
            return this.maxShownArrayElems;
        }

        @Override
        public int maxShownMapEntries() {
            return this.maxShownMapEntries;
        }

        @Override
        public int initialGutterWidth() {
            return this.initialGutterWidth;
        }

        @Override
        public boolean renderLevelCount() {
            return this.renderLevelCount;
        }

        @Override
        public boolean renderEndOfInput() {
            return this.renderEndOfInput;
        }

        @Override
        public boolean renderCommas() {
            return this.renderCommas;
        }

        @Override
        public String indentation() {
            return this.indentation;
        }

        @Override
        public String mapKeySep() {
            return this.mapKeySep;
        }

        public String lineSep() {
            return this.lineSep;
        }

        public boolean mapValueOnNewLine() {
            return this.mapValueOnNewLine;
        }

        @Override
        public void renderLine(String line) {
            block3: {
                block2: {
                    this.stringBuilder().append(line);
                    if (this.mapValueOnNewLine()) break block2;
                    ElementType elementType = this.info().elementType();
                    Logging$ElementType$MapKey$ logging$ElementType$MapKey$ = Logging$ElementType$MapKey$.MODULE$;
                    if (!(elementType == null ? logging$ElementType$MapKey$ != null : !elementType.equals(logging$ElementType$MapKey$))) break block3;
                }
                this.stringBuilder().append(this.lineSep());
                return;
            }
        }

        @Override
        public StringBuilder appendIndent(StringBuilder sb, int level) {
            if (this.mapValueOnNewLine() || this.lineStart()) {
                return super.appendIndent(sb, level);
            }
            return sb;
        }

        @Override
        public StringBuilder appendLevelCount(StringBuilder sb, long count, long size) {
            if (this.mapValueOnNewLine() || this.lineStart()) {
                return super.appendLevelCount(sb, count, size);
            }
            return sb;
        }

        private boolean lineStart() {
            return this.stringBuilder().length() == 0 || this.lineSep().isEmpty() || this.stringBuilder().charAt(this.stringBuilder().length() - 1) == StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(this.lineSep()));
        }
    }
}

