/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer;

import io.bullet.borer.Borer;
import io.bullet.borer.ByteAccess;
import io.bullet.borer.ByteAccess$ForByteArray$;
import io.bullet.borer.DataItem$;
import io.bullet.borer.Decoder;
import io.bullet.borer.Input;
import io.bullet.borer.Input$;
import io.bullet.borer.Reader;
import io.bullet.borer.Receiver;
import io.bullet.borer.Tag;
import io.bullet.borer.Target;
import io.bullet.borer.Utf8$;
import io.bullet.borer.internal.ElementDeque;
import io.bullet.borer.internal.Parser;
import io.bullet.borer.internal.Receptacle;
import io.bullet.borer.internal.ResizableByteRingBuffer;
import io.bullet.borer.internal.Util$;
import io.bullet.borer.json.DirectJsonParser;
import io.bullet.borer.json.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import scala.Function1;
import scala.Function2;
import scala.collection.Factory;
import scala.collection.mutable.Builder;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;

public final class InputReader<Config extends Reader.Config> {
    private final Parser<?> parser;
    private final DirectJsonParser directParser;
    private final Target target;
    private final boolean configReadIntegersAlsoAsFloatingPoint;
    private final boolean configReadDoubleAlsoAsFloat;
    private final Receptacle receptacle;
    private final Receiver receiver;
    private int _dataItem;
    private ElementDeque stash;

    public InputReader(Parser<?> parser, DirectJsonParser directParser, Function2<Receiver, Config, Receiver> receiverWrapper, Config config, Target target) {
        this.parser = parser;
        this.directParser = directParser;
        this.target = target;
        this.configReadIntegersAlsoAsFloatingPoint = config.readIntegersAlsoAsFloatingPoint();
        this.configReadDoubleAlsoAsFloat = config.readDoubleAlsoAsFloat();
        this.receptacle = new Receptacle();
        this.receiver = receiverWrapper.apply(this.receptacle, config);
    }

    public Target target() {
        return this.target;
    }

    public ElementDeque stash() {
        return this.stash;
    }

    public void stash_$eq(ElementDeque x$1) {
        this.stash = x$1;
    }

    public void release() {
        if (this.directParser == null) {
            Parser<?> parser = this.parser;
            if (parser instanceof JsonParser) {
                JsonParser x = (JsonParser)parser;
                x.release();
                return;
            }
            return;
        }
        this.directParser.release();
    }

    public int dataItem() {
        if (this._dataItem == 0) {
            this._dataItem = this.stash() != null ? this.pullFromStash$1() : (this.directParser != null ? this.directParser.pull(this.receiver) : this.parser.pull(this.receiver));
        }
        return this._dataItem;
    }

    public int receiveInto(Receiver rcv) {
        int result = this.dataItem();
        this.receptacle.pushInto(rcv, result);
        this.inline$_dataItem_$eq(0);
        return result;
    }

    public Input<?> input() {
        if (this.directParser != null) {
            return this.directParser.input();
        }
        return this.parser.input();
    }

    public long cursor() {
        if (this.directParser != null) {
            return this.directParser.valueIndex();
        }
        return this.parser.valueIndex();
    }

    public Null$ readNull() {
        if (this.hasNull()) {
            Null$ value$proxy1 = null;
            InputReader InputReader_this = this;
            InputReader_this.inline$_dataItem_$eq(0);
            return value$proxy1;
        }
        throw this.unexpectedDataItem("null");
    }

    public boolean hasNull() {
        return this.dataItem() == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadNull() {
        boolean value$proxy2 = this.hasNull();
        if (!value$proxy2) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public InputReader readUndefined() {
        if (this.hasUndefined()) {
            InputReader InputReader_this = this;
            InputReader_this.inline$_dataItem_$eq(0);
            return this;
        }
        throw this.unexpectedDataItem("undefined");
    }

    public boolean hasUndefined() {
        return this.dataItem() == 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadUndefined() {
        boolean value$proxy3 = this.hasUndefined();
        if (!value$proxy3) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public boolean readBoolean() {
        if (this.hasBoolean()) {
            this.inline$_dataItem_$eq(0);
            Receptacle Receptacle_this = this.receptacle;
            return Receptacle_this.inline$_bool();
        }
        throw this.unexpectedDataItem("Bool");
    }

    public boolean hasBoolean() {
        return this.dataItem() == 4;
    }

    public boolean hasBoolean(boolean value) {
        Receptacle Receptacle_this;
        return this.hasBoolean() && (Receptacle_this = this.receptacle).inline$_bool() == value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadBoolean(boolean value) {
        boolean value$proxy4 = this.hasBoolean(value);
        if (!value$proxy4) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public char readChar() {
        if (this.hasChar()) {
            this.inline$_dataItem_$eq(0);
            Receptacle Receptacle_this = this.receptacle;
            return (char)Receptacle_this.inline$_int();
        }
        throw this.unexpectedDataItem("Char");
    }

    public boolean hasChar() {
        Receptacle Receptacle_this;
        int x$proxy1;
        return this.hasInt() && (x$proxy1 = (Receptacle_this = this.receptacle).inline$_int()) >> 16 == 0;
    }

    public boolean hasChar(char value) {
        Receptacle Receptacle_this;
        return this.hasChar() && (Receptacle_this = this.receptacle).inline$_int() == value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadChar(char value) {
        boolean value$proxy5 = this.hasChar(value);
        if (!value$proxy5) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public byte readByte() {
        if (this.hasByte()) {
            this.inline$_dataItem_$eq(0);
            Receptacle Receptacle_this = this.receptacle;
            return (byte)Receptacle_this.inline$_int();
        }
        throw this.unexpectedDataItem("Byte");
    }

    public boolean hasByte() {
        Receptacle Receptacle_this;
        int x$proxy2;
        return this.hasInt() && (x$proxy2 = (Receptacle_this = this.receptacle).inline$_int()) >> 7 == x$proxy2 >> 31;
    }

    public boolean hasByte(byte value) {
        Receptacle Receptacle_this;
        return this.hasByte() && (Receptacle_this = this.receptacle).inline$_int() == value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadByte(byte value) {
        boolean value$proxy6 = this.hasByte(value);
        if (!value$proxy6) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public short readShort() {
        if (this.hasShort()) {
            this.inline$_dataItem_$eq(0);
            Receptacle Receptacle_this = this.receptacle;
            return (short)Receptacle_this.inline$_int();
        }
        throw this.unexpectedDataItem("Short");
    }

    public boolean hasShort() {
        Receptacle Receptacle_this;
        int x$proxy3;
        return this.hasInt() && (x$proxy3 = (Receptacle_this = this.receptacle).inline$_int()) >> 15 == x$proxy3 >> 31;
    }

    public boolean hasShort(short value) {
        Receptacle Receptacle_this;
        return this.hasShort() && (Receptacle_this = this.receptacle).inline$_int() == value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadShort(short value) {
        boolean value$proxy7 = this.hasShort(value);
        if (!value$proxy7) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public int readInt() {
        if (this.hasInt()) {
            this.inline$_dataItem_$eq(0);
            Receptacle Receptacle_this = this.receptacle;
            return Receptacle_this.inline$_int();
        }
        throw this.unexpectedDataItem("Int");
    }

    public boolean hasInt() {
        return this.dataItem() == 8;
    }

    public boolean hasInt(int value) {
        Receptacle Receptacle_this;
        return this.hasInt() && (Receptacle_this = this.receptacle).inline$_int() == value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadInt(int value) {
        boolean value$proxy8 = this.hasInt(value);
        if (!value$proxy8) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public long readLong() {
        if (this.hasLong()) {
            long l;
            if (this.hasInt()) {
                Receptacle Receptacle_this = this.receptacle;
                l = Receptacle_this.inline$_int();
            } else {
                Receptacle Receptacle_this = this.receptacle;
                l = Receptacle_this.inline$_long();
            }
            long result = l;
            this.inline$_dataItem_$eq(0);
            return result;
        }
        throw this.unexpectedDataItem("Long");
    }

    public boolean hasLong() {
        return (this.dataItem() & 0x18) != 0;
    }

    public boolean hasLong(long value) {
        Receptacle Receptacle_this;
        Receptacle Receptacle_this2;
        return this.hasInt() && (long)(Receptacle_this2 = this.receptacle).inline$_int() == value || this.hasLong() && (Receptacle_this = this.receptacle).inline$_long() == value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadLong(long value) {
        boolean value$proxy9 = this.hasLong(value);
        if (!value$proxy9) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public int longCompare(long value) {
        if (this.hasLong()) {
            long l;
            if (this.hasInt()) {
                Receptacle Receptacle_this = this.receptacle;
                l = Receptacle_this.inline$_int();
            } else {
                Receptacle Receptacle_this = this.receptacle;
                l = Receptacle_this.inline$_long();
            }
            long l2 = l;
            return (int)package$.MODULE$.signum(l2 - value);
        }
        return Integer.MAX_VALUE;
    }

    public int tryReadLongCompare(long value) {
        int result = this.longCompare(value);
        if (result == 0) {
            this.inline$_dataItem_$eq(0);
        }
        return result;
    }

    public long readOverLong() {
        if (this.hasOverLong()) {
            this.inline$_dataItem_$eq(0);
            Receptacle Receptacle_this = this.receptacle;
            return Receptacle_this.inline$_long();
        }
        throw this.unexpectedDataItem("OverLong");
    }

    public boolean hasOverLong() {
        return this.dataItem() == 32;
    }

    public boolean hasOverLong(long value) {
        Receptacle Receptacle_this;
        return this.hasOverLong() && (Receptacle_this = this.receptacle).inline$_long() == value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadOverLong(long value) {
        boolean value$proxy10 = this.hasOverLong(value);
        if (!value$proxy10) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public boolean overLongNegative() {
        if (this.hasOverLong()) {
            Receptacle Receptacle_this = this.receptacle;
            return Receptacle_this.inline$_bool();
        }
        throw this.unexpectedDataItem("OverLong");
    }

    public float readFloat16() {
        if (this.hasFloat16()) {
            this.inline$_dataItem_$eq(0);
            Receptacle Receptacle_this = this.receptacle;
            return Receptacle_this.inline$_float();
        }
        throw this.unexpectedDataItem("Float16");
    }

    public boolean hasFloat16() {
        return this.dataItem() == 64;
    }

    public boolean hasFloat16(float value) {
        Receptacle Receptacle_this;
        return this.hasFloat16() && (Receptacle_this = this.receptacle).inline$_float() == value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadFloat16(float value) {
        boolean value$proxy11 = this.hasFloat16(value);
        if (!value$proxy11) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public float readFloat() {
        float f;
        int n = this.dataItem();
        if (64 == n || 128 == n) {
            Receptacle Receptacle_this = this.receptacle;
            f = Receptacle_this.inline$_float();
        } else if (256 == n && this.configReadDoubleAlsoAsFloat) {
            Receptacle Receptacle_this = this.receptacle;
            f = (float)Receptacle_this.inline$_double();
        } else if (8 == n && this.configReadIntegersAlsoAsFloatingPoint) {
            Receptacle Receptacle_this = this.receptacle;
            f = Receptacle_this.inline$_int();
        } else if (16 == n && this.configReadIntegersAlsoAsFloatingPoint) {
            Receptacle Receptacle_this = this.receptacle;
            f = Receptacle_this.inline$_long();
        } else if (512 == n) {
            Receptacle Receptacle_this = this.receptacle;
            f = Float.parseFloat((String)Receptacle_this.inline$_obj());
        } else {
            throw this.unexpectedDataItem("Float");
        }
        float result = f;
        this.inline$_dataItem_$eq(0);
        return result;
    }

    public boolean hasFloat() {
        return (this.dataItem() & 0x2C0) != 0 || this.configReadIntegersAlsoAsFloatingPoint && this.hasLong() || this.configReadDoubleAlsoAsFloat && this.dataItem() == 256;
    }

    public boolean hasFloat(float value) {
        Receptacle Receptacle_this;
        return this.hasFloat() && (Receptacle_this = this.receptacle).inline$_float() == value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadFloat(float value) {
        boolean value$proxy12 = this.hasFloat(value);
        if (!value$proxy12) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public double readDouble() {
        double d;
        int n = this.dataItem();
        switch (n) {
            case 256: {
                Receptacle Receptacle_this = this.receptacle;
                d = Receptacle_this.inline$_double();
                break;
            }
            case 64: 
            case 128: {
                Receptacle Receptacle_this = this.receptacle;
                d = Receptacle_this.inline$_float();
                break;
            }
            default: {
                if (8 == n && this.configReadIntegersAlsoAsFloatingPoint) {
                    Receptacle Receptacle_this = this.receptacle;
                    d = Receptacle_this.inline$_int();
                    break;
                }
                if (16 == n && this.configReadIntegersAlsoAsFloatingPoint) {
                    Receptacle Receptacle_this = this.receptacle;
                    d = Receptacle_this.inline$_long();
                    break;
                }
                if (512 == n) {
                    Receptacle Receptacle_this = this.receptacle;
                    d = Double.parseDouble((String)Receptacle_this.inline$_obj());
                    break;
                }
                throw this.unexpectedDataItem("Double");
            }
        }
        double result = d;
        this.inline$_dataItem_$eq(0);
        return result;
    }

    public boolean hasDouble() {
        return (this.dataItem() & 0x3C0) != 0 || this.configReadIntegersAlsoAsFloatingPoint && this.hasLong();
    }

    public boolean hasDouble(double value) {
        Receptacle Receptacle_this;
        return this.hasDouble() && (Receptacle_this = this.receptacle).inline$_double() == value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadDouble(double value) {
        boolean value$proxy13 = this.hasDouble(value);
        if (!value$proxy13) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public String readNumberString() {
        if (this.hasNumberString()) {
            Receptacle Receptacle_this = this.receptacle;
            String value$proxy14 = (String)Receptacle_this.inline$_obj();
            InputReader InputReader_this = this;
            InputReader_this.inline$_dataItem_$eq(0);
            return value$proxy14;
        }
        throw this.unexpectedDataItem("NumberString");
    }

    public boolean hasNumberString() {
        return this.dataItem() == 512;
    }

    public boolean hasNumberString(String value) {
        return this.hasNumberString() && this.stringCompare(value) == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadNumberString(String value) {
        boolean value$proxy15 = this.hasNumberString(value);
        if (!value$proxy15) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public byte[] readByteArray() {
        return this.readBytes(ByteAccess$ForByteArray$.MODULE$);
    }

    public <Bytes> Bytes readBytes(ByteAccess<Bytes> evidence$1) {
        int n = this.dataItem();
        if (16384 == n) {
            return this.readSizedBytes(evidence$1);
        }
        if (32768 == n) {
            return this.readUnsizedBytes(evidence$1);
        }
        throw this.unexpectedDataItem("Bytes");
    }

    public boolean hasBytes() {
        return (this.dataItem() & 0xC000) != 0;
    }

    public <Bytes> Bytes readSizedBytes(ByteAccess<Bytes> byteAccess) {
        if (this.hasSizedBytes()) {
            Receptacle Receptacle_this = this.receptacle;
            Bytes value$proxy16 = byteAccess.convert(Receptacle_this.inline$_obj(), Receptacle_this.inline$_byteAccess());
            InputReader InputReader_this = this;
            InputReader_this.inline$_dataItem_$eq(0);
            return value$proxy16;
        }
        throw this.unexpectedDataItem("Bounded Bytes");
    }

    public boolean hasSizedBytes() {
        return this.dataItem() == 16384;
    }

    public InputReader readBytesStart() {
        if (this.tryReadBytesStart()) {
            return this;
        }
        throw this.unexpectedDataItem("Unbounded Bytes-Start");
    }

    public boolean hasBytesStart() {
        return this.dataItem() == 32768;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadBytesStart() {
        boolean value$proxy17 = this.hasBytesStart();
        if (!value$proxy17) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public <Bytes> Bytes readUnsizedBytes(ByteAccess<Bytes> byteAccess) {
        if (this.hasUnsizedBytes()) {
            return this.bufferUnsizedBytes(byteAccess).readSizedBytes(byteAccess);
        }
        throw this.unexpectedDataItem("Unbounded Bytes");
    }

    public boolean hasUnsizedBytes() {
        return this.hasBytesStart();
    }

    public <Bytes> InputReader bufferUnsizedBytes(ByteAccess<Bytes> byteAccess) {
        if (this.tryReadBytesStart()) {
            Bytes result = byteAccess.empty();
            while (!this.tryReadBreak()) {
                result = byteAccess.concat(result, this.readBytes(byteAccess));
            }
            this.receptacle.onBytes(result, byteAccess);
            this._dataItem = 16384;
        }
        return this;
    }

    public String readString() {
        int n = this.dataItem();
        switch (n) {
            case 2048: {
                Receptacle Receptacle_this = this.receptacle;
                Receptacle Receptacle_this2 = this.receptacle;
                String value$proxy18 = new String((char[])Receptacle_this.inline$_obj(), 0, Receptacle_this2.inline$_int());
                InputReader InputReader_this = this;
                InputReader_this.inline$_dataItem_$eq(0);
                return value$proxy18;
            }
            case 1024: {
                Receptacle Receptacle_this = this.receptacle;
                String value$proxy19 = (String)Receptacle_this.inline$_obj();
                InputReader InputReader_this = this;
                InputReader_this.inline$_dataItem_$eq(0);
                return value$proxy19;
            }
            case 4096: {
                byte[] bytes$proxy1 = this.readSizedTextBytes(ByteAccess$ForByteArray$.MODULE$);
                if (bytes$proxy1.length > 0) {
                    return new String(bytes$proxy1, StandardCharsets.UTF_8);
                }
                return "";
            }
            case 8192: {
                byte[] bytes$proxy2 = this.readUnsizedTextBytes(ByteAccess$ForByteArray$.MODULE$);
                if (bytes$proxy2.length > 0) {
                    return new String(bytes$proxy2, StandardCharsets.UTF_8);
                }
                return "";
            }
        }
        throw this.unexpectedDataItem("String or Text-Bytes");
    }

    public InputReader readString(String s2) {
        if (this.tryReadString(s2)) {
            return this;
        }
        throw this.unexpectedDataItem(new StringBuilder(2).append("\"").append(s2).append("\"").toString());
    }

    public boolean hasString() {
        return (this.dataItem() & 0x3C00) != 0;
    }

    public boolean hasString(String value) {
        block5: while (true) {
            int n = this_.dataItem();
            switch (n) {
                case 2048: {
                    Receptacle Receptacle_this = this_.receptacle;
                    Receptacle Receptacle_this2 = this_.receptacle;
                    return Util$.MODULE$.charsStringCompare((char[])Receptacle_this.inline$_obj(), Receptacle_this2.inline$_int(), value) == 0;
                }
                case 1024: {
                    Receptacle Receptacle_this = this_.receptacle;
                    String string2 = (String)Receptacle_this.inline$_obj();
                    String string3 = value;
                    return !(string2 != null ? !string2.equals(string3) : string3 != null);
                }
                case 4096: 
                case 8192: {
                    InputReader this_ = this_.decodeTextBytes();
                    continue block5;
                }
            }
            break;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadString(String value) {
        boolean value$proxy20 = this.hasString(value);
        if (!value$proxy20) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public int stringCompare(String value) {
        block5: while (true) {
            int n = this_.dataItem();
            switch (n) {
                case 2048: {
                    Receptacle Receptacle_this = this_.receptacle;
                    Receptacle Receptacle_this2 = this_.receptacle;
                    return Util$.MODULE$.charsStringCompare((char[])Receptacle_this.inline$_obj(), Receptacle_this2.inline$_int(), value);
                }
                case 1024: {
                    Receptacle Receptacle_this = this_.receptacle;
                    return ((String)Receptacle_this.inline$_obj()).compareTo(value);
                }
                case 4096: 
                case 8192: {
                    InputReader this_ = this_.decodeTextBytes();
                    continue block5;
                }
            }
            break;
        }
        return Integer.MIN_VALUE;
    }

    public int tryReadStringCompare(String value) {
        int result = this.stringCompare(value);
        if (result == 0) {
            this.inline$_dataItem_$eq(0);
        }
        return result;
    }

    public char[] readChars() {
        int n = this.dataItem();
        switch (n) {
            case 2048: {
                Receptacle Receptacle_this = this.receptacle;
                Receptacle Receptacle_this2 = this.receptacle;
                char[] value$proxy21 = Arrays.copyOf((char[])Receptacle_this.inline$_obj(), Receptacle_this2.inline$_int());
                InputReader InputReader_this = this;
                InputReader_this.inline$_dataItem_$eq(0);
                return value$proxy21;
            }
            case 1024: {
                Receptacle Receptacle_this = this.receptacle;
                char[] value$proxy22 = ((String)Receptacle_this.inline$_obj()).toCharArray();
                InputReader InputReader_this = this;
                InputReader_this.inline$_dataItem_$eq(0);
                return value$proxy22;
            }
            case 4096: {
                return Utf8$.MODULE$.decode(this.readSizedTextBytes(ByteAccess$ForByteArray$.MODULE$));
            }
            case 8192: {
                return Utf8$.MODULE$.decode(this.readUnsizedTextBytes(ByteAccess$ForByteArray$.MODULE$));
            }
        }
        throw this.unexpectedDataItem("String or Text-Bytes");
    }

    public InputReader readChars(char[] chars) {
        if (this.tryReadChars(chars)) {
            return this;
        }
        throw this.unexpectedDataItem(new StringBuilder(2).append("\"").append(new String(chars)).append("\"").toString());
    }

    public boolean hasChars(char[] value) {
        block5: while (true) {
            int n = this_.dataItem();
            switch (n) {
                case 2048: {
                    Receptacle Receptacle_this = this_.receptacle;
                    Receptacle Receptacle_this2 = this_.receptacle;
                    return Util$.MODULE$.charsCharsCompare((char[])Receptacle_this.inline$_obj(), Receptacle_this2.inline$_int(), value) == 0;
                }
                case 1024: {
                    Receptacle Receptacle_this = this_.receptacle;
                    return Util$.MODULE$.charsStringCompare(value, value.length, (String)Receptacle_this.inline$_obj()) == 0;
                }
                case 4096: 
                case 8192: {
                    InputReader this_ = this_.decodeTextBytes();
                    continue block5;
                }
            }
            break;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadChars(char[] value) {
        boolean value$proxy23 = this.hasChars(value);
        if (!value$proxy23) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public int charsCompare(char[] value) {
        block5: while (true) {
            int n = this_.dataItem();
            switch (n) {
                case 2048: {
                    Receptacle Receptacle_this = this_.receptacle;
                    Receptacle Receptacle_this2 = this_.receptacle;
                    return Util$.MODULE$.charsCharsCompare((char[])Receptacle_this.inline$_obj(), Receptacle_this2.inline$_int(), value);
                }
                case 1024: {
                    Receptacle Receptacle_this = this_.receptacle;
                    return -Util$.MODULE$.charsStringCompare(value, value.length, (String)Receptacle_this.inline$_obj());
                }
                case 4096: 
                case 8192: {
                    InputReader this_ = this_.decodeTextBytes();
                    continue block5;
                }
            }
            break;
        }
        return Integer.MIN_VALUE;
    }

    public int tryReadCharsCompare(char[] value) {
        int result = this.charsCompare(value);
        if (result == 0) {
            this.inline$_dataItem_$eq(0);
        }
        return result;
    }

    public <Bytes> Bytes readTextBytes(ByteAccess<Bytes> evidence$1) {
        int n = this.dataItem();
        if (4096 == n) {
            return this.readSizedTextBytes(evidence$1);
        }
        if (8192 == n) {
            return this.readUnsizedTextBytes(evidence$1);
        }
        throw this.unexpectedDataItem("Text-Bytes");
    }

    public boolean hasTextBytes() {
        return (this.dataItem() & 0x3000) != 0;
    }

    public <Bytes> Bytes readSizedTextBytes(ByteAccess<Bytes> byteAccess) {
        if (this.hasSizedTextBytes()) {
            Receptacle Receptacle_this = this.receptacle;
            Bytes value$proxy24 = byteAccess.convert(Receptacle_this.inline$_obj(), Receptacle_this.inline$_byteAccess());
            InputReader InputReader_this = this;
            InputReader_this.inline$_dataItem_$eq(0);
            return value$proxy24;
        }
        throw this.unexpectedDataItem("Bounded Text-Bytes");
    }

    public boolean hasSizedTextBytes() {
        return this.dataItem() == 4096;
    }

    public InputReader readTextStart() {
        if (this.tryReadTextStart()) {
            return this;
        }
        throw this.unexpectedDataItem("Unbounded Text-Start");
    }

    public boolean hasTextStart() {
        return this.dataItem() == 8192;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadTextStart() {
        boolean value$proxy25 = this.hasTextStart();
        if (!value$proxy25) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public <Bytes> Bytes readUnsizedTextBytes(ByteAccess<Bytes> byteAccess) {
        if (this.hasUnsizedTextBytes()) {
            return this.bufferUnsizedTextBytes(byteAccess).readSizedTextBytes(byteAccess);
        }
        throw this.unexpectedDataItem("Unbounded Text Bytes");
    }

    public boolean hasUnsizedTextBytes() {
        return this.hasTextStart();
    }

    public <Bytes> InputReader bufferUnsizedTextBytes(ByteAccess<Bytes> byteAccess) {
        if (this.tryReadTextStart()) {
            Bytes result = byteAccess.empty();
            while (!this.tryReadBreak()) {
                result = byteAccess.concat(result, this.readTextBytes(byteAccess));
            }
            this.receptacle.onText(result, byteAccess);
            this._dataItem = 4096;
        }
        return this;
    }

    public InputReader decodeTextBytes() {
        while (true) {
            int n;
            if (4096 == (n = this_.dataItem())) {
                Receptacle Receptacle_this = this_.receptacle;
                this_.receptacle.onChars(Utf8$.MODULE$.decode(ByteAccess$ForByteArray$.MODULE$.convert(Receptacle_this.inline$_obj(), Receptacle_this.inline$_byteAccess())));
                this_._dataItem = 2048;
                return this_;
            }
            if (8192 != n) break;
            InputReader this_ = this_.bufferUnsizedTextBytes(ByteAccess$ForByteArray$.MODULE$);
        }
        return this_;
    }

    public long readArrayHeader() {
        if (this.hasArrayHeader()) {
            Receptacle Receptacle_this = this.receptacle;
            long result = Receptacle_this.inline$_long();
            this.inline$_dataItem_$eq(0);
            return result;
        }
        throw this.unexpectedDataItem("Array-Header");
    }

    public boolean hasArrayHeader() {
        return this.dataItem() == 65536;
    }

    public boolean hasArrayHeader(int length) {
        return this.hasArrayHeader((long)length);
    }

    public boolean hasArrayHeader(long length) {
        Receptacle Receptacle_this;
        return this.hasArrayHeader() && (Receptacle_this = this.receptacle).inline$_long() == length;
    }

    public InputReader readArrayHeader(int length) {
        return this.readArrayHeader((long)length);
    }

    public InputReader readArrayHeader(long length) {
        if (this.tryReadArrayHeader(length)) {
            return this;
        }
        throw this.unexpectedDataItem(new StringBuilder(14).append("Array-Header(").append(length).append(")").toString());
    }

    public boolean tryReadArrayHeader(int length) {
        return this.tryReadArrayHeader((long)length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadArrayHeader(long length) {
        boolean value$proxy26 = this.hasArrayHeader(length);
        if (!value$proxy26) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public InputReader readArrayStart() {
        if (this.tryReadArrayStart()) {
            return this;
        }
        throw this.unexpectedDataItem("Array-Start");
    }

    public boolean hasArrayStart() {
        return this.dataItem() == 131072;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadArrayStart() {
        boolean value$proxy27 = this.hasArrayStart();
        if (!value$proxy27) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public long readMapHeader() {
        if (this.hasMapHeader()) {
            Receptacle Receptacle_this = this.receptacle;
            long result = Receptacle_this.inline$_long();
            this.inline$_dataItem_$eq(0);
            return result;
        }
        throw this.unexpectedDataItem("Map-Header");
    }

    public boolean hasMapHeader() {
        return this.dataItem() == 262144;
    }

    public boolean hasMapHeader(int length) {
        return this.hasMapHeader((long)length);
    }

    public boolean hasMapHeader(long length) {
        Receptacle Receptacle_this;
        return this.hasMapHeader() && (Receptacle_this = this.receptacle).inline$_long() == length;
    }

    public InputReader readMapHeader(int length) {
        return this.readMapHeader((long)length);
    }

    public InputReader readMapHeader(long length) {
        if (this.tryReadMapHeader(length)) {
            return this;
        }
        throw this.unexpectedDataItem(new StringBuilder(12).append("Map-Header(").append(length).append(")").toString());
    }

    public boolean tryReadMapHeader(int length) {
        return this.tryReadMapHeader((long)length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadMapHeader(long length) {
        boolean value$proxy28 = this.hasMapHeader(length);
        if (!value$proxy28) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public InputReader readMapStart() {
        if (this.tryReadMapStart()) {
            return this;
        }
        throw this.unexpectedDataItem("Map-Start");
    }

    public boolean hasMapStart() {
        return this.dataItem() == 524288;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadMapStart() {
        boolean value$proxy29 = this.hasMapStart();
        if (!value$proxy29) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public InputReader readBreak() {
        if (this.tryReadBreak()) {
            return this;
        }
        throw this.unexpectedDataItem("BREAK");
    }

    public boolean hasBreak() {
        return this.dataItem() == 0x100000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadBreak() {
        boolean value$proxy30 = this.hasBreak();
        if (!value$proxy30) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public Tag readTag() {
        if (this.hasTag()) {
            Receptacle Receptacle_this = this.receptacle;
            Tag value$proxy31 = (Tag)Receptacle_this.inline$_obj();
            InputReader InputReader_this = this;
            InputReader_this.inline$_dataItem_$eq(0);
            return value$proxy31;
        }
        throw this.unexpectedDataItem("Tag");
    }

    public boolean hasTag() {
        return this.dataItem() == 0x200000;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasTag(Tag tag) {
        if (!this.hasTag()) return false;
        Receptacle Receptacle_this = this.receptacle;
        Tag tag2 = (Tag)Receptacle_this.inline$_obj();
        Tag tag3 = tag;
        if (tag2 != null) {
            if (!tag2.equals(tag3)) return false;
            return true;
        }
        if (tag3 == null) return true;
        return false;
    }

    public InputReader readTag(Tag tag) {
        if (this.tryReadTag(tag)) {
            return this;
        }
        throw this.unexpectedDataItem(tag.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadTag(Tag tag) {
        boolean value$proxy32 = this.hasTag(tag);
        if (!value$proxy32) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public int readSimpleValue() {
        if (this.hasSimpleValue()) {
            Receptacle Receptacle_this = this.receptacle;
            int result = Receptacle_this.inline$_int();
            this.inline$_dataItem_$eq(0);
            return result;
        }
        throw this.unexpectedDataItem("Simple Value");
    }

    public boolean hasSimpleValue() {
        return this.dataItem() == 0x400000;
    }

    public boolean hasSimpleValue(int value) {
        Receptacle Receptacle_this;
        return this.hasSimpleValue() && (Receptacle_this = this.receptacle).inline$_int() == value;
    }

    public InputReader readSimpleValue(int value) {
        if (this.tryReadSimpleValue(value)) {
            return this;
        }
        throw this.unexpectedDataItem(new StringBuilder(13).append("Simple Value ").append(value).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean tryReadSimpleValue(int value) {
        boolean value$proxy33 = this.hasSimpleValue(value);
        if (!value$proxy33) return false;
        InputReader InputReader_this = this;
        InputReader_this.inline$_dataItem_$eq(0);
        if (!true) return false;
        return true;
    }

    public boolean hasEndOfInput() {
        return this.dataItem() == 0x800000;
    }

    public void readEndOfInput() {
        if (!this.hasEndOfInput()) {
            throw this.unexpectedDataItem("End-of-Input");
        }
    }

    public boolean tryReadEndOfInput() {
        return this.hasEndOfInput();
    }

    public <M, T> Object readUntilBreak(Decoder<T> evidence$1, Factory<T, Object> factory) {
        return this.rec$1(evidence$1, factory.newBuilder());
    }

    public <T> T readUntilBreak(T zero, Function1<T, T> f) {
        return (T)this.rec$2(f, zero);
    }

    public InputReader skipDataItem() {
        this.dataItem();
        this.inline$_dataItem_$eq(0);
        return this;
    }

    public InputReader skipElement() {
        if ((this.dataItem() & 0xFA000) != 0) {
            return this.skipComplex$1(0);
        }
        this.inline$_dataItem_$eq(0);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readArrayOpen(long arity) {
        if (this.tryReadArrayStart()) return true;
        this.readArrayHeader(arity);
        if (!false) return false;
        return true;
    }

    public <T> T readArrayClose(boolean unbounded, T value) {
        if (unbounded) {
            this.readBreak();
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean readMapOpen(long arity) {
        if (this.tryReadMapStart()) return true;
        this.readMapHeader(arity);
        if (!false) return false;
        return true;
    }

    public <T> T readMapClose(boolean unbounded, T value) {
        if (unbounded) {
            this.readBreak();
        }
        return value;
    }

    public Nothing$ validationFailure(String msg) {
        throw new Borer.Error.ValidationFailure<Input.Position>(Input$.MODULE$.position(this.input(), this.cursor()), msg);
    }

    public Nothing$ overflow(String msg) {
        throw new Borer.Error.Overflow<Input.Position>(Input$.MODULE$.position(this.input(), this.cursor()), msg);
    }

    public Nothing$ unexpectedDataItem(String expected) {
        String string2;
        int n = this._dataItem;
        switch (n) {
            case 65536: {
                Receptacle Receptacle_this = this.receptacle;
                string2 = new StringBuilder(14).append("Array-Header(").append(BoxesRunTime.boxToLong(Receptacle_this.inline$_long())).append(")").toString();
                break;
            }
            case 262144: {
                Receptacle Receptacle_this = this.receptacle;
                string2 = new StringBuilder(12).append("Map-Header(").append(BoxesRunTime.boxToLong(Receptacle_this.inline$_long())).append(")").toString();
                break;
            }
            case 0x200000: {
                Receptacle Receptacle_this = this.receptacle;
                string2 = new StringBuilder(5).append("Tag: ").append((Tag)Receptacle_this.inline$_obj()).toString();
                break;
            }
            default: {
                string2 = DataItem$.MODULE$.stringify(this._dataItem);
                break;
            }
        }
        String actual = string2;
        return this.unexpectedDataItem(expected, actual);
    }

    public Nothing$ unexpectedDataItem(String expected, String actual) {
        throw new Borer.Error.InvalidInputData<Input.Position>(Input$.MODULE$.position(this.input(), this.cursor()), expected, actual);
    }

    public final int inline$_dataItem() {
        return this._dataItem;
    }

    public final void inline$_dataItem_$eq(int x$0) {
        this._dataItem = x$0;
    }

    private final int pullFromStash$1() {
        ElementDeque ElementDeque_this = this.stash();
        ResizableByteRingBuffer ResizableByteRingBuffer_this = ElementDeque_this.inline$byteBuffer();
        if (ResizableByteRingBuffer_this.inline$writeIx() == ResizableByteRingBuffer_this.inline$readIx()) {
            this.stash_$eq(this.stash().next());
            return this.dataItem();
        }
        return this.stash().pull(this.receptacle);
    }

    private final Object rec$1(Decoder evidence$1$1, Builder b) {
        while (!this.tryReadBreak()) {
            b = (Builder)b.$plus$eq(evidence$1$1.read(this));
        }
        return b.result();
    }

    private final Object rec$2(Function1 f$1, Object acc) {
        while (!this.tryReadBreak()) {
            acc = f$1.apply(acc);
        }
        return acc;
    }

    private final InputReader skipN$1(int level$1, long remaining) {
        while (remaining > 0L) {
            Object object;
            if ((this.dataItem() & 0xFA000) != 0) {
                object = this.skipComplex$1(level$1 + 1);
            } else {
                this.inline$_dataItem_$eq(0);
                object = BoxedUnit.UNIT;
            }
            --remaining;
        }
        return this;
    }

    private final InputReader skipUntilBreak$1(int level$2) {
        while (!this.tryReadBreak()) {
            Object object;
            if ((this.dataItem() & 0xFA000) != 0) {
                object = this.skipComplex$1(level$2 + 1);
                continue;
            }
            this.inline$_dataItem_$eq(0);
            object = BoxedUnit.UNIT;
        }
        return this;
    }

    private final InputReader skipComplex$1(int level) {
        if (level < 100) {
            int n = this.dataItem();
            if (65536 == n) {
                return this.skipN$1(level, this.readArrayHeader());
            }
            if (262144 == n) {
                long elemsToSkip = this.readMapHeader() << 1;
                if (elemsToSkip >= 0L) {
                    return this.skipN$1(level, elemsToSkip);
                }
                throw this.overflow("Maps with more than 2^62 elements cannot be skipped");
            }
            this.inline$_dataItem_$eq(0);
            return this.skipUntilBreak$1(level);
        }
        throw this.overflow("Structures more than 100 levels deep cannot be skipped");
    }
}

