/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer;

import io.bullet.borer.Borer;
import io.bullet.borer.CommonApi;
import io.bullet.borer.Encoder;
import io.bullet.borer.Json;
import io.bullet.borer.Output;
import io.bullet.borer.Output$;
import io.bullet.borer.Receiver;
import io.bullet.borer.Target;
import io.bullet.borer.Writer;
import io.bullet.borer.internal.Renderer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import scala.Function2;
import scala.Option;
import scala.package$;
import scala.util.Either;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class EncodingSetup {

    public static interface Api<Config extends Borer.EncodingConfig>
    extends CommonApi<Config> {
        public byte[] toByteArray();

        public Try<byte[]> toByteArrayTry();

        public Either<Borer.Error<Output>, byte[]> toByteArrayEither();

        public ByteBuffer toByteBuffer();

        public Try<ByteBuffer> toByteBufferTry();

        public Either<Borer.Error<Output>, ByteBuffer> toByteBufferEither();

        public <R> Sealed<Output, R> to(Output.ToTypeProvider<R> var1);

        public <R> Sealed<Output, R> to(R var1, Output.ToValueProvider<R> var2);
    }

    public static final class Impl<T, Config extends Borer.EncodingConfig>
    extends CommonApi.Impl<Config>
    implements JsonApi<T, Config>,
    Sealed<Output, Object> {
        private final T value;
        private final Target target;
        private final Function2<Output, Config, Renderer> rendererCreator;
        private final Encoder<T> evidence$1;
        private Output _output;

        public Impl(T value, Target target, Config defaultConfig, Function2<Receiver, Config, Receiver> defaultWrapper, Function2<Output, Config, Renderer> rendererCreator, Encoder<T> evidence$1) {
            this.value = value;
            this.target = target;
            this.rendererCreator = rendererCreator;
            this.evidence$1 = evidence$1;
            super(defaultConfig, defaultWrapper);
        }

        @Override
        public Impl withPrettyRendering(int indent) {
            Json.EncodingConfig encodingConfig = (Json.EncodingConfig)this.config();
            return (Impl)this.withConfig(encodingConfig.copy(encodingConfig.copy$default$1(), encodingConfig.copy$default$2(), indent));
        }

        @Override
        public String toUtf8String() {
            return new String(this.toByteArray(), StandardCharsets.UTF_8);
        }

        @Override
        public byte[] toByteArray() {
            return this.to(Output$.MODULE$.ToByteArrayProvider()).result();
        }

        @Override
        public Try<byte[]> toByteArrayTry() {
            return this.to(Output$.MODULE$.ToByteArrayProvider()).resultTry();
        }

        @Override
        public Either<Borer.Error<Output>, byte[]> toByteArrayEither() {
            return this.to(Output$.MODULE$.ToByteArrayProvider()).resultEither();
        }

        @Override
        public ByteBuffer toByteBuffer() {
            return this.to(Output$.MODULE$.ToByteBufferProvider()).result();
        }

        @Override
        public Try<ByteBuffer> toByteBufferTry() {
            return this.to(Output$.MODULE$.ToByteBufferProvider()).resultTry();
        }

        @Override
        public Either<Borer.Error<Output>, ByteBuffer> toByteBufferEither() {
            return this.to(Output$.MODULE$.ToByteBufferProvider()).resultEither();
        }

        @Override
        public <R> Sealed<Output, R> to(Output.ToTypeProvider<R> op) {
            this._output = op.apply(((Borer.EncodingConfig)this.config()).bufferSize(), ((Borer.EncodingConfig)this.config()).allowBufferCaching());
            return this;
        }

        @Override
        public <R> Sealed<Output, R> to(R target, Output.ToValueProvider<R> op) {
            this._output = op.apply(target, ((Borer.EncodingConfig)this.config()).bufferSize(), ((Borer.EncodingConfig)this.config()).allowBufferCaching());
            return this;
        }

        @Override
        public Object result() {
            Object object;
            Renderer renderer = this.rendererCreator.apply(this._output, this.config());
            try {
                object = this.render(renderer).out().result();
            }
            catch (Borer.Error e) {
                throw e.withOut(renderer.out());
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    throw new Borer.Error.General<Output>(renderer.out(), e);
                }
                throw throwable;
            }
            return object;
        }

        @Override
        public Try<Object> resultTry() {
            Try try_;
            Renderer renderer = this.rendererCreator.apply(this._output, this.config());
            try {
                try_ = Success$.MODULE$.apply(this.render(renderer).out().result());
            }
            catch (Borer.Error e) {
                try_ = Failure$.MODULE$.apply(e.withOut(renderer.out()));
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    try_ = Failure$.MODULE$.apply(new Borer.Error.General<Output>(renderer.out(), e));
                }
                throw throwable;
            }
            return try_;
        }

        @Override
        public Either<Borer.Error<Output>, Object> resultEither() {
            Either either;
            Renderer renderer = this.rendererCreator.apply(this._output, this.config());
            try {
                either = package$.MODULE$.Right().apply(this.render(renderer).out().result());
            }
            catch (Borer.Error e) {
                either = package$.MODULE$.Left().apply(e.withOut(renderer.out()));
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    either = package$.MODULE$.Left().apply(new Borer.Error.General<Output>(renderer.out(), e));
                }
                throw throwable;
            }
            return either;
        }

        @Override
        public Output output() {
            return this.render(this.rendererCreator.apply(this._output, this.config())).out();
        }

        @Override
        public Try<Output> outputTry() {
            Try try_;
            Renderer renderer = this.rendererCreator.apply(this._output, this.config());
            try {
                try_ = Success$.MODULE$.apply(this.render(renderer).out());
            }
            catch (Borer.Error e) {
                try_ = Failure$.MODULE$.apply(e.withOut(renderer.out()));
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    try_ = Failure$.MODULE$.apply(new Borer.Error.General<Output>(renderer.out(), e));
                }
                throw throwable;
            }
            return try_;
        }

        @Override
        public Either<Borer.Error<Output>, Output> outputEither() {
            Either either;
            Renderer renderer = this.rendererCreator.apply(this._output, this.config());
            try {
                either = package$.MODULE$.Right().apply(this.render(renderer).out());
            }
            catch (Borer.Error e) {
                either = package$.MODULE$.Left().apply(e.withOut(renderer.out()));
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    either = package$.MODULE$.Left().apply(new Borer.Error.General<Output>(renderer.out(), e));
                }
                throw throwable;
            }
            return either;
        }

        private Renderer render(Renderer renderer) {
            Writer writer = new Writer(this._output, this.receiverTransformer().apply(renderer, this.config()), this.target, (Writer.Config)this.config());
            writer.write(this.value, this.evidence$1).writeEndOfInput();
            return renderer;
        }
    }

    public static interface JsonApi<T, Config extends Borer.EncodingConfig>
    extends Api<Config> {
        public JsonApi withPrettyRendering(int var1);

        public static int withPrettyRendering$default$1$(JsonApi $this) {
            return $this.withPrettyRendering$default$1();
        }

        default public int withPrettyRendering$default$1() {
            return 2;
        }

        public String toUtf8String();
    }

    public static interface Sealed<Out extends Output, Result> {
        public Result result();

        public Try<Result> resultTry();

        public Either<Borer.Error<Out>, Result> resultEither();

        public Out output();

        public Try<Out> outputTry();

        public Either<Borer.Error<Out>, Out> outputEither();
    }
}

