/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer;

import io.bullet.borer.Cbor$;
import io.bullet.borer.Decoder;
import io.bullet.borer.Dom;
import io.bullet.borer.Dom$;
import io.bullet.borer.Dom$ArrayElem$;
import io.bullet.borer.Dom$ArrayElem$Sized$;
import io.bullet.borer.Dom$ArrayElem$Unsized$;
import io.bullet.borer.Dom$BooleanElem$;
import io.bullet.borer.Dom$ByteArrayElem$;
import io.bullet.borer.Dom$BytesStreamElem$;
import io.bullet.borer.Dom$DoubleElem$;
import io.bullet.borer.Dom$Float16Elem$;
import io.bullet.borer.Dom$FloatElem$;
import io.bullet.borer.Dom$IntElem$;
import io.bullet.borer.Dom$LongElem$;
import io.bullet.borer.Dom$MapElem$;
import io.bullet.borer.Dom$MapElem$Sized$;
import io.bullet.borer.Dom$MapElem$Unsized$;
import io.bullet.borer.Dom$NullElem$;
import io.bullet.borer.Dom$NumberStringElem$;
import io.bullet.borer.Dom$OverLongElem$;
import io.bullet.borer.Dom$SimpleValueElem$;
import io.bullet.borer.Dom$StringElem$;
import io.bullet.borer.Dom$TaggedElem$;
import io.bullet.borer.Dom$TextStreamElem$;
import io.bullet.borer.Dom$UndefinedElem$;
import io.bullet.borer.Encoder;
import io.bullet.borer.EncodingSetup;
import io.bullet.borer.Output$;
import io.bullet.borer.SimpleValue;
import io.bullet.borer.Tag;
import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.Factory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;

public final class Dom {
    public static Decoder<Element> elementDecoder() {
        return Dom$.MODULE$.elementDecoder();
    }

    public static Encoder<Element> elementEncoder() {
        return Dom$.MODULE$.elementEncoder();
    }

    public static <T extends Element> Decoder<T> given_Decoder_T() {
        return Dom$.MODULE$.given_Decoder_T();
    }

    public static <T extends Element> Encoder<T> given_Encoder_T() {
        return Dom$.MODULE$.given_Encoder_T();
    }

    public static abstract class AbstractBytesElem
    extends Element {
        public AbstractBytesElem(int dataItem) {
            super(dataItem);
        }

        public abstract long byteCount();

        public abstract Iterator<byte[]> bytesIterator();

        public abstract byte[] compact();
    }

    public static abstract class AbstractTextElem
    extends Element {
        public AbstractTextElem(int dataItem) {
            super(dataItem);
        }

        public abstract long charCount();

        public abstract Iterator<String> stringIterator();

        public abstract String compact();
    }

    public static abstract class ArrayElem
    extends Element {
        public static int ordinal(ArrayElem arrayElem) {
            return Dom$ArrayElem$.MODULE$.ordinal(arrayElem);
        }

        public ArrayElem(int dataItem) {
            super(dataItem);
        }

        public abstract Vector<Element> elems();
    }

    public static final class BooleanElem
    extends Element
    implements Product,
    Serializable {
        private final boolean value;

        public static BooleanElem False() {
            return Dom$BooleanElem$.MODULE$.False();
        }

        public static BooleanElem True() {
            return Dom$BooleanElem$.MODULE$.True();
        }

        public static BooleanElem apply(boolean bl) {
            return Dom$BooleanElem$.MODULE$.apply(bl);
        }

        public static BooleanElem fromProduct(Product product) {
            return Dom$BooleanElem$.MODULE$.fromProduct(product);
        }

        public static BooleanElem unapply(BooleanElem booleanElem) {
            return Dom$BooleanElem$.MODULE$.unapply(booleanElem);
        }

        public BooleanElem(boolean value) {
            this.value = value;
            super(2);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.value() ? 1231 : 1237);
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BooleanElem)) return false;
            BooleanElem booleanElem = (BooleanElem)object;
            if (this.value() != booleanElem.value()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof BooleanElem;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "BooleanElem";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToBoolean(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public boolean value() {
            return this.value;
        }

        public BooleanElem copy(boolean value) {
            return new BooleanElem(value);
        }

        public boolean copy$default$1() {
            return this.value();
        }

        public boolean _1() {
            return this.value();
        }
    }

    public static final class ByteArrayElem
    extends AbstractBytesElem
    implements Product,
    Serializable {
        private final byte[] bytes;

        public static ByteArrayElem apply(byte[] byArray) {
            return Dom$ByteArrayElem$.MODULE$.apply(byArray);
        }

        public static ByteArrayElem fromProduct(Product product) {
            return Dom$ByteArrayElem$.MODULE$.fromProduct(product);
        }

        public static ByteArrayElem unapply(ByteArrayElem byteArrayElem) {
            return Dom$ByteArrayElem$.MODULE$.unapply(byteArrayElem);
        }

        public ByteArrayElem(byte[] bytes) {
            this.bytes = bytes;
            super(14);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof ByteArrayElem;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "ByteArrayElem";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "bytes";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public byte[] bytes() {
            return this.bytes;
        }

        @Override
        public long byteCount() {
            return this.bytes().length;
        }

        @Override
        public Iterator<byte[]> bytesIterator() {
            return package$.MODULE$.Iterator().single(this.bytes());
        }

        @Override
        public byte[] compact() {
            return this.bytes();
        }

        public String toString() {
            return new StringBuilder(8).append(this.productPrefix()).append("(").append(this.byteCount()).append(" bytes)").toString();
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes());
        }

        @Override
        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof ByteArrayElem) {
                byte[] byArray;
                ByteArrayElem byteArrayElem = Dom$ByteArrayElem$.MODULE$.unapply((ByteArrayElem)object);
                byte[] x = byArray = byteArrayElem._1();
                return Arrays.equals(this.bytes(), x);
            }
            return false;
        }

        public ByteArrayElem copy(byte[] bytes) {
            return new ByteArrayElem(bytes);
        }

        public byte[] copy$default$1() {
            return this.bytes();
        }

        public byte[] _1() {
            return this.bytes();
        }
    }

    public static final class BytesStreamElem
    extends AbstractBytesElem
    implements Product,
    Serializable {
        private final Vector elems;

        public static BytesStreamElem apply(Vector<AbstractBytesElem> vector) {
            return Dom$BytesStreamElem$.MODULE$.apply(vector);
        }

        public static BytesStreamElem fromProduct(Product product) {
            return Dom$BytesStreamElem$.MODULE$.fromProduct(product);
        }

        public static BytesStreamElem unapply(BytesStreamElem bytesStreamElem) {
            return Dom$BytesStreamElem$.MODULE$.unapply(bytesStreamElem);
        }

        public BytesStreamElem(Vector<AbstractBytesElem> elems) {
            this.elems = elems;
            super(15);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BytesStreamElem)) return false;
            BytesStreamElem bytesStreamElem = (BytesStreamElem)object;
            Vector<AbstractBytesElem> vector = this.elems();
            Vector<AbstractBytesElem> vector2 = bytesStreamElem.elems();
            if (vector != null) {
                if (!((Object)vector).equals(vector2)) return false;
                return true;
            }
            if (vector2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof BytesStreamElem;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "BytesStreamElem";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "elems";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Vector<AbstractBytesElem> elems() {
            return this.elems;
        }

        @Override
        public long byteCount() {
            return BoxesRunTime.unboxToLong(this.elems().foldLeft(BoxesRunTime.boxToLong(0L), Dom$::io$bullet$borer$Dom$BytesStreamElem$$_$byteCount$$anonfun$adapted$1));
        }

        @Override
        public Iterator<byte[]> bytesIterator() {
            return (Iterator)this.elems().foldLeft(package$.MODULE$.Iterator().empty(), Dom$::io$bullet$borer$Dom$BytesStreamElem$$_$bytesIterator$$anonfun$1);
        }

        @Override
        public byte[] compact() {
            long longSize = this.byteCount();
            int len = (int)longSize;
            if ((long)len != longSize) {
                throw scala.sys.package$.MODULE$.error("byte stream with total size > Int.MaxValue cannot be compacted");
            }
            byte[] result = new byte[len];
            Iterator<byte[]> iter = this.bytesIterator();
            return this.rec$5(len, iter, result, 0);
        }

        public BytesStreamElem copy(Vector<AbstractBytesElem> elems) {
            return new BytesStreamElem(elems);
        }

        public Vector<AbstractBytesElem> copy$default$1() {
            return this.elems();
        }

        public Vector<AbstractBytesElem> _1() {
            return this.elems();
        }

        private final byte[] rec$5(int len$1, Iterator iter$1, byte[] result$1, int ix) {
            while (ix < len$1) {
                byte[] chunk = (byte[])iter$1.next();
                System.arraycopy(chunk, 0, result$1, ix, chunk.length);
                ix += chunk.length;
            }
            return result$1;
        }
    }

    public static final class DoubleElem
    extends Element
    implements Product,
    Serializable {
        private final double value;

        public static DoubleElem apply(double d) {
            return Dom$DoubleElem$.MODULE$.apply(d);
        }

        public static DoubleElem fromProduct(Product product) {
            return Dom$DoubleElem$.MODULE$.fromProduct(product);
        }

        public static DoubleElem unapply(DoubleElem doubleElem) {
            return Dom$DoubleElem$.MODULE$.unapply(doubleElem);
        }

        public DoubleElem(double value) {
            this.value = value;
            super(8);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.doubleHash(this.value()));
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DoubleElem)) return false;
            DoubleElem doubleElem = (DoubleElem)object;
            if (this.value() != doubleElem.value()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof DoubleElem;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "DoubleElem";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToDouble(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public double value() {
            return this.value;
        }

        public DoubleElem copy(double value) {
            return new DoubleElem(value);
        }

        public double copy$default$1() {
            return this.value();
        }

        public double _1() {
            return this.value();
        }
    }

    public static abstract class Element {
        private final int dataItemShift;

        public Element(int dataItemShift) {
            this.dataItemShift = dataItemShift;
        }

        public int dataItemShift() {
            return this.dataItemShift;
        }

        public String render(int maxShownByteArrayPrefixLen, int maxShownStringPrefixLen, int maxShownArrayElems, int maxShownMapEntries, int initialGutterWidth, boolean renderLevelCount, boolean renderEndOfInput, boolean renderCommas, String indentation, String mapKeySep, String lineSep, boolean mapValueOnNewLine) {
            StringBuilder sb = new StringBuilder();
            ((EncodingSetup.Api)Cbor$.MODULE$.encode(this, Dom$.MODULE$.given_Encoder_T()).withStringLogging(sb, maxShownByteArrayPrefixLen, maxShownStringPrefixLen, maxShownArrayElems, maxShownMapEntries, initialGutterWidth, renderLevelCount, renderEndOfInput, renderCommas, indentation, mapKeySep, lineSep, mapValueOnNewLine)).to(Output$.MODULE$.ToUnitProvider()).result();
            return sb.toString();
        }

        public int render$default$1() {
            return 20;
        }

        public int render$default$2() {
            return 50;
        }

        public int render$default$3() {
            return 20;
        }

        public int render$default$4() {
            return 20;
        }

        public int render$default$5() {
            return 5;
        }

        public boolean render$default$6() {
            return false;
        }

        public boolean render$default$7() {
            return false;
        }

        public boolean render$default$8() {
            return true;
        }

        public String render$default$9() {
            return "  ";
        }

        public String render$default$10() {
            return " = ";
        }

        public String render$default$11() {
            return System.lineSeparator();
        }

        public boolean render$default$12() {
            return false;
        }
    }

    public static final class Float16Elem
    extends Element
    implements Product,
    Serializable {
        private final float value;

        public static Float16Elem apply(float f) {
            return Dom$Float16Elem$.MODULE$.apply(f);
        }

        public static Float16Elem fromProduct(Product product) {
            return Dom$Float16Elem$.MODULE$.fromProduct(product);
        }

        public static Float16Elem unapply(Float16Elem float16Elem) {
            return Dom$Float16Elem$.MODULE$.unapply(float16Elem);
        }

        public Float16Elem(float value) {
            this.value = value;
            super(6);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.floatHash(this.value()));
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Float16Elem)) return false;
            Float16Elem float16Elem = (Float16Elem)object;
            if (this.value() != float16Elem.value()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Float16Elem;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Float16Elem";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToFloat(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public float value() {
            return this.value;
        }

        public Float16Elem copy(float value) {
            return new Float16Elem(value);
        }

        public float copy$default$1() {
            return this.value();
        }

        public float _1() {
            return this.value();
        }
    }

    public static final class FloatElem
    extends Element
    implements Product,
    Serializable {
        private final float value;

        public static FloatElem apply(float f) {
            return Dom$FloatElem$.MODULE$.apply(f);
        }

        public static FloatElem fromProduct(Product product) {
            return Dom$FloatElem$.MODULE$.fromProduct(product);
        }

        public static FloatElem unapply(FloatElem floatElem) {
            return Dom$FloatElem$.MODULE$.unapply(floatElem);
        }

        public FloatElem(float value) {
            this.value = value;
            super(7);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.floatHash(this.value()));
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FloatElem)) return false;
            FloatElem floatElem = (FloatElem)object;
            if (this.value() != floatElem.value()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof FloatElem;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "FloatElem";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToFloat(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public float value() {
            return this.value;
        }

        public FloatElem copy(float value) {
            return new FloatElem(value);
        }

        public float copy$default$1() {
            return this.value();
        }

        public float _1() {
            return this.value();
        }
    }

    public static final class IntElem
    extends Element
    implements Product,
    Serializable {
        private final int value;

        public static IntElem apply(int n) {
            return Dom$IntElem$.MODULE$.apply(n);
        }

        public static IntElem fromProduct(Product product) {
            return Dom$IntElem$.MODULE$.fromProduct(product);
        }

        public static IntElem unapply(IntElem intElem) {
            return Dom$IntElem$.MODULE$.unapply(intElem);
        }

        public IntElem(int value) {
            this.value = value;
            super(3);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.value());
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof IntElem)) return false;
            IntElem intElem = (IntElem)object;
            if (this.value() != intElem.value()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof IntElem;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "IntElem";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToInteger(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public int value() {
            return this.value;
        }

        public IntElem copy(int value) {
            return new IntElem(value);
        }

        public int copy$default$1() {
            return this.value();
        }

        public int _1() {
            return this.value();
        }
    }

    public static final class LongElem
    extends Element
    implements Product,
    Serializable {
        private final long value;

        public static LongElem apply(long l) {
            return Dom$LongElem$.MODULE$.apply(l);
        }

        public static LongElem fromProduct(Product product) {
            return Dom$LongElem$.MODULE$.fromProduct(product);
        }

        public static LongElem unapply(LongElem longElem) {
            return Dom$LongElem$.MODULE$.unapply(longElem);
        }

        public LongElem(long value) {
            this.value = value;
            super(4);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.longHash(this.value()));
            return Statics.finalizeHash(n, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LongElem)) return false;
            LongElem longElem = (LongElem)object;
            if (this.value() != longElem.value()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof LongElem;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "LongElem";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return BoxesRunTime.boxToLong(this._1());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public long value() {
            return this.value;
        }

        public LongElem copy(long value) {
            return new LongElem(value);
        }

        public long copy$default$1() {
            return this.value();
        }

        public long _1() {
            return this.value();
        }
    }

    public static abstract class MapElem
    extends Element {
        private final Element[] elems;
        private final int dataItem;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Dom$MapElem$.class.getDeclaredField("stringStringOrElem$lzy1"));

        public static <T extends Element> StringOrElem<T> elementStringOrElem() {
            return Dom$MapElem$.MODULE$.elementStringOrElem();
        }

        public static StringOrElem<String> stringStringOrElem() {
            return Dom$MapElem$.MODULE$.stringStringOrElem();
        }

        public MapElem(Element[] elems, int dataItem) {
            this.elems = elems;
            this.dataItem = dataItem;
            super(dataItem);
            if ((elems.length & 1) != 0) {
                throw new IllegalArgumentException();
            }
        }

        public Element[] elems() {
            return this.elems;
        }

        public final int size() {
            return this.elems().length >> 1;
        }

        public final IndexedSeq<Element> elementsInterleaved() {
            return ArraySeq$.MODULE$.unsafeWrapArray(this.elems());
        }

        public final boolean isEmpty() {
            return false;
        }

        public final Tuple3<Object, Iterator<Element>, Iterator<Element>> get() {
            return Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(this.size()), this.keys(), this.values());
        }

        public final Iterator<Element> keys() {
            return new KVIterator(this.elems(), 0);
        }

        public final Iterator<Element> values() {
            return new KVIterator(this.elems(), 1);
        }

        public final Iterator<Tuple2<Element, Element>> members() {
            return this.keys().zip(this.values());
        }

        public final Iterator<Tuple2<String, Element>> stringKeyedMembers() {
            return this.members().collect(new Serializable(){

                public final boolean isDefinedAt(Tuple2 x) {
                    Element element;
                    Tuple2 tuple2 = x;
                    if (tuple2 != null && (element = (Element)tuple2._1()) instanceof StringElem) {
                        String string2;
                        StringElem stringElem = Dom$StringElem$.MODULE$.unapply((StringElem)element);
                        String s2 = string2 = stringElem._1();
                        Element v = (Element)tuple2._2();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Tuple2 x, Function1 function1) {
                    Element element;
                    Tuple2 tuple2 = x;
                    if (tuple2 != null && (element = (Element)tuple2._1()) instanceof StringElem) {
                        String string2;
                        StringElem stringElem = Dom$StringElem$.MODULE$.unapply((StringElem)element);
                        String s2 = string2 = stringElem._1();
                        Element v = (Element)tuple2._2();
                        String string3 = Predef$.MODULE$.ArrowAssoc(s2);
                        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, v);
                    }
                    return function1.apply(x);
                }
            });
        }

        public Option<Element> apply(String key2) {
            return this.rec$6(key2, 0);
        }

        public Option<Element> apply(Element key2) {
            return this.rec$7(key2, 0);
        }

        public final HashMap<Element, Element> toMap() {
            Iterator<Element> k = this.keys();
            Iterator<Element> v = this.values();
            return this.rec$8(k, v, (HashMap)HashMap$.MODULE$.empty());
        }

        public final Either<Element, HashMap<String, Element>> toStringKeyedMap() {
            Iterator<Element> k = this.keys();
            Iterator<Element> v = this.values();
            return this.rec$9(k, v, (HashMap)HashMap$.MODULE$.empty());
        }

        public final <M extends Map<Object, Object>> Map<Element, Element> to(Factory<Tuple2<Element, Element>, Map<Element, Element>> fac) {
            Builder<Tuple2<Element, Element>, Map<Element, Element>> b = fac.newBuilder();
            b.$plus$plus$eq(this.keys().zip(this.values()));
            return b.result();
        }

        public final <M extends Map<Object, Object>> Either<Element, Map<String, Element>> toStringKeyed(Factory<Tuple2<String, Element>, Map<String, Element>> fac) {
            Iterator<Element> k = this.keys();
            Iterator<Element> v = this.values();
            return this.rec$10(k, v, fac.newBuilder());
        }

        public final String toString() {
            return this.keys().zip(this.values()).map(Dom$::io$bullet$borer$Dom$MapElem$$_$toString$$anonfun$1).mkString(this.dataItem == 19 ? "*{" : "{", ", ", "}");
        }

        public final int hashCode() {
            return Statics.finalizeHash(Statics.mix(Statics.mix(Statics.mix(-889275714, this.size()), MurmurHash3$.MODULE$.arrayHash(this.elems())), this.dataItem), 3);
        }

        public final boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof MapElem) {
                MapElem that = (MapElem)object;
                return this.dataItemShift() == that.dataItemShift() && Arrays.equals(this.elems(), that.elems());
            }
            return false;
        }

        private final Option rec$6(String key$1, int ix) {
            while (ix < this.elems().length) {
                Element element = this.elems()[ix];
                if (element instanceof StringElem) {
                    StringElem stringElem = Dom$StringElem$.MODULE$.unapply((StringElem)element);
                    String string2 = stringElem._1();
                    String string3 = key$1;
                    String string4 = string2;
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        return Some$.MODULE$.apply(this.elems()[ix + 1]);
                    }
                }
                ix += 2;
            }
            return None$.MODULE$;
        }

        private final Option rec$7(Element key$2, int ix) {
            while (ix < this.elems().length) {
                Element element = this.elems()[ix];
                Element element2 = key$2;
                if (!(element != null ? !element.equals(element2) : element2 != null)) {
                    return Some$.MODULE$.apply(this.elems()[ix + 1]);
                }
                ix += 2;
            }
            return None$.MODULE$;
        }

        private final HashMap rec$8(Iterator k$1, Iterator v$1, HashMap m) {
            while (k$1.hasNext()) {
                m = m.updated(k$1.next(), v$1.next());
            }
            return m;
        }

        private final Either rec$9(Iterator k$2, Iterator v$2, HashMap m) {
            while (k$2.hasNext()) {
                Element element = (Element)k$2.next();
                if (element instanceof StringElem) {
                    String string2;
                    StringElem stringElem = Dom$StringElem$.MODULE$.unapply((StringElem)element);
                    String x = string2 = stringElem._1();
                    m = m.updated(x, v$2.next());
                    continue;
                }
                Element x = element;
                return package$.MODULE$.Left().apply(x);
            }
            return package$.MODULE$.Right().apply(m);
        }

        private final Either rec$10(Iterator k$3, Iterator v$3, Builder b) {
            while (k$3.hasNext()) {
                Element element = (Element)k$3.next();
                if (element instanceof StringElem) {
                    String string2;
                    StringElem stringElem = Dom$StringElem$.MODULE$.unapply((StringElem)element);
                    String x = string2 = stringElem._1();
                    String string3 = Predef$.MODULE$.ArrowAssoc(x);
                    b = (Builder)b.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, v$3.next()));
                    continue;
                }
                Element x = element;
                return package$.MODULE$.Left().apply(x);
            }
            return package$.MODULE$.Right().apply(b.result());
        }

        public static final class KVIterator
        implements Iterator<Element> {
            private final Element[] elements;
            private int ix;

            public KVIterator(Element[] elements, int startIndex) {
                this.elements = elements;
                IterableOnce.$init$(this);
                IterableOnceOps.$init$(this);
                Iterator.$init$(this);
                this.ix = startIndex;
            }

            @Override
            public boolean hasNext() {
                return this.ix < this.elements.length;
            }

            @Override
            public Element next() {
                if (this.hasNext()) {
                    Element elem = this.elements[this.ix];
                    this.ix += 2;
                    return elem;
                }
                return (Element)package$.MODULE$.Iterator().empty().next();
            }
        }

        public static interface StringOrElem<T> {
        }
    }

    public static final class NumberStringElem
    extends Element
    implements Product,
    Serializable {
        private final String value;

        public static NumberStringElem apply(String string2) {
            return Dom$NumberStringElem$.MODULE$.apply(string2);
        }

        public static NumberStringElem fromProduct(Product product) {
            return Dom$NumberStringElem$.MODULE$.fromProduct(product);
        }

        public static NumberStringElem unapply(NumberStringElem numberStringElem) {
            return Dom$NumberStringElem$.MODULE$.unapply(numberStringElem);
        }

        public NumberStringElem(String value) {
            this.value = value;
            super(9);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NumberStringElem)) return false;
            NumberStringElem numberStringElem = (NumberStringElem)object;
            String string2 = this.value();
            String string3 = numberStringElem.value();
            if (string2 != null) {
                if (!string2.equals(string3)) return false;
                return true;
            }
            if (string3 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof NumberStringElem;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "NumberStringElem";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String value() {
            return this.value;
        }

        public NumberStringElem copy(String value) {
            return new NumberStringElem(value);
        }

        public String copy$default$1() {
            return this.value();
        }

        public String _1() {
            return this.value();
        }
    }

    public static final class OverLongElem
    extends Element
    implements Product,
    Serializable {
        private final boolean negative;
        private final long value;

        public static OverLongElem apply(boolean bl, long l) {
            return Dom$OverLongElem$.MODULE$.apply(bl, l);
        }

        public static OverLongElem fromProduct(Product product) {
            return Dom$OverLongElem$.MODULE$.fromProduct(product);
        }

        public static OverLongElem unapply(OverLongElem overLongElem) {
            return Dom$OverLongElem$.MODULE$.unapply(overLongElem);
        }

        public OverLongElem(boolean negative, long value) {
            this.negative = negative;
            this.value = value;
            super(5);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, this.negative() ? 1231 : 1237);
            n = Statics.mix(n, Statics.longHash(this.value()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OverLongElem)) return false;
            OverLongElem overLongElem = (OverLongElem)object;
            if (this.negative() != overLongElem.negative()) return false;
            if (this.value() != overLongElem.value()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof OverLongElem;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "OverLongElem";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return BoxesRunTime.boxToBoolean(this._1());
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong(this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "negative";
            }
            if (1 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public boolean negative() {
            return this.negative;
        }

        public long value() {
            return this.value;
        }

        public OverLongElem copy(boolean negative, long value) {
            return new OverLongElem(negative, value);
        }

        public boolean copy$default$1() {
            return this.negative();
        }

        public long copy$default$2() {
            return this.value();
        }

        public boolean _1() {
            return this.negative();
        }

        public long _2() {
            return this.value();
        }
    }

    public static final class SimpleValueElem
    extends Element
    implements Product,
    Serializable {
        private final SimpleValue value;

        public static SimpleValueElem apply(SimpleValue simpleValue) {
            return Dom$SimpleValueElem$.MODULE$.apply(simpleValue);
        }

        public static SimpleValueElem fromProduct(Product product) {
            return Dom$SimpleValueElem$.MODULE$.fromProduct(product);
        }

        public static SimpleValueElem unapply(SimpleValueElem simpleValueElem) {
            return Dom$SimpleValueElem$.MODULE$.unapply(simpleValueElem);
        }

        public SimpleValueElem(SimpleValue value) {
            this.value = value;
            super(22);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SimpleValueElem)) return false;
            SimpleValueElem simpleValueElem = (SimpleValueElem)object;
            SimpleValue simpleValue = this.value();
            SimpleValue simpleValue2 = simpleValueElem.value();
            if (simpleValue != null) {
                if (!((Object)simpleValue).equals(simpleValue2)) return false;
                return true;
            }
            if (simpleValue2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof SimpleValueElem;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "SimpleValueElem";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public SimpleValue value() {
            return this.value;
        }

        public SimpleValueElem copy(SimpleValue value) {
            return new SimpleValueElem(value);
        }

        public SimpleValue copy$default$1() {
            return this.value();
        }

        public SimpleValue _1() {
            return this.value();
        }
    }

    public static final class StringElem
    extends AbstractTextElem
    implements Product,
    Serializable {
        private final String value;

        public static StringElem apply(String string2) {
            return Dom$StringElem$.MODULE$.apply(string2);
        }

        public static StringElem fromProduct(Product product) {
            return Dom$StringElem$.MODULE$.fromProduct(product);
        }

        public static StringElem unapply(StringElem stringElem) {
            return Dom$StringElem$.MODULE$.unapply(stringElem);
        }

        public StringElem(String value) {
            this.value = value;
            super(10);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StringElem)) return false;
            StringElem stringElem = (StringElem)object;
            String string2 = this.value();
            String string3 = stringElem.value();
            if (string2 != null) {
                if (!string2.equals(string3)) return false;
                return true;
            }
            if (string3 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof StringElem;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "StringElem";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String value() {
            return this.value;
        }

        @Override
        public long charCount() {
            return this.value().length();
        }

        @Override
        public Iterator<String> stringIterator() {
            return package$.MODULE$.Iterator().single(this.value());
        }

        @Override
        public String compact() {
            return this.value();
        }

        public StringElem copy(String value) {
            return new StringElem(value);
        }

        public String copy$default$1() {
            return this.value();
        }

        public String _1() {
            return this.value();
        }
    }

    public static final class TaggedElem
    extends Element
    implements Product,
    Serializable {
        private final Tag tag;
        private final Element value;

        public static TaggedElem apply(Tag tag, Element element) {
            return Dom$TaggedElem$.MODULE$.apply(tag, element);
        }

        public static TaggedElem fromProduct(Product product) {
            return Dom$TaggedElem$.MODULE$.fromProduct(product);
        }

        public static TaggedElem unapply(TaggedElem taggedElem) {
            return Dom$TaggedElem$.MODULE$.unapply(taggedElem);
        }

        public TaggedElem(Tag tag, Element value) {
            this.tag = tag;
            this.value = value;
            super(21);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TaggedElem)) return false;
            TaggedElem taggedElem = (TaggedElem)object;
            Tag tag = this.tag();
            Tag tag2 = taggedElem.tag();
            if (tag == null) {
                if (tag2 != null) {
                    return false;
                }
            } else if (!tag.equals(tag2)) return false;
            Element element = this.value();
            Element element2 = taggedElem.value();
            if (element == null) {
                if (element2 == null) return true;
                return false;
            } else {
                if (!element.equals(element2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof TaggedElem;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "TaggedElem";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "tag";
            }
            if (1 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Tag tag() {
            return this.tag;
        }

        public Element value() {
            return this.value;
        }

        public TaggedElem copy(Tag tag, Element value) {
            return new TaggedElem(tag, value);
        }

        public Tag copy$default$1() {
            return this.tag();
        }

        public Element copy$default$2() {
            return this.value();
        }

        public Tag _1() {
            return this.tag();
        }

        public Element _2() {
            return this.value();
        }
    }

    public static final class TextStreamElem
    extends AbstractTextElem
    implements Product,
    Serializable {
        private final Vector elems;

        public static TextStreamElem apply(Vector<AbstractTextElem> vector) {
            return Dom$TextStreamElem$.MODULE$.apply(vector);
        }

        public static TextStreamElem fromProduct(Product product) {
            return Dom$TextStreamElem$.MODULE$.fromProduct(product);
        }

        public static TextStreamElem unapply(TextStreamElem textStreamElem) {
            return Dom$TextStreamElem$.MODULE$.unapply(textStreamElem);
        }

        public TextStreamElem(Vector<AbstractTextElem> elems) {
            this.elems = elems;
            super(13);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TextStreamElem)) return false;
            TextStreamElem textStreamElem = (TextStreamElem)object;
            Vector<AbstractTextElem> vector = this.elems();
            Vector<AbstractTextElem> vector2 = textStreamElem.elems();
            if (vector != null) {
                if (!((Object)vector).equals(vector2)) return false;
                return true;
            }
            if (vector2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof TextStreamElem;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "TextStreamElem";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "elems";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Vector<AbstractTextElem> elems() {
            return this.elems;
        }

        @Override
        public long charCount() {
            return BoxesRunTime.unboxToLong(this.elems().foldLeft(BoxesRunTime.boxToLong(0L), Dom$::io$bullet$borer$Dom$TextStreamElem$$_$charCount$$anonfun$adapted$1));
        }

        @Override
        public Iterator<String> stringIterator() {
            return (Iterator)this.elems().foldLeft(package$.MODULE$.Iterator().empty(), Dom$::io$bullet$borer$Dom$TextStreamElem$$_$stringIterator$$anonfun$1);
        }

        @Override
        public String compact() {
            long longSize = this.charCount();
            int len = (int)longSize;
            if ((long)len != longSize) {
                throw scala.sys.package$.MODULE$.error("text stream with total size > Int.MaxValue cannot be compacted");
            }
            Iterator<String> iter = this.stringIterator();
            StringBuilder sb = new StringBuilder(len);
            while (iter.hasNext()) {
                sb.append(iter.next());
            }
            return sb.toString();
        }

        public TextStreamElem copy(Vector<AbstractTextElem> elems) {
            return new TextStreamElem(elems);
        }

        public Vector<AbstractTextElem> copy$default$1() {
            return this.elems();
        }

        public Vector<AbstractTextElem> _1() {
            return this.elems();
        }
    }

    public static interface Transformer
    extends Function1<Element, Element> {
        public static Element apply$(Transformer $this, Element elem) {
            return $this.apply(elem);
        }

        @Override
        default public Element apply(Element elem) {
            int n = elem.dataItemShift();
            switch (n) {
                case 0: {
                    return this.transformNull();
                }
                case 1: {
                    return this.transformUndefined();
                }
                case 2: {
                    return this.transformBoolean((BooleanElem)elem);
                }
                case 3: {
                    return this.transformInt((IntElem)elem);
                }
                case 4: {
                    return this.transformLong((LongElem)elem);
                }
                case 5: {
                    return this.transformOverLong((OverLongElem)elem);
                }
                case 6: {
                    return this.transformFloat16((Float16Elem)elem);
                }
                case 7: {
                    return this.transformFloat((FloatElem)elem);
                }
                case 8: {
                    return this.transformDouble((DoubleElem)elem);
                }
                case 9: {
                    return this.transformNumberString((NumberStringElem)elem);
                }
                case 10: {
                    return this.transformString((StringElem)elem);
                }
                case 13: {
                    return this.transformTextStream((TextStreamElem)elem);
                }
                case 14: {
                    return this.transformBytes((ByteArrayElem)elem);
                }
                case 15: {
                    return this.transformBytesStream((BytesStreamElem)elem);
                }
                case 22: {
                    return this.transformSimpleValue((SimpleValueElem)elem);
                }
                case 16: {
                    return this.transformSizedArray((ArrayElem.Sized)elem);
                }
                case 17: {
                    return this.transformUnsizedArray((ArrayElem.Unsized)elem);
                }
                case 18: {
                    return this.transformSizedMap((MapElem.Sized)elem);
                }
                case 19: {
                    return this.transformUnsizedMap((MapElem.Unsized)elem);
                }
                case 21: {
                    return this.transformTag((TaggedElem)elem);
                }
            }
            throw new MatchError(BoxesRunTime.boxToInteger(n));
        }

        public static Element transformNull$(Transformer $this) {
            return $this.transformNull();
        }

        default public Element transformNull() {
            return Dom$NullElem$.MODULE$;
        }

        public static Element transformUndefined$(Transformer $this) {
            return $this.transformUndefined();
        }

        default public Element transformUndefined() {
            return Dom$UndefinedElem$.MODULE$;
        }

        public static Element transformBoolean$(Transformer $this, BooleanElem elem) {
            return $this.transformBoolean(elem);
        }

        default public Element transformBoolean(BooleanElem elem) {
            return elem;
        }

        public static Element transformInt$(Transformer $this, IntElem elem) {
            return $this.transformInt(elem);
        }

        default public Element transformInt(IntElem elem) {
            return elem;
        }

        public static Element transformLong$(Transformer $this, LongElem elem) {
            return $this.transformLong(elem);
        }

        default public Element transformLong(LongElem elem) {
            return elem;
        }

        public static Element transformOverLong$(Transformer $this, OverLongElem elem) {
            return $this.transformOverLong(elem);
        }

        default public Element transformOverLong(OverLongElem elem) {
            return elem;
        }

        public static Element transformFloat16$(Transformer $this, Float16Elem elem) {
            return $this.transformFloat16(elem);
        }

        default public Element transformFloat16(Float16Elem elem) {
            return elem;
        }

        public static Element transformFloat$(Transformer $this, FloatElem elem) {
            return $this.transformFloat(elem);
        }

        default public Element transformFloat(FloatElem elem) {
            return elem;
        }

        public static Element transformDouble$(Transformer $this, DoubleElem elem) {
            return $this.transformDouble(elem);
        }

        default public Element transformDouble(DoubleElem elem) {
            return elem;
        }

        public static Element transformNumberString$(Transformer $this, NumberStringElem elem) {
            return $this.transformNumberString(elem);
        }

        default public Element transformNumberString(NumberStringElem elem) {
            return elem;
        }

        public static Element transformString$(Transformer $this, StringElem elem) {
            return $this.transformString(elem);
        }

        default public Element transformString(StringElem elem) {
            return this.transformTextElem(elem);
        }

        public static Element transformTextStream$(Transformer $this, TextStreamElem elem) {
            return $this.transformTextStream(elem);
        }

        default public Element transformTextStream(TextStreamElem elem) {
            return this.transformTextElem(elem);
        }

        public static Element transformTextElem$(Transformer $this, AbstractTextElem elem) {
            return $this.transformTextElem(elem);
        }

        default public Element transformTextElem(AbstractTextElem elem) {
            return elem;
        }

        public static Element transformBytes$(Transformer $this, ByteArrayElem elem) {
            return $this.transformBytes(elem);
        }

        default public Element transformBytes(ByteArrayElem elem) {
            return this.transformBytesElem(elem);
        }

        public static Element transformBytesStream$(Transformer $this, BytesStreamElem elem) {
            return $this.transformBytesStream(elem);
        }

        default public Element transformBytesStream(BytesStreamElem elem) {
            return this.transformBytesElem(elem);
        }

        public static Element transformBytesElem$(Transformer $this, AbstractBytesElem elem) {
            return $this.transformBytesElem(elem);
        }

        default public Element transformBytesElem(AbstractBytesElem elem) {
            return elem;
        }

        public static Element transformSimpleValue$(Transformer $this, SimpleValueElem elem) {
            return $this.transformSimpleValue(elem);
        }

        default public Element transformSimpleValue(SimpleValueElem elem) {
            return elem;
        }

        public static Element transformTag$(Transformer $this, TaggedElem elem) {
            return $this.transformTag(elem);
        }

        default public Element transformTag(TaggedElem elem) {
            return elem;
        }

        public static Element transformSizedArray$(Transformer $this, ArrayElem.Sized elem) {
            return $this.transformSizedArray(elem);
        }

        default public Element transformSizedArray(ArrayElem.Sized elem) {
            return Dom$ArrayElem$Sized$.MODULE$.apply(this.transformArray(elem.elems()));
        }

        public static Element transformUnsizedArray$(Transformer $this, ArrayElem.Unsized elem) {
            return $this.transformUnsizedArray(elem);
        }

        default public Element transformUnsizedArray(ArrayElem.Unsized elem) {
            return Dom$ArrayElem$Unsized$.MODULE$.apply(this.transformArray(elem.elems()));
        }

        public static Vector transformArray$(Transformer $this, Vector elements) {
            return $this.transformArray(elements);
        }

        default public Vector<Element> transformArray(Vector<Element> elements) {
            return (Vector)elements.map((Function1)this);
        }

        public static Element transformSizedMap$(Transformer $this, MapElem.Sized elem) {
            return $this.transformSizedMap(elem);
        }

        default public Element transformSizedMap(MapElem.Sized elem) {
            return Dom$MapElem$Sized$.MODULE$.apply(this.transformMapMembers(elem.members()), Dom$MapElem$.MODULE$.elementStringOrElem());
        }

        public static Element transformUnsizedMap$(Transformer $this, MapElem.Unsized elem) {
            return $this.transformUnsizedMap(elem);
        }

        default public Element transformUnsizedMap(MapElem.Unsized elem) {
            return Dom$MapElem$Unsized$.MODULE$.apply(this.transformMapMembers(elem.members()), Dom$MapElem$.MODULE$.elementStringOrElem());
        }

        public static Iterator transformMapMembers$(Transformer $this, Iterator members) {
            return $this.transformMapMembers(members);
        }

        default public Iterator<Tuple2<Element, Element>> transformMapMembers(Iterator<Tuple2<Element, Element>> members) {
            return members.map((Function1<Tuple2, Tuple2> & Serializable)member -> this.transformMapMember((Tuple2<Element, Element>)member));
        }

        public static Tuple2 transformMapMember$(Transformer $this, Tuple2 member) {
            return $this.transformMapMember(member);
        }

        default public Tuple2<Element, Element> transformMapMember(Tuple2<Element, Element> member) {
            Element element = Predef$.MODULE$.ArrowAssoc(this.apply(member._1()));
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(element, this.apply(member._2()));
        }
    }
}

