/*
 * Decompiled with CFR 0.152.
 */
package io.bullet.borer;

import io.bullet.borer.Borer;
import io.bullet.borer.ByteAccess;
import io.bullet.borer.CommonApi;
import io.bullet.borer.Decoder;
import io.bullet.borer.Input;
import io.bullet.borer.Input$;
import io.bullet.borer.InputReader;
import io.bullet.borer.Json;
import io.bullet.borer.Reader;
import io.bullet.borer.Receiver;
import io.bullet.borer.Target;
import io.bullet.borer.internal.Parser;
import io.bullet.borer.json.DirectJsonParser;
import io.bullet.borer.json.DirectParser$;
import scala.Function2;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.package$;
import scala.util.Either;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class DecodingSetup {

    public static interface Api<Config extends Borer.DecodingConfig>
    extends CommonApi<Config> {
        public Api withPrefixOnly();

        public <T> Sealed<T> to(Decoder<T> var1);
    }

    public static final class Impl<V, Bytes, Config extends Borer.DecodingConfig>
    extends CommonApi.Impl<Config>
    implements Api<Config>,
    Sealed<Object> {
        private final V inputValue;
        private final Function3<Input<Bytes>, ByteAccess<Bytes>, Config, Parser<Bytes>> parserCreator;
        private final Target target;
        private final Input.Provider<V> p;
        private boolean prefixOnly;
        private Decoder<Object> decoder;

        public Impl(V inputValue, Config defaultConfig, Function2<Receiver, Config, Receiver> defaultWrapper, Function3<Input<Bytes>, ByteAccess<Bytes>, Config, Parser<Bytes>> parserCreator, Target target, Input.Provider<V> p) {
            this.inputValue = inputValue;
            this.parserCreator = parserCreator;
            this.target = target;
            this.p = p;
            super(defaultConfig, defaultWrapper);
        }

        @Override
        public Impl withPrefixOnly() {
            this.prefixOnly = true;
            return this;
        }

        @Override
        public <T> Sealed<T> to(Decoder<T> decoder) {
            this.decoder = decoder;
            return this;
        }

        @Override
        public Object value() {
            Object object;
            InputReader<Reader.Config> reader = this.newReader();
            try {
                object = this.decodeFrom(reader);
            }
            catch (Borer.Error e) {
                throw e.withPosOf(reader);
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    InputReader<Reader.Config> InputReader_this = reader;
                    throw new Borer.Error.General<Input.Position>(Input$.MODULE$.position(InputReader_this.input(), InputReader_this.cursor()), e);
                }
                throw throwable;
            }
            return object;
        }

        @Override
        public Try<Object> valueTry() {
            Try try_;
            InputReader<Reader.Config> reader = this.newReader();
            try {
                try_ = Success$.MODULE$.apply(this.decodeFrom(reader));
            }
            catch (Borer.Error e) {
                try_ = Failure$.MODULE$.apply(e.withPosOf(reader));
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    InputReader<Reader.Config> InputReader_this = reader;
                    try_ = Failure$.MODULE$.apply(new Borer.Error.General<Input.Position>(Input$.MODULE$.position(InputReader_this.input(), InputReader_this.cursor()), e));
                }
                throw throwable;
            }
            return try_;
        }

        @Override
        public Either<Borer.Error<Input.Position>, Object> valueEither() {
            Either either;
            InputReader<Reader.Config> reader = this.newReader();
            try {
                either = package$.MODULE$.Right().apply(this.decodeFrom(reader));
            }
            catch (Borer.Error e) {
                either = package$.MODULE$.Left().apply(e.withPosOf(reader));
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    InputReader<Reader.Config> InputReader_this = reader;
                    either = package$.MODULE$.Left().apply(new Borer.Error.General<Input.Position>(Input$.MODULE$.position(InputReader_this.input(), InputReader_this.cursor()), e));
                }
                throw throwable;
            }
            return either;
        }

        @Override
        public Tuple2<Object, Input<?>> valueAndInput() {
            Tuple2<Object, Input<?>> tuple2;
            InputReader<Reader.Config> reader = this.newReader();
            try {
                Object object = Predef$.MODULE$.ArrowAssoc(this.decodeFrom(reader));
                tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(object, reader.input());
            }
            catch (Borer.Error e) {
                throw e.withPosOf(reader);
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    InputReader<Reader.Config> InputReader_this = reader;
                    throw new Borer.Error.General<Input.Position>(Input$.MODULE$.position(InputReader_this.input(), InputReader_this.cursor()), e);
                }
                throw throwable;
            }
            return tuple2;
        }

        @Override
        public Try<Tuple2<Object, Input<?>>> valueAndInputTry() {
            Try try_;
            InputReader<Reader.Config> reader = this.newReader();
            try {
                Object object = Predef$.MODULE$.ArrowAssoc(this.decodeFrom(reader));
                try_ = Success$.MODULE$.apply(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(object, reader.input()));
            }
            catch (Borer.Error e) {
                try_ = Failure$.MODULE$.apply(e.withPosOf(reader));
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    InputReader<Reader.Config> InputReader_this = reader;
                    try_ = Failure$.MODULE$.apply(new Borer.Error.General<Input.Position>(Input$.MODULE$.position(InputReader_this.input(), InputReader_this.cursor()), e));
                }
                throw throwable;
            }
            return try_;
        }

        @Override
        public Either<Borer.Error<Input.Position>, Tuple2<Object, Input<?>>> valueAndInputEither() {
            Either either;
            InputReader<Reader.Config> reader = this.newReader();
            try {
                Object object = Predef$.MODULE$.ArrowAssoc(this.decodeFrom(reader));
                either = package$.MODULE$.Right().apply(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(object, reader.input()));
            }
            catch (Borer.Error e) {
                either = package$.MODULE$.Left().apply(e.withPosOf(reader));
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    InputReader<Reader.Config> InputReader_this = reader;
                    either = package$.MODULE$.Left().apply(new Borer.Error.General<Input.Position>(Input$.MODULE$.position(InputReader_this.input(), InputReader_this.cursor()), e));
                }
                throw throwable;
            }
            return either;
        }

        private InputReader<? extends Reader.Config> newReader() {
            DirectJsonParser directJsonParser;
            Borer.DecodingConfig decodingConfig = (Borer.DecodingConfig)this.config();
            if (decodingConfig instanceof Json.DecodingConfig) {
                Json.DecodingConfig x = (Json.DecodingConfig)decodingConfig;
                directJsonParser = DirectParser$.MODULE$.apply(this.inputValue, x);
            } else {
                directJsonParser = null;
            }
            DirectJsonParser directParser = directJsonParser;
            Parser<Bytes> parser = directParser != null ? null : this.parserCreator.apply(this.p.apply(this.inputValue), this.p.byteAccess(), this.config());
            return new InputReader<Reader.Config>(parser, directParser, this.receiverTransformer(), (Reader.Config)this.config(), this.target);
        }

        /*
         * WARNING - void declaration
         */
        private Object decodeFrom(InputReader<? extends Reader.Config> reader) {
            void v0;
            try {
                void var2_2;
                Object value = this.decoder.read(reader);
                if (!this.prefixOnly) {
                    reader.readEndOfInput();
                }
                v0 = var2_2;
            }
            finally {
                reader.release();
            }
            return v0;
        }
    }

    public static interface Sealed<T> {
        public T value();

        public Try<T> valueTry();

        public Either<Borer.Error<Input.Position>, T> valueEither();

        public Tuple2<T, Input<?>> valueAndInput();

        public Try<Tuple2<T, Input<?>>> valueAndInputTry();

        public Either<Borer.Error<Input.Position>, Tuple2<T, Input<?>>> valueAndInputEither();
    }
}

